/*
 * Decompiled with CFR 0.152.
 */
package jupar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import jupar.objects.Modes;
import jupar.parsers.DownloaderXMLParser;
import org.xml.sax.SAXException;

public class Downloader {
    public void download(String filesxml, String destinationdir, Modes mode) throws SAXException, FileNotFoundException, IOException, InterruptedException {
        DownloadProgress progress = new DownloadProgress(){

            @Override
            public void onProgressChanged(boolean finished) {
            }
        };
        this.download(filesxml, destinationdir, mode, progress);
    }

    public void download(String filesxml, String destinationdir, Modes mode, DownloadProgress progress) throws SAXException, FileNotFoundException, IOException, InterruptedException {
        DownloaderXMLParser parser = new DownloaderXMLParser();
        ArrayList<String> links = parser.parse(filesxml, mode);
        File dir = new File(destinationdir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        progress.setTotalFiles(links.size());
        for (String link : links) {
            if (progress.isCanceled()) break;
            URL url = new URL(link);
            this.wget(url, String.valueOf(destinationdir) + File.separator + new File(url.getFile()).getName(), progress);
            progress.setTotalDownloadedFiles(progress.getTotalDownloadedFiles() + 1);
        }
        progress.onProgressChanged(true);
    }

    private void wget(URL url, String destination, DownloadProgress progress) throws MalformedURLException, IOException {
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        progress.setTotalDownloadedFileSize(0L);
        progress.setTotalDownloadSize(conn.getContentLength());
        InputStream in = conn.getInputStream();
        File dstfile = new File(destination);
        FileOutputStream out = new FileOutputStream(dstfile);
        byte[] buffer = new byte[1024];
        long lengthUpdate = 0L;
        try {
            int length;
            while (!progress.isCanceled() && (length = in.read(buffer)) > 0) {
                progress.setTotalDownloadedSize(progress.getTotalDownloadedSize() + (long)length);
                progress.setTotalDownloadedFileSize(progress.getTotalDownloadedFileSize() + (long)length);
                if ((lengthUpdate += (long)length) >= (long)progress.getLengthProgressUpdate()) {
                    progress.onProgressChanged(false);
                    lengthUpdate = 0L;
                }
                ((OutputStream)out).write(buffer, 0, length);
            }
            progress.onProgressChanged(false);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static abstract class DownloadProgress {
        private long totalDownloadedSize = 0L;
        private long totalDownloadedFileSize = 0L;
        private long totalDownloadingFileSize = 0L;
        private int totalFiles = 0;
        private int totalDownloadedFiles = 0;
        private int lengthProgressUpdate = 5120;
        private boolean canceled = false;

        public DownloadProgress(int lengthProgressUpdate) {
            this.lengthProgressUpdate = lengthProgressUpdate;
        }

        public DownloadProgress() {
        }

        public abstract void onProgressChanged(boolean var1);

        public long getTotalDownloadedSize() {
            return this.totalDownloadedSize;
        }

        protected void setTotalDownloadedSize(long totalDownloadedSize) {
            this.totalDownloadedSize = totalDownloadedSize;
        }

        public int getTotalFiles() {
            return this.totalFiles;
        }

        protected void setTotalFiles(int totalFiles) {
            this.totalFiles = totalFiles;
        }

        public int getTotalDownloadedFiles() {
            return this.totalDownloadedFiles;
        }

        protected void setTotalDownloadedFiles(int totalDownloadedFiles) {
            this.totalDownloadedFiles = totalDownloadedFiles;
        }

        public int getLengthProgressUpdate() {
            return this.lengthProgressUpdate;
        }

        protected void setLengthProgressUpdate(int lengthProgressUpdate) {
            this.lengthProgressUpdate = lengthProgressUpdate;
        }

        public long getTotalDownloadingFileSize() {
            return this.totalDownloadingFileSize;
        }

        protected void setTotalDownloadSize(long totalDownloadSize) {
            this.totalDownloadingFileSize = totalDownloadSize;
        }

        public long getTotalDownloadedFileSize() {
            return this.totalDownloadedFileSize;
        }

        public void setTotalDownloadedFileSize(long totalDownloadedFileSize) {
            this.totalDownloadedFileSize = totalDownloadedFileSize;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean canceled) {
            this.canceled = canceled;
        }
    }
}

