/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class MenuItemIconFactory
implements Serializable {
    private static final HashMap cache = new HashMap();
    private static final Dimension CHECK_ICON_SIZE = new Dimension(10, 10);
    private static final Dimension ARROW_ICON_SIZE = new Dimension(4, 8);
    private static final int SYSTEM_CLOSE_ICON = 1;
    private static final int SYSTEM_ICONIFY_ICON = 2;
    private static final int SYSTEM_MAXIMIZE_ICON = 3;
    private static final int SYSTEM_RESTORE_ICON = 4;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon menuArrowIcon;
    private static Icon systemCloseIcon;
    private static Icon systemIconifyIcon;
    private static Icon systemMaximizeIcon;
    private static Icon systemRestoreIcon;

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    public static Icon getSystemCloseIcon() {
        if (systemCloseIcon == null) {
            systemCloseIcon = new SystemMenuIcon(1);
        }
        return systemCloseIcon;
    }

    public static Icon getSystemIconifyIcon() {
        if (systemIconifyIcon == null) {
            systemIconifyIcon = new SystemMenuIcon(2);
        }
        return systemIconifyIcon;
    }

    public static Icon getSystemMaximizeIcon() {
        if (systemMaximizeIcon == null) {
            systemMaximizeIcon = new SystemMenuIcon(3);
        }
        return systemMaximizeIcon;
    }

    public static Icon getSystemRestoreIcon() {
        if (systemRestoreIcon == null) {
            systemRestoreIcon = new SystemMenuIcon(4);
        }
        return systemRestoreIcon;
    }

    public static void clearCache() {
        cache.clear();
    }

    private static class SystemMenuIcon
    implements Icon,
    UIResource,
    Serializable {
        private int style;

        SystemMenuIcon(int n) {
            this.style = n;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (component instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)component;
                if (!jMenuItem.isEnabled()) {
                    graphics.setColor(Theme.menuIconDisabledColor.getColor());
                } else if (jMenuItem.isArmed()) {
                    graphics.setColor(Theme.menuIconRolloverColor.getColor());
                } else {
                    graphics.setColor(Theme.menuIconColor.getColor());
                }
                if (this.style == 1) {
                    graphics.drawLine(n + 1, n2 + 1, n + 2, n2 + 1);
                    graphics.drawLine(n + 8, n2 + 1, n + 9, n2 + 1);
                    graphics.drawLine(n + 1, n2 + 2, n + 3, n2 + 2);
                    graphics.drawLine(n + 7, n2 + 2, n + 9, n2 + 2);
                    graphics.drawLine(n + 2, n2 + 3, n + 4, n2 + 3);
                    graphics.drawLine(n + 6, n2 + 3, n + 8, n2 + 3);
                    graphics.drawLine(n + 3, n2 + 4, n + 7, n2 + 4);
                    graphics.drawLine(n + 4, n2 + 5, n + 6, n2 + 5);
                    graphics.drawLine(n + 3, n2 + 6, n + 7, n2 + 6);
                    graphics.drawLine(n + 2, n2 + 7, n + 4, n2 + 7);
                    graphics.drawLine(n + 6, n2 + 7, n + 8, n2 + 7);
                    graphics.drawLine(n + 1, n2 + 8, n + 3, n2 + 8);
                    graphics.drawLine(n + 7, n2 + 8, n + 9, n2 + 8);
                    graphics.drawLine(n + 1, n2 + 9, n + 2, n2 + 9);
                    graphics.drawLine(n + 8, n2 + 9, n + 9, n2 + 9);
                } else if (this.style == 2) {
                    graphics.fillRect(n + 1, n + 8, 7, 2);
                } else if (this.style == 3) {
                    graphics.drawLine(n + 0, n2 + 0, n + 9, n2 + 0);
                    graphics.drawRect(n + 0, n + 1, 9, 8);
                } else if (this.style == 4) {
                    graphics.fillRect(n + 2, n + 1, 8, 2);
                    graphics.drawLine(n + 9, n2 + 3, n + 9, n2 + 6);
                    graphics.drawLine(n + 8, n2 + 6, n + 8, n2 + 6);
                    graphics.drawLine(n + 2, n2 + 3, n + 2, n2 + 3);
                    graphics.drawLine(n + 0, n2 + 4, n + 7, n2 + 4);
                    graphics.drawRect(n + 0, n + 5, 7, 4);
                }
            }
        }

        public int getIconWidth() {
            return 10;
        }

        public int getIconHeight() {
            return 10;
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuArrowIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            graphics.translate(n, n2);
            if (!buttonModel.isEnabled()) {
                graphics.setColor(Theme.menuItemDisabledFgColor.getColor());
            } else if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(Theme.menuItemSelectedTextColor.getColor());
            } else {
                graphics.setColor(jMenuItem.getForeground());
            }
            if (component.getComponentOrientation().isLeftToRight()) {
                graphics.drawLine(0, 0, 0, 7);
                graphics.drawLine(1, 1, 1, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(3, 3, 3, 4);
            } else {
                graphics.drawLine(4, 0, 4, 7);
                graphics.drawLine(3, 1, 3, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(1, 3, 1, 4);
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return ARROW_ICON_SIZE.width;
        }

        public int getIconHeight() {
            return ARROW_ICON_SIZE.height;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int[][] ALPHA_BORDER = new int[][]{{255, 255, 163, 84, 25, 25, 84, 163, 255, 255}, {255, 127, 92, 171, 230, 230, 171, 92, 127, 255}, {163, 92, 255, 255, 255, 255, 255, 255, 92, 163}, {84, 171, 255, 255, 255, 255, 255, 255, 171, 84}, {25, 230, 255, 255, 255, 255, 255, 255, 230, 25}, {25, 230, 255, 255, 255, 255, 255, 255, 230, 25}, {84, 171, 255, 255, 255, 255, 255, 255, 171, 84}, {163, 92, 255, 255, 255, 255, 255, 255, 92, 163}, {255, 127, 92, 171, 230, 230, 171, 92, 127, 255}, {255, 255, 163, 84, 25, 25, 84, 163, 255, 255}};
        private static final int[][] ALPHA_CHECK = new int[][]{{255, 255, 163, 84, 25, 25, 84, 163, 255, 255}, {255, 127, 92, 171, 230, 230, 171, 92, 127, 255}, {163, 92, 255, 255, 255, 255, 255, 255, 92, 163}, {84, 171, 255, 170, 63, 63, 170, 255, 171, 84}, {25, 230, 255, 63, 0, 0, 63, 255, 230, 25}, {25, 230, 255, 63, 0, 0, 63, 255, 230, 25}, {84, 171, 255, 170, 63, 63, 170, 255, 171, 84}, {163, 92, 255, 255, 255, 255, 255, 255, 92, 163}, {255, 127, 92, 171, 230, 230, 171, 92, 127, 255}, {255, 255, 163, 84, 25, 25, 84, 163, 255, 255}};

        private RadioButtonMenuItemIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            boolean bl = buttonModel.isSelected();
            boolean bl2 = buttonModel.isEnabled();
            boolean bl3 = buttonModel.isPressed();
            boolean bl4 = buttonModel.isArmed();
            Color color = jMenuItem.getBackground();
            ColorUIResource colorUIResource = null;
            graphics.translate(n, n2);
            colorUIResource = bl2 ? (bl3 || bl4 ? Theme.menuIconRolloverColor.getColor() : Theme.menuIconColor.getColor()) : Theme.menuIconDisabledColor.getColor();
            if (TinyLookAndFeel.controlPanelInstantiated) {
                this.paintIconNoCache(graphics, colorUIResource, bl);
            } else {
                this.paintIcon(graphics, colorUIResource, jMenuItem, bl);
            }
            graphics.translate(-n, -n2);
        }

        private void paintIcon(Graphics graphics, Color color, JMenuItem jMenuItem, boolean bl) {
            Color color2;
            int n;
            int n2;
            Color color3 = jMenuItem.getBackground();
            if (jMenuItem.getModel().isArmed()) {
                color3 = Theme.menuItemRolloverColor.getColor();
            } else if (color3 instanceof ColorUIResource) {
                color3 = Theme.menuPopupColor.getColor();
            }
            RadioKey radioKey = new RadioKey(color, color3, bl);
            Object v = cache.get(radioKey);
            if (v != null) {
                graphics.drawImage((Image)v, 0, 0, jMenuItem);
                return;
            }
            BufferedImage bufferedImage = new BufferedImage(CHECK_ICON_SIZE.width, CHECK_ICON_SIZE.height, 2);
            Graphics graphics2 = ((Image)bufferedImage).getGraphics();
            graphics2.setColor(color3);
            graphics2.fillRect(0, 0, CHECK_ICON_SIZE.width, CHECK_ICON_SIZE.height);
            for (n2 = 0; n2 < 10; ++n2) {
                for (n = 0; n < 10; ++n) {
                    if (ALPHA_BORDER[n][n2] == 255) continue;
                    color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255 - ALPHA_BORDER[n][n2]);
                    graphics2.setColor(color2);
                    graphics2.drawLine(n, n2, n, n2);
                }
            }
            if (bl) {
                for (n2 = 3; n2 < 7; ++n2) {
                    for (n = 3; n < 7; ++n) {
                        color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255 - ALPHA_CHECK[n][n2]);
                        graphics2.setColor(color2);
                        graphics2.drawLine(n, n2, n, n2);
                    }
                }
            }
            graphics2.dispose();
            graphics.drawImage(bufferedImage, 0, 0, jMenuItem);
            cache.put(radioKey, bufferedImage);
        }

        private void paintIconNoCache(Graphics graphics, Color color, boolean bl) {
            Color color2;
            int n;
            int n2;
            for (n2 = 0; n2 < 10; ++n2) {
                for (n = 0; n < 10; ++n) {
                    if (ALPHA_BORDER[n][n2] == 255) continue;
                    color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255 - ALPHA_BORDER[n][n2]);
                    graphics.setColor(color2);
                    graphics.drawLine(n, n2, n, n2);
                }
            }
            if (bl) {
                for (n2 = 3; n2 < 7; ++n2) {
                    for (n = 3; n < 7; ++n) {
                        color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255 - ALPHA_CHECK[n][n2]);
                        graphics.setColor(color2);
                        graphics.drawLine(n, n2, n, n2);
                    }
                }
            }
        }

        public int getIconWidth() {
            return CHECK_ICON_SIZE.width;
        }

        public int getIconHeight() {
            return CHECK_ICON_SIZE.height;
        }

        class RadioKey {
            private Color c;
            private Color background;
            private boolean selected;

            RadioKey(Color color, Color color2, boolean bl) {
                this.c = color;
                this.background = color2;
                this.selected = bl;
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (!(object instanceof RadioKey)) {
                    return false;
                }
                RadioKey radioKey = (RadioKey)object;
                return this.selected == radioKey.selected && this.c.equals(radioKey.c) && this.background.equals(radioKey.background);
            }

            public int hashCode() {
                return this.c.hashCode() * this.background.hashCode() * (this.selected ? 1 : 2);
            }
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            boolean bl = buttonModel.isSelected();
            if (!bl) {
                return;
            }
            boolean bl2 = buttonModel.isEnabled();
            boolean bl3 = buttonModel.isPressed();
            boolean bl4 = buttonModel.isArmed();
            graphics.translate(n, n2);
            if (bl2) {
                if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                    graphics.setColor(Theme.menuIconRolloverColor.getColor());
                } else {
                    graphics.setColor(Theme.menuIconColor.getColor());
                }
            } else {
                graphics.setColor(Theme.menuIconDisabledColor.getColor());
            }
            graphics.drawLine(2, 4, 2, 6);
            graphics.drawLine(3, 5, 3, 7);
            graphics.drawLine(4, 6, 4, 8);
            graphics.drawLine(5, 5, 5, 7);
            graphics.drawLine(6, 4, 6, 6);
            graphics.drawLine(7, 3, 7, 5);
            graphics.drawLine(8, 2, 8, 4);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return CHECK_ICON_SIZE.width;
        }

        public int getIconHeight() {
            return CHECK_ICON_SIZE.height;
        }
    }
}

