/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import sun.awt.shell.ShellFolder;

public class TinyDirectoryModel
extends BasicDirectoryModel {
    private JFileChooser filechooser = null;
    private Vector fileCache = new Vector(50);
    private LoadFilesThread loadThread = null;
    private Vector files = null;
    private Vector directories = null;
    private int fetchID = 0;
    private PropertyChangeSupport changeSupport;
    private boolean busy = false;

    public TinyDirectoryModel(JFileChooser jFileChooser) {
        super(jFileChooser);
        this.filechooser = jFileChooser;
        this.validateFileCache();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "directoryChanged" || string == "fileViewChanged" || string == "fileFilterChanged" || string == "FileHidingChanged" || string == "fileSelectionChanged") {
            this.validateFileCache();
        } else if ("UI".equals(string)) {
            BasicFileChooserUI basicFileChooserUI;
            BasicDirectoryModel basicDirectoryModel;
            Object object = propertyChangeEvent.getOldValue();
            if (object instanceof BasicFileChooserUI && (basicDirectoryModel = (basicFileChooserUI = (BasicFileChooserUI)object).getModel()) != null) {
                basicDirectoryModel.invalidateFileCache();
            }
        } else if ("JFileChooserDialogIsClosingProperty".equals(string)) {
            this.invalidateFileCache();
        }
    }

    public void invalidateFileCache() {
        if (this.loadThread != null) {
            this.loadThread.interrupt();
            this.loadThread.cancelRunnables();
            this.loadThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDirectories() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.directories != null) {
                return this.directories;
            }
            Vector vector2 = this.getFiles();
            return this.directories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFiles() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.files != null) {
                return this.files;
            }
            this.files = new Vector();
            this.directories = new Vector();
            this.directories.addElement(this.filechooser.getFileSystemView().createFileObject(this.filechooser.getCurrentDirectory(), ".."));
            for (int i = 0; i < this.getSize(); ++i) {
                File file = (File)this.fileCache.get(i);
                if (this.filechooser.isTraversable(file)) {
                    this.directories.add(file);
                    continue;
                }
                this.files.add(file);
            }
            return this.files;
        }
    }

    public void validateFileCache() {
        if (this.filechooser == null) {
            return;
        }
        File file = this.filechooser.getCurrentDirectory();
        if (file == null) {
            return;
        }
        if (this.loadThread != null) {
            this.loadThread.interrupt();
            this.loadThread.cancelRunnables();
        }
        this.setBusy(true, ++this.fetchID);
        this.loadThread = new LoadFilesThread(file, this.fetchID);
        this.loadThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameFile(File file, File file2) {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (file.renameTo(file2)) {
                this.validateFileCache();
                return true;
            }
            return false;
        }
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public int getSize() {
        return this.fileCache.size();
    }

    public boolean contains(Object object) {
        return this.fileCache.contains(object);
    }

    public int indexOf(Object object) {
        return this.fileCache.indexOf(object);
    }

    public Object getElementAt(int n) {
        return this.fileCache.get(n);
    }

    public Vector getFileCache() {
        return this.fileCache;
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    protected void sort(Vector vector) {
        ShellFolder.sortFiles((List)vector);
    }

    protected boolean lt(File file, File file2) {
        int n = file.getName().toLowerCase().compareTo(file2.getName().toLowerCase());
        if (n != 0) {
            return n < 0;
        }
        return file.getName().compareTo(file2.getName()) < 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, bl, bl2);
        }
    }

    private synchronized void setBusy(final boolean bl, int n) {
        if (n == this.fetchID) {
            boolean bl2 = this.busy;
            this.busy = bl;
            if (this.changeSupport != null && bl != bl2) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TinyDirectoryModel.this.firePropertyChange("busy", !bl, bl);
                    }
                });
            }
        }
    }

    class DoChangeContents
    implements Runnable {
        private List addFiles;
        private List remFiles;
        private boolean doFire = true;
        private int fid;
        private int addStart = 0;
        private int remStart = 0;
        private int change;

        public DoChangeContents(List list, int n, List list2, int n2, int n3) {
            this.addFiles = list;
            this.addStart = n;
            this.remFiles = list2;
            this.remStart = n2;
            this.fid = n3;
        }

        synchronized void cancel() {
            this.doFire = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            if (TinyDirectoryModel.this.fetchID == this.fid && this.doFire) {
                int n = this.remFiles == null ? 0 : this.remFiles.size();
                int n2 = this.addFiles == null ? 0 : this.addFiles.size();
                Vector vector = TinyDirectoryModel.this.fileCache;
                synchronized (vector) {
                    if (n > 0) {
                        TinyDirectoryModel.this.fileCache.removeAll(this.remFiles);
                    }
                    if (n2 > 0) {
                        TinyDirectoryModel.this.fileCache.addAll(this.addStart, this.addFiles);
                    }
                    TinyDirectoryModel.this.files = null;
                    TinyDirectoryModel.this.directories = null;
                }
                if (n > 0 && n2 == 0) {
                    TinyDirectoryModel.this.fireIntervalRemoved(TinyDirectoryModel.this, this.remStart, this.remStart + n - 1);
                } else if (n2 > 0 && n == 0 && TinyDirectoryModel.this.fileCache.size() > n2) {
                    TinyDirectoryModel.this.fireIntervalAdded(TinyDirectoryModel.this, this.addStart, this.addStart + n2 - 1);
                } else {
                    TinyDirectoryModel.this.fireContentsChanged();
                }
            }
        }
    }

    class LoadFilesThread
    extends Thread {
        File currentDirectory;
        int fid;
        Vector runnables;

        public LoadFilesThread(File file, int n) {
            super("Basic L&F File Loading Thread");
            this.currentDirectory = null;
            this.runnables = new Vector(10);
            this.currentDirectory = file;
            this.fid = n;
        }

        private void invokeLater(Runnable runnable) {
            this.runnables.addElement(runnable);
            SwingUtilities.invokeLater(runnable);
        }

        public void run() {
            this.run0();
            TinyDirectoryModel.this.setBusy(false, this.fid);
        }

        public void run0() {
            int n;
            FileSystemView fileSystemView = TinyDirectoryModel.this.filechooser.getFileSystemView();
            File[] fileArray = fileSystemView.getFiles(this.currentDirectory, TinyDirectoryModel.this.filechooser.isFileHidingEnabled());
            Vector<File> vector = new Vector<File>();
            if (this.isInterrupted()) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (!TinyDirectoryModel.this.filechooser.accept(fileArray[i])) continue;
                vector.addElement(fileArray[i]);
            }
            if (this.isInterrupted()) {
                return;
            }
            TinyDirectoryModel.this.sort(vector);
            Vector<File> vector2 = new Vector<File>(50);
            Vector<File> vector3 = new Vector<File>();
            for (int i = 0; i < vector.size(); ++i) {
                File file = (File)vector.elementAt(i);
                n = TinyDirectoryModel.this.filechooser.isTraversable(file);
                if (n != 0) {
                    vector2.addElement(file);
                } else if (n == 0 && TinyDirectoryModel.this.filechooser.isFileSelectionEnabled()) {
                    vector3.addElement(file);
                }
                if (!this.isInterrupted()) continue;
                return;
            }
            Vector<File> vector4 = new Vector<File>(vector2);
            vector4.addAll(vector3);
            int n2 = vector4.size();
            n = TinyDirectoryModel.this.fileCache.size();
            if (n2 > n) {
                int n3 = n;
                int n4 = n2;
                block2: for (int i = 0; i < n; ++i) {
                    if (vector4.get(i).equals(TinyDirectoryModel.this.fileCache.get(i))) continue;
                    n3 = i;
                    for (int j = i; j < n2; ++j) {
                        if (!vector4.get(j).equals(TinyDirectoryModel.this.fileCache.get(i))) continue;
                        n4 = j;
                        break block2;
                    }
                    break;
                }
                if (n3 >= 0 && n4 > n3 && ((Object)vector4.subList(n4, n2)).equals(TinyDirectoryModel.this.fileCache.subList(n3, n))) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    this.invokeLater(new DoChangeContents(vector4.subList(n3, n4), n3, null, 0, this.fid));
                    vector4 = null;
                }
            } else if (n2 < n) {
                int n5 = -1;
                int n6 = -1;
                for (int i = 0; i < n2; ++i) {
                    if (vector4.get(i).equals(TinyDirectoryModel.this.fileCache.get(i))) continue;
                    n5 = i;
                    n6 = i + n - n2;
                    break;
                }
                if (n5 >= 0 && n6 > n5 && ((Object)TinyDirectoryModel.this.fileCache.subList(n6, n)).equals(vector4.subList(n5, n2))) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    this.invokeLater(new DoChangeContents(null, 0, new Vector(TinyDirectoryModel.this.fileCache.subList(n5, n6)), n5, this.fid));
                    vector4 = null;
                }
            }
            if (vector4 != null && !TinyDirectoryModel.this.fileCache.equals(vector4)) {
                if (this.isInterrupted()) {
                    this.cancelRunnables(this.runnables);
                }
                this.invokeLater(new DoChangeContents(vector4, 0, TinyDirectoryModel.this.fileCache, 0, this.fid));
            }
        }

        public void cancelRunnables(Vector vector) {
            for (int i = 0; i < vector.size(); ++i) {
                ((DoChangeContents)vector.elementAt(i)).cancel();
            }
        }

        public void cancelRunnables() {
            this.cancelRunnables(this.runnables);
        }
    }
}

