/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalSliderUI;

public class TinySliderUI
extends MetalSliderUI {
    private static final BasicStroke focusStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);
    private static final Dimension sliderVertSize = new Dimension(22, 11);
    private static final Dimension sliderHorzSize = new Dimension(11, 22);
    protected boolean isRollover = false;
    protected boolean wasRollover = false;
    protected boolean isDragging = false;
    protected BasicSliderUI.TrackListener trackListener;

    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new MyTrackListener();
    }

    protected Dimension getThumbSize() {
        if (this.slider.getOrientation() == 1) {
            return sliderVertSize;
        }
        return sliderHorzSize;
    }

    protected int getTrackWidth() {
        return 4;
    }

    public void paintThumb(Graphics graphics) {
        if (!this.slider.isEnabled()) {
            graphics.setColor(Theme.sliderThumbDisabledColor.getColor());
            this.drawXpThumbDisabled(graphics);
            return;
        }
        if (this.isDragging) {
            graphics.setColor(Theme.sliderThumbPressedColor.getColor());
        } else if (this.isRollover && Theme.sliderRolloverEnabled.getValue()) {
            graphics.setColor(Theme.sliderThumbColor.getColor());
        } else {
            graphics.setColor(Theme.sliderThumbColor.getColor());
        }
        this.drawXpThumb(graphics);
    }

    private void drawXpThumb(Graphics graphics) {
        int n = this.thumbRect.x;
        int n2 = this.thumbRect.y;
        int n3 = n + this.thumbRect.width - 1;
        int n4 = n2 + this.thumbRect.height - 1;
        Color color = graphics.getColor();
        if (this.slider.getPaintTicks()) {
            if (this.slider.getOrientation() == 0) {
                graphics.fillRect(n + 1, n2 + 4, this.thumbRect.width - 4, this.thumbRect.height - 8);
                graphics.drawLine(n + 5, n4 - 3, n + 5, n4 - 3);
                graphics.setColor(ColorRoutines.darken(color, 10));
                graphics.drawLine(n3 - 2, n2 + 4, n3 - 2, n4 - 6);
                graphics.setColor(ColorRoutines.darken(color, 20));
                graphics.drawLine(n3 - 1, n2 + 4, n3 - 1, n4 - 7);
                ColorUIResource colorUIResource = Theme.sliderBorderColor.getColor();
                graphics.setColor(colorUIResource);
                graphics.drawLine(n + 1, n2, n3 - 1, n2);
                graphics.drawLine(n, n2 + 1, n, n4 - 5);
                graphics.drawLine(n + 1, n4 - 4, n + 1, n4 - 4);
                graphics.drawLine(n + 2, n4 - 3, n + 2, n4 - 3);
                graphics.drawLine(n + 3, n4 - 2, n + 3, n4 - 2);
                graphics.drawLine(n + 4, n4 - 1, n + 4, n4 - 1);
                graphics.setColor(Theme.sliderDarkColor.getColor());
                graphics.drawLine(n3, n2 + 1, n3, n4 - 5);
                graphics.drawLine(n3 - 1, n4 - 4, n3 - 1, n4 - 4);
                graphics.drawLine(n3 - 2, n4 - 3, n3 - 2, n4 - 3);
                graphics.drawLine(n3 - 3, n4 - 2, n3 - 3, n4 - 2);
                graphics.drawLine(n3 - 4, n4 - 1, n3 - 4, n4 - 1);
                graphics.drawLine(n3 - 5, n4, n3 - 5, n4);
                ColorUIResource colorUIResource2 = null;
                colorUIResource2 = !this.isDragging && this.isRollover && Theme.sliderRolloverEnabled.getValue() ? Theme.sliderThumbRolloverColor.getColor() : Theme.sliderLightColor.getColor();
                Color color2 = ColorRoutines.getAdjustedColor(colorUIResource2, 67, 39);
                graphics.setColor(color2);
                graphics.drawLine(n + 1, n2 + 1, n3 - 1, n2 + 1);
                graphics.drawLine(n + 1, n4 - 6, n + 1, n4 - 6);
                graphics.drawLine(n + 2, n4 - 5, n + 2, n4 - 5);
                graphics.drawLine(n + 3, n4 - 4, n + 3, n4 - 4);
                graphics.setColor(ColorRoutines.getAverage(colorUIResource, color2));
                graphics.drawLine(n + 1, n4 - 5, n + 1, n4 - 5);
                graphics.drawLine(n + 2, n4 - 4, n + 2, n4 - 4);
                graphics.drawLine(n + 3, n4 - 3, n + 3, n4 - 3);
                Color color3 = ColorRoutines.getAverage(colorUIResource2, color2);
                graphics.setColor(color3);
                graphics.drawLine(n + 1, n2 + 2, n3 - 1, n2 + 2);
                graphics.drawLine(n + 4, n4 - 3, n + 4, n4 - 3);
                graphics.drawLine(n + 5, n4 - 2, n + 5, n4 - 2);
                graphics.drawLine(n + 6, n4 - 3, n + 6, n4 - 3);
                graphics.setColor(ColorRoutines.getAverage(colorUIResource, color3));
                graphics.drawLine(n + 4, n4 - 2, n + 4, n4 - 2);
                graphics.drawLine(n + 5, n4 - 1, n + 5, n4 - 1);
                graphics.drawLine(n + 6, n4 - 2, n + 6, n4 - 2);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n + 1, n2 + 3, n3 - 1, n2 + 3);
                graphics.drawLine(n + 9, n4 - 6, n + 9, n4 - 6);
                graphics.drawLine(n + 8, n4 - 5, n + 8, n4 - 5);
                graphics.drawLine(n + 7, n4 - 4, n + 7, n4 - 4);
                graphics.setColor(ColorRoutines.getAverage(colorUIResource, colorUIResource2));
                graphics.drawLine(n + 9, n4 - 5, n + 9, n4 - 5);
                graphics.drawLine(n + 8, n4 - 4, n + 8, n4 - 4);
                graphics.drawLine(n + 7, n4 - 3, n + 7, n4 - 3);
            } else {
                graphics.fillRect(n + 4, n2 + 1, this.thumbRect.width - 8, this.thumbRect.height - 4);
                graphics.drawLine(n3 - 3, n2 + 5, n3 - 3, n2 + 5);
                graphics.setColor(ColorRoutines.darken(color, 10));
                graphics.drawLine(n + 4, n4 - 2, n3 - 6, n4 - 2);
                graphics.setColor(ColorRoutines.darken(color, 20));
                graphics.drawLine(n + 4, n4 - 1, n3 - 7, n4 - 1);
                ColorUIResource colorUIResource = Theme.sliderBorderColor.getColor();
                graphics.setColor(colorUIResource);
                graphics.drawLine(n, n2 + 1, n, n4 - 1);
                graphics.drawLine(n + 1, n2, n3 - 5, n2);
                graphics.drawLine(n3 - 4, n2 + 1, n3 - 4, n2 + 1);
                graphics.drawLine(n3 - 3, n2 + 2, n3 - 3, n2 + 2);
                graphics.drawLine(n3 - 2, n2 + 3, n3 - 2, n2 + 3);
                graphics.drawLine(n3 - 1, n2 + 4, n3 - 1, n2 + 4);
                graphics.setColor(Theme.sliderDarkColor.getColor());
                graphics.drawLine(n + 1, n4, n3 - 5, n4);
                graphics.drawLine(n3 - 4, n4 - 1, n3 - 4, n4 - 1);
                graphics.drawLine(n3 - 3, n4 - 2, n3 - 3, n4 - 2);
                graphics.drawLine(n3 - 2, n4 - 3, n3 - 2, n4 - 3);
                graphics.drawLine(n3 - 1, n4 - 4, n3 - 1, n4 - 4);
                graphics.drawLine(n3, n4 - 5, n3, n4 - 5);
                ColorUIResource colorUIResource3 = null;
                colorUIResource3 = !this.isDragging && this.isRollover && Theme.sliderRolloverEnabled.getValue() ? Theme.sliderThumbRolloverColor.getColor() : Theme.sliderLightColor.getColor();
                Color color4 = ColorRoutines.getAdjustedColor(colorUIResource3, 67, 39);
                graphics.setColor(color4);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n4 - 1);
                graphics.drawLine(n3 - 6, n2 + 1, n3 - 6, n2 + 1);
                graphics.drawLine(n3 - 5, n2 + 2, n3 - 5, n2 + 2);
                graphics.drawLine(n3 - 4, n2 + 3, n3 - 4, n2 + 3);
                graphics.setColor(ColorRoutines.getAverage(colorUIResource, color4));
                graphics.drawLine(n3 - 5, n2 + 1, n3 - 5, n2 + 1);
                graphics.drawLine(n3 - 4, n2 + 2, n3 - 4, n2 + 2);
                graphics.drawLine(n3 - 3, n2 + 3, n3 - 3, n2 + 3);
                Color color5 = ColorRoutines.getAverage(colorUIResource3, color4);
                graphics.setColor(color5);
                graphics.drawLine(n + 2, n2 + 1, n + 2, n4 - 1);
                graphics.drawLine(n3 - 3, n2 + 4, n3 - 3, n2 + 4);
                graphics.drawLine(n3 - 2, n2 + 5, n3 - 2, n2 + 5);
                graphics.drawLine(n3 - 3, n2 + 6, n3 - 3, n2 + 6);
                graphics.setColor(ColorRoutines.getAverage(colorUIResource, color5));
                graphics.drawLine(n3 - 2, n2 + 4, n3 - 2, n2 + 4);
                graphics.drawLine(n3 - 1, n2 + 5, n3 - 1, n2 + 5);
                graphics.drawLine(n3 - 2, n2 + 6, n3 - 2, n2 + 6);
                graphics.setColor(colorUIResource3);
                graphics.drawLine(n + 3, n2 + 1, n + 3, n4 - 1);
                graphics.drawLine(n3 - 6, n2 + 9, n3 - 6, n2 + 9);
                graphics.drawLine(n3 - 5, n2 + 8, n3 - 5, n2 + 8);
                graphics.drawLine(n3 - 4, n2 + 7, n3 - 4, n2 + 7);
                graphics.setColor(ColorRoutines.getAverage(colorUIResource, colorUIResource3));
                graphics.drawLine(n3 - 5, n2 + 9, n3 - 5, n2 + 9);
                graphics.drawLine(n3 - 4, n2 + 8, n3 - 4, n2 + 8);
                graphics.drawLine(n3 - 3, n2 + 7, n3 - 3, n2 + 7);
            }
        } else if (this.slider.getOrientation() == 0) {
            graphics.fillRect(n + 1, n2 + 1, this.thumbRect.width - 4, this.thumbRect.height - 4);
            graphics.setColor(ColorRoutines.darken(color, 10));
            graphics.drawLine(n3 - 2, n2 + 3, n3 - 2, n4 - 3);
            graphics.setColor(ColorRoutines.darken(color, 20));
            graphics.drawLine(n3 - 1, n2 + 3, n3 - 1, n4 - 3);
            graphics.setColor(Theme.sliderBorderColor.getColor());
            graphics.drawLine(n, n2 + 1, n, n4 - 1);
            graphics.drawLine(n + 1, n2, n3 - 1, n2);
            graphics.setColor(Theme.sliderDarkColor.getColor());
            graphics.drawLine(n + 1, n4, n3 - 1, n4);
            graphics.drawLine(n3, n2 + 1, n3, n4 - 1);
            ColorUIResource colorUIResource = null;
            colorUIResource = !this.isDragging && this.isRollover && Theme.sliderRolloverEnabled.getValue() ? Theme.sliderThumbRolloverColor.getColor() : Theme.sliderLightColor.getColor();
            Color color6 = ColorRoutines.getAdjustedColor(colorUIResource, 67, 39);
            graphics.setColor(color6);
            graphics.drawLine(n + 1, n2 + 1, n3 - 1, n2 + 1);
            graphics.setColor(ColorRoutines.getAverage(colorUIResource, color6));
            graphics.drawLine(n + 1, n2 + 2, n3 - 1, n2 + 2);
            graphics.drawLine(n + 1, n4 - 2, n3 - 1, n4 - 2);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n + 1, n4 - 1, n3 - 1, n4 - 1);
        } else {
            graphics.fillRect(n + 1, n2 + 1, this.thumbRect.width - 4, this.thumbRect.height - 4);
            graphics.setColor(ColorRoutines.darken(color, 10));
            graphics.drawLine(n + 3, n4 - 2, n3 - 3, n4 - 2);
            graphics.setColor(ColorRoutines.darken(color, 20));
            graphics.drawLine(n + 3, n4 - 1, n3 - 3, n4 - 1);
            graphics.setColor(Theme.sliderBorderColor.getColor());
            graphics.drawLine(n + 1, n2, n3 - 1, n2);
            graphics.drawLine(n, n2 + 1, n, n4 - 1);
            graphics.setColor(Theme.sliderDarkColor.getColor());
            graphics.drawLine(n3, n2 + 1, n3, n4 - 1);
            graphics.drawLine(n + 1, n4, n3 - 1, n4);
            ColorUIResource colorUIResource = null;
            colorUIResource = !this.isDragging && this.isRollover && Theme.sliderRolloverEnabled.getValue() ? Theme.sliderThumbRolloverColor.getColor() : Theme.sliderLightColor.getColor();
            Color color7 = ColorRoutines.getAdjustedColor(colorUIResource, 67, 39);
            graphics.setColor(color7);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n4 - 1);
            graphics.setColor(ColorRoutines.getAverage(colorUIResource, color7));
            graphics.drawLine(n + 2, n2 + 1, n + 2, n4 - 1);
            graphics.drawLine(n3 - 2, n2 + 1, n3 - 2, n4 - 1);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n3 - 1, n2 + 1, n3 - 1, n4 - 1);
        }
    }

    private void drawXpThumbDisabled(Graphics graphics) {
        int n = this.thumbRect.x;
        int n2 = this.thumbRect.y;
        int n3 = n + this.thumbRect.width - 1;
        int n4 = n2 + this.thumbRect.height - 1;
        Color color = graphics.getColor();
        Color color2 = ColorRoutines.getAdjustedColor(color, 0, -3);
        Color color3 = ColorRoutines.getAdjustedColor(color, 0, -7);
        ColorUIResource colorUIResource = Theme.sliderBorderDisabledColor.getColor();
        Color color4 = ColorRoutines.getAdjustedColor(colorUIResource, -19, -1);
        Color color5 = ColorRoutines.getAdjustedColor(colorUIResource, 0, -3);
        Color color6 = ColorRoutines.getAdjustedColor(colorUIResource, 0, -10);
        Color color7 = ColorRoutines.getAdjustedColor(colorUIResource, 3, -12);
        Color color8 = ColorRoutines.getAdjustedColor(colorUIResource, 0, -13);
        if (this.slider.getPaintTicks()) {
            if (this.slider.getOrientation() == 0) {
                graphics.fillRect(n + 1, n2 + 3, 7, 13);
                graphics.drawLine(n + 2, n4 - 5, n + 6, n4 - 5);
                graphics.drawLine(n + 3, n4 - 4, n + 5, n4 - 4);
                graphics.drawLine(n + 4, n4 - 3, n + 4, n4 - 3);
                graphics.setColor(color2);
                graphics.drawLine(n3 - 2, n2 + 3, n3 - 2, n4 - 3);
                graphics.drawLine(n3 - 3, n4 - 5, n3 - 3, n4 - 5);
                graphics.drawLine(n3 - 4, n4 - 4, n3 - 4, n4 - 4);
                graphics.drawLine(n3 - 5, n4 - 3, n3 - 5, n4 - 3);
                graphics.drawLine(n3 - 5, n4 - 2, n3 - 5, n4 - 2);
                graphics.setColor(color3);
                graphics.drawLine(n3 - 1, n2 + 3, n3 - 1, n4 - 6);
                graphics.drawLine(n3 - 2, n4 - 5, n3 - 2, n4 - 5);
                graphics.drawLine(n3 - 3, n4 - 4, n3 - 3, n4 - 4);
                graphics.drawLine(n3 - 4, n4 - 3, n3 - 4, n4 - 3);
                graphics.setColor(colorUIResource);
                graphics.drawLine(n + 1, n2, n3 - 1, n2);
                graphics.drawLine(n, n2 + 1, n, n4 - 5);
                graphics.setColor(color4);
                graphics.drawLine(n + 1, n2 + 1, n3, n2 + 1);
                graphics.setColor(color5);
                graphics.drawLine(n + 1, n2 + 2, n3, n2 + 2);
                graphics.drawLine(n + 1, n4 - 4, n + 1, n4 - 4);
                graphics.drawLine(n + 2, n4 - 3, n + 2, n4 - 3);
                graphics.drawLine(n + 3, n4 - 2, n + 3, n4 - 2);
                graphics.drawLine(n + 4, n4 - 1, n + 4, n4 - 1);
                graphics.setColor(color6);
                graphics.drawLine(n + 1, n4 - 5, n + 1, n4 - 5);
                graphics.drawLine(n + 2, n4 - 4, n + 2, n4 - 4);
                graphics.drawLine(n + 3, n4 - 3, n + 3, n4 - 3);
                graphics.drawLine(n + 4, n4 - 2, n + 4, n4 - 2);
                graphics.drawLine(n + 5, n4 - 1, n + 5, n4);
                graphics.setColor(color7);
                graphics.drawLine(n3, n2 + 3, n3, n4 - 5);
                graphics.drawLine(n3 - 1, n4 - 4, n3 - 1, n4 - 4);
                graphics.drawLine(n3 - 2, n4 - 3, n3 - 2, n4 - 3);
                graphics.drawLine(n3 - 3, n4 - 2, n3 - 3, n4 - 2);
                graphics.drawLine(n3 - 4, n4 - 1, n3 - 4, n4 - 1);
                graphics.drawLine(n3 - 5, n4, n3 - 5, n4);
                graphics.setColor(color8);
                graphics.drawLine(n3 - 1, n4 - 5, n3 - 1, n4 - 5);
                graphics.drawLine(n3 - 2, n4 - 4, n3 - 2, n4 - 4);
                graphics.drawLine(n3 - 3, n4 - 3, n3 - 3, n4 - 3);
                graphics.drawLine(n3 - 4, n4 - 2, n3 - 4, n4 - 2);
            } else {
                graphics.fillRect(n + 3, n2 + 1, 13, 7);
                graphics.drawLine(n3 - 5, n2 + 2, n3 - 5, n2 + 6);
                graphics.drawLine(n3 - 4, n2 + 3, n3 - 4, n2 + 5);
                graphics.drawLine(n3 - 3, n2 + 4, n3 - 3, n2 + 4);
                graphics.setColor(color2);
                graphics.drawLine(n + 3, n4 - 2, n3 - 6, n4 - 2);
                graphics.drawLine(n3 - 5, n4 - 3, n3 - 5, n4 - 3);
                graphics.drawLine(n3 - 4, n4 - 4, n3 - 4, n4 - 4);
                graphics.drawLine(n3 - 3, n4 - 5, n3 - 3, n4 - 5);
                graphics.setColor(color3);
                graphics.drawLine(n + 3, n4 - 1, n3 - 6, n4 - 1);
                graphics.drawLine(n3 - 5, n4 - 2, n3 - 5, n4 - 2);
                graphics.drawLine(n3 - 4, n4 - 3, n3 - 4, n4 - 3);
                graphics.drawLine(n3 - 3, n4 - 4, n3 - 3, n4 - 4);
                graphics.drawLine(n3 - 2, n4 - 5, n3 - 2, n4 - 5);
                graphics.setColor(colorUIResource);
                graphics.drawLine(n, n2 + 1, n, n4 - 1);
                graphics.drawLine(n + 1, n2, n3 - 5, n2);
                graphics.setColor(color4);
                graphics.drawLine(n + 1, n2, n + 1, n4);
                graphics.setColor(color5);
                graphics.drawLine(n + 2, n2, n + 2, n4);
                graphics.drawLine(n3 - 5, n2 + 1, n3 - 4, n2 + 1);
                graphics.drawLine(n3 - 4, n2 + 2, n3 - 3, n2 + 2);
                graphics.drawLine(n3 - 3, n2 + 3, n3 - 2, n2 + 3);
                graphics.drawLine(n3 - 2, n2 + 4, n3 - 1, n2 + 4);
                graphics.setColor(color6);
                graphics.drawLine(n3 - 1, n2 + 5, n3, n2 + 5);
                graphics.setColor(color7);
                graphics.drawLine(n + 3, n4, n3 - 5, n4);
                graphics.setColor(color8);
                graphics.drawLine(n3 - 5, n4 - 1, n3 - 4, n4 - 1);
                graphics.drawLine(n3 - 4, n4 - 2, n3 - 3, n4 - 2);
                graphics.drawLine(n3 - 3, n4 - 3, n3 - 2, n4 - 3);
                graphics.drawLine(n3 - 2, n4 - 4, n3 - 1, n4 - 4);
            }
        } else if (this.slider.getOrientation() == 0) {
            graphics.fillRect(n + 1, n2 + 3, 7, 16);
            graphics.setColor(color2);
            graphics.drawLine(n3 - 2, n2 + 3, n3 - 2, n4 - 3);
            graphics.setColor(color3);
            graphics.drawLine(n3 - 1, n2 + 3, n3 - 1, n4 - 3);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n, n2 + 1, n, n4 - 3);
            graphics.drawLine(n + 1, n2, n3 - 1, n2);
            graphics.setColor(color4);
            graphics.drawLine(n, n2 + 1, n3, n2 + 1);
            graphics.setColor(color5);
            graphics.drawLine(n, n2 + 2, n3, n2 + 2);
            graphics.setColor(color6);
            graphics.drawLine(n, n4 - 2, n3, n4 - 2);
            graphics.setColor(color8);
            graphics.drawLine(n, n4 - 1, n3, n4 - 1);
            graphics.setColor(color7);
            graphics.drawLine(n + 1, n4, n3 - 1, n4);
            graphics.drawLine(n3, n2 + 3, n3, n4 - 3);
        } else {
            graphics.fillRect(n + 3, n2 + 1, this.thumbRect.width - 6, this.thumbRect.height - 4);
            graphics.setColor(color2);
            graphics.drawLine(n + 3, n4 - 2, n3 - 3, n4 - 2);
            graphics.setColor(color3);
            graphics.drawLine(n + 3, n4 - 1, n3 - 3, n4 - 1);
            graphics.setColor(colorUIResource);
            graphics.drawLine(n, n2 + 1, n, n4 - 1);
            graphics.drawLine(n + 1, n2, n3 - 1, n2);
            graphics.setColor(color4);
            graphics.drawLine(n + 1, n2, n + 1, n4);
            graphics.setColor(color5);
            graphics.drawLine(n + 2, n2, n + 2, n4);
            graphics.setColor(color6);
            graphics.drawLine(n3 - 2, n2, n3 - 2, n4);
            graphics.setColor(color8);
            graphics.drawLine(n3 - 1, n2, n3 - 1, n4);
            graphics.setColor(color7);
            graphics.drawLine(n3, n2 + 1, n3, n4 - 1);
            graphics.drawLine(n + 3, n4, n3 - 3, n4);
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new TinySliderUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    protected int getThumbOverhang() {
        if (this.slider.getOrientation() == 1) {
            return (int)(this.getThumbSize().getWidth() - (double)this.getTrackWidth()) / 2;
        }
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    public void paintTrack(Graphics graphics) {
        this.drawXpTrack(graphics);
    }

    public void paintFocus(Graphics graphics) {
        if (!Theme.sliderFocusEnabled.getValue()) {
            return;
        }
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(focusStroke);
        graphics2D.setColor(Theme.sliderFocusColor.getColor());
        graphics2D.drawRect(0, 0, this.slider.getWidth() - 1, this.slider.getHeight() - 1);
        graphics2D.setStroke(stroke);
    }

    private void drawXpTrack(Graphics graphics) {
        int n = this.trackRect.x;
        int n2 = n + this.trackRect.width;
        int n3 = this.trackRect.y;
        int n4 = n3 + this.trackRect.height;
        if (this.slider.getOrientation() == 0) {
            int n5 = n3 + (this.trackRect.height - 4) / 2;
            graphics.setColor(Theme.sliderTrackColor.getColor());
            graphics.drawLine(n + 1, n5 + 2, n2 - 2, n5 + 2);
            graphics.setColor(Theme.sliderTrackDarkColor.getColor());
            graphics.drawLine(n + 1, n5 + 1, n2 - 2, n5 + 1);
            graphics.drawLine(n2 - 1, n5 + 1, n2 - 1, n5 + 2);
            graphics.setColor(ColorRoutines.darken(Theme.sliderTrackDarkColor.getColor(), 10));
            graphics.drawLine(n, n5, n, n5);
            graphics.drawLine(n, n5 + 3, n, n5 + 3);
            graphics.setColor(Theme.sliderTrackLightColor.getColor());
            graphics.drawLine(n + 1, n5 + 3, n2 - 1, n5 + 3);
            graphics.drawLine(n2, n5 + 1, n2, n5 + 3);
            graphics.setColor(Theme.sliderTrackBorderColor.getColor());
            graphics.drawLine(n + 1, n5, n2, n5);
            graphics.setColor(ColorRoutines.lighten(Theme.sliderTrackBorderColor.getColor(), 20));
            graphics.drawLine(n, n5 + 1, n, n5 + 2);
        } else {
            int n6 = n + (this.trackRect.width - 4) / 2;
            graphics.setColor(Theme.sliderTrackBorderColor.getColor());
            graphics.drawLine(n6, n3 + 1, n6, n4 - 1);
            graphics.setColor(ColorRoutines.lighten(Theme.sliderTrackBorderColor.getColor(), 20));
            graphics.drawLine(n6 + 1, n3, n6 + 1, n3);
            graphics.drawLine(n6 + 1, n4, n6 + 1, n4);
            graphics.setColor(Theme.sliderTrackDarkColor.getColor());
            graphics.drawLine(n6 + 1, n3 + 1, n6 + 1, n4 - 1);
            graphics.setColor(ColorRoutines.darken(Theme.sliderTrackDarkColor.getColor(), 10));
            graphics.drawLine(n6, n3, n6, n3);
            graphics.drawLine(n6, n4, n6, n4);
            graphics.setColor(Theme.sliderTrackLightColor.getColor());
            graphics.drawLine(n6 + 3, n3, n6 + 3, n4);
            graphics.drawLine(n6 + 2, n3, n6 + 2, n3);
            graphics.drawLine(n6 + 2, n4, n6 + 2, n4);
            graphics.setColor(Theme.sliderTrackColor.getColor());
            graphics.drawLine(n6 + 2, n3 + 1, n6 + 2, n4 - 1);
        }
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? Theme.sliderTickColor.getColor() : Theme.sliderTickDisabledColor.getColor());
        graphics.drawLine(n, 0, n, rectangle.height / 2 - 1);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? Theme.sliderTickColor.getColor() : Theme.sliderTickDisabledColor.getColor());
        graphics.drawLine(n, 0, n, rectangle.height - 2);
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? Theme.sliderTickColor.getColor() : Theme.sliderTickDisabledColor.getColor());
        graphics.drawLine(0, n, rectangle.width / 2 - 1, n);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.setColor(this.slider.isEnabled() ? Theme.sliderTickColor.getColor() : Theme.sliderTickDisabledColor.getColor());
        graphics.drawLine(0, n, rectangle.width - 2, n);
    }

    class MyTrackListener
    extends BasicSliderUI.TrackListener {
        MyTrackListener() {
            super(TinySliderUI.this);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            TinySliderUI.this.isDragging = false;
            TinySliderUI.this.slider.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (TinySliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                TinySliderUI.this.isDragging = true;
            }
            TinySliderUI.this.slider.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            TinySliderUI.this.isRollover = false;
            TinySliderUI.this.wasRollover = false;
            if (TinySliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                TinySliderUI.this.isRollover = true;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            TinySliderUI.this.isRollover = false;
            if (TinySliderUI.this.isRollover != TinySliderUI.this.wasRollover) {
                TinySliderUI.this.slider.repaint();
                TinySliderUI.this.wasRollover = TinySliderUI.this.isRollover;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (TinySliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                TinySliderUI.this.isRollover = true;
            }
            super.mouseDragged(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (TinySliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                TinySliderUI.this.isRollover = true;
                if (TinySliderUI.this.isRollover != TinySliderUI.this.wasRollover) {
                    TinySliderUI.this.slider.repaint();
                    TinySliderUI.this.wasRollover = TinySliderUI.this.isRollover;
                }
            } else {
                TinySliderUI.this.isRollover = false;
                if (TinySliderUI.this.isRollover != TinySliderUI.this.wasRollover) {
                    TinySliderUI.this.slider.repaint();
                    TinySliderUI.this.wasRollover = TinySliderUI.this.isRollover;
                }
            }
        }
    }
}

