/*
 * Decompiled with CFR 0.152.
 */
package serpro.receitanet.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.Random;
import java.util.zip.CRC32;
import serpro.receitanet.util.IndicadorProgresso;

public class Misc {
    public static String gerarStringAleatoria(int length) {
        StringBuffer randomString = new StringBuffer();
        Random random = new Random();
        int i = 0;
        while (i < length) {
            int digit = random.nextInt(62);
            char alphaNum = digit < 26 ? (char)(digit + 65) : (digit < 36 ? (char)(digit - 26 + 48) : (char)(digit - 36 + 97));
            randomString.append(alphaNum);
            ++i;
        }
        return randomString.toString();
    }

    public static void copy(InputStream src, File dst) throws IOException {
        int len;
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = src.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        src.close();
        ((OutputStream)out).close();
    }

    public static void escreverBytes(byte[] bytes, File arquivo) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(arquivo));
        ((OutputStream)out).write(bytes);
        ((OutputStream)out).close();
    }

    public static String preencherComZerosAEsquerda(String texto, int tamanho) {
        if (texto.length() >= tamanho) {
            return texto;
        }
        StringBuffer sb = new StringBuffer(texto);
        while (sb.length() < tamanho) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    public static byte[] calcularHash(String algoritmo, byte[] dados) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algoritmo);
        md.update(dados);
        return md.digest();
    }

    public static byte[] calcularHash(String algoritmo, InputStream dados, IndicadorProgresso m) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algoritmo);
        byte[] lb = new byte[1024];
        int cb = -1;
        long c = 0L;
        while ((cb = dados.read(lb)) != -1) {
            md.update(lb, 0, cb);
            m.setProgresso(c += (long)cb);
            if (!m.foiCancelado()) continue;
            return null;
        }
        return md.digest();
    }

    public static String removerNaoDigitos(String entrada) {
        if (entrada == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < entrada.length()) {
            char l = entrada.charAt(i);
            if (l >= '0' && l <= '9') {
                sb.append(l);
            }
            ++i;
        }
        return sb.toString();
    }

    public static Properties lerRecnetIni() {
        File pasta = new File(System.getProperty("user.home"), ".receitanet");
        File ini = new File(pasta, "recnet.ini");
        if (!ini.exists()) {
            return new Properties();
        }
        BufferedInputStream bin = null;
        try {
            bin = new BufferedInputStream(new FileInputStream(ini));
            Properties p = new Properties();
            p.load(bin);
            Properties properties = p;
            return properties;
        }
        catch (IOException e) {
            Properties properties = new Properties();
            return properties;
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static long calcularCRC(InputStream dados) throws IOException {
        CRC32 crc = new CRC32();
        byte[] lb = new byte[1024];
        int cb = -1;
        while ((cb = dados.read(lb)) != -1) {
            crc.update(lb, 0, cb);
        }
        return crc.getValue();
    }

    public static boolean eValidoControleRFB(long controleRFB) {
        return controleRFB <= 0xFFFFFFFFL && controleRFB >= 0L;
    }
}

