/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.UIManager;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class FontesUtil {
    private static FontesUtil instancia = new FontesUtil();
    private static String NOME_FONTE_PADRAO = FabricaUtilitarios.isMac() ? "Helvetica Neue" : "RobotoPGD";
    private static String NOME_FONTE_PADRAO_MEDIUM = FabricaUtilitarios.isMac() ? "Helvetica Neue" : "RobotoPGD Medium";
    public static final Font FONTE_NORMAL = new Font(NOME_FONTE_PADRAO, 0, 13);
    public static final Font FONTE_MAIOR = new Font(NOME_FONTE_PADRAO, 0, 14);
    public static final Font FONTE_MEDIUM = new Font(NOME_FONTE_PADRAO_MEDIUM, 0, 13);
    public static final Font FONTE_MENOR = new Font(NOME_FONTE_PADRAO, 0, 13);
    public static final Font FONTE_MENOR_NEGRITO = new Font(NOME_FONTE_PADRAO, 1, 13);
    public static final Font FONTE_XMENOR = new Font(NOME_FONTE_PADRAO, 0, 11);
    public static final Font FONTE_XMENOR_MEDIUM = new Font(NOME_FONTE_PADRAO_MEDIUM, 0, 11);
    public static final Font FONTE_XMENOR_NEGRITO = new Font(NOME_FONTE_PADRAO, 1, 11);
    public static final Font FONTE_TITULO_NORMAL = new Font(NOME_FONTE_PADRAO, 1, 13);
    public static final Font FONTE_TITULO_MENOR = new Font(NOME_FONTE_PADRAO, 1, 12);
    public static final Font FONTE_TITULO_MAIOR = new Font(NOME_FONTE_PADRAO, 1, 15);
    public static final Font FONTE_TITULO_XMAIOR = new Font(NOME_FONTE_PADRAO, 1, 18);
    public static final Font FONTE_TITULO_SPLASH = new Font(NOME_FONTE_PADRAO, 1, 38);
    public static final Font FONTE_EDITOR_NORMAL = new Font(NOME_FONTE_PADRAO, 0, 13);
    public static final Font FONTE_MENU_NORMAL = new Font(NOME_FONTE_PADRAO, 0, 13);
    public static final Color COR_TEXTO_NORMAL = new Color(89, 89, 89);

    public static FontesUtil getInstancia() {
        return instancia;
    }

    private void registraFonte(String nomeArq) {
        try {
            URL urlArq = UtilitariosArquivo.localizaArquivoEmClasspath((String)("/" + nomeArq));
            if (urlArq == null) {
                System.err.println("ERRO: N\u00e3o foi poss\u00edvel localizar a fonte " + urlArq + "!");
                return;
            }
            InputStream stream = urlArq.openStream();
            if (stream == null) {
                System.err.println("ERRO: N\u00e3o foi poss\u00edvel abrir o stream da fonte " + nomeArq + "!");
                return;
            }
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (!ge.registerFont(Font.createFont(0, stream))) {
                LogPPGD.erro((String)("Aten\u00e7\u00e3o: n\u00e3o foi poss\u00edvel registrar a fonte " + nomeArq + ". \u00c9 poss\u00edvel que ela j\u00e1 exista no sistema? Se esse for o caso, ignore."));
            }
            stream.close();
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
        }
    }

    private void configuraFontesDefault() {
        UIManager.put("Button.font", FONTE_EDITOR_NORMAL);
        UIManager.put("RadioButton.font", FONTE_EDITOR_NORMAL);
        UIManager.put("CheckBox.font", FONTE_EDITOR_NORMAL);
        UIManager.put("ComboBox.font", FONTE_EDITOR_NORMAL);
        UIManager.put("FileChooser.font", FONTE_NORMAL);
        UIManager.put("Label.font", FONTE_NORMAL);
        UIManager.put("List.font", FONTE_EDITOR_NORMAL);
        UIManager.put("RadioButtonMenuItem.font", FONTE_EDITOR_NORMAL);
        UIManager.put("PopupMenu.font", FONTE_EDITOR_NORMAL);
        UIManager.put("Frame.font", FONTE_EDITOR_NORMAL);
        UIManager.put("Panel.font", FONTE_EDITOR_NORMAL);
        UIManager.put("ScrollPane.font", FONTE_EDITOR_NORMAL);
        UIManager.put("Viewport.font", FONTE_EDITOR_NORMAL);
        UIManager.put("TabbedPane.font", FONTE_EDITOR_NORMAL);
        UIManager.put("Table.font", FONTE_EDITOR_NORMAL);
        UIManager.put("TextField.font", FONTE_EDITOR_NORMAL);
        UIManager.put("FormattedTextField.font", FONTE_EDITOR_NORMAL);
        UIManager.put("TextArea.font", FONTE_EDITOR_NORMAL);
        UIManager.put("TextPane.font", FONTE_EDITOR_NORMAL);
        UIManager.put("EditorPane.font", FONTE_EDITOR_NORMAL);
        UIManager.put("TitledBorder.font", FONTE_EDITOR_NORMAL);
        UIManager.put("ToolBar.font", FONTE_EDITOR_NORMAL);
        UIManager.put("Tree.font", FONTE_EDITOR_NORMAL);
        UIManager.put("EditValorTotal.font", FONTE_EDITOR_NORMAL.deriveFont(1));
        UIManager.put("EditValor.font", FONTE_EDITOR_NORMAL);
        UIManager.put("OptionPane.messageFont", FONTE_MENOR);
        UIManager.put("OptionPane.buttonFont", FONTE_MENOR);
        UIManager.put("TaskPane.font", FONTE_MENOR_NEGRITO);
        UIManager.put("ToolTip.font", FONTE_MENOR);
        UIManager.put("Menu.font", FONTE_MENU_NORMAL);
        UIManager.put("MenuItem.font", FONTE_MENU_NORMAL);
    }

    private void printFontesDisponiveis() {
        System.out.println("Fontes disponiveis:");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String name : ge.getAvailableFontFamilyNames()) {
            System.out.println(name);
        }
    }

    public void carregaFontes() {
        this.registraFonte("RobotoPGD-Regular.ttf");
        this.registraFonte("RobotoPGD-Bold.ttf");
        this.registraFonte("RobotoPGD-BoldItalic.ttf");
        this.registraFonte("RobotoPGD-Italic.ttf");
        this.registraFonte("RobotoPGD-Light.ttf");
        this.registraFonte("RobotoPGD-LightItalic.ttf");
        this.registraFonte("RobotoPGD-Medium.ttf");
        this.registraFonte("RobotoPGD-MediumItalic.ttf");
        this.registraFonte("RobotoPGD-Black.ttf");
        this.registraFonte("RobotoPGD-BlackItalic.ttf");
        this.configuraFontesDefault();
    }
}

