/*
 * Decompiled with CFR 0.152.
 */
package serpro.receitanet.envelope;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import serpro.receitanet.envelope.Envelope;
import serpro.receitanet.envelope.ExcecaoEnvelope;
import serpro.receitanet.util.Conversoes;
import serpro.receitanet.util.Misc;

public class GeradorEnvelope {
    private static final int DADO_NAO_INFORMADO = -9999999;
    private boolean _versaoDesenvolvimento;
    private boolean _certificavel;
    private int _tipoRetificadora;
    private String _sistema;
    private int _formulario = -9999999;
    private String _exercicioPGD;
    private String _exercicioArquivo;
    private long _controleRFB;
    private boolean _fControleRFB = false;
    private String _criterioUploadPendente;
    private int _versaoPGD = -9999999;
    private String _uf;
    private String _hashArquivo;
    private int _anoComp = 0;
    private int _periodoComp = 0;
    private String _nome;
    private String _label;
    private String _ni;
    private int _tipoNI = -9999999;
    private byte[] _area;
    private long _tamanhoAssinado;
    private String _comentarioAssinatura;
    private List _assinaturas = new ArrayList();
    private Map _extras = new HashMap();

    public int getVersaoEnvelope() {
        return 1;
    }

    public byte[] gerarEnvelope() throws ExcecaoEnvelope {
        Iterator i;
        if (!this.foramDadosObrigatoriosInformados().equals("Ok")) {
            throw new IllegalStateException("Um ou mais dados obrigat\u00f3rios n\u00e3o foram informados (" + this.foramDadosObrigatoriosInformados() + ")." + "Verifique se todos os m\u00e9todos obrigat\u00f3rios foram chamados e se os argumentos " + "deles foram corretamente preenchidos.");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<receitanet versao=\"1\">\n");
        if (this._versaoDesenvolvimento) {
            sb.append("<desenvolvimento/>\n");
        }
        if (this._certificavel) {
            sb.append("<certificavel/>\n");
        }
        sb.append("<retificadora valor=\"").append(this._tipoRetificadora).append("\"/>\n");
        sb.append("<sistema valor=\"").append(this._sistema).append("\"/>\n");
        sb.append("<formulario valor=\"").append(this._formulario).append("\"/>\n");
        if (this._exercicioPGD != null) {
            sb.append("<exercicio_pgd valor=\"").append(this._exercicioPGD).append("\"/>\n");
        }
        if (this._exercicioArquivo != null) {
            sb.append("<exercicio_arquivo valor=\"").append(this._exercicioArquivo).append("\"/>\n");
        }
        sb.append("<versao_pgd valor=\"").append(this._versaoPGD).append("\"/>\n");
        if (this._criterioUploadPendente != null) {
            sb.append("<pend_upload valor=\"").append(this._criterioUploadPendente).append("\"/>\n");
        }
        sb.append("<uf valor=\"").append(this._uf).append("\"/>\n");
        sb.append("<id valor=\"").append(this._hashArquivo).append("\"/>\n");
        sb.append("<controle_rfb valor=\"").append(this._controleRFB).append("\"/>\n");
        sb.append("<competencia periodo=\"").append(this._periodoComp).append("\" ano=\"").append(this._anoComp).append("\"/>\n");
        sb.append("<nome valor=\"").append(this._nome).append("\"");
        if (this._label != null) {
            sb.append(" label=\"").append(this._label).append("\"");
        }
        sb.append("/>\n");
        sb.append("<ni tipo=\"").append(this._tipoNI).append("\" valor=\"").append(this._ni).append("\"/>\n");
        sb.append("<area_reservada>").append(Conversoes.base64StringFromBytes((byte[])this._area)).append("</area_reservada>\n");
        if (this._assinaturas.size() > 0) {
            sb.append("<assinaturas num_bytes_assinados=\"").append(this._tamanhoAssinado).append("\">\n");
            i = this._assinaturas.iterator();
            while (i.hasNext()) {
                if (this._comentarioAssinatura != null) {
                    sb.append("<!--");
                    sb.append(this._comentarioAssinatura);
                    sb.append("-->");
                }
                sb.append("<pkcs7>");
                sb.append(Conversoes.base64StringFromBytes((byte[])((byte[])i.next())));
                sb.append("</pkcs7>\n");
            }
            sb.append("</assinaturas>\n");
        }
        if (this._extras.size() > 0) {
            i = this._extras.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                String chave = (String)e.getKey();
                String valor = (String)e.getValue();
                sb.append("<ext_").append(chave).append(" valor=\"").append(valor).append("\"/>\n");
            }
        }
        sb.append("</receitanet>");
        try {
            byte[] _envelopeXML = Conversoes.bytesFromString((String)sb.toString());
            byte[] md5 = Misc.calcularHash((String)"MD5", (byte[])_envelopeXML);
            String hashEnvelope = Conversoes.base64StringFromBytes((byte[])md5);
            sb.insert(12, "id=\"" + hashEnvelope + "\" ");
            _envelopeXML = Conversoes.bytesFromString((String)sb.toString());
            return _envelopeXML;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new ExcecaoEnvelope("Algoritmo MD5 n\u00e3o dispon\u00edvel.");
        }
    }

    public void anexarEnvelope(File arquivo) throws FileNotFoundException, IOException, ExcecaoEnvelope {
        if (arquivo == null) {
            throw new IllegalArgumentException("A indica\u00e7\u00e3o de um arquivo \u00e9 obrigat\u00f3ria para a anexa\u00e7\u00e3o de um envelope Receitanet.");
        }
        if (!arquivo.exists()) {
            throw new FileNotFoundException("O arquivo " + arquivo.getAbsolutePath() + " n\u00e3o foi encontrado.");
        }
        if (!arquivo.isFile()) {
            throw new IllegalArgumentException("O caminho " + arquivo.getAbsolutePath() + " n\u00e3o indica um arquivo.");
        }
        byte[] envelope = Envelope.removerEnvelope(arquivo);
        boolean append = true;
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(arquivo, true));
        try {
            try {
                out.write(this.gerarEnvelope());
            }
            catch (ExcecaoEnvelope e) {
                out.write(envelope);
                out.close();
            }
        }
        finally {
            out.close();
        }
    }

    public void setComentarioAssinatura(String comentario) {
        this._comentarioAssinatura = comentario;
    }

    public void setDesenvolvimento(boolean versaoDesenvolvimento) {
        this._versaoDesenvolvimento = versaoDesenvolvimento;
    }

    public void setCertificavel(boolean certificavel) {
        this._certificavel = certificavel;
    }

    public void setRetificadora(int tipoRetificadora) {
        this._tipoRetificadora = tipoRetificadora;
    }

    public void setSistema(String sistema) {
        this._sistema = GeradorEnvelope.tratarString(sistema);
    }

    public void setCodigoTipoArquivo(int codigo) {
        this._formulario = codigo;
    }

    public void setExercicioPGD(String exercicio) {
        this._exercicioPGD = exercicio;
    }

    public void setExercicioArquivo(String exercicio) {
        this._exercicioArquivo = exercicio;
    }

    public void setPendenciaUpload(String criterio) {
        this._criterioUploadPendente = GeradorEnvelope.tratarString(criterio);
    }

    public void setVersaoPGD(int versao) {
        if (versao < 0) {
            throw new IllegalArgumentException();
        }
        this._versaoPGD = versao;
    }

    public void setUF(String uf) {
        this._uf = GeradorEnvelope.tratarString(uf);
    }

    public void setHashArquivo(byte[] md5) {
        if ((md5 = (byte[])md5.clone()).length != 16) {
            throw new IllegalArgumentException();
        }
        this._hashArquivo = Conversoes.base64StringFromBytes((byte[])md5);
    }

    public void setCompetencia(int ano, int periodo) {
        this._anoComp = ano;
        this._periodoComp = periodo;
    }

    public void setControleRFB(long controle) {
        if (controle > 0xFFFFFFFFL || controle < 0L) {
            throw new IllegalArgumentException("Valor de controleRFB inv\u00e1lido.");
        }
        this._controleRFB = controle;
        this._fControleRFB = true;
    }

    public void setNome(String nome, String label) {
        this._nome = GeradorEnvelope.tratarString(nome);
        this._label = GeradorEnvelope.tratarString(label);
    }

    public void setNome(String nome) {
        this.setNome(nome, null);
    }

    public void setNI(String ni, int tipo) {
        this._ni = GeradorEnvelope.tratarString(ni);
        this._tipoNI = tipo;
    }

    public void setNI(String ni, String tipo) {
        if (tipo.equalsIgnoreCase("CPF")) {
            this.setNI(ni, 1);
        } else if (tipo.equalsIgnoreCase("CNPJ")) {
            this.setNI(ni, 2);
        } else if (tipo.equalsIgnoreCase("NIRF")) {
            this.setNI(ni, 3);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setAreaReservada(byte[] area) {
        this._area = (byte[])area.clone();
    }

    public void addAssinatura(byte[] assinatura) {
        this._assinaturas.add(assinatura.clone());
    }

    public void setTamanhoAssinado(long tamanho) {
        if (tamanho < 0L) {
            throw new IllegalArgumentException();
        }
        this._tamanhoAssinado = tamanho;
    }

    public void addExtra(String chave, String valor) {
        this._extras.put(GeradorEnvelope.tratarString(chave), GeradorEnvelope.tratarString(valor));
    }

    private static String tratarString(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        return s;
    }

    private String foramDadosObrigatoriosInformados() {
        if (this._sistema == null) {
            return "identificador de sistema";
        }
        if (this._formulario == -9999999) {
            return "c\u00f3digo receitanet";
        }
        if (this._versaoPGD == -9999999) {
            return "vers\u00e3o do PGD";
        }
        if (this._uf == null) {
            return "UF";
        }
        if (this._hashArquivo == null) {
            return "hash do arquivo";
        }
        if (this._nome == null) {
            return "nome";
        }
        if (this._ni == null) {
            return "NI";
        }
        if (this._tipoNI == -9999999) {
            return "tipo do NI";
        }
        if (this._area == null) {
            return "\u00e1rea reservada";
        }
        if (!this._fControleRFB) {
            return "controle RFB";
        }
        return "Ok";
    }
}

