/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import jsignnet.aplicacao.JSignNet;
import jsignnet.crypto.TipoKeyStore;
import jsignnet.crypto.X509CertificadoWrapper;
import jsignnet.erro.CertificadoNaoFoiLido;
import jsignnet.erro.ErroDeLogin;
import jsignnet.erro.JSignException;
import jsignnet.erro.JSignRuntimeException;

public final class KeyStoreUtil {
    private KeyStoreUtil() {
    }

    private static KeyStore getKeystoreImplementacao(TipoKeyStore tipoKeystore) throws JSignException {
        KeyStore keyStore = null;
        try {
            if (tipoKeystore == TipoKeyStore.PKCS12) {
                keyStore = KeyStore.getInstance(tipoKeystore.toString(), "BC");
            } else if (tipoKeystore == TipoKeyStore.SUNMSCAPI) {
                keyStore = KeyStore.getInstance(tipoKeystore.toString(), "SunMSCAPI");
            } else if (tipoKeystore == TipoKeyStore.KEYCHAINSTORE) {
                keyStore = KeyStore.getInstance(tipoKeystore.toString(), "Apple");
            } else if (keyStore == null) {
                keyStore = KeyStore.getInstance(tipoKeystore.toString());
            }
        }
        catch (NoSuchProviderException ex) {
            ex.printStackTrace();
            JSignNet.logger.severe("Provider inexistente: " + tipoKeystore.toString());
            throw new JSignException("Provider inexistente");
        }
        catch (KeyStoreException ex) {
            JSignNet.logger.severe("Erro instanciando keystore: " + tipoKeystore.toString());
            throw new JSignException("Erro instanciando keystore");
        }
        return keyStore;
    }

    public static KeyStore leKeyStore(String arquivoKeystore, char[] senha, TipoKeyStore tipo) throws JSignException {
        return KeyStoreUtil.leKeyStore(new File(arquivoKeystore), senha, tipo);
    }

    public static KeyStore leKeyStore(File arquivoKeyStore, char[] senha, TipoKeyStore tipo) throws JSignException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(arquivoKeyStore);
        }
        catch (FileNotFoundException e) {
            throw new JSignException("Arquivo n\u00e3o encontrado em leKeyStore:" + arquivoKeyStore.toString());
        }
        return KeyStoreUtil.leKeyStore(fis, senha, tipo);
    }

    public static KeyStore leKeyStore(InputStream arquivoKeyStore, char[] senha, TipoKeyStore tipo) throws JSignException {
        KeyStore keyStore = KeyStoreUtil.getKeystoreImplementacao(tipo);
        try {
            keyStore.load(arquivoKeyStore, senha);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JSignException("Erro carregando do keystore de tipo " + tipo.toString() + ".\nO algoritmo usado na assinatura digital n\u00e3o est\u00e1 dispon\u00edvel.");
        }
        catch (CertificateException e) {
            throw new JSignException("Erro carregando do keystore de tipo " + tipo.toString() + ".\nUm dos certificados presentes no arquivo n\u00e3o p\u00f4de ser carregado devido a problemas.");
        }
        catch (IOException e) {
            e.printStackTrace();
            if (tipo.equals(TipoKeyStore.PKCS12)) {
                String mensagemErro = e.getMessage();
                if (mensagemErro.equalsIgnoreCase("stream does not represent a PKCS12 key store")) {
                    throw new JSignException("O arquivo selecionado n\u00e3o \u00e9 um arquivo de certificado v\u00e1lido.");
                }
                if (mensagemErro.indexOf("wrong password or corrupted file") != -1) {
                    throw new JSignException("A senha informada est\u00e1 incorreta ou o arquivo foi corrompido.");
                }
                throw new JSignException("Erro carregando certificado de arquivo.\nErro:[" + mensagemErro + "]");
            }
            throw new JSignException("Erro carregando do keystore de tipo " + tipo.toString() + ", erro:" + e.getMessage());
        }
        catch (ClassCastException e) {
            throw new JSignException("Erro carregando do keystore de tipo " + tipo.toString() + ".\nArquivo inv\u00e1lido. Provavelmente n\u00e3o possui uma chave privada.");
        }
        finally {
            try {
                if (arquivoKeyStore != null) {
                    arquivoKeyStore.close();
                }
            }
            catch (IOException iOException) {}
        }
        return keyStore;
    }

    public static KeyStore leKeyStorePKCS11(String providerPKCS11, final char[] pinSmartcard) throws JSignException {
        KeyStore keyStore = null;
        try {
            if (Security.getProvider(providerPKCS11) == null) {
                throw new CertificadoNaoFoiLido();
            }
            CallbackHandler bogusHandler = new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (int i = 0; i < callbacks.length; ++i) {
                        if (!(callbacks[i] instanceof PasswordCallback)) continue;
                        PasswordCallback callback = (PasswordCallback)callbacks[i];
                        callback.setPassword(pinSmartcard);
                    }
                }
            };
            KeyStoreUtil.login(providerPKCS11, bogusHandler);
            keyStore = KeyStore.getInstance(TipoKeyStore.PKCS11.toString(), providerPKCS11);
        }
        catch (FailedLoginException e) {
            JSignNet.logger.info("Erro de login no provider " + providerPKCS11 + ", senha incorreta.");
            throw new ErroDeLogin(e);
        }
        catch (LoginException e) {
            JSignNet.logger.info("Erro de login no provider " + providerPKCS11 + ", exce\u00e7\u00e3o gen\u00e9rica:" + e.getMessage());
            throw new ErroDeLogin(e);
        }
        catch (GeneralSecurityException e) {
            JSignNet.logger.severe("Erro de login no provider " + providerPKCS11 + ", exce\u00e7\u00e3o de seguran\u00e7a:" + e.getMessage());
            throw new CertificadoNaoFoiLido(e);
        }
        try {
            keyStore.load(null, pinSmartcard);
        }
        catch (Exception e) {
            JSignNet.logger.warning("Erro em keyStore.load, provider " + providerPKCS11 + ", erro:" + e.getMessage());
            throw new JSignException(e, "Erro lendo o keystore PKCS#11 " + providerPKCS11);
        }
        return keyStore;
    }

    private static void login(String nomeProvider, CallbackHandler handler) throws JSignException, LoginException {
        Method login;
        try {
            login = Class.forName("sun.security.pkcs11.SunPKCS11").getMethod("login", Subject.class, CallbackHandler.class);
        }
        catch (Exception e) {
            JSignNet.logger.severe("Provider PKCS#11 da sun n\u00e3o encontrado: " + e.getMessage());
            throw new JSignException(e, "Provider PKCS#11 da sun n\u00e3o encontrado.");
        }
        try {
            login.invoke((Object)Security.getProvider(nomeProvider), null, handler);
        }
        catch (InvocationTargetException exc) {
            if (LoginException.class.isInstance(exc.getCause())) {
                throw (LoginException)exc.getCause();
            }
            if (Exception.class.isInstance(exc.getCause())) {
                throw new JSignException((Exception)exc.getCause());
            }
            if (Error.class.isInstance(exc.getCause())) {
                throw (Error)exc.getCause();
            }
            throw new JSignException("Erro de implementa\u00e7\u00e3o.");
        }
        catch (Exception e) {
            JSignNet.logger.severe("Erro invocando login em PKCS#11 no provider " + nomeProvider + ", erro:" + e.getMessage());
            throw new JSignException(e, "Erro invocando login em PKCS#11 no provider " + nomeProvider);
        }
    }

    public static KeyStore leKeyStore(TipoKeyStore tipo) throws JSignException {
        KeyStore keyStore = null;
        keyStore = KeyStoreUtil.getKeystoreImplementacao(tipo);
        try {
            keyStore.load(null, null);
        }
        catch (Exception e) {
            throw new JSignException(e, "Erro carregando do keystore de tipo " + tipo.toString());
        }
        return keyStore;
    }

    public static void salvaNovaKeyStore(KeyStore keyStore, File arquivoDestino, char[] senha) throws JSignException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(arquivoDestino);
            keyStore.store(fos, senha);
        }
        catch (Exception e) {
            throw new JSignException("Erro salvando store no arquivo JKS:" + e.getMessage());
        }
        finally {
            try {
                if (fos != null) {
                    fos.flush();
                    fos.close();
                }
            }
            catch (IOException e) {
                throw new JSignException("Erro fechando arquivo JKS:" + e.getMessage());
            }
        }
    }

    public static boolean importaCertificado(X509CertificadoWrapper certificado, KeyStore keyStoreDestino, String nomeArquivo, char[] pinCertificadoOrigem, char[] pinCertificadoDestino, char[] senhaContainerDestino) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, IOException, Exception {
        boolean resposta = false;
        if (!certificado.hasPrivateKey(certificado.getAlias())) {
            throw new JSignRuntimeException("Certificado n\u00e3o \u00e9 v\u00e1lido.");
        }
        if (!KeyStoreUtil.isContainerJaPossuiCertificado(keyStoreDestino, certificado)) {
            keyStoreDestino.setKeyEntry(certificado.getAlias(), certificado.getChavePrivada(pinCertificadoOrigem), pinCertificadoDestino, certificado.getCadeiaCertificados());
            resposta = true;
            KeyStoreUtil.salvaNovaKeyStore(keyStoreDestino, new File(nomeArquivo), senhaContainerDestino);
        }
        return resposta;
    }

    public static boolean isContainerJaPossuiCertificado(KeyStore keystore, X509CertificadoWrapper certificado) throws KeyStoreException {
        boolean resposta = false;
        String alias = certificado.getAlias();
        Enumeration<String> aliases = keystore.aliases();
        if (aliases != null) {
            while (aliases.hasMoreElements() && !resposta) {
                String elemento = aliases.nextElement();
                if (!elemento.equalsIgnoreCase(alias)) continue;
                resposta = true;
            }
        }
        return resposta;
    }
}

