/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.infra;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;

public class CMSProcessablePartialFile
implements CMSProcessable {
    private static final int DEFAULT_BUF_SIZE = 32768;
    private final File _file;
    private final long _fileSize;
    private final byte[] _buf;

    public CMSProcessablePartialFile(File file, long fileSize) {
        this(file, fileSize, 32768);
    }

    public CMSProcessablePartialFile(File file, long fileSize, int bufSize) {
        this._file = file;
        this._buf = new byte[bufSize];
        this._fileSize = fileSize;
    }

    @Override
    public void write(OutputStream zOut) throws IOException, CMSException {
        int len;
        FileInputStream fIn = new FileInputStream(this._file);
        long bytesLeft = this._fileSize;
        int toBeRead = (int)Math.min(bytesLeft, (long)this._buf.length);
        while ((len = fIn.read(this._buf, 0, toBeRead)) > 0) {
            zOut.write(this._buf, 0, len);
            toBeRead = (int)Math.min(bytesLeft -= (long)len, (long)this._buf.length);
        }
        assert (toBeRead == 0) : toBeRead + " bytes weren\u00b4t read from the file.";
        fIn.close();
    }

    @Override
    public Object getContent() {
        return this._file;
    }
}

