/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import serpro.ppgd.formatosexternos.PPGDJasperViewer;
import serpro.ppgd.formatosexternos.RelatorioIf;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class RelatorioDB
implements RelatorioIf {
    private static String driver = FabricaUtilitarios.getProperties().getProperty("aplicacao.persistencia.conexaoDB.driver");
    private static String url = FabricaUtilitarios.getProperties().getProperty("aplicacao.persistencia.conexaoDB.url");
    private static String login = FabricaUtilitarios.getProperties().getProperty("aplicacao.persistencia.conexaoDB.usuario");
    private static String pass = FabricaUtilitarios.getProperties().getProperty("aplicacao.persistencia.conexaoDB.senha");
    private String relatorioJasper;
    private boolean isHabilitado = true;
    private String titulo;
    private Map<String, Object> params;
    private JasperPrint jasperPrint;
    private boolean preparado = false;

    public RelatorioDB(String aTitulo, String aRelatorioJasper) {
        this.setTitulo(aTitulo);
        this.setRelatorioJasper(aRelatorioJasper);
        this.params = new HashMap<String, Object>();
    }

    @Override
    public void imprimir() {
        try {
            this.prepara();
            JasperPrintManager.printReport((JasperPrint)this.jasperPrint, (boolean)true);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void visualizar() {
        this.prepara();
        PPGDJasperViewer viewer = new PPGDJasperViewer(this.jasperPrint, true, new Locale("pt", "BR"));
        viewer.setVisible(true);
    }

    @Override
    public void prepara() {
        if (!this.isPreparado()) {
            try {
                Connection con = DriverManager.getConnection(url, login, pass);
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                this.jasperPrint = JasperFillManager.fillReport((InputStream)streamRel, this.params, (Connection)con);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.preparado = true;
        }
    }

    @Override
    public String getTitulo() {
        return this.titulo;
    }

    @Override
    public void setTitulo(String aTitulo) {
        this.titulo = aTitulo;
    }

    private void setRelatorioJasper(String relatorioJasper) {
        this.relatorioJasper = relatorioJasper;
    }

    private String getRelatorioJasper() {
        return this.relatorioJasper;
    }

    @Override
    public boolean isHabilitado() {
        return this.isHabilitado;
    }

    @Override
    public void setHabilitado(boolean aHabilitado) {
        this.isHabilitado = aHabilitado;
    }

    @Override
    public boolean isPreparado() {
        return this.preparado;
    }

    static {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

