/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.txt;

import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Valor;

public class CampoTXT {
    private static final String TIPO_DATA = "D";
    private static final String TIPO_BOOLEAN = "I";
    private static final String TIPO_ALFA = "A";
    private static final String TIPO_CHAR = "C";
    private static final String TIPO_NUMERICO = "N";
    private String fNome;
    private String fTipo;
    private String fConteudo;
    private int fTamanho;
    private int fDecimais;
    private boolean fAutomatico;
    private String atributoObjetoNegocio = null;

    public CampoTXT(String nome, String tipoTamanho) throws GeracaoTxtException {
        int decimais = 0;
        String tipos = "CcAaNnIiDd";
        this.fNome = nome;
        this.fTamanho = 0;
        if (tipos.indexOf(tipoTamanho.charAt(0)) == -1) {
            // empty if block
        }
        this.fTipo = tipoTamanho.substring(0, 1);
        if (this.fTipo.equals(TIPO_BOOLEAN)) {
            this.fTamanho = 1;
        } else if (this.fTipo.equals(TIPO_CHAR) || this.fTipo.equals(TIPO_ALFA)) {
            this.fTamanho = Integer.parseInt(tipoTamanho.substring(1, tipoTamanho.length()));
        } else if (this.fTipo.equals(TIPO_NUMERICO)) {
            int tamanho = tipoTamanho.indexOf(",");
            if (tamanho < 0) {
                tamanho = tipoTamanho.length();
            } else {
                decimais = Integer.parseInt(tipoTamanho.substring(tamanho + 1, tipoTamanho.length()));
            }
            String aux = tipoTamanho.substring(1, tamanho);
            this.fTamanho = Integer.parseInt(aux);
            if (decimais > this.fTamanho) {
                throw new GeracaoTxtException("Erro de layout - Campo " + this.fNome + " com n\u00ef\u00bf\u00bdmero de decimais maior que tamanho.");
            }
            this.fDecimais = decimais;
        } else {
            this.fTamanho = 8;
        }
    }

    public CampoTXT(String nome, String tipoTamanho, boolean informacaoAutomatica) throws GeracaoTxtException {
        this(nome, tipoTamanho);
        this.fAutomatico = informacaoAutomatica;
    }

    private boolean getBoolean() {
        if ("SsNn10".indexOf(this.fConteudo) == -1) {
            // empty if block
        }
        return this.fConteudo.equals("S") || this.fConteudo.equals("1");
    }

    private int getInteger() {
        int aux = 0;
        if (this.fTipo.equals(TIPO_NUMERICO)) {
            aux = Integer.parseInt(this.fConteudo);
        } else if (this.fTipo.equals(TIPO_CHAR)) {
            if (this.fConteudo.trim().length() == 0) {
                // empty if block
            }
            aux = Integer.parseInt(this.fConteudo);
        } else if (this.fTipo.equals(TIPO_DATA)) {
            if (this.fConteudo.trim().length() == 0) {
                // empty if block
            }
            aux = Integer.parseInt(this.fConteudo);
        } else if (this.fTipo.equals(TIPO_BOOLEAN)) {
            aux = this.fConteudo == "S" ? 1 : 0;
        }
        return aux;
    }

    private String getString() {
        if (this.fConteudo == null) {
            return "";
        }
        return this.fConteudo;
    }

    private void setBoolean(boolean value) {
        this.fConteudo = this.fTipo.equals(TIPO_BOOLEAN) || this.fTipo.equals(TIPO_CHAR) ? (value ? "S" : TIPO_NUMERICO) : (value ? "1" : "0");
    }

    private void setInteger(int value) throws GeracaoTxtException {
        String aux;
        if (this.fTipo.equals(TIPO_BOOLEAN)) {
            if (value == 1) {
                this.fConteudo = "S";
            } else if (value == 0) {
                this.fConteudo = TIPO_NUMERICO;
            } else {
                throw new GeracaoTxtException("Erro atribuindo conte\u00ef\u00bf\u00bddo a campo do tipo Indicador " + this.fNome + ".");
            }
        }
        if ((aux = String.valueOf(value)).length() > this.fTamanho) {
            throw new GeracaoTxtException("Erro atribuindo conte\u00ef\u00bf\u00bddo a campo do tipo Indicador " + this.fNome + ".");
        }
        this.fConteudo = aux;
    }

    protected void setString(String value) throws GeracaoTxtException {
        String aux = value.trim().toUpperCase();
        if (this.fTipo.equals(TIPO_DATA)) {
            while (aux.indexOf("/") > 0) {
                aux = aux.substring(0, aux.indexOf("/")) + aux.substring(aux.indexOf("/") + 1);
            }
            if (aux.length() > this.fTamanho) {
                throw new GeracaoTxtException("Erro atribuindo conte\u00ef\u00bf\u00bddo maior que o tamanho do campo " + this.fNome + ".");
            }
            this.fConteudo = aux;
        } else {
            if (aux.length() > this.fTamanho) {
                throw new GeracaoTxtException("Erro atribuindo conteudo ('" + aux + "') maior que o tamanho do campo " + this.fNome + ". Tamanho esperado: " + this.fTamanho);
            }
            if (this.fTipo.equals(TIPO_CHAR) || this.fTipo.equals(TIPO_ALFA)) {
                this.fConteudo = aux;
            } else if (this.fTipo.equals(TIPO_NUMERICO)) {
                if (aux.length() == 0) {
                    this.fConteudo = "0";
                    aux = "0";
                }
                if (this.fDecimais == 0) {
                    try {
                        Long.parseLong(aux);
                        this.fConteudo = aux;
                    }
                    catch (Exception e) {
                        throw new GeracaoTxtException("Erro atribuindo conte\u00ef\u00bf\u00bddo inv\u00ef\u00bf\u00bdlido ao campo " + this.fNome + ".");
                    }
                } else {
                    if (this.fDecimais > 0 & aux.indexOf(".") > 0 && this.fDecimais < aux.substring(aux.indexOf(".") + 1).length()) {
                        throw new GeracaoTxtException("Quantidade de decimais maior que o permitido no campo " + this.fNome + ".");
                    }
                    Double.parseDouble(aux);
                    this.fConteudo = aux;
                }
            } else if (this.fTipo.equals(TIPO_BOOLEAN)) {
                if (aux.length() > 1) {
                    aux = aux.substring(0, 0);
                }
                if (aux.equalsIgnoreCase("S") || aux.equalsIgnoreCase(TIPO_NUMERICO)) {
                    this.fConteudo = aux.toUpperCase();
                } else if (aux.length() == 0) {
                    this.fConteudo = " ";
                }
            } else {
                throw new GeracaoTxtException("<html>Quantidade de decimais maior que o<br>definido para o campo " + this.fNome + ".</html>");
            }
        }
    }

    private String getTxt() throws GeracaoTxtException {
        String texto = this.getString().trim();
        if (this.fTipo.equals(TIPO_CHAR) | this.fTipo.equals(TIPO_BOOLEAN) | this.fTipo.equals(TIPO_DATA) | this.fTipo.equals(TIPO_ALFA)) {
            if (texto.length() > this.fTamanho) {
                texto = texto.substring(1, this.fTamanho);
            }
            while (texto.length() < this.fTamanho) {
                texto = texto.concat(" ");
            }
        } else if (this.fTipo.equals(TIPO_NUMERICO)) {
            texto.replaceAll("[,.]", "");
            int aux = texto.length();
            if (aux > this.fTamanho + this.fDecimais) {
                throw new GeracaoTxtException("Erro atribuindo conte\u00ef\u00bf\u00bddo (" + texto + ") maior que o tamanho do campo " + this.fNome + ".");
            }
            while (texto.length() < this.fTamanho) {
                texto = "0".concat(texto);
            }
            if (texto.indexOf("-") >= 0) {
                texto = texto.replaceAll("-", "");
                texto = "-".concat(texto);
            }
        }
        return texto;
    }

    private void setLogico(Logico value) {
        this.fConteudo = value.asString();
    }

    public boolean estaPreenchido() throws NumberFormatException, GeracaoTxtException {
        if (this.fAutomatico) {
            return false;
        }
        if (this.getString().length() == 0) {
            return false;
        }
        return !this.fTipo.equals(TIPO_NUMERICO) || Double.parseDouble(this.getTxt()) != 0.0;
    }

    public String getNome() {
        return this.fNome;
    }

    public String getTipo() {
        return this.fTipo;
    }

    public int getTamanho() {
        return this.fTamanho;
    }

    public int getDecimais() {
        return this.fDecimais;
    }

    public String asString() {
        return this.getString();
    }

    public boolean asBoolean() {
        return this.getBoolean();
    }

    public int asInteger() {
        return this.getInteger();
    }

    public Valor asValor() {
        Valor val = new Valor();
        val.setCasasDecimais(this.getDecimais());
        val.setConteudo(Long.valueOf(this.asString()));
        return val;
    }

    public Alfa asAlfa() {
        Alfa info = new Alfa();
        info.setConteudo(this.asString());
        return info;
    }

    public Informacao asInformacao() {
        Valor info = null;
        boolean aux = false;
        if (this.getTipo().equals(TIPO_NUMERICO)) {
            info = this.asValor();
        } else if (this.getTipo().equals(TIPO_CHAR) || this.getTipo().equals(TIPO_ALFA) || this.getTipo().equals(TIPO_BOOLEAN)) {
            info = this.asAlfa();
        } else if (this.getTipo().equals(TIPO_DATA)) {
            info = new Data();
            info.setConteudo(this.asString());
        }
        return info;
    }

    public String asTxt() throws GeracaoTxtException {
        return this.getTxt();
    }

    public void set(String valor) throws GeracaoTxtException {
        this.setString(valor);
    }

    public void setLimitado(String valor) throws GeracaoTxtException {
        if (valor.length() > this.getTamanho()) {
            valor = valor.substring(0, this.getTamanho());
        }
        this.setString(valor);
    }

    public void set(boolean valor) {
        this.setBoolean(valor);
    }

    public void set(int valor) throws GeracaoTxtException {
        this.setInteger(valor);
    }

    public void set(Valor pValor) throws GeracaoTxtException {
        boolean ehNegativo;
        Valor valArmazenado = pValor;
        if (pValor.getCasasDecimais() != this.getDecimais()) {
            valArmazenado = new Valor();
            valArmazenado.setConteudo(pValor);
            valArmazenado.converteQtdCasasDecimais(this.getDecimais());
        }
        String valTxt = valArmazenado.asTxt();
        String acrescimo = "";
        int totalAcrescimos = this.getTamanho();
        boolean bl = ehNegativo = pValor.getConteudo() < 0L;
        if (ehNegativo) {
            --totalAcrescimos;
            valTxt = valTxt.replaceAll("-", "");
        }
        if (valTxt.length() < totalAcrescimos) {
            for (int i = 0; i < totalAcrescimos - valTxt.length(); ++i) {
                acrescimo = acrescimo + "0";
            }
        }
        if (ehNegativo) {
            acrescimo = "-" + acrescimo;
        }
        this.set(acrescimo + valTxt);
    }

    public void set(Logico valor) {
        this.setLogico(valor);
    }

    public String getAtributoObjetoNegocio() {
        if (this.atributoObjetoNegocio == null) {
            this.atributoObjetoNegocio = "";
        }
        return this.atributoObjetoNegocio;
    }

    public void setAtributoObjetoNegocio(String pAcessoObjetoNegocio) {
        this.atributoObjetoNegocio = pAcessoObjetoNegocio;
    }

    public static void main(String[] args) throws GeracaoTxtException {
    }
}

