/*
 * Decompiled with CFR 0.152.
 */
package serpro.receitanet.envelope;

class ByteList {
    private transient byte[] elementData;
    private int size;

    public ByteList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new byte[initialCapacity];
    }

    public ByteList() {
        this(2048);
    }

    public void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.size < oldCapacity) {
            byte[] oldData = this.elementData;
            this.elementData = new byte[this.size];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            byte[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new byte[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public byte[] toArray() {
        byte[] result = new byte[this.size];
        System.arraycopy(this.elementData, 0, result, 0, this.size);
        return result;
    }

    public byte get(int index) {
        this.RangeCheck(index);
        return this.elementData[index];
    }

    public byte set(int index, byte element) {
        this.RangeCheck(index);
        byte oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    public boolean add(byte o) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = o;
        return true;
    }

    public void add(int index, byte element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    public void addAll(byte[] elements) {
        int otherSize = elements.length;
        this.ensureCapacity(this.size + otherSize);
        System.arraycopy(elements, 0, this.elementData, this.size, otherSize);
        this.size += otherSize;
    }

    public void addAll(ByteList list) {
        this.addAll(list.toArray());
    }

    public byte remove(int index) {
        this.RangeCheck(index);
        byte oldValue = this.elementData[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        --this.size;
        return oldValue;
    }

    public byte removeLast() {
        int index = --this.size;
        return this.elementData[index];
    }

    public void clear() {
        this.size = 0;
    }

    private void RangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            sb.append(Integer.toHexString(this.elementData[i]));
        }
        return sb.toString();
    }

    public void copy(int offsetSrc, int length, byte[] b, int offsetDst) {
        System.arraycopy(this.elementData, offsetSrc, b, offsetDst, length);
    }
}

