/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app;

import java.io.IOException;
import javax.swing.ToolTipManager;
import serpro.ppgd.app.PlataformaITRPGD;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.VisualizadorHelp;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.gui.SplashScreen;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.util.AplicacaoPropertiesUtil;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.itr.util.SingleInstanceUtil;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public abstract class PGDAb {
    protected static final String ARG_LEIAME = "--leia-me";
    protected static final String ARG_AJUDA = "--ajuda";
    protected static final String ARG_HELP = "--help";
    protected static final String ARG_H = "-h";
    protected static final String ARG_DESINSTALAR = "--desinstalar";
    protected static final String ARG_VERIFICA = "--verifica";

    protected abstract boolean getPermiteMaisDeUmaInstanciaAplicacao();

    protected abstract void posCriar(PlataformaPPGD var1);

    protected PGDAb(Class<?> pJanelaPrincipal) throws IOException {
        this.verificarLock();
        SplashScreen splash = new SplashScreen(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/imagens/splash.png"), null, 1500);
        PlataformaPPGD.setPlataforma((PlataformaPPGD)new PlataformaITRPGD());
        PlataformaPPGD lPlataformaPPGD = PlataformaPPGD.getPlataforma();
        lPlataformaPPGD.carrega(pJanelaPrincipal);
        ITRFacade.getInstancia();
        ITRFacade.verificaIdDeclaracoes();
        String tooltipdelay = FabricaUtilitarios.getProperties().getProperty("aplicacao.tooltipdelay", "");
        if (tooltipdelay.length() > 0) {
            try {
                ToolTipManager.sharedInstance().setDismissDelay(Integer.parseInt(tooltipdelay));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        splash.setShowing(false);
        lPlataformaPPGD.exibe();
        lPlataformaPPGD.getJanelaPrincipal().setExtendedState(lPlataformaPPGD.getJanelaPrincipal().getExtendedState() | 6);
        this.posCriar(lPlataformaPPGD);
    }

    public static void verificaVersaoMinimaJava() throws Exception {
        boolean versaoIncompativel = false;
        Object lVersaoJava = System.getProperty("java.version");
        try {
            if (!((String)lVersaoJava).contains(".")) {
                lVersaoJava = (String)lVersaoJava + ".0.0";
            }
            if (!((String)lVersaoJava).contains("_")) {
                lVersaoJava = (String)lVersaoJava + "_00";
            }
            float lNumVersaoEspecificacao = Float.parseFloat(((String)lVersaoJava).substring(0, 3));
            String pVersaoRequerida = "1.7.0_111";
            if (lNumVersaoEspecificacao == Float.valueOf("1.8").floatValue()) {
                pVersaoRequerida = "1.8.0_101";
            }
            float lNumVersaoEspecificacaoRequerida = Float.parseFloat(pVersaoRequerida.substring(0, 3));
            int lNumVersaoSegundaRequerida = Integer.parseInt("" + pVersaoRequerida.charAt(4));
            int lNumVersaoBuildRequerida = Integer.parseInt(pVersaoRequerida.substring(6));
            if (lNumVersaoEspecificacao < lNumVersaoEspecificacaoRequerida) {
                versaoIncompativel = true;
            } else if (lNumVersaoEspecificacao == lNumVersaoEspecificacaoRequerida) {
                int lNumVersaoBuild;
                int lNumVersaoSegunda = Integer.parseInt("" + ((String)lVersaoJava).charAt(4));
                if (lNumVersaoSegunda < lNumVersaoSegundaRequerida) {
                    versaoIncompativel = true;
                }
                if ((lNumVersaoBuild = Integer.parseInt(((String)lVersaoJava).substring(6))) < lNumVersaoBuildRequerida) {
                    versaoIncompativel = true;
                }
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            versaoIncompativel = true;
        }
        String archModel = System.getProperty("sun.arch.data.model");
        archModel = archModel == null || !archModel.equals("64") ? "" : "(64 bits)";
        if (versaoIncompativel) {
            String msg = MensagemUtil.getMensagem("VersaoBuildJavaIncompativel", new String[]{lVersaoJava, archModel});
            throw new Exception(msg);
        }
    }

    protected static void verificarSO() throws Exception {
        if (System.getProperty("os.name").toLowerCase().startsWith("windows 95")) {
            String msg = MensagemUtil.getMensagem("ErroCompatibilidadeSO");
            throw new Exception(msg);
        }
    }

    protected static void mostrarHelp() {
        VisualizadorHelp visualizador = new VisualizadorHelp();
        visualizador.exibe();
    }

    protected static void mostrarLeiame() {
        PGDAb.execXdgOpen("Leia-me.htm");
    }

    protected static void mostrarAjuda() {
        PGDAb.execXdgOpen("./help/AjudaITR.pdf");
    }

    protected static void desinstalarLinux() {
        try {
            Runtime.getRuntime().exec("./uninstall", null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    protected static void execXdgOpen(String file) {
        try {
            Runtime.getRuntime().exec("xdg-open " + file, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    protected void verificarLock() {
        if (!this.getPermiteMaisDeUmaInstanciaAplicacao() && PGDAb.verificaPGDEmExecucao()) {
            GuiUtil.mostrarAviso("CopiaJaEmExecucao", new String[]{AplicacaoPropertiesUtil.getTituloVersao()});
            System.exit(1);
        }
    }

    protected static boolean verificaPGDEmExecucao() {
        return SingleInstanceUtil.lock();
    }

    protected static boolean possuiArgumentosExecucao(String[] args) {
        return args.length > 0 && (args[0].equals(ARG_LEIAME) || args[0].equals(ARG_AJUDA) || args[0].equals(ARG_HELP) || args[0].equals(ARG_H) || args[0].equals(ARG_DESINSTALAR));
    }
}

