/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import serpro.ppgd.app.PGDAb;
import serpro.ppgd.infraestrutura.JanelaPrincipalPPGD;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.VisualizadorHelp;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.JanelaPrincipalITR;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.itr.util.OpcoesApp;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class PgdITR
extends PGDAb {
    private PlataformaPPGD plataforma = PlataformaPPGD.getPlataforma();
    public static Font FONTE_DEFAULT = null;
    public static final int SPLIT_DIVIDER_LOCATION = 130;
    public static final String VERSAO_JAVA_INCOMPATIVEL_WIN = "A configura\u00e7\u00e3o m\u00ednima para utilizar o programa ITR" + ConstantesGlobais.EXERCICIO + " \n\u00e9 o sistema operacional Windows 98SE ou posterior.";
    private static boolean permiteMaisDeUmaInstanciaAplicacao = false;

    public PgdITR() throws Exception {
        super(JanelaPrincipalITR.class);
    }

    private void ajustaBotoesToolbar(JToolBar tool) {
        for (int i = tool.getComponentCount() - 1; i >= 0; --i) {
            Component c = tool.getComponent(i);
            if (!(c instanceof JButton)) continue;
            int tam = 36;
            ((JButton)c).setPreferredSize(new Dimension(tam, tam));
            ((JButton)c).setSize(new Dimension(tam, tam));
            ((JButton)c).setMinimumSize(new Dimension(tam, tam));
            ((JButton)c).setMaximumSize(new Dimension(tam, tam));
        }
    }

    public static void preparaFontes() {
        boolean temArial = false;
        boolean temSansSerif = false;
        boolean temDialog = false;
        Font fontDefault = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontnames = ge.getAvailableFontFamilyNames();
        for (int i = 0; i < fontnames.length; ++i) {
            if (fontnames[i].equals("SansSerif")) {
                temSansSerif = true;
                continue;
            }
            if (fontnames[i].equals("Arial")) {
                temArial = true;
                continue;
            }
            if (!fontnames[i].equals("Dialog")) continue;
            temDialog = true;
        }
        fontDefault = System.getProperty("os.name").startsWith("Linux") ? (temSansSerif ? new Font("SansSerif", 0, 10) : (temArial ? new Font("Arial", 0, 10) : (temDialog ? new Font("Dialog", 0, 10) : new Font("Default", 0, 10)))) : (System.getProperty("os.name").startsWith("Mac") ? (temSansSerif ? new Font("SansSerif", 0, 10) : (temArial ? new Font("Arial", 0, 10) : (temDialog ? new Font("Dialog", 0, 10) : new Font("Default", 0, 10)))) : (temSansSerif ? new Font("SansSerif", 0, 11) : (temArial ? new Font("Arial", 0, 10) : (temDialog ? new Font("Dialog", 0, 10) : new Font("Default", 0, 10)))));
        UIManager.put("Button.font", fontDefault);
        UIManager.put("RadioButton.font", fontDefault);
        UIManager.put("CheckBox.font", fontDefault);
        UIManager.put("FileChooser.font", fontDefault);
        UIManager.put("Label.font", fontDefault);
        UIManager.put("List.font", fontDefault);
        UIManager.put("RadioButtonMenuItem.font", fontDefault);
        UIManager.put("PopupMenu.font", fontDefault);
        UIManager.put("Frame.font", fontDefault);
        UIManager.put("Panel.font", fontDefault);
        UIManager.put("ScrollPane.font", fontDefault);
        UIManager.put("Viewport.font", fontDefault);
        UIManager.put("TabbedPane.font", fontDefault);
        UIManager.put("Table.font", fontDefault);
        UIManager.put("TextField.font", fontDefault);
        UIManager.put("FormattedTextField.font", fontDefault);
        UIManager.put("TextArea.font", fontDefault);
        UIManager.put("TextPane.font", fontDefault);
        UIManager.put("EditorPane.font", fontDefault);
        UIManager.put("TitledBorder.font", fontDefault);
        UIManager.put("ToolBar.font", fontDefault);
        UIManager.put("ToolTip.font", fontDefault.deriveFont(1));
        UIManager.put("Tree.font", fontDefault);
        FONTE_DEFAULT = fontDefault;
    }

    private static void chamaHelp() {
        VisualizadorHelp visualizador = new VisualizadorHelp();
        visualizador.exibe();
        Frame.getFrames()[0].addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public static void main(String[] args) throws Exception {
        try {
            if (args.length > 0 && args[0].equals("--verifica")) {
                if (PgdITR.verificaPGDEmExecucao()) {
                    System.out.print("1");
                } else {
                    System.out.print("0");
                }
                return;
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)("Ocorreu uma falha na execu\u00e7\u00e3o do PGDITR: " + e.getMessage()));
        }
        if (FabricaUtilitarios.isLinux() && args.length > 0) {
            if (args[0].equals("--leia-me")) {
                PgdITR.mostrarLeiame();
            } else if (args[0].equals("--ajuda")) {
                PgdITR.mostrarAjuda();
            } else if (args[0].equals("--desinstalar")) {
                PgdITR.desinstalarLinux();
            }
        }
        try {
            OpcoesApp opcoes = new OpcoesApp(args);
            opcoes.processaArgs();
            PgdITR.verificarSO();
            PgdITR.verificaVersaoMinimaJava();
            if (args.length > 0 && (args[0].equals("-h") || args[0].equals("--help"))) {
                PgdITR.mostrarHelp();
            } else {
                new PgdITR();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            GuiUtil.mostrarErro(null, e.getMessage());
            System.exit(1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            GuiUtil.mostrarErro(null, "Ocorreu um erro inesperado!\nO aplicativo ser\u00e1 encerrado!");
            System.exit(1);
        }
    }

    private static void verificaVersaoMinimaJVM() {
        int numVersaoTerceiro;
        int VERSAO_MINIMA_SEGUNDO = 4;
        boolean VERSAO_MINIMA_TERCEIRO = true;
        String versaoJVM = System.getProperty("java.version");
        int numVersaoSegundo = Integer.parseInt("" + versaoJVM.charAt(2));
        boolean versaoIncompativel = false;
        if (numVersaoSegundo < 4) {
            versaoIncompativel = true;
        } else if (numVersaoSegundo == 4 && (numVersaoTerceiro = Integer.parseInt("" + versaoJVM.charAt(4))) < 1) {
            versaoIncompativel = true;
        }
        if (versaoIncompativel) {
            String msg = MensagemUtil.getMensagem("versao_java_incompativel", new String[]{versaoJVM});
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), msg, "ITR" + ConstantesGlobais.EXERCICIO, 1);
            System.exit(1);
        }
    }

    @Override
    protected boolean getPermiteMaisDeUmaInstanciaAplicacao() {
        return false;
    }

    @Override
    protected void posCriar(PlataformaPPGD pPlataforma) {
        ControladorGui.init();
        ((JanelaPrincipalPPGD)PlataformaPPGD.getPlataforma().getJanelaPrincipal()).configurarHelp();
    }

    static class DebugBorder
    implements Border {
        private Border b;

        public DebugBorder(Border b) {
            this.b = b;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.b.paintBorder(c, g, x, y, width, height);
            Insets insets = this.b.getBorderInsets(c);
            Color layerColor = new Color(0.0f, 1.0f, 0.0f, 0.35f);
            g.setColor(layerColor);
            g.fillRect(x, y, width, insets.top);
            g.fillRect(x, y + insets.top, insets.left, height - insets.bottom - insets.top);
            g.fillRect(x, y + height - insets.bottom, width, insets.bottom);
            g.fillRect(x + width - insets.right, y + insets.top, insets.right, height - insets.bottom - insets.top);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.b.getBorderInsets(c);
        }

        @Override
        public boolean isBorderOpaque() {
            return this.b.isBorderOpaque();
        }

        public Border getDelegate() {
            return this.b;
        }
    }

    static class DebugEventListener
    implements AWTEventListener {
        DebugEventListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            Object o = event.getSource();
            if (o instanceof JComponent) {
                JComponent source = (JComponent)o;
                Border border = source.getBorder();
                switch (event.getID()) {
                    case 1005: {
                        if (border == null || !(border instanceof DebugBorder)) break;
                        source.setBorder(((DebugBorder)border).getDelegate());
                        break;
                    }
                    case 1004: {
                        if (border == null) break;
                        source.setBorder(new DebugBorder(border));
                    }
                }
            }
        }

        public void printHierarchy(Container c) {
            Container p = c.getParent();
            if (p != null) {
                this.printHierarchy(p);
            }
        }
    }
}

