/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import serpro.ppgd.app.acoes.NovidadesAction;
import serpro.ppgd.app.acoes.SairAction;
import serpro.ppgd.app.acoes.VerificarNovaVersaoAction;
import serpro.ppgd.infraestrutura.JanelaPrincipalPPGD;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.itr.ajuda.PGDITRHelp;
import serpro.ppgd.itr.exception.AplicacaoException;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.Toast;
import serpro.ppgd.itr.gui.update.PainelAvisoVerificarAtualizacoes;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.itr.util.update.ITRUpdateProperties;
import serpro.ppgd.itr.util.update.ITRUpdater;

public class PlataformaITRPGD
extends PlataformaPPGD {
    private SairAction fecharAction = new SairAction();
    private PGDITRHelp help = new PGDITRHelp();

    public void carrega(Class<?> classJanelaPGD) {
        try {
            PlataformaITRPGD.setEmDesign((boolean)false);
            this.configuraFontes();
            this.setAplicativo((JanelaPrincipalPPGD)classJanelaPGD.newInstance());
            this.help.carregaHelp();
            this.getJanelaPrincipal().setDefaultCloseOperation(0);
            this.getJanelaPrincipal().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PlataformaITRPGD.this.fecharAction.actionPerformed(null);
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    if (!PlataformaITRPGD.this.finalizouAtualizacao()) {
                        if (!ControladorGui.getITRPreferences().getBoolean(ControladorGui.NAO_EXIBIR_NOVIDADES_ITR, false)) {
                            new NovidadesAction().executarAcao(null);
                        }
                        PlataformaITRPGD.this.verificarNovaVersao();
                    }
                }
            });
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    private boolean finalizouAtualizacao() {
        boolean finalizouAtualizacao = false;
        ITRUpdater itrUpdater = ITRUpdater.getInstance();
        if (itrUpdater.temPermissaoEscritaPastaBase()) {
            ITRUpdateProperties updateProperties = null;
            try {
                updateProperties = itrUpdater.temAtualizacaoCompletada();
                if (updateProperties != null) {
                    Toast.makeText(ControladorGui.getJanelaPrincipal(), MensagemUtil.getMensagem("111119", new String[]{updateProperties.getVersaoAtual()})).display();
                    if (updateProperties.getMensagem() != null && !updateProperties.getMensagem().trim().isEmpty()) {
                        finalizouAtualizacao = true;
                        GuiUtil.exibeDialog(this.getJanelaPrincipal(), new PainelAvisoVerificarAtualizacoes("Nova Vers\u00e3o Instalada", updateProperties.getMensagem(), null, "OK"), true, "Verificar Atualiza\u00e7\u00f5es", false, null, null, false, 0, true, false);
                    }
                }
            }
            catch (AplicacaoException aplicacaoException) {
                // empty catch block
            }
        }
        return finalizouAtualizacao;
    }

    private void verificarNovaVersao() {
        new VerificarNovaVersaoAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void verificacaoFinalizada(ITRUpdater itrUpdater, ITRUpdateProperties updateProperties, AplicacaoException exception) {
                if (exception == null && updateProperties != null) {
                    this.confirmarNovaVersao(itrUpdater, updateProperties, true);
                }
            }
        }.verificarUltimaVersao();
    }

    public void aplicaArvore(String aFonteArvore) {
    }

    public PGDITRHelp getHelpPDF() {
        return this.help;
    }

    public void setHelp(PGDITRHelp help) {
        this.help = help;
    }
}

