/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app.acoes;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import serpro.ppgd.app.acoes.ActionAb;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.infraestrutura.util.ProcessoSwing;
import serpro.ppgd.infraestrutura.util.Tarefa;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.ListaDecGravadaTableModel;
import serpro.ppgd.itr.gui.ListaDecRepositorioTableModel;
import serpro.ppgd.itr.gui.PainelBarraProgresso;
import serpro.ppgd.itr.gui.dialogs.PainelConfirmarExibirPendenciasGravacao;
import serpro.ppgd.itr.gui.dialogs.PainelConfirmarGravar;
import serpro.ppgd.itr.gui.dialogs.PainelCopiaSeguranca;
import serpro.ppgd.itr.gui.dialogs.PainelGravarCopiaSeguranca;
import serpro.ppgd.itr.gui.dialogs.PainelGravarCopiaSegurancaGravada;
import serpro.ppgd.itr.gui.dialogs.PainelGravarCopiaSegurancaTransmitida;
import serpro.ppgd.itr.gui.dialogs.PainelVerificarPendenciasPopup;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.gui.util.TarefaMonitorada;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class GravarCopiaSegurancaAction
extends ActionAb {
    private PainelGravarCopiaSeguranca painelGravarCopiaAtual = null;
    private PainelGravarCopiaSegurancaTransmitida painelGravarTransmitida = null;
    private PainelGravarCopiaSegurancaGravada painelGravarDeclaracaoGravada = null;
    private PainelBarraProgresso barraProgresso = null;
    private IdentificadorDeclaracao idDec;

    @Override
    public boolean isFecharDeclaracaoExigido() {
        this.idDec = ControladorGui.isDeclaracaoAberta() ? ControladorGui.getDeclaracaoAberta().getIdentificadorDeclaracao() : null;
        return true;
    }

    @Override
    protected String getChaveMensagemConfirmaFecharDeclaracao() {
        return "111128";
    }

    @Override
    public void executarAcao(ActionEvent e) {
        PainelCopiaSeguranca pnlOpCopSeg = (PainelCopiaSeguranca)ProcessoSwing.executa((Tarefa)new Tarefa(){

            public Object run() {
                PainelCopiaSeguranca pnlOpCopSeg = new PainelCopiaSeguranca();
                GuiUtil.exibeDialog(pnlOpCopSeg, true, "Gravar C\u00f3pia de Seguran\u00e7a", false);
                return pnlOpCopSeg;
            }
        });
        if (pnlOpCopSeg.getTipoCopia().equals("1")) {
            this.painelGravarCopiaAtual = this.idDec == null ? new PainelGravarCopiaSeguranca() : new PainelGravarCopiaSeguranca(this.idDec);
            GuiUtil.exibeDialog(this.painelGravarCopiaAtual, true, "Gravar C\u00f3pia de Seguran\u00e7a", false);
            this.gravarCopiaDecAtual();
        } else if (pnlOpCopSeg.getTipoCopia().equals("2")) {
            this.painelGravarTransmitida = new PainelGravarCopiaSegurancaTransmitida();
            GuiUtil.exibeDialog(this.painelGravarTransmitida, true, "Gravar C\u00f3pia de Seguran\u00e7a de Declara\u00e7\u00e3o Entregue", false);
            this.gravarCopiaDecTransmitida();
        } else if (pnlOpCopSeg.getTipoCopia().equals("3")) {
            this.painelGravarDeclaracaoGravada = this.idDec == null ? new PainelGravarCopiaSegurancaGravada() : new PainelGravarCopiaSegurancaGravada(this.idDec);
            GuiUtil.exibeDialog(this.painelGravarDeclaracaoGravada, true, "Gravar Declara\u00e7\u00e3o para Entrega \u00e0 RFB", false);
            this.gravarCopiaDecGravada();
        }
    }

    private void gravarCopiaDecTransmitida() {
        if (this.painelGravarTransmitida.getRetorno() == 1) {
            TarefaMonitorada tarefa = new TarefaMonitorada(){

                @Override
                public Object doInBackGround() {
                    int[] selecteds = GravarCopiaSegurancaAction.this.painelGravarTransmitida.getPnlListaDec().getTblDeclaracao().getSelectedRows();
                    this.setMax(selecteds.length);
                    this.setProgress(0);
                    int progresso = 0;
                    ListaDecGravadaTableModel model = (ListaDecGravadaTableModel)GravarCopiaSegurancaAction.this.painelGravarTransmitida.getPnlListaDec().getTblDeclaracao().getModel();
                    int qtdGravadas = 0;
                    for (int i = 0; i < selecteds.length && !this.cancelado(); ++i) {
                        int index = GravarCopiaSegurancaAction.this.painelGravarTransmitida.getPnlListaDec().getTblDeclaracao().convertRowIndexToModel(selecteds[i]);
                        progresso = i + 1;
                        this.setNota(progresso + " de " + selecteds.length);
                        this.setProgress(progresso);
                        File arqDec = model.getDecFiles()[index];
                        File arqDestino = new File(GravarCopiaSegurancaAction.this.painelGravarTransmitida.getPnlLocalizadorPasta().getPasta().getPath() + File.separator + arqDec.getName());
                        if (arqDestino.exists() && arqDestino.isFile()) {
                            String nirfFormatado = arqDec.getName().substring(0, 1) + "." + arqDec.getName().substring(1, 4) + "." + arqDec.getName().substring(4, 7) + "-" + arqDec.getName().substring(7, 8);
                            int ret = GuiUtil.confirmaPaginado(MensagemUtil.getMensagem("110370", new String[]{nirfFormatado}), "Gravar C\u00f3pia", i + 1, selecteds.length, 1, 3);
                            if (ret == 1) continue;
                            if (ret == 2) break;
                        }
                        try {
                            ITRFacade.gravarCopiaDeclaracaoTransmitida(arqDec, GravarCopiaSegurancaAction.this.painelGravarTransmitida.getPnlLocalizadorPasta().getPasta());
                            ++qtdGravadas;
                            continue;
                        }
                        catch (GeracaoTxtException e) {
                            GuiUtil.confirmaPaginado(e.getMessage(), "Gravar C\u00f3pia", i + 1, selecteds.length, 2, 0);
                        }
                    }
                    this.fechar();
                    if (qtdGravadas > 0) {
                        GuiUtil.mostrarInfo("800020");
                    }
                    if (ITRFacade.getDeclaracaoAberta() == null) {
                        ITRFacade.limparRepositorioXML();
                        ITRFacade.setDeclaracaoEmMemoria(null);
                    }
                    return null;
                }
            };
            this.barraProgresso = new PainelBarraProgresso("Gravar C\u00f3pias de Seguran\u00e7a", tarefa);
            this.barraProgresso.exibir();
            this.barraProgresso = null;
        }
    }

    private void gravarCopiaDecGravada() {
        if (this.painelGravarDeclaracaoGravada.getRetorno() == 1) {
            TarefaMonitorada tarefa = new TarefaMonitorada(){

                @Override
                public Object doInBackGround() {
                    int[] selecteds = GravarCopiaSegurancaAction.this.painelGravarDeclaracaoGravada.getPnlListaDec().getTblDeclaracao().getSelectedRows();
                    this.setMax(selecteds.length);
                    this.setProgress(0);
                    int progresso = 0;
                    ListaDecRepositorioTableModel model = (ListaDecRepositorioTableModel)GravarCopiaSegurancaAction.this.painelGravarDeclaracaoGravada.getPnlListaDec().getTblDeclaracao().getModel();
                    GravarDeclaracaoAction acao = new GravarDeclaracaoAction();
                    for (int i = 0; i < selecteds.length && !this.cancelado(); ++i) {
                        progresso = i + 1;
                        this.setNota(progresso + " de " + selecteds.length);
                        this.setProgress(progresso);
                        int index = GravarCopiaSegurancaAction.this.painelGravarDeclaracaoGravada.getPnlListaDec().getTblDeclaracao().convertRowIndexToModel(selecteds[i]);
                        IdentificadorDeclaracao id = (IdentificadorDeclaracao)model.getIds().get(index);
                        int ret = acao.verificarPendencias(id, i + 1, selecteds.length);
                        if (ret == 2) {
                            ret = acao.gravarEntrega(GravarCopiaSegurancaAction.this.painelGravarDeclaracaoGravada.getPnlLocalizadorPasta().getPasta(), id, i + 1, selecteds.length);
                            if (ret == 3) {
                                id.liberarInformacoes();
                                break;
                            }
                            id.liberarInformacoes();
                            continue;
                        }
                        if (ret == 3) break;
                    }
                    this.fechar();
                    if (acao.getQtdGravadas() > 0) {
                        GuiUtil.mostrarInfo("800020");
                    }
                    if (ITRFacade.getDeclaracaoAberta() == null) {
                        ITRFacade.limparRepositorioXML();
                        ITRFacade.setDeclaracaoEmMemoria(null);
                    }
                    return null;
                }
            };
            this.barraProgresso = new PainelBarraProgresso("Gravar C\u00f3pias de Seguran\u00e7a", tarefa);
            this.barraProgresso.exibir();
            this.barraProgresso = null;
        }
    }

    private void gravarCopiaDecAtual() {
        if (this.painelGravarCopiaAtual.getRetorno() == 1) {
            TarefaMonitorada tarefa = new TarefaMonitorada(){

                @Override
                public Object doInBackGround() {
                    int[] selecteds = GravarCopiaSegurancaAction.this.painelGravarCopiaAtual.getPnlListaDec().getTblDeclaracao().getSelectedRows();
                    this.setMax(selecteds.length);
                    this.setProgress(0);
                    int progresso = 0;
                    ListaDecRepositorioTableModel model = (ListaDecRepositorioTableModel)GravarCopiaSegurancaAction.this.painelGravarCopiaAtual.getPnlListaDec().getTblDeclaracao().getModel();
                    GravarDeclaracaoAction acao = new GravarDeclaracaoAction();
                    for (int i = 0; i < selecteds.length && !this.cancelado(); ++i) {
                        int index = GravarCopiaSegurancaAction.this.painelGravarCopiaAtual.getPnlListaDec().getTblDeclaracao().convertRowIndexToModel(selecteds[i]);
                        progresso = i + 1;
                        this.setNota(progresso + " de " + selecteds.length);
                        this.setProgress(progresso);
                        IdentificadorDeclaracao id = (IdentificadorDeclaracao)model.getIds().get(index);
                        int ret = acao.gravar(GravarCopiaSegurancaAction.this.painelGravarCopiaAtual.getPnlLocalizadorPasta().getPasta(), id, i + 1, selecteds.length);
                        if (ret == 3) {
                            id.liberarInformacoes();
                            break;
                        }
                        id.liberarInformacoes();
                    }
                    this.fechar();
                    if (acao.getQtdGravadas() > 0) {
                        GuiUtil.mostrarInfo("800020");
                    }
                    if (ITRFacade.getDeclaracaoAberta() == null) {
                        ITRFacade.limparRepositorioXML();
                        ITRFacade.setDeclaracaoEmMemoria(null);
                    }
                    return null;
                }
            };
            this.barraProgresso = new PainelBarraProgresso("Gravar C\u00f3pias de Seguran\u00e7a", tarefa);
            this.barraProgresso.exibir();
            this.barraProgresso = null;
        }
    }

    private class GravarDeclaracaoAction {
        public static final int RETORNO_PROXIMA = 0;
        public static final int RETORNO_EXIBIR_PENDENCIAS = 1;
        public static final int RETORNO_GRAVAR = 2;
        public static final int RETORNO_CANCELAR = 3;
        public static final int RETORNO_VERIFICAR_PENDENCIAS = 7;
        private FileFilter fileFilterDecTransmitida = ITRFacade.obterNovoFileFilterArquivoDecTransmitida();
        private int qtdGravadas = 0;

        private GravarDeclaracaoAction() {
        }

        public int gravarEntrega(File destino, IdentificadorDeclaracao id, int indice, int total) {
            block6: {
                File fileDec = new File(destino.getPath() + File.separator + ITRFacade.obterNomeArquivoDec(id));
                if (fileDec.exists() && fileDec.isFile()) {
                    String nirf = id.getNirf().naoFormatado();
                    String msg = null;
                    msg = MensagemUtil.getMensagem("800015", new String[]{UtilitariosString.formataNIRF((String)nirf)});
                    int ret = GuiUtil.confirmaPaginado(msg, "Declara\u00e7\u00e3o", indice, total, 1, 3);
                    if (ret == 1) {
                        return 0;
                    }
                    if (ret == 2) {
                        return 3;
                    }
                }
                try {
                    ITRFacade.gravarParaEntrega(destino, id.getNirf().naoFormatado());
                    ++this.qtdGravadas;
                }
                catch (GeracaoTxtException e) {
                    GuiUtil.confirmaPaginado(e.getMessage(), "Declara\u00e7\u00e3o", indice, total, 2, 0);
                    return 0;
                }
                catch (Exception e) {
                    String nirf = id.getNirf().naoFormatado();
                    if (GuiUtil.confirmaPaginado(MensagemUtil.getMensagem("110270", new String[]{nirf}), "Declara\u00e7\u00e3o", indice, total, 2, 0) != 2) break block6;
                    return 3;
                }
            }
            return 0;
        }

        public int gravar(File destino, IdentificadorDeclaracao id, int indice, int total) {
            block5: {
                File fileDec = new File(destino.getPath() + File.separator + ITRFacade.obterNomeArquivoDecCopia(id));
                String nirf = id.getNirf().naoFormatado();
                if (fileDec.exists() && fileDec.isFile()) {
                    int ret = GuiUtil.confirmaPaginado(MensagemUtil.getMensagem("900090", new String[]{id.getNirf().formatado()}), "Declara\u00e7\u00e3o", indice, total, 1, 3);
                    if (ret == 1) {
                        return 0;
                    }
                    if (ret == 2) {
                        return 3;
                    }
                }
                try {
                    ITRFacade.gravarCopiaSeguranca(destino, id.getNirf().naoFormatado());
                    ++this.qtdGravadas;
                }
                catch (Exception e) {
                    if (GuiUtil.confirmaPaginado(MensagemUtil.getMensagem("110260", new String[]{nirf}), "Declara\u00e7\u00e3o", indice, total, 2, 0) != 2) break block5;
                    return 3;
                }
            }
            return 0;
        }

        public int verificarPendencias(IdentificadorDeclaracao id, int indice, int total) {
            List pendencias = null;
            int qtdAvisos = 0;
            int qtdErros = 0;
            try {
                pendencias = ITRFacade.verificarPendencias(id.getNirf().naoFormatado());
                for (Pendencia pendencia : pendencias) {
                    if (pendencia.getSeveridade() == 2) {
                        ++qtdAvisos;
                    }
                    if (pendencia.getSeveridade() != 3 && pendencia.getSeveridade() != 5) continue;
                    ++qtdErros;
                }
                int retorno = 2;
                do {
                    if (qtdErros > 0) {
                        retorno = this.confirmarExibirPendencias(id, indice, total);
                    } else if (qtdAvisos > 0) {
                        retorno = this.confirmarGravar(id, indice, total);
                    }
                    if (retorno != 1) continue;
                    retorno = this.exibirPendencias(id);
                } while (retorno == 7);
                return retorno;
            }
            catch (Exception e) {
                GuiUtil.mostrarErro("110270", new String[]{id.getNirf().formatado()});
                return 0;
            }
        }

        public int exibirPendencias(IdentificadorDeclaracao id) throws RepositorioXMLException, HashInvalidoException {
            DeclaracaoITR dec = ITRFacade.obterDeclaracaoRepositorio(id.getNirf().naoFormatado());
            PainelVerificarPendenciasPopup painel = new PainelVerificarPendenciasPopup(FabricaUtilitarios.verificarPendencias((Object)((Object)dec)));
            painel.preExibir();
            if (dec != null) {
                GuiUtil.exibeDialog(painel, true, "Rela\u00e7\u00e3o de Pend\u00eancias", false);
            }
            switch (painel.getRetorno()) {
                case 1: {
                    return 7;
                }
                case 3: {
                    painel.imprimirPendencias(dec.getIdentificadorDeclaracao());
                    return 3;
                }
                case 2: {
                    ControladorGui.abrirDeclaracao(dec.getIdentificadorDeclaracao(), false);
                    painel.selecionaPendencia();
                }
            }
            return 3;
        }

        public int confirmarExibirPendencias(IdentificadorDeclaracao id, int indice, int total) {
            PainelConfirmarExibirPendenciasGravacao painel = new PainelConfirmarExibirPendenciasGravacao(id.getNirf().formatado(), id.getNomeImovel().formatado(), indice, total, UtilitariosString.insereQuebraDeLinha((String)MensagemUtil.getMensagem("110120"), (int)60, (String)"<br>"));
            GuiUtil.exibeDialog(painel, true, "Gravar Declara\u00e7\u00e3o para Entrega \u00e0 RFB", false);
            switch (painel.getRetorno()) {
                case 2: {
                    return 1;
                }
                case 3: {
                    return 3;
                }
            }
            return 0;
        }

        public int confirmarGravar(IdentificadorDeclaracao id, int indice, int total) {
            PainelConfirmarGravar painelConfirmarGravar = new PainelConfirmarGravar(id.getNirf().formatado(), id.getNomeImovel().formatado(), indice, total, UtilitariosString.insereQuebraDeLinha((String)MensagemUtil.getMensagem("110125"), (int)80, (String)"<br>"));
            GuiUtil.exibeDialog(painelConfirmarGravar, true, "Gravar Declara\u00e7\u00e3o para Entrega \u00e0 RFB", false);
            switch (painelConfirmarGravar.getRetorno()) {
                case 1: {
                    return 2;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 3;
                }
            }
            return 0;
        }

        public int getQtdGravadas() {
            return this.qtdGravadas;
        }
    }
}

