/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app.acoes;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.UUID;
import serpro.ppgd.app.acoes.ActionAb;
import serpro.ppgd.itr.exception.AplicacaoException;
import serpro.ppgd.itr.exception.BarramentoException;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.NavegadorHtml;
import serpro.ppgd.itr.gui.nuvem.PainelProcessaLogin;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.nuvem.BarramentoITRFService;
import serpro.ppgd.itr.nuvem.UsuarioLogado;
import serpro.ppgd.itr.util.CpfCnpjUtil;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;

public class LoginGovAction
extends ActionAb {
    private static final long serialVersionUID = 1L;

    public LoginGovAction() {
    }

    public LoginGovAction(String pNomeAcao) {
        super(pNomeAcao);
    }

    @Override
    public final void executarAcao(ActionEvent ae) {
        try {
            this.iniciarLogon();
        }
        catch (AplicacaoException e) {
            GuiUtil.mostrarErro(e);
        }
    }

    public void iniciarLogon() throws AplicacaoException {
        this.iniciarLogon(null);
    }

    public void iniciarLogon(TarefaAposLogin aposSucesso) throws AplicacaoException {
        String state = UUID.randomUUID().toString();
        String msg = MensagemUtil.getMensagem("nuvem.info.iniciar.login.gov");
        if (!GuiUtil.mostrarConfirma(ControladorGui.getJanelaPrincipal(), msg)) {
            return;
        }
        PainelProcessaLogin painelEspera = new PainelProcessaLogin();
        Runnable executarAposSucesso = () -> {
            BarramentoITRFService.stopHTTPLocalhostServer();
            ControladorGui.atualizarUsuarioLogado(BarramentoITRFService.getUsuarioLogado());
            GuiUtil.fecharDialog(painelEspera);
            GuiUtil.mostrarAviso("nuvem.info.login.sucesso", new String[]{CpfCnpjUtil.getLabel(BarramentoITRFService.getUsuarioLogado().getNi()), CpfCnpjUtil.formatar(BarramentoITRFService.getUsuarioLogado().getNi()), BarramentoITRFService.getUsuarioLogado().getNomeNi()});
            if (aposSucesso != null) {
                aposSucesso.executar(BarramentoITRFService.getUsuarioLogado());
            }
        };
        Runnable executarAposErro = () -> {
            BarramentoITRFService.stopHTTPLocalhostServer();
            GuiUtil.fecharDialog(painelEspera);
        };
        try {
            BarramentoITRFService.initHTTPLocalhostServer(executarAposSucesso, executarAposErro, state);
        }
        catch (BarramentoException e) {
            throw new AplicacaoException(e.getMessage(), e);
        }
        try {
            NavegadorHtml.executarNavegador(BarramentoITRFService.URL_AUTENTICACAO_GOV_LOGIN + "?exercicio=" + ConstantesGlobais.EXERCICIO + "&state=" + state);
        }
        catch (IOException e) {
            throw new AplicacaoException(e.getMessage(), e);
        }
        painelEspera.setAcaoCancelar(() -> {
            BarramentoITRFService.stopHTTPLocalhostServer();
            GuiUtil.mostrarAviso("nuvem.info.login.cancelar");
            GuiUtil.fecharDialog(painelEspera);
        });
        GuiUtil.exibeDialog(ControladorGui.getJanelaPrincipal(), painelEspera, true, "Aguardando Login", false, null, null);
    }

    @FunctionalInterface
    public static interface TarefaAposLogin {
        public void executar(UsuarioLogado var1);
    }
}

