/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app.acoes;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import serpro.ppgd.app.acoes.ActionAb;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.gui.UtilitariosGUI;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.ProcessoSwing;
import serpro.ppgd.infraestrutura.util.Tarefa;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.PainelBarraProgresso;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.gui.util.TarefaMonitorada;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.repositorio.RepositorioException;

public class RecuperarExercicioAnteriorAction
extends ActionAb {
    private static File dirInicial = null;
    private int qtdRecuperadas = 0;
    private PainelBarraProgresso barraProgresso = null;

    @Override
    public boolean isFecharDeclaracaoExigido() {
        return true;
    }

    @Override
    protected String getChaveMensagemConfirmaFecharDeclaracao() {
        return "111125";
    }

    @Override
    public void executarAcao(ActionEvent e) {
        final JFileChooser fc = UtilitariosGUI.setFileChooserProperties((String)("Importar Dados da Declara\u00e7\u00e3o de " + ConstantesGlobais.EXERCICIO_ANTERIOR), (String)"Procurar em:", (String)"Importar", (String)("Importar Dados da Declara\u00e7\u00e3o de " + ConstantesGlobais.EXERCICIO_ANTERIOR));
        fc.setApproveButtonMnemonic('R');
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(ITRFacade.obterNovoFileChooserFilterArquivoExercicioAnterior());
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(true);
        if (dirInicial == null && !(dirInicial = ITRFacade.obterPastaPadraoGravadasExercicioAnterior()).exists()) {
            dirInicial = null;
        }
        fc.setCurrentDirectory(dirInicial);
        Integer ret = (Integer)ProcessoSwing.executa((Tarefa)new Tarefa(){

            public Object run() {
                int ret = fc.showDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), null);
                return new Integer(ret);
            }
        });
        if (ret == 0) {
            dirInicial = fc.getCurrentDirectory();
            this.qtdRecuperadas = 0;
            final File[] selectedFiles = fc.getSelectedFiles();
            TarefaMonitorada tarefa = new TarefaMonitorada(){

                @Override
                public Object doInBackGround() {
                    this.setMax(selectedFiles.length);
                    this.setProgress(0);
                    for (int i = 0; i < selectedFiles.length && !this.cancelado(); ++i) {
                        int ret;
                        int progresso = i + 1;
                        this.setNota(progresso + " de " + selectedFiles.length);
                        this.setProgress(progresso);
                        boolean sobrescrever = false;
                        String nirf = ITRFacade.obterNirfArquivoExercicioAnterior(selectedFiles[i]);
                        if (nirf == null) continue;
                        if (ITRFacade.existeDeclaracao(nirf)) {
                            int ret2 = GuiUtil.confirmaPaginado(MensagemUtil.getMensagem("110350", new String[]{UtilitariosString.formataNIRF((String)nirf)}), "Importar", i + 1, selectedFiles.length, 1, 3);
                            if (ret2 == 0) {
                                sobrescrever = true;
                            } else {
                                if (ret2 != 1) break;
                                continue;
                            }
                        }
                        try {
                            ITRFacade.recuperarDeclaracaoExercicioAnterior(selectedFiles[i], sobrescrever);
                            ITRFacade.limparRepositorioXML();
                            ++RecuperarExercicioAnteriorAction.this.qtdRecuperadas;
                            continue;
                        }
                        catch (RepositorioException e) {
                            ret = GuiUtil.confirmaPaginado(e.getMessage(), "Importar", i + 1, selectedFiles.length, 2, 1);
                            if (ret == 0) continue;
                            break;
                        }
                        catch (GeracaoTxtException e) {
                            ret = GuiUtil.confirmaPaginado(e.getMessage(), "importar", i + 1, selectedFiles.length, 2, 1);
                            if (ret == 0) continue;
                            break;
                        }
                        catch (Exception e) {
                            ret = GuiUtil.confirmaPaginado("Ocorreu um erro durante a restaura\u00e7\u00e3o", "Importar", i + 1, selectedFiles.length, 2, 0);
                            if (ret != 0) break;
                        }
                    }
                    this.fechar();
                    if (RecuperarExercicioAnteriorAction.this.qtdRecuperadas > 0) {
                        GuiUtil.mostrarInfo("800105", new String[]{ConstantesGlobais.EXERCICIO_ANTERIOR});
                    }
                    if (ITRFacade.getDeclaracaoAberta() == null) {
                        ITRFacade.limparRepositorioXML();
                        ITRFacade.setDeclaracaoEmMemoria(null);
                    }
                    ControladorGui.atualizarNumeroDeclaracoes();
                    return null;
                }
            };
            this.barraProgresso = new PainelBarraProgresso("Importando Declara\u00e7\u00f5es", tarefa);
            this.barraProgresso.exibir();
            this.barraProgresso = null;
        }
    }

    public int getQtdRecuperadas() {
        return this.qtdRecuperadas;
    }

    public void setQtdRecuperadas(int qtdRecuperadas) {
        this.qtdRecuperadas = qtdRecuperadas;
    }
}

