/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app.acoes;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import serpro.ppgd.app.acoes.ActionAb;
import serpro.ppgd.gui.UtilitariosGUI;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.PainelBarraProgresso;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.gui.util.TarefaMonitorada;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.repositorio.RepositorioException;

public class RestaurarCopiaSegurancaAction
extends ActionAb {
    private int qtdRestauradas = 0;
    private PainelBarraProgresso barraProgresso = null;

    @Override
    public boolean isFecharDeclaracaoExigido() {
        return true;
    }

    @Override
    protected String getChaveMensagemConfirmaFecharDeclaracao() {
        return "111126";
    }

    @Override
    public void executarAcao(ActionEvent e) {
        JFileChooser fc = UtilitariosGUI.setFileChooserProperties((String)"Restaurar C\u00f3pia de Seguran\u00e7a", (String)"Procurar em:", (String)"Restaurar", (String)"Restaura c\u00f3pia de seguran\u00e7a");
        fc.setApproveButtonMnemonic('R');
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(ITRFacade.obterNovoFileChooserFilterArquivoCopiaSeguranca());
        fc.setMultiSelectionEnabled(true);
        fc.setCurrentDirectory(ITRFacade.obterPastaPadraoGravadas());
        if (fc.showDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), null) == 0) {
            final File[] selectedFiles = fc.getSelectedFiles();
            TarefaMonitorada tarefa = new TarefaMonitorada(){

                @Override
                public Object doInBackGround() {
                    this.setMax(selectedFiles.length);
                    this.setProgress(0);
                    int progresso = 0;
                    RestaurarCopiaSegurancaAction.this.qtdRestauradas = 0;
                    for (int i = 0; i < selectedFiles.length && !this.cancelado(); ++i) {
                        int ret;
                        progresso = i + 1;
                        this.setNota(progresso + " de " + selectedFiles.length);
                        this.setProgress(progresso);
                        boolean sobrescrever = false;
                        String nirf = ITRFacade.obterNirfArquivoCopiaSeguranca(selectedFiles[i]);
                        if (nirf == null) {
                            if (selectedFiles[i].exists()) continue;
                            GuiUtil.mostrarErro("800295");
                            continue;
                        }
                        if (ITRFacade.existeDeclaracao(nirf)) {
                            int ret2 = GuiUtil.confirmaPaginado(MensagemUtil.getMensagem("110350", new String[]{UtilitariosString.formataNIRF((String)nirf)}), "Restaurar", i + 1, selectedFiles.length, 1, 3);
                            if (ret2 == 0) {
                                sobrescrever = true;
                            } else {
                                if (ret2 != 1) break;
                                continue;
                            }
                        }
                        try {
                            ITRFacade.restaurarDeclaracao(selectedFiles[i], sobrescrever, true);
                            ++RestaurarCopiaSegurancaAction.this.qtdRestauradas;
                        }
                        catch (RepositorioException e) {
                            ret = GuiUtil.confirmaPaginado(e.getMessage(), "Declara\u00e7\u00e3o", i + 1, selectedFiles.length, 2, 1);
                            if (ret != 0) {
                                break;
                            }
                        }
                        catch (Exception e) {
                            ret = GuiUtil.confirmaPaginado("Ocorreu um erro durante a restaura\u00e7\u00e3o", "Declara\u00e7\u00e3o", i + 1, selectedFiles.length, 2, 0);
                            if (ret != 0) break;
                        }
                        ITRFacade.setDeclaracaoEmMemoria(null);
                        ITRFacade.limparRepositorioXML();
                    }
                    this.fechar();
                    if (RestaurarCopiaSegurancaAction.this.qtdRestauradas > 0) {
                        GuiUtil.mostrarInfo("110330");
                    }
                    ControladorGui.atualizarNumeroDeclaracoes();
                    return null;
                }
            };
            this.barraProgresso = new PainelBarraProgresso("Restaurando C\u00f3pias", tarefa);
            this.barraProgresso.exibir();
            this.barraProgresso = null;
        }
    }
}

