/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app.acoes;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import serpro.ppgd.app.acoes.ActionAb;
import serpro.ppgd.gui.UtilitariosGUI;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.PainelBarraProgresso;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.gui.util.TarefaMonitorada;
import serpro.ppgd.itr.txt.UtilitariosTXT;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.repositorio.RepositorioException;

public class RestaurarDeclaracaoGravadaAction
extends ActionAb {
    private int qtdRestauradas = 0;
    private PainelBarraProgresso barraProgresso = null;

    @Override
    public boolean isFecharDeclaracaoExigido() {
        return true;
    }

    @Override
    protected String getChaveMensagemConfirmaFecharDeclaracao() {
        return "111127";
    }

    @Override
    public void executarAcao(ActionEvent e) {
        JFileChooser fc = UtilitariosGUI.setFileChooserProperties((String)"Restaurar Declara\u00e7\u00e3o Gravada para Entrega \u00e0 RFB", (String)"Procurar em:", (String)"Restaurar", (String)"Restaura Gravada");
        fc.setApproveButtonMnemonic('R');
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(ITRFacade.obterNovoFileChooserFilterArquivoDec());
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(true);
        fc.setCurrentDirectory(ITRFacade.obterPastaPadraoGravadas());
        if (fc.showDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), null) == 0) {
            final File[] selectedFiles = fc.getSelectedFiles();
            TarefaMonitorada tarefa = new TarefaMonitorada(){

                @Override
                public Object doInBackGround() {
                    int progresso = 0;
                    this.setMax(selectedFiles.length);
                    this.setProgress(progresso);
                    RestaurarDeclaracaoGravadaAction.this.qtdRestauradas = 0;
                    for (int i = 0; i < selectedFiles.length && !this.cancelado(); ++i) {
                        int ret;
                        progresso = i + 1;
                        this.setNota(progresso + " de " + selectedFiles.length);
                        this.setProgress(progresso);
                        boolean sobrescrever = false;
                        String nirf = ITRFacade.obterNirfArquivoDeclaracao(selectedFiles[i]);
                        if (nirf == null) {
                            if (selectedFiles[i].exists()) continue;
                            GuiUtil.mostrarErro("800295");
                            continue;
                        }
                        if (ITRFacade.existeDeclaracao(nirf)) {
                            int ret2 = GuiUtil.confirmaPaginado(MensagemUtil.getMensagem("110350", new String[]{UtilitariosString.formataNIRF((String)nirf)}), "Restaurar", i + 1, selectedFiles.length, 1, 3);
                            if (ret2 == 0) {
                                sobrescrever = true;
                            } else {
                                if (ret2 != 1) break;
                                continue;
                            }
                        }
                        try {
                            File fileRec = UtilitariosTXT.getRECCorrespondente(selectedFiles[i]);
                            if (fileRec != null && !UtilitariosTXT.controleSRFBate(selectedFiles[i], fileRec)) {
                                fileRec = null;
                            }
                            ITRFacade.restaurarDeclaracao(selectedFiles[i], sobrescrever, false);
                            RestaurarDeclaracaoGravadaAction.this.copiaDecRec(selectedFiles[i], fileRec);
                            ++RestaurarDeclaracaoGravadaAction.this.qtdRestauradas;
                        }
                        catch (RepositorioException e) {
                            ret = GuiUtil.confirmaPaginado(e.getMessage(), "Declara\u00e7\u00e3o", i + 1, selectedFiles.length, 2, 1);
                            if (ret != 0) {
                                break;
                            }
                        }
                        catch (Exception e) {
                            if (ITRFacade.existeDeclaracao(nirf)) {
                                ITRFacade.excluirDeclaracao(nirf);
                            }
                            if ((ret = GuiUtil.confirmaPaginado("Ocorreu um erro durante a restaura\u00e7\u00e3o", "Declara\u00e7\u00e3o", i + 1, selectedFiles.length, 2, 0)) != 0) break;
                        }
                        ITRFacade.limparRepositorioXML();
                        ITRFacade.setDeclaracaoEmMemoria(null);
                    }
                    this.fechar();
                    if (RestaurarDeclaracaoGravadaAction.this.qtdRestauradas > 0) {
                        GuiUtil.mostrarInfo("110330");
                    }
                    ControladorGui.atualizarNumeroDeclaracoes();
                    return null;
                }
            };
            this.barraProgresso = new PainelBarraProgresso("Restaurando Declara\u00e7\u00f5es", tarefa);
            this.barraProgresso.exibir();
            this.barraProgresso = null;
        }
    }

    private void copiaDecRec(File dec, File fileRec) {
        UtilitariosArquivo.copiaArquivo((String)dec.toString(), (String)FabricaUtilitarios.getPathCompletoDirGravadas());
        if (fileRec != null) {
            UtilitariosArquivo.copiaArquivo((String)fileRec.toString(), (String)FabricaUtilitarios.getPathCompletoDirGravadas());
            UtilitariosArquivo.copiaArquivo((String)dec.toString(), (String)FabricaUtilitarios.getPathCompletoDirTransmitidas());
            UtilitariosArquivo.copiaArquivo((String)fileRec.toString(), (String)FabricaUtilitarios.getPathCompletoDirTransmitidas());
        } else {
            File fileRecDest = UtilitariosTXT.getRECCorrespondente(new File(FabricaUtilitarios.getPathCompletoDirGravadas() + File.separator + dec.getName()));
            if (fileRecDest != null) {
                fileRecDest.delete();
            }
        }
    }
}

