/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app.acoes;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import jupar.Downloader;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.styles.RoundedBalloonStyle;
import net.java.balloontip.utils.TimingUtils;
import serpro.ppgd.app.acoes.ActionAb;
import serpro.ppgd.app.acoes.SairAction;
import serpro.ppgd.gui.DialogoOcupado;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.exception.AplicacaoException;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.JanelaPrincipalITR;
import serpro.ppgd.itr.gui.update.PainelAvisoVerificarAtualizacoes;
import serpro.ppgd.itr.gui.update.PainelDownloadAtualizacoes;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.itr.util.update.ITRUpdateProperties;
import serpro.ppgd.itr.util.update.ITRUpdater;
import serpro.ppgd.negocio.ConstantesGlobais;

public class VerificarNovaVersaoAction
extends ActionAb {
    private static final long serialVersionUID = 1L;
    public static final String NOME_ARQ_PROPRIEDADES = "release_properties.xml";
    private static SwingWorker<ITRUpdateProperties, Void> worker = null;

    @Override
    public void executarAcao(ActionEvent e) {
        this.verificarUltimaVersao();
    }

    public void verificarUltimaVersao() {
        if (worker == null || SwingWorker.StateValue.DONE.equals((Object)worker.getState())) {
            worker = new SwingWorker<ITRUpdateProperties, Void>(){
                private DialogoOcupado dlg = null;

                @Override
                protected ITRUpdateProperties doInBackground() throws Exception {
                    this.dlg = DialogoOcupado.exibeDialogo((String)"Verificando atualiza\u00e7\u00e3o...");
                    return ITRUpdater.getInstance().verificarUltimaVersaoOnline();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    ITRUpdateProperties updateProperties = null;
                    AplicacaoException ex = null;
                    try {
                        updateProperties = worker.get();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        ex = new AplicacaoException("atualizar.erro.verificacao");
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                        Throwable cause = e.getCause();
                        ex = cause != null && cause instanceof AplicacaoException ? (AplicacaoException)cause : new AplicacaoException("atualizar.erro.verificacao");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ex = new AplicacaoException("atualizar.erro.verificacao");
                    }
                    finally {
                        this.dlg.finaliza();
                    }
                    VerificarNovaVersaoAction.this.verificacaoFinalizada(ITRUpdater.getInstance(), updateProperties, ex);
                }
            };
        }
        if (SwingWorker.StateValue.PENDING.equals((Object)worker.getState())) {
            worker.execute();
        }
    }

    public void verificacaoFinalizada(ITRUpdater itrUpdater, ITRUpdateProperties updateProperties, AplicacaoException exception) {
        if (exception != null) {
            GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), exception.getMessage());
        } else if (updateProperties != null) {
            this.confirmarNovaVersao(itrUpdater, updateProperties);
        } else {
            GuiUtil.mostrarInfo("atualizar.aviso.semNovaVersao", new String[]{ConstantesGlobais.EXERCICIO});
        }
    }

    public BalloonTip novaInstanciaBalaoDica() {
        BalloonTip balloonTip = new BalloonTip(((JanelaPrincipalITR)PlataformaPPGD.getPlataforma().getJanelaPrincipal()).getJMenuFerramentas(), new JLabel(MensagemUtil.getMensagem("atualizar.aviso.dicaMenuFerramentas")), new RoundedBalloonStyle(5, 5, Color.white, Color.gray), BalloonTip.Orientation.LEFT_ABOVE, BalloonTip.AttachLocation.ALIGNED, 30, 15, true);
        balloonTip.setPadding(10);
        balloonTip.setTopLevelContainer(PlataformaPPGD.getPlataforma().getJanelaPrincipal().getLayeredPane());
        return balloonTip;
    }

    public void confirmarNovaVersao(ITRUpdater itrUpdater, ITRUpdateProperties updateProperties) {
        this.confirmarNovaVersao(itrUpdater, updateProperties, false);
    }

    public void confirmarNovaVersao(final ITRUpdater itrUpdater, final ITRUpdateProperties updateProperties, boolean exibirDica) {
        String titulo = MensagemUtil.getMensagem("atualizar.titulo");
        String mensagem = null;
        PainelAvisoVerificarAtualizacoes painel = null;
        if (!itrUpdater.temPermissaoEscritaPastaBase() || updateProperties.isDownloadManual()) {
            mensagem = updateProperties.getTipoAtualizacao() == ITRUpdateProperties.TipoAtualizacao.Obrigatoria ? (itrUpdater.temPermissaoEscritaPastaBase() ? "atualizar.aviso.atualizacaoManualObrigatoria" : "atualizar.aviso.semPermissaoAtualizacao.atualizacaoManualObrigatoria") : (itrUpdater.temPermissaoEscritaPastaBase() ? "atualizar.aviso.atualizacaoManual" : "atualizar.aviso.semPermissaoAtualizacao.atualizacaoManual");
            mensagem = MensagemUtil.getMensagem(mensagem, new String[]{ConstantesGlobais.EXERCICIO, updateProperties.getUltimaVersao()});
            painel = new PainelAvisoVerificarAtualizacoes(titulo, mensagem, "Sim", "N\u00e3o");
            GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), painel, true, "Verificar Atualiza\u00e7\u00f5es", false, null, null, false, 0, false, true);
            if (painel.isAtualizar()) {
                try {
                    itrUpdater.execNavegador(this.getEnderecoDownloadManual(updateProperties));
                }
                catch (AplicacaoException e) {
                    e.printStackTrace();
                    GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), e.getMessage());
                }
                SairAction fecharAction = new SairAction();
                fecharAction.setMostrarConfirmacaoFecharPrograma(false);
                fecharAction.actionPerformed(null);
            }
        } else {
            mensagem = updateProperties.getTipoAtualizacao() == ITRUpdateProperties.TipoAtualizacao.Obrigatoria ? "atualizar.confirma.atualizacaoObrigatoria" : "atualizar.confirma.novaVersao";
            mensagem = MensagemUtil.getMensagem(mensagem, new String[]{ConstantesGlobais.EXERCICIO, updateProperties.getUltimaVersao()});
            painel = new PainelAvisoVerificarAtualizacoes(titulo, mensagem);
            GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), painel, true, "Verificar Atualiza\u00e7\u00f5es", false, null, null, false, 0, false, true);
            if (painel.isAtualizar()) {
                if (this.verificarDeclaracaoFechado()) {
                    final PainelDownloadAtualizacoes painelDownload = new PainelDownloadAtualizacoes();
                    final Downloader.DownloadProgress progress = new Downloader.DownloadProgress(512){

                        public void onProgressChanged(boolean finished) {
                            final long downloaded = this.getTotalDownloadedFileSize() * 100L / this.getTotalDownloadingFileSize();
                            if (finished) {
                                if (this.isCanceled()) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            painelDownload.getLblDescricao().setText("Transfer\u00eancia de arquivos cancelada.");
                                            painelDownload.getLblPercentual().setText("");
                                            painelDownload.getProgressBar().setValue(painelDownload.getProgressBar().getMaximum());
                                        }
                                    });
                                } else {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            painelDownload.getLblDescricao().setText("Transfer\u00eancia de arquivos conclu\u00edda.");
                                            painelDownload.getLblPercentual().setText("");
                                            painelDownload.getProgressBar().setValue(painelDownload.getProgressBar().getMaximum());
                                        }
                                    });
                                }
                            } else {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        painelDownload.getLblDescricao().setText("Transferindo arquivo " + (this.getTotalDownloadedFiles() + 1) + " de " + this.getTotalFiles());
                                        painelDownload.getLblPercentual().setText(downloaded + "% completo");
                                        painelDownload.getProgressBar().setValue((int)downloaded);
                                    }
                                });
                            }
                        }
                    };
                    painelDownload.getBtnCancelar().addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            progress.setCanceled(true);
                        }
                    });
                    Runnable updatethread = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), painelDownload, true, "Verificar Atualiza\u00e7\u00f5es", false, null, null, false, 0, false, true);
                                    }
                                });
                                itrUpdater.download(updateProperties, progress);
                            }
                            catch (AplicacaoException ex) {
                                try {
                                    GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), ex.getMessage());
                                }
                                catch (Throwable throwable) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            GuiUtil.fecharDialog(painelDownload);
                                        }
                                    });
                                    throw throwable;
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                return;
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            if (progress.isCanceled()) {
                                System.out.println("Atualiza\u00e7\u00e3o do ITR" + ConstantesGlobais.EXERCICIO + ". Transfer\u00eancia de arquivos cancelada.");
                                GuiUtil.mostrarAviso(GuiUtil.getParent(), MensagemUtil.getMensagem("atualizar.aviso.downloadCancelado"));
                            } else {
                                System.out.println("Atualiza\u00e7\u00e3o do ITR" + ConstantesGlobais.EXERCICIO + ". Transfer\u00eancia de arquivos conclu\u00edda.");
                                GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new PainelAvisoVerificarAtualizacoes("Concluir Atualiza\u00e7\u00e3o", MensagemUtil.getMensagem("atualizar.aviso.update"), PainelAvisoVerificarAtualizacoes.IconeAvisoAtualizacao.ICONE_OK, null, "OK"), true, "Verificar Atualiza\u00e7\u00f5es", false, null, null, false, 0, false, true);
                                SairAction fecharAction = new SairAction(){

                                    @Override
                                    protected void onExitPgd() {
                                        try {
                                            itrUpdater.execUpdate(updateProperties);
                                        }
                                        catch (AplicacaoException ex) {
                                            GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), ex.getMessage());
                                        }
                                    }
                                };
                                fecharAction.setMostrarConfirmacaoFecharPrograma(false);
                                fecharAction.actionPerformed(null);
                            }
                        }
                    };
                    new Thread(updatethread).start();
                }
            } else if (exibirDica) {
                final BalloonTip balloonTip = this.novaInstanciaBalaoDica();
                TimingUtils.showTimedBalloon(balloonTip, 10000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        balloonTip.closeBalloon();
                    }
                });
            }
        }
    }

    private String getEnderecoDownloadManual(ITRUpdateProperties updateProperties) {
        if (ConstantesGlobaisITR.FASE.equalsIgnoreCase("Desenvolvimento")) {
            return updateProperties.getEnderecoServidorDownloadManualDes();
        }
        if (ConstantesGlobaisITR.VERSAO_TESTES) {
            return updateProperties.getEnderecoServidorDownloadManualHom();
        }
        if (ConstantesGlobaisITR.VERSAO_HOMOLOGACAO) {
            return updateProperties.getEnderecoServidorDownloadManualHom();
        }
        return updateProperties.getEnderecoServidorDownloadManual();
    }
}

