/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr;

import java.util.StringTokenizer;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.ObjetoNegocio;

public class DataITR
extends Data {
    private String anoReferencia = ConstantesGlobais.EXERCICIO;

    public DataITR() {
    }

    public DataITR(ObjetoNegocio owner, String nomeCampo) {
        super(owner, nomeCampo);
    }

    public DataITR(ObjetoNegocio owner, String nomeCampo, String anoReferencia) {
        super(owner, nomeCampo);
        this.anoReferencia = anoReferencia;
    }

    public void setConteudo(String conteudo) {
        Object dataCorrigida = null;
        if (conteudo.indexOf("/") != -1) {
            super.setConteudo(DataITR.corrigeDataFormatada(conteudo, this.anoReferencia));
        } else {
            super.setConteudo(conteudo);
        }
    }

    public static String corrigeDataFormatada(String data, String anoReferencia) {
        StringBuffer retorno = new StringBuffer();
        Object dia = "  ";
        Object mes = "  ";
        Object ano = "    ";
        int pos = 1;
        StringTokenizer tokens = new StringTokenizer(data, "/");
        while (tokens.hasMoreTokens()) {
            String tokenAtual = tokens.nextToken();
            switch (pos) {
                case 1: {
                    dia = tokenAtual;
                    break;
                }
                case 2: {
                    mes = tokenAtual;
                    break;
                }
                case 3: {
                    ano = tokenAtual;
                }
            }
            ++pos;
        }
        try {
            int diaInt = Integer.parseInt(((String)dia).trim());
            if (diaInt > 0 && diaInt < 32) {
                dia = String.valueOf(diaInt);
                dia = ((String)dia).length() == 1 ? "0" + (String)dia : dia;
            }
        }
        catch (Exception diaInt) {
            // empty catch block
        }
        try {
            int mesInt = Integer.parseInt(((String)mes).trim());
            if (mesInt > 0 && mesInt < 13) {
                mes = String.valueOf(mesInt);
                mes = ((String)mes).length() == 1 ? "0" + (String)mes : mes;
            }
        }
        catch (Exception mesInt) {
            // empty catch block
        }
        try {
            int anoInt = Integer.parseInt(((String)ano).trim());
            int anoRef = Integer.parseInt(anoReferencia);
            ano = anoInt >= 100 ? String.valueOf(anoInt) : (anoInt > anoRef % 100 ? (anoRef - 100) / 100 + (anoInt < 10 ? "0" : "") + String.valueOf(anoInt) : anoRef / 100 + (anoInt < 10 ? "0" : "") + String.valueOf(anoInt));
        }
        catch (Exception exception) {
            // empty catch block
        }
        retorno.append((String)dia);
        retorno.append("/");
        retorno.append((String)mes);
        retorno.append("/");
        retorno.append((String)ano);
        return retorno.toString();
    }
}

