/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.gui.pendencia.MapeamentoInformacaoEditCampo;
import serpro.ppgd.itr.ColecaoIdDeclaracao;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.RepositorioXMLITR;
import serpro.ppgd.itr.aquisicaoalienacao.InformacaoAquisicaoAlienacao;
import serpro.ppgd.itr.aquisicaoalienacao.InformacaoDesapropriacao;
import serpro.ppgd.itr.declaracao.ComplementoRecibo;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.demaiscondominos.Condomino;
import serpro.ppgd.itr.exception.AplicacaoException;
import serpro.ppgd.itr.gui.IdImovel;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.impressao.ImpressaoDeclaracao;
import serpro.ppgd.itr.impressao.RelatorioMultiploXMLITR;
import serpro.ppgd.itr.txt.RepositorioDeclaracaoTxt;
import serpro.ppgd.itr.util.DataUtil;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.PPGDFacade;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class ITRFacade
implements PPGDFacade {
    private static ITRFacade instancia = null;
    private static DeclaracaoITR declaracaoEmMemoria = null;
    private RepositorioXMLITR repositorioXMLITR = new RepositorioXMLITR();
    private RepositorioDeclaracaoTxt repositorioTxtITR = new RepositorioDeclaracaoTxt();
    private ImpressaoDeclaracao impressao = new ImpressaoDeclaracao();

    private ITRFacade() {
    }

    public static ITRFacade getInstancia() {
        if (instancia == null) {
            instancia = new ITRFacade();
        }
        return instancia;
    }

    public static void limpaCacheDeclaracoes() {
        ITRFacade.getInstancia().repositorioXMLITR.fechaDeclaracao();
    }

    public static void limparRepositorioXML() {
        ITRFacade.getInstancia().repositorioXMLITR = new RepositorioXMLITR();
    }

    public static DeclaracaoITR getDeclaracaoEmMemoria() {
        return declaracaoEmMemoria;
    }

    public static void setDeclaracaoEmMemoria(DeclaracaoITR declaracaoEmMemoria) {
        ITRFacade.declaracaoEmMemoria = declaracaoEmMemoria;
    }

    public static boolean existemDeclaracoes() {
        return !ITRFacade.getListaIdDeclaracoes().itens().isEmpty();
    }

    public static ColecaoIdDeclaracao getListaIdDeclaracoes() {
        return ITRFacade.getInstancia().repositorioXMLITR.getListaIdDeclaracoes();
    }

    public static boolean existeDeclaracao(String cib) {
        return ITRFacade.getInstancia().repositorioXMLITR.getListaIdDeclaracoes().existeNirfCadastrado(cib);
    }

    public static void criarDeclaracao(IdentificadorDeclaracao id) {
        id.getDataUltimoAcesso().setConteudo(DataUtil.obterDataAtual());
        ITRFacade.getInstancia().repositorioXMLITR.criarDeclaracao(id);
    }

    public static void criarDeclaracao(DeclaracaoITR dec) {
        dec.getIdentificadorDeclaracao().getDataUltimoAcesso().setConteudo(DataUtil.obterDataAtual());
        ITRFacade.getInstancia().repositorioXMLITR.criarDeclaracao(dec);
    }

    public static void abreDeclaracao(IdentificadorDeclaracao id) throws HashInvalidoException {
        try {
            if (ITRFacade.getDeclaracaoEmMemoria() != null && id != null && ITRFacade.getDeclaracaoEmMemoria().getIdentificadorDeclaracao().getNirf().naoFormatado().equals(id.getNirf().naoFormatado())) {
                ITRFacade.getInstancia().repositorioXMLITR.abreDeclaracao(ITRFacade.getDeclaracaoEmMemoria(), true);
            } else {
                ITRFacade.getInstancia().repositorioXMLITR.abreDeclaracao(id);
            }
        }
        catch (RepositorioXMLException e) {
            e.printStackTrace();
            GuiUtil.mostrarErro("excecao_inesperada");
            System.exit(1);
        }
    }

    public static void abreDeclaracao(DeclaracaoITR dec) {
        try {
            ITRFacade.getInstancia().repositorioXMLITR.abreDeclaracao(dec);
        }
        catch (Exception e) {
            e.printStackTrace();
            GuiUtil.mostrarErro("excecao_inesperada");
            System.exit(1);
        }
    }

    public static void fecharDeclaracao() {
        ITRFacade.getInstancia().repositorioXMLITR.fechaDeclaracao();
        MapeamentoInformacaoEditCampo.limpaAssociacoes();
        if (declaracaoEmMemoria != null) {
            declaracaoEmMemoria.getIdentificadorDeclaracao().liberarInformacoes();
        }
        declaracaoEmMemoria = null;
    }

    public static void salvaDeclaracaoAberta() {
        DeclaracaoITR dec = ITRFacade.getDeclaracaoAberta();
        ITRFacade.limparBrancosEmColecaoCondominos(dec.getDemaisCondominos().itens());
        ITRFacade.limparBrancosEmColecoesAquisAlien(dec.getAquisicaoAlienacao().getAquisicaoTotal().itens());
        ITRFacade.limparBrancosEmColecoesAquisAlien(dec.getAquisicaoAlienacao().getAquisicaoParcial().itens());
        ITRFacade.limparBrancosEmColecoesAquisAlien(dec.getAquisicaoAlienacao().getAlienacaoParcial().itens());
        ITRFacade.limparBrancosEmColecaoDesaprop(dec.getAquisicaoAlienacao().getDesapropriacao().itens());
        ITRFacade.getInstancia().repositorioXMLITR.salvaDeclaracaoAberta();
    }

    public static void salvarDeclaracao(DeclaracaoITR dec) throws RepositorioXMLException {
        try {
            ITRFacade.getInstancia().repositorioXMLITR.salvarDeclaracao(dec);
            dec.getDataHoraSalvamento().setConteudo(DataUtil.obterDataAtual());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void salvaDeclaracaoEmMemoria() {
        try {
            DeclaracaoITR dec = ITRFacade.getDeclaracaoEmMemoria();
            ITRFacade.salvarDeclaracao(dec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void definirDeclaracaoComoNaoModificada(String nirf) throws RepositorioXMLException {
        ITRFacade.getInstancia().repositorioXMLITR.definirDeclaracaoComoNaoModificada(nirf);
    }

    private static void limparBrancosEmColecoesAquisAlien(List list) {
        boolean encontrouBrancos = false;
        InformacaoAquisicaoAlienacao infoAnterior = null;
        int tam = list.size();
        int contAnterior = -1;
        for (int contAtual = 0; contAtual < tam; ++contAtual) {
            InformacaoAquisicaoAlienacao infoAtual = (InformacaoAquisicaoAlienacao)((Object)list.get(contAtual));
            if (infoAtual.getNiAlienanteAdquirente().naoFormatado().trim().length() == 0 && infoAtual.getNirfImovelAlienanteAdquirente().naoFormatado().trim().length() == 0 && infoAtual.getData().naoFormatado().trim().length() == 0 && infoAtual.getArea().naoFormatado().trim().equals("0,0")) {
                encontrouBrancos = true;
                if (contAnterior != -1) continue;
                contAnterior = contAtual;
                continue;
            }
            if (!encontrouBrancos) continue;
            infoAnterior = (InformacaoAquisicaoAlienacao)((Object)list.get(contAnterior));
            infoAnterior.getNiAlienanteAdquirente().setConteudo(infoAtual.getNiAlienanteAdquirente().naoFormatado());
            infoAnterior.getNirfImovelAlienanteAdquirente().setConteudo(infoAtual.getNirfImovelAlienanteAdquirente().naoFormatado());
            infoAnterior.getArea().setConteudo(infoAtual.getArea().naoFormatado());
            infoAnterior.getData().setConteudo(infoAtual.getData().naoFormatado());
            ++contAnterior;
        }
        if (encontrouBrancos) {
            while (contAnterior < tam) {
                infoAnterior = (InformacaoAquisicaoAlienacao)((Object)list.get(contAnterior));
                infoAnterior.getNiAlienanteAdquirente().clear();
                infoAnterior.getNirfImovelAlienanteAdquirente().clear();
                infoAnterior.getArea().clear();
                infoAnterior.getData().clear();
                ++contAnterior;
            }
        }
    }

    private static void limparBrancosEmColecaoDesaprop(List list) {
        boolean encontrouBrancos = false;
        InformacaoDesapropriacao infoAnterior = null;
        int tam = list.size();
        int contAnterior = -1;
        for (int contAtual = 0; contAtual < tam; ++contAtual) {
            InformacaoDesapropriacao infoAtual = (InformacaoDesapropriacao)((Object)list.get(contAtual));
            if (infoAtual.getCnpjDesaproprianteAdquirente().naoFormatado().trim().length() == 0 && infoAtual.getData().naoFormatado().trim().length() == 0 && infoAtual.getArea().naoFormatado().trim().equals("0,0")) {
                encontrouBrancos = true;
                if (contAnterior != -1) continue;
                contAnterior = contAtual;
                continue;
            }
            if (!encontrouBrancos) continue;
            infoAnterior = (InformacaoDesapropriacao)((Object)list.get(contAnterior));
            infoAnterior.getCnpjDesaproprianteAdquirente().setConteudo(infoAtual.getCnpjDesaproprianteAdquirente().naoFormatado());
            infoAnterior.getArea().setConteudo(infoAtual.getArea().naoFormatado());
            infoAnterior.getData().setConteudo(infoAtual.getData().naoFormatado());
            ++contAnterior;
        }
        if (encontrouBrancos) {
            while (contAnterior < tam) {
                infoAnterior = (InformacaoDesapropriacao)((Object)list.get(contAnterior));
                infoAnterior.getCnpjDesaproprianteAdquirente().clear();
                infoAnterior.getArea().clear();
                infoAnterior.getData().clear();
                ++contAnterior;
            }
        }
    }

    private static void limparBrancosEmColecaoCondominos(List list) {
        boolean encontrouBrancos = false;
        Condomino infoAnterior = null;
        int tam = list.size();
        int contAnterior = -1;
        for (int contAtual = 0; contAtual < tam; ++contAtual) {
            Condomino infoAtual = (Condomino)((Object)list.get(contAtual));
            if (infoAtual.getNi().naoFormatado().trim().length() == 0 && infoAtual.getNome().naoFormatado().trim().length() == 0 && infoAtual.getPercentual().getConteudoAbsoluto().intValue() == 0) {
                encontrouBrancos = true;
                if (contAnterior != -1) continue;
                contAnterior = contAtual;
                continue;
            }
            if (!encontrouBrancos) continue;
            infoAnterior = (Condomino)((Object)list.get(contAnterior));
            infoAnterior.getNi().setConteudo(infoAtual.getNi().naoFormatado());
            infoAnterior.getNome().setConteudo(infoAtual.getNome().naoFormatado());
            infoAnterior.getPercentual().setConteudo(infoAtual.getPercentual().naoFormatado());
            ++contAnterior;
        }
        if (encontrouBrancos) {
            while (contAnterior < tam) {
                infoAnterior = (Condomino)((Object)list.get(contAnterior));
                infoAnterior.getNi().clear();
                infoAnterior.getNome().clear();
                infoAnterior.getPercentual().clear();
                ++contAnterior;
            }
        }
    }

    public DeclaracaoITR getDeclaracao() {
        return ITRFacade.getInstancia().repositorioXMLITR.getDeclaracaoAberta();
    }

    public static DeclaracaoITR getDeclaracao(String cib) throws RepositorioXMLException, HashInvalidoException {
        return ITRFacade.recuperarDeclaracao(cib);
    }

    public static DeclaracaoITR getDeclaracaoAberta() {
        return ITRFacade.getInstancia().repositorioXMLITR.getDeclaracaoAberta();
    }

    public static File gravarParaEntrega(File destino, String cib) throws RepositorioXMLException, GeracaoTxtException, IOException, HashInvalidoException {
        DeclaracaoITR dec = ITRFacade.recuperarDeclaracao(cib);
        return ITRFacade.getInstancia().repositorioTxtITR.gravarParaEntrega(dec, destino);
    }

    public static void gravarCopiaSeguranca(File destino, String cib) throws RepositorioXMLException, GeracaoTxtException, HashInvalidoException {
        ITRFacade.getInstancia().repositorioTxtITR.gravarCopiaSeguranca(ITRFacade.recuperarDeclaracao(cib), destino);
    }

    public static void gravarCopiaDeclaracaoTransmitida(File arqDecOrigem, File destino) throws GeracaoTxtException {
        ITRFacade.getInstancia().repositorioTxtITR.gravarCopiaDeclaracaoTransmitida(arqDecOrigem, destino);
    }

    public static ComplementoRecibo getRecibo(File arqDec) throws Exception {
        ComplementoRecibo recibo = ITRFacade.getInstancia().repositorioTxtITR.restaurarRecibo(arqDec);
        recibo.setPathArquivo(arqDec.getAbsolutePath());
        return recibo;
    }

    public static DeclaracaoITR getDeclaracao(File arqDec) throws Exception {
        return ITRFacade.getInstancia().repositorioTxtITR.restaurarDeclaracao(arqDec, false);
    }

    public static RelatorioMultiploXMLITR imprimirDeclaracao(String cib, File decTransmitida) throws RepositorioXMLException, HashInvalidoException {
        return ITRFacade.getInstancia().impressao.imprimirDeclaracao(ITRFacade.recuperarDeclaracao(cib), decTransmitida);
    }

    private static DeclaracaoITR recuperarDeclaracao(String cib) throws RepositorioXMLException, HashInvalidoException {
        return ITRFacade.getInstancia().repositorioXMLITR.recuperarDeclaracaoITR(cib);
    }

    public static RelatorioMultiploXMLITR imprimirRecibo(File arqDec) throws Exception {
        return ITRFacade.getInstancia().impressao.imprimirRecibo(ITRFacade.getRecibo(arqDec));
    }

    public static RelatorioMultiploXMLITR imprimirDarfDecPreenchimento(DeclaracaoITR dec, Integer[] quotas) throws Exception {
        return ITRFacade.getInstancia().impressao.imprimirDarfDecPreenchimento(dec, quotas);
    }

    public static RelatorioMultiploXMLITR imprimirDarfDecTrasmitida(File arqDec, Integer[] quotas) throws Exception {
        return ITRFacade.getInstancia().impressao.imprimirDarfDecTrasmitida(ITRFacade.getRecibo(arqDec), quotas);
    }

    public static RelatorioMultiploXMLITR imprimirDarfMulta(File arqDec) throws Exception {
        ComplementoRecibo recibo = ITRFacade.getRecibo(arqDec);
        if (recibo.getNumSequencial().isVazio()) {
            throw new RepositorioException(MensagemUtil.getMensagem("110170", new String[]{recibo.getNirf().formatado()}));
        }
        return ITRFacade.getInstancia().impressao.imprimirDarfMulta(recibo);
    }

    public static RelatorioMultiploXMLITR imprimirNotificacao(File arqDec) throws Exception {
        ComplementoRecibo recibo = ITRFacade.getRecibo(arqDec);
        if (recibo.getNumSequencial().isVazio()) {
            throw new RepositorioException(MensagemUtil.getMensagem("110171", new String[]{recibo.getNirf().formatado()}));
        }
        return ITRFacade.getInstancia().impressao.imprimirNotificacao(recibo);
    }

    public static DeclaracaoITR obterDeclaracaoRepositorio(String cib) throws RepositorioXMLException, HashInvalidoException {
        return ITRFacade.recuperarDeclaracao(cib);
    }

    public static List verificarPendencias(String cib) throws RepositorioXMLException, HashInvalidoException {
        return FabricaUtilitarios.verificarPendencias((Object)((Object)ITRFacade.recuperarDeclaracao(cib)));
    }

    public static void salvarDeclaracaoRestaurada(DeclaracaoITR dec, boolean sobrescrever) throws AplicacaoException, RepositorioXMLException {
        String cib = dec.getIdentificadorDeclaracao().getNirf().asString();
        if (ITRFacade.existeDeclaracao(cib)) {
            if (sobrescrever) {
                ITRFacade.excluirDeclaracao(cib);
            } else {
                throw new AplicacaoException("declaracao.existente");
            }
        }
        FabricaUtilitarios.verificarPendencias((Object)((Object)dec));
        ITRFacade.criarDeclaracao(dec);
        ITRFacade.getInstancia().repositorioXMLITR.salvarDeclaracao(dec);
    }

    public static void restaurarDeclaracao(File arquivo, boolean sobrescrever, boolean copia) throws Exception {
        DeclaracaoITR dec = ITRFacade.getInstancia().repositorioTxtITR.restaurarDeclaracao(arquivo, copia);
        ITRFacade.getInstancia().repositorioTxtITR.importarDeclaracaoGravada(arquivo);
        ITRFacade.salvarDeclaracaoRestaurada(dec, sobrescrever);
        dec.getIdentificadorDeclaracao().liberarInformacoes();
    }

    public static void recuperarDeclaracaoExercicioAnterior(File arquivo, boolean sobrescrever) throws Exception {
        DeclaracaoITR dec = ITRFacade.getInstancia().repositorioTxtITR.recuperarDeclaracaoExercicioAnterior(arquivo);
        ITRFacade.salvarDeclaracaoRestaurada(dec, sobrescrever);
        dec.getIdentificadorDeclaracao().liberarInformacoes();
    }

    public static void excluirDeclaracao(String cib) {
        ITRFacade.getInstancia().repositorioXMLITR.excluirDeclaracao(cib);
    }

    public static void excluirDeclaracao(IdentificadorDeclaracao id) {
        ITRFacade.getInstancia().repositorioXMLITR.excluirDeclaracao(id.getNirf().asString());
    }

    public static String obterNirfArquivoDeclaracao(File arquivo) {
        return ITRFacade.getInstancia().repositorioTxtITR.obterNirfArquivoDeclaracao(arquivo);
    }

    public static String obterNirfArquivoCopiaSeguranca(File arquivo) {
        return ITRFacade.getInstancia().repositorioTxtITR.obterNirfArquivoCopiaSeguranca(arquivo);
    }

    public static String obterNirfArquivoExercicioAnterior(File arquivo) {
        return ITRFacade.getInstancia().repositorioTxtITR.obterNirfArquivoExercicioAnterior(arquivo);
    }

    public static String obterNomeArquivoDec(IdentificadorDeclaracao id) {
        return ITRFacade.getInstancia().repositorioTxtITR.obterNomeArquivoDec(id);
    }

    public static String obterNomeArquivoDecCopia(IdentificadorDeclaracao id) {
        return ITRFacade.getInstancia().repositorioTxtITR.obterNomeArquivoDecCopia(id);
    }

    public static FileFilter obterNovoFileFilterArquivoDecUltimaTransmitida() {
        return ITRFacade.getInstancia().repositorioTxtITR.obterNovoFileFilterArquivoDecUltimaTransmitida();
    }

    public static FileFilter obterNovoFileFilterArquivoDecTransmitida() {
        return ITRFacade.getInstancia().repositorioTxtITR.obterNovoFileFilterArquivoDecTransmitida();
    }

    public static FileFilter obterNovoFileFilterArquivoDecTransmitidaMaed() {
        return ITRFacade.getInstancia().repositorioTxtITR.obterNovoFileFilterArquivoDecTransmitidaMaed();
    }

    public static FileFilter obterNovoFileFilterArquivoDec() {
        return ITRFacade.getInstancia().repositorioTxtITR.obterNovoFileFilterArquivoDec();
    }

    public static javax.swing.filechooser.FileFilter obterNovoFileChooserFilterArquivoDec() {
        return ITRFacade.getInstancia().repositorioTxtITR.obterNovoFileChooserFilterArquivoDec();
    }

    public static FileFilter obterNovoFileFilterArquivoCopiaSeguranca() {
        return ITRFacade.getInstancia().repositorioTxtITR.obterNovoFileFilterArquivoCopiaSeguranca();
    }

    public static javax.swing.filechooser.FileFilter obterNovoFileChooserFilterArquivoCopiaSeguranca() {
        return ITRFacade.getInstancia().repositorioTxtITR.obterNovoFileChooserFilterArquivoCopiaSeguranca();
    }

    public static FileFilter obterNovoFileFilterArquivoExercicioAnterior() {
        return ITRFacade.getInstancia().repositorioTxtITR.obterNovoFileFilterArquivoExercicioAnterior();
    }

    public static javax.swing.filechooser.FileFilter obterNovoFileChooserFilterArquivoExercicioAnterior() {
        return ITRFacade.getInstancia().repositorioTxtITR.obterNovoFileChooserFilterArquivoExercicioAnterior();
    }

    public static String obterNomeArquivoRec(IdentificadorDeclaracao id) {
        return ITRFacade.getInstancia().repositorioTxtITR.obterNomeArquivoRec(id);
    }

    public static String obterNomeArquivoSemExtensao(IdentificadorDeclaracao id) {
        return RepositorioDeclaracaoTxt.obterNomeArquivoSemExtensao(id);
    }

    public static List obterPrimeirosRegistros(File arq, String tipoArq, String tipoReg, int qtdRegs) throws GeracaoTxtException, IOException {
        return ITRFacade.getInstancia().repositorioTxtITR.obterPrimeirosRegistros(arq, tipoArq, tipoReg, qtdRegs);
    }

    public static IdImovel obterIdImovelRepositorio(IdentificadorDeclaracao id) {
        return ITRFacade.getInstancia().repositorioTxtITR.obterIdImovelRepositorio(id);
    }

    public static IdImovel obterIdImovelDecGravada(File arqDec) {
        return ITRFacade.getInstancia().repositorioTxtITR.obterIdImovelDecGravada(arqDec);
    }

    public static int obterStatusIdImovel(IdentificadorDeclaracao id) {
        return ITRFacade.getInstancia().repositorioTxtITR.obterStatusIdImovel(id);
    }

    public static File obterPastaPadraoGravadas() {
        File gravadas = new File(ConstantesGlobaisITR.PATH_GRAVADAS);
        if (!gravadas.exists() || !gravadas.isDirectory()) {
            gravadas.mkdirs();
        }
        return gravadas;
    }

    public static File obterPastaPadraoTransmitidas() {
        File transmitidas = new File(ConstantesGlobaisITR.PATH_TRANSMITIDAS);
        if (!transmitidas.exists() || !transmitidas.isDirectory()) {
            transmitidas.mkdirs();
        }
        return transmitidas;
    }

    public static File obterPastaPadraoGravadasExercicioAnterior() {
        File gravadas = null;
        if (FabricaUtilitarios.isWindows()) {
            String pathGravadas = File.separator + "Arquivos de Programas RFB" + File.separator + "ITR" + ConstantesGlobais.EXERCICIO_ANTERIOR + File.separator + "gravadas";
            gravadas = new File(pathGravadas);
        } else if (FabricaUtilitarios.isMac()) {
            String pathGravadas = File.separator + "Applications" + File.separator + "Programas RFB" + ConstantesGlobais.EXERCICIO_ANTERIOR + File.separator + "ITR" + File.separator + "gravadas";
            gravadas = new File(pathGravadas);
        } else {
            String pathGravadas = System.getProperty("user.home") + File.separator + "ProgramasRFB" + File.separator + "ITR" + ConstantesGlobais.EXERCICIO_ANTERIOR + File.separator + "gravadas";
            gravadas = new File(pathGravadas);
        }
        return gravadas;
    }

    public static void verificaIdDeclaracoes() {
        ITRFacade.getInstancia().repositorioXMLITR.verificaIdDeclaracoes();
    }

    public static List<IdentificadorDeclaracao> getListaDeclaracoesRecentes() {
        List lista = ITRFacade.getListaIdDeclaracoes().itens();
        ArrayList<IdentificadorDeclaracao> listaOrdenada = new ArrayList<IdentificadorDeclaracao>();
        Collections.sort(lista, new Comparator<ObjetoNegocio>(){

            @Override
            public int compare(ObjetoNegocio o1, ObjetoNegocio o2) {
                IdentificadorDeclaracao i1 = (IdentificadorDeclaracao)o1;
                IdentificadorDeclaracao i2 = (IdentificadorDeclaracao)o2;
                Date d1 = i1.getDataUltimoAcesso().asDate();
                Date d2 = i2.getDataUltimoAcesso().asDate();
                if (d1 != null && d2 != null) {
                    return i2.getDataUltimoAcesso().asDate().compareTo(i1.getDataUltimoAcesso().asDate());
                }
                if (d1 == null) {
                    return 1;
                }
                return -1;
            }
        });
        int cont = 0;
        for (ObjetoNegocio objetoNegocio : lista) {
            IdentificadorDeclaracao id = (IdentificadorDeclaracao)objetoNegocio;
            listaOrdenada.add(id);
            if (++cont < 10) continue;
            break;
        }
        return listaOrdenada;
    }

    public static boolean verificaImovelPreenchido(DeclaracaoITR dec) {
        return !dec.getImovel().getAreaTotal().isVazio() && !dec.getImovel().getUf().isVazio() && !dec.getImovel().getMunicipio().isVazio();
    }

    public static boolean verificaImovelCondominio(DeclaracaoITR dec) {
        return dec.getImovel().getPertenceCondominio().naoFormatado().equals(Logico.SIM);
    }

    public static boolean verificaImovelImuneIsento(DeclaracaoITR dec) {
        return dec.getImovel().getIsento().naoFormatado().equals(Logico.SIM);
    }

    public static boolean verificaImovelEnquadramento(DeclaracaoITR dec) {
        return dec.getImovel().enquadramento();
    }

    public static boolean habilitarFichaContribuinte(DeclaracaoITR dec) {
        return ITRFacade.verificaImovelPreenchido(dec);
    }

    public static boolean habilitarFichaDemaisCondominos(DeclaracaoITR dec) {
        return ITRFacade.verificaImovelPreenchido(dec) && ITRFacade.verificaImovelCondominio(dec);
    }

    public static boolean habilitarFichaAquisicaoAlienacao(DeclaracaoITR dec) {
        return ITRFacade.verificaImovelPreenchido(dec);
    }

    public static boolean habilitarFichaUtilizacaoImovel(DeclaracaoITR dec) {
        return ITRFacade.verificaImovelPreenchido(dec) && !ITRFacade.verificaImovelImuneIsento(dec);
    }

    public static boolean habilitarFichaAreaNaoUtilizada(DeclaracaoITR dec) {
        return ITRFacade.verificaImovelPreenchido(dec) && !ITRFacade.verificaImovelImuneIsento(dec);
    }

    public static boolean habilitarFichaCalculoImposto(DeclaracaoITR dec) {
        return ITRFacade.verificaImovelPreenchido(dec) && !ITRFacade.verificaImovelImuneIsento(dec);
    }

    public static boolean habilitarFichaAtividadePecuaria(DeclaracaoITR dec) {
        return ITRFacade.verificaImovelPreenchido(dec) && !ITRFacade.verificaImovelImuneIsento(dec) && ITRFacade.verificaImovelEnquadramento(dec);
    }

    public static boolean habilitarFichaAtividadeExtrativa(DeclaracaoITR dec) {
        return ITRFacade.verificaImovelPreenchido(dec) && !ITRFacade.verificaImovelImuneIsento(dec) && ITRFacade.verificaImovelEnquadramento(dec);
    }
}

