/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr;

import java.io.File;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.ObservadorEspacosDuplicados;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.itr.validadores.ValidadorCIB;
import serpro.ppgd.itr.validadores.ValidadorNirf;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.DataHora;
import serpro.ppgd.negocio.IdentificadorDeclaracaoXML;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.NIRF;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class IdentificadorDeclaracao
extends ObjetoNegocio
implements Comparable<IdentificadorDeclaracao>,
IdentificadorDeclaracaoXML {
    public static final String LABEL_RETIFICADORA = "Indicador de Declara\u00e7\u00e3o retificadora";
    private NIRF nirf = new NIRF("Nirf");
    private NI niContribuinte = new NI(null, "NI do Contribuinte");
    private Alfa nomeContribuinte = new Alfa(null, "Nome da Pessoa F\u00edsica / Nome Empresarial", 60);
    private Alfa nomeImovel = new Alfa(null, "Nome do Im\u00f3vel Rural", 55);
    private Logico retificadora = new Logico(null, "Indicador de Declara\u00e7\u00e3o retificadora");
    private Alfa numeroReciboDeclaracaoAnterior = new Alfa(null, "N\u00famero do Recibo da \u00faltima Declara\u00e7\u00e3o Transmitida", 12);
    private Logico modificada = new Logico(null, "Modificada");
    private DataHora dataUltimoAcesso = new DataHora((ObjetoNegocio)this, "Data \u00faltimo Acesso");

    public IdentificadorDeclaracao() {
        this.retificadora.addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.retificadora.addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.modificada.addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.modificada.addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.adicionaValidadores();
        this.nomeContribuinte.addObservador((Observador)new ObservadorEspacosDuplicados());
        this.nomeImovel.addObservador((Observador)new ObservadorEspacosDuplicados());
    }

    public void liberarInformacoes() {
        this.nirf = null;
        this.niContribuinte = null;
        this.nomeContribuinte = null;
        this.nomeImovel = null;
        this.retificadora = null;
        this.numeroReciboDeclaracaoAnterior = null;
        this.modificada = null;
    }

    public void adicionaValidadores() {
        this.nirf.addValidador((ValidadorIf)new ValidadorNirf(3, MensagemUtil.getMensagem("300050")));
        this.nirf.addValidador((ValidadorIf)new ValidadorCIB(3, MensagemUtil.getMensagem("300050")));
        this.nirf.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("300045")));
    }

    public String getPathArquivo() {
        String path = ConstantesGlobaisITR.PATH_DADOS + File.separator + this.getNirf().asString();
        File flDados = new File(path);
        if (!flDados.exists()) {
            flDados.mkdirs();
        }
        return path + File.separator + this.getNirf().asString() + ".xml";
    }

    public NIRF getNirf() {
        return this.nirf;
    }

    public void setNirf(NIRF nirf) {
        this.nirf = nirf;
    }

    public NI getNiContribuinte() {
        return this.niContribuinte;
    }

    public void setNiContribuinte(NI niContribuinte) {
        this.niContribuinte = niContribuinte;
    }

    public Alfa getNomeContribuinte() {
        return this.nomeContribuinte;
    }

    public void setNomeContribuinte(Alfa nomeContribuinte) {
        this.nomeContribuinte = nomeContribuinte;
    }

    public Alfa getNomeImovel() {
        return this.nomeImovel;
    }

    public void setNomeImovel(Alfa nomeImovel) {
        this.nomeImovel = nomeImovel;
    }

    public Logico getRetificadora() {
        return this.retificadora;
    }

    public Alfa getNumeroReciboDeclaracaoAnterior() {
        return this.numeroReciboDeclaracaoAnterior;
    }

    public Logico getModificada() {
        return this.modificada;
    }

    public boolean isModificada() {
        return this.modificada.isVazio() || this.modificada.getConteudoFormatado().equals(Logico.SIM);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof IdentificadorDeclaracao && ((IdentificadorDeclaracao)obj).getNirf().asString().equals(this.getNirf().asString());
    }

    public DataHora getDataUltimoAcesso() {
        return this.dataUltimoAcesso;
    }

    public void setDataUltimoAcesso(DataHora dataUltimoAcesso) {
        this.dataUltimoAcesso = dataUltimoAcesso;
    }

    @Override
    public int compareTo(IdentificadorDeclaracao idDeclaracao) {
        String nome1 = this.getNirf().asString().toUpperCase();
        String nome2 = idDeclaracao.getNirf().asString().toUpperCase();
        return nome1.compareTo(nome2);
    }
}

