/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import serpro.ppgd.gui.DialogoOcupado;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.itr.ColecaoIdDeclaracao;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.util.DataUtil;
import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.itr.xml.IdDeclaracaoXMLTagHandler;
import serpro.ppgd.itr.xml.XMLSaxHandler;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.DeclaracaoComIdentificador;
import serpro.ppgd.negocio.IdentificadorDeclaracaoXML;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.persistenciagenerica.DefaultTagHandler;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;
import serpro.ppgd.persistenciagenerica.RepositorioXML;
import serpro.ppgd.persistenciagenerica.RepositorioXMLDefault;
import serpro.ppgd.persistenciagenerica.RepositorioXMLListener;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class RepositorioXMLITR
extends RepositorioXML
implements RepositorioXMLListener {
    public static final String PATH_XML_ID_DECS = ConstantesGlobaisITR.PATH_DADOS + File.separator + "iddeclaracoes.xml";
    private IdentificadorDeclaracao identificadorDeclaracao = null;
    private DeclaracaoITR declaracaoITR = null;
    private ColecaoIdDeclaracao listaIdDeclaracoesCache = null;
    private boolean cacheIdDeclaracao = false;
    private RepositorioXMLDefault repositorioIds = new RepositorioXMLDefault();
    private RepositorioXMLDefault repositorioDeclaracoes = new RepositorioXMLDefault();

    public RepositorioXMLITR() {
        this.carregaIdDeclaracoes();
    }

    private ColecaoIdDeclaracao carregaIdDeclaracoes() {
        if (PlataformaPPGD.isEmDesign()) {
            this.listaIdDeclaracoesCache = new ColecaoIdDeclaracao();
            return this.listaIdDeclaracoesCache;
        }
        try {
            this.testaDiretorioDados();
            this.listaIdDeclaracoesCache = new ColecaoIdDeclaracao();
            this.repositorioIds.preencheObjeto((ObjetoNegocio)this.listaIdDeclaracoesCache, PATH_XML_ID_DECS, true);
            return this.listaIdDeclaracoesCache;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void testaDiretorioDados() {
        String diretorioDadosApp = ConstantesGlobaisITR.PATH_DADOS;
        File flDados = new File(diretorioDadosApp);
        if (!flDados.exists()) {
            flDados.mkdirs();
        }
    }

    public DeclaracaoITR recuperarDeclaracaoITR(String nirf) throws RepositorioXMLException, HashInvalidoException {
        IdentificadorDeclaracao idAtual = this.getListaIdDeclaracoes().getIdentificadorDeclaracao(nirf);
        DeclaracaoITR dec = null;
        if (this.repositorioDeclaracoes.temObjetoNegocioEmCache(idAtual.getPathArquivo())) {
            dec = (DeclaracaoITR)this.repositorioDeclaracoes.getObjeto(idAtual.getPathArquivo());
        } else {
            dec = new DeclaracaoITR(idAtual);
            if (this.repositorioDeclaracoes.preencheObjeto((ObjetoNegocio)dec, idAtual.getPathArquivo(), false) == null) {
                throw new RepositorioXMLException("A declara\u00e7\u00e3o solicitada nao existe");
            }
        }
        return dec;
    }

    public void definirDeclaracaoComoNaoModificada(String nirf) throws RepositorioXMLException {
        try {
            ColecaoIdDeclaracao colIds = this.getListaIdDeclaracoes();
            IdentificadorDeclaracao idAtual = colIds.getIdentificadorDeclaracao(nirf);
            if (idAtual != null) {
                idAtual.getModificada().setConteudo(Logico.NAO);
                this.repositorioIds.salvar((ObjetoNegocio)colIds, PATH_XML_ID_DECS);
            }
        }
        catch (RepositorioException e) {
            e.printStackTrace();
        }
    }

    public void salvarDeclaracao(DeclaracaoITR dec) throws RepositorioXMLException {
        try {
            ColecaoIdDeclaracao colIds = this.getListaIdDeclaracoes();
            IdentificadorDeclaracao idAtual = dec.getIdentificadorDeclaracao();
            IdentificadorDeclaracao item = colIds.getIdentificadorDeclaracao(idAtual.getNirf().naoFormatado());
            item.getModificada().setConteudo(Logico.SIM);
            dec.getIdentificadorDeclaracao().getDataUltimoAcesso().setConteudo(DataUtil.obterDataAtual());
            this.copiaIdentificador(idAtual, item);
            IdentificadorDeclaracao itemDec = dec.getCopiaIdentificador();
            this.copiaIdentificador(idAtual, itemDec);
            this.repositorioIds.salvar((ObjetoNegocio)colIds, PATH_XML_ID_DECS);
            this.repositorioDeclaracoes.salvar((ObjetoNegocio)dec, idAtual.getPathArquivo());
        }
        catch (RepositorioException e) {
            e.printStackTrace();
        }
    }

    public void abreDeclaracao(DeclaracaoITR dec, boolean emMemoria) throws RepositorioXMLException, HashInvalidoException {
        this.identificadorDeclaracao = dec.getIdentificadorDeclaracao();
        DialogoOcupado diaOcupado = DialogoOcupado.exibeDialogo((int)0, (int)4, (String)"Aguarde...");
        try {
            diaOcupado.atualiza("Abrindo declara\u00e7\u00e3o...");
            this.declaracaoITR = dec;
            diaOcupado.atualiza();
            if (!emMemoria) {
                this.repositorioDeclaracoes.preencheObjeto((ObjetoNegocio)this.declaracaoITR, this.identificadorDeclaracao.getPathArquivo(), false);
                diaOcupado.atualiza();
            }
        }
        catch (RepositorioXMLException e) {
            throw e;
        }
        finally {
            diaOcupado.finaliza();
        }
    }

    public void abreDeclaracao(IdentificadorDeclaracao id) throws RepositorioXMLException, HashInvalidoException {
        this.abreDeclaracao(new DeclaracaoITR(id), false);
    }

    public void abreDeclaracao(DeclaracaoITR dec) throws RepositorioXMLException, HashInvalidoException {
        this.abreDeclaracao(dec, false);
    }

    public boolean existeDeclaracao(String nirf) {
        return this.getListaIdDeclaracoes().existeNirfCadastrado(nirf);
    }

    public ColecaoIdDeclaracao getListaIdDeclaracoes() {
        if (this.isCacheIdDeclaracao()) {
            return this.listaIdDeclaracoesCache;
        }
        return this.carregaIdDeclaracoes();
    }

    public void criarDeclaracao(IdentificadorDeclaracao id) {
        try {
            this.testaDiretorioDados();
            if (this.existeDeclaracao(id.getNirf().naoFormatado())) {
                throw new Exception("Declara\u00e7\u00e3o j\u00e1 existe.");
            }
            ColecaoIdDeclaracao colIds = this.getListaIdDeclaracoes();
            colIds.itens().add(id);
            this.repositorioIds.salvar((ObjetoNegocio)colIds, PATH_XML_ID_DECS);
            this.identificadorDeclaracao = id;
            DeclaracaoITR dec = new DeclaracaoITR(this.identificadorDeclaracao);
            this.repositorioDeclaracoes.salvar((ObjetoNegocio)dec, id.getPathArquivo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void criarDeclaracao(DeclaracaoITR dec) {
        try {
            this.testaDiretorioDados();
            IdentificadorDeclaracao id = dec.getIdentificadorDeclaracao();
            if (this.existeDeclaracao(id.getNirf().naoFormatado())) {
                throw new Exception("Declara\u00e7\u00e3o j\u00e1 existe.");
            }
            ColecaoIdDeclaracao colIds = this.getListaIdDeclaracoes();
            colIds.itens().add(id);
            this.repositorioIds.salvar((ObjetoNegocio)colIds, PATH_XML_ID_DECS);
            this.identificadorDeclaracao = id;
            this.repositorioDeclaracoes.salvar((ObjetoNegocio)dec, id.getPathArquivo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void excluirDeclaracao(String nirf) {
        try {
            this.testaDiretorioDados();
            ColecaoIdDeclaracao colIds = this.getListaIdDeclaracoes();
            IdentificadorDeclaracao id = colIds.getIdentificadorDeclaracao(nirf);
            colIds.removeNirf(id.getNirf().naoFormatado());
            this.repositorioIds.salvar((ObjetoNegocio)colIds, PATH_XML_ID_DECS);
            String dir = UtilitariosArquivo.extraiPath((String)id.getPathArquivo());
            this.repositorioDeclaracoes.excluir(id.getPathArquivo());
            new File(dir).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void salvaDeclaracaoAberta() {
        try {
            ColecaoIdDeclaracao colIds = this.getListaIdDeclaracoes();
            IdentificadorDeclaracao idAberto = this.getIdDeclaracaoAberto();
            IdentificadorDeclaracao item = colIds.getIdentificadorDeclaracao(idAberto.getNirf().naoFormatado());
            idAberto.getDataUltimoAcesso().setConteudo(DataUtil.obterDataAtual());
            this.copiaIdentificador(idAberto, item);
            this.repositorioIds.salvar((ObjetoNegocio)colIds, PATH_XML_ID_DECS);
            this.repositorioDeclaracoes.salvar((ObjetoNegocio)this.getDeclaracaoAberta(), idAberto.getPathArquivo());
        }
        catch (RepositorioException e) {
            e.printStackTrace();
        }
    }

    protected void copiaIdentificador(IdentificadorDeclaracaoXML orig, IdentificadorDeclaracaoXML destin) {
        IdentificadorDeclaracao origem = (IdentificadorDeclaracao)orig;
        IdentificadorDeclaracao destino = (IdentificadorDeclaracao)destin;
        destino.getNirf().setConteudo(origem.getNirf().naoFormatado());
        destino.getRetificadora().setConteudo(origem.getRetificadora().naoFormatado());
        destino.getNiContribuinte().setConteudo(origem.getNiContribuinte().naoFormatado());
        destino.getNomeContribuinte().setConteudo(origem.getNomeContribuinte().naoFormatado());
        destino.getNomeImovel().setConteudo(origem.getNomeImovel().naoFormatado());
        destino.getDataUltimoAcesso().setConteudo(origem.getDataUltimoAcesso().naoFormatado());
    }

    public void fechaDeclaracao() {
        this.declaracaoITR = null;
        this.identificadorDeclaracao = null;
        this.listaIdDeclaracoesCache = null;
        this.repositorioDeclaracoes.zeraCache();
        this.repositorioIds.zeraCache();
    }

    public IdentificadorDeclaracao getIdDeclaracaoAberto() {
        return this.identificadorDeclaracao;
    }

    public DeclaracaoITR getDeclaracaoAberta() {
        return this.declaracaoITR;
    }

    public boolean existeDeclaracoes() {
        return this.getListaIdDeclaracoes().itens().size() > 0;
    }

    public void setCacheIdDeclaracao(boolean cacheIdDeclaracao) {
        this.cacheIdDeclaracao = cacheIdDeclaracao;
        if (cacheIdDeclaracao) {
            this.listaIdDeclaracoesCache = new ColecaoIdDeclaracao();
            this.listaIdDeclaracoesCache.itens().addAll(this.carregaIdDeclaracoes().itens());
        } else {
            if (this.listaIdDeclaracoesCache != null) {
                this.listaIdDeclaracoesCache.clear();
            }
            this.listaIdDeclaracoesCache = null;
        }
    }

    public boolean isCacheIdDeclaracao() {
        return this.cacheIdDeclaracao;
    }

    public void verificaIdDeclaracoes() {
        ColecaoIdDeclaracao colIds = this.getListaIdDeclaracoes();
        this.testaDiretorioDados();
        String[] decs = null;
        try {
            File dados = new File(ConstantesGlobaisITR.PATH_DADOS);
            decs = dados.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean ret = name.matches("^[a-zA-Z0-9]{8}");
                    return ret;
                }
            });
        }
        catch (Exception e) {
            return;
        }
        if (colIds == null || decs != null && colIds.itens().size() != decs.length) {
            this.recuperaListaIdDeclaracoes(colIds, decs);
            try {
                this.repositorioIds.salvar((ObjetoNegocio)colIds, PATH_XML_ID_DECS);
            }
            catch (RepositorioXMLException repositorioXMLException) {
                // empty catch block
            }
        }
    }

    private void recuperaListaIdDeclaracoes(ColecaoIdDeclaracao colIds, String[] decs) {
        if (colIds == null) {
            colIds = new ColecaoIdDeclaracao();
        } else {
            colIds.itens().clear();
        }
        IdDeclaracaoXMLTagHandler tagHandler = new IdDeclaracaoXMLTagHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            XMLSaxHandler handler = new XMLSaxHandler();
            handler.addTagHandler("/classe/imovel/identificadorDeclaracao", tagHandler);
            for (int i = 0; i < decs.length; ++i) {
                File dirDec = new File(ConstantesGlobaisITR.PATH_DADOS + File.separator + decs[i]);
                if (!dirDec.isDirectory()) continue;
                try {
                    File[] decXml = dirDec.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            boolean ret = pathname.isFile() && pathname.getName().matches("^[a-zA-Z0-9]{8}\\.xml");
                            return ret;
                        }
                    });
                    if (decXml == null || decXml.length <= 0) continue;
                    tagHandler.setIdDec(new IdentificadorDeclaracao());
                    parser.parse(decXml[0], (DefaultHandler)handler);
                    colIds.itens().add(tagHandler.getIdDec());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    protected void antesDeSalvar(DeclaracaoComIdentificador aDec) {
        DeclaracaoITR dec = (DeclaracaoITR)aDec;
        IdentificadorDeclaracao copia = dec.getCopiaIdentificador();
        IdentificadorDeclaracao origem = dec.getIdentificadorDeclaracao();
        dec.getIdentificadorDeclaracao().getDataUltimoAcesso().setConteudo(DataUtil.obterDataAtual());
        this.copiaIdentificador(origem, copia);
    }

    public void abriuDeclaracao(DeclaracaoComIdentificador arg0) {
    }

    public void criouDeclaracao(DeclaracaoComIdentificador arg0) {
    }

    public void recuperouDeclaracao(DeclaracaoComIdentificador arg0) {
    }

    protected Colecao criarListaIdDeclaracoes() {
        return new ColecaoIdDeclaracao();
    }

    protected boolean existeDeclaracao(IdentificadorDeclaracaoXML identificadorDeclaracao) {
        IdentificadorDeclaracao identificadorITR = (IdentificadorDeclaracao)identificadorDeclaracao;
        return this.getListaIdDeclaracoes().existeNirfCadastrado(identificadorITR.getNirf().naoFormatado());
    }

    public String getXPathCopiaId() {
        return "/classe/copiaIdentificador";
    }

    protected DeclaracaoComIdentificador instanciarDeclaracao(IdentificadorDeclaracaoXML identificadorDeclaracao) {
        return new DeclaracaoITR((IdentificadorDeclaracao)identificadorDeclaracao);
    }

    protected String obterExpressaoRegularNomePasta() {
        return "^[a-zA-Z0-9]{8}";
    }

    protected IdentificadorDeclaracaoXML obterIdentificador(Colecao listaIdDeclaracoes, String numeroIdentificacao) {
        return ((ColecaoIdDeclaracao)listaIdDeclaracoes).getIdentificadorDeclaracao(numeroIdentificacao);
    }

    protected String obterNumeroIdentificacao(IdentificadorDeclaracaoXML identificadorDeclaracao) {
        return ((IdentificadorDeclaracao)identificadorDeclaracao).getNirf().naoFormatado();
    }

    protected String obterPathDados() {
        return ITRUtil.DIR_DADOS;
    }

    protected String obterPathXmlIdsDeclaracoes() {
        return this.obterPathDados() + File.separator + "iddeclaracoes.xml";
    }

    protected DefaultTagHandler obterTagHandler() {
        return new serpro.ppgd.itr.util.IdDeclaracaoXMLTagHandler();
    }

    protected void parseXml(Colecao colecaoIds, SAXParser parser, DefaultTagHandler tagHandler, serpro.ppgd.persistenciagenerica.XMLSaxHandler xmlHandler, File[] decXml) {
        try {
            serpro.ppgd.itr.util.IdDeclaracaoXMLTagHandler idDeclaracaoXMLTagHandler = (serpro.ppgd.itr.util.IdDeclaracaoXMLTagHandler)tagHandler;
            idDeclaracaoXMLTagHandler.setIdDec(new IdentificadorDeclaracao());
            parser.parse(decXml[0], (DefaultHandler)xmlHandler);
            colecaoIds.itens().add(idDeclaracaoXMLTagHandler.getIdDec());
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void removerIdentificador(Colecao colecaoIdentificadores, IdentificadorDeclaracaoXML identificadorDeclaracao) {
        ((ColecaoIdDeclaracao)colecaoIdentificadores).removeNirf(((IdentificadorDeclaracao)identificadorDeclaracao).getNirf().naoFormatado());
    }
}

