/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.ajuda;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.icepdf.core.pobjects.OutlineItem;
import org.icepdf.core.pobjects.Outlines;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.ComponentKeyBinding;
import org.icepdf.ri.common.MyAnnotationCallback;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.common.utility.outline.OutlineItemTreeNode;
import org.icepdf.ri.common.views.AnnotationCallback;
import serpro.ppgd.itr.ajuda.ActionAjudaF1;
import serpro.ppgd.itr.ajuda.ClickActionAjudaF1;
import serpro.ppgd.itr.ajuda.PDFViewBuilderPPGD;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class PDFHelp {
    private SwingController controller;
    private SwingViewBuilder factory;
    private JPanel viewerComponentPanel;
    private JFrame helpWindow;
    private String pdfFile;

    public PDFHelp(String filePath) {
        if (!FabricaUtilitarios.isMac()) {
            filePath = "help/" + (String)filePath;
        }
        String pathDefault = UtilitariosArquivo.getPathAplicacao() + "help/" + (String)filePath;
        String pathOpcional = UtilitariosArquivo.getPathAplicacao() + (String)filePath;
        if (new File(pathDefault).exists()) {
            this.setPdfFile(pathDefault);
        } else {
            this.setPdfFile(pathOpcional);
        }
    }

    public void acionaAjuda() {
        this.acionaAjuda(null);
    }

    public void acionaAjuda(String marcador) {
        boolean reload;
        boolean bl = reload = this.helpWindow == null || !this.helpWindow.isVisible();
        if (reload) {
            Defs.setProperty((String)"org.icepdf.core.print.alphaInterpolation", (Object)"VALUE_ALPHA_INTERPOLATION_SPEED");
            Defs.setProperty((String)"org.icepdf.core.print.antiAliasing", (Object)"VALUE_ANTIALIAS_OFF");
            Defs.setProperty((String)"org.icepdf.core.print.textAntiAliasing", (Object)"VALUE_TEXT_ANTIALIAS_OFF");
            Defs.setProperty((String)"org.icepdf.core.print.colorRender", (Object)"VALUE_COLOR_RENDER_SPEED");
            Defs.setProperty((String)"org.icepdf.core.print.dither", (Object)"VALUE_DITHER_DEFAULT");
            Defs.setProperty((String)"org.icepdf.core.print.fractionalmetrics", (Object)"VALUE_FRACTIONALMETRICS_OFF");
            Defs.setProperty((String)"org.icepdf.core.print.interpolation", (Object)"VALUE_INTERPOLATION_NEAREST_NEIGHBOR");
            Defs.setProperty((String)"org.icepdf.core.print.render", (Object)"VALUE_RENDER_SPEED");
            Defs.setProperty((String)"org.icepdf.core.print.stroke", (Object)"VALUE_STROKE_PURE");
            this.controller = new SwingController();
            this.factory = new PDFViewBuilderPPGD(this.controller);
            this.viewerComponentPanel = this.factory.buildViewerPanel();
            ComponentKeyBinding.install((SwingController)this.controller, (JComponent)this.viewerComponentPanel);
            this.controller.getDocumentViewController().setAnnotationCallback((AnnotationCallback)new MyAnnotationCallback(this.controller.getDocumentViewController()));
            this.controller.openDocument(this.getPdfFile());
            this.helpWindow = new JFrame("Ajuda");
            this.helpWindow.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
            this.helpWindow.getContentPane().add(this.viewerComponentPanel);
            this.helpWindow.setSize(1020, 800);
            this.helpWindow.setLocationRelativeTo(null);
        }
        this.helpWindow.setVisible(true);
        this.controller.setUtilityPaneVisible(true);
        this.controller.setPageViewMode(2, true);
        this.controller.setZoom(1.2f);
        this.posicionaNoMarcador(marcador);
    }

    private void posicionaNoMarcador(String marcador) {
        OutlineItem item = null;
        if (marcador != null) {
            Outlines outlines = this.controller.getDocument().getCatalog().getOutlines();
            if (outlines != null) {
                item = outlines.getRootOutlineItem();
            }
            String[] splitMarcadores = this.extraiMarcadoresDePath(marcador);
            for (int i = 0; i < splitMarcadores.length && item != null; ++i) {
                String subMarcador = splitMarcadores[i];
                Pattern p = Pattern.compile("\\[[0-9]+\\]");
                Matcher m = p.matcher(subMarcador);
                int nMarcador = -1;
                if (m.find()) {
                    String strMatch = m.group();
                    String strMarcador = strMatch.replaceAll("\\[", "").replaceAll("\\]", "");
                    nMarcador = Integer.parseInt(strMarcador);
                    subMarcador = subMarcador.replace(strMatch, "");
                }
                item = this.buscaOutlineFilhoPorTitulo(item, subMarcador, nMarcador);
            }
        }
        if (item != null) {
            this.controller.getDocumentViewController().setDestinationTarget(item.getDest());
        } else {
            this.controller.getDocumentViewController().setCurrentPageIndex(0);
            System.err.println(this.getClass().getName() + ": N\u00e3o foi poss\u00c3\u00advel encontrar o marcador [" + marcador + "]");
        }
    }

    private String[] extraiMarcadoresDePath(String path) {
        String[] splitMarcadores;
        ArrayList<String> marcadores = new ArrayList<String>();
        String pathTemp = path.replaceAll("//", "#");
        for (String tk : splitMarcadores = pathTemp.split("/")) {
            marcadores.add(tk.replace('#', '/'));
        }
        String[] result = marcadores.toArray(new String[0]);
        return result;
    }

    private OutlineItem buscaOutlineFilhoPorTitulo(OutlineItem raiz, String titulo, int indiceMarcador) {
        if (raiz != null) {
            OutlineItemTreeNode outlineItemTreeNode = new OutlineItemTreeNode(raiz);
            Enumeration depthFirst = outlineItemTreeNode.children();
            int countMarcador = indiceMarcador == -1 ? -1 : 0;
            for (int i = 0; i < outlineItemTreeNode.getChildCount(); ++i) {
                String title;
                OutlineItem item = ((OutlineItemTreeNode)outlineItemTreeNode.getChildAt(i)).getOutlineItem();
                String string = title = item.getTitle().startsWith("\ufeff") ? item.getTitle().substring(1) : item.getTitle();
                if (!title.equals(titulo)) continue;
                if (countMarcador == indiceMarcador) {
                    return item;
                }
                ++countMarcador;
            }
        }
        return null;
    }

    public void setHelpID(Container container, String id) {
        if (container instanceof JButton) {
            this.setHelpID((JButton)container, id);
        } else if (container instanceof JMenuItem) {
            this.setHelpID((JMenuItem)container, id);
        } else if (container instanceof JLabel) {
            this.setHelpID((JLabel)container, id);
        } else if (container instanceof JPanel) {
            JPanel painel = (JPanel)container;
            ActionMap actionMap = painel.getActionMap();
            InputMap inputMap = painel.getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke("F1"), id);
            actionMap.put(id, new ActionAjudaF1(this, id));
        } else if (container instanceof JComponent) {
            JComponent componente = (JComponent)container;
            InputMap inputMap = componente.getInputMap();
            ActionMap actionMap = componente.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke("F1"), id);
            actionMap.put(id, new ActionAjudaF1(this, id));
        } else if (container instanceof JFrame) {
            JPanel painel = (JPanel)((JFrame)container).getContentPane();
            InputMap inputMap = painel.getInputMap(2);
            ActionMap actionMap = painel.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke("F1"), id);
            actionMap.put(id, new ActionAjudaF1(this, id));
        }
    }

    public void setHelpID(JButton button, String id) {
        this.removeActionAjudaAntigo(button);
        button.addActionListener(new ActionAjudaF1(this, id));
        InputMap inputMap = button.getInputMap(2);
        ActionMap actionMap = button.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("F1"), id);
        actionMap.put(id, new ActionAjudaF1(this, id));
    }

    public void setHelpID(JMenuItem menuItem, String id) {
        this.removeActionAjudaAntigo(menuItem);
        menuItem.addActionListener(new ActionAjudaF1(this, id));
    }

    public void setHelpID(JLabel label, String id) {
        this.removeClickActionAjudaAntigo(label);
        label.addMouseListener(new ClickActionAjudaF1(this, id));
    }

    private void removeActionAjudaAntigo(AbstractButton button) {
        ActionAjudaF1 ajudaAnterior = null;
        for (ActionListener listener : button.getActionListeners()) {
            if (!(listener instanceof ActionAjudaF1)) continue;
            ajudaAnterior = (ActionAjudaF1)listener;
            break;
        }
        if (ajudaAnterior != null) {
            button.removeActionListener(ajudaAnterior);
        }
    }

    private void removeClickActionAjudaAntigo(JComponent comp) {
        ClickActionAjudaF1 ajudaAnterior = null;
        for (MouseListener listener : comp.getMouseListeners()) {
            if (!(listener instanceof ClickActionAjudaF1)) continue;
            ajudaAnterior = (ClickActionAjudaF1)listener;
            break;
        }
        if (ajudaAnterior != null) {
            comp.removeMouseListener(ajudaAnterior);
        }
    }

    public String getPdfFile() {
        return this.pdfFile;
    }

    public void setPdfFile(String pdfFile) {
        this.pdfFile = pdfFile;
    }
}

