/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.aquisicaoalienacao;

import java.util.List;
import serpro.ppgd.itr.AreaHectares;
import serpro.ppgd.itr.DataITR;
import serpro.ppgd.itr.ObjetoNegocioITR;
import serpro.ppgd.itr.ValidadorDataSimples;
import serpro.ppgd.itr.ValidadorNIItr;
import serpro.ppgd.itr.aquisicaoalienacao.ValidadorDataITR;
import serpro.ppgd.itr.aquisicaoalienacao.ValidadorInfoIncompletaArea;
import serpro.ppgd.itr.aquisicaoalienacao.ValidadorInfoIncompletaData;
import serpro.ppgd.itr.aquisicaoalienacao.ValidadorInfoIncompletaNI;
import serpro.ppgd.itr.aquisicaoalienacao.ValidadorInfoIncompletaNirf;
import serpro.ppgd.itr.aquisicaoalienacao.ValidadorInfoIncompletaNirfCPF;
import serpro.ppgd.itr.gui.aquisicaoalienacao.PainelDadosAquisicaoAlienacao;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.NIRF;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNIRF;

public class InformacaoAquisicaoAlienacao
extends ObjetoNegocioITR
implements ObjetoFicha {
    private NI niAlienanteAdquirente = new NI((ObjetoNegocio)this, "CPF/CNPJ do Alienante ou Adquirente");
    private Data data = new DataITR(this, "Data");
    private NIRF nirfImovelAlienanteAdquirente = new NIRF((ObjetoNegocio)this, "Nirf");
    private AreaHectares area = new AreaHectares(this, "\u00c1rea Adquirida (em hectares)");
    private Alfa fichaOrigem = new Alfa((ObjetoNegocio)this, "classeFicha");

    public InformacaoAquisicaoAlienacao(String nomeCampoArea) {
        this.niAlienanteAdquirente.addValidador((ValidadorIf)new ValidadorNIItr(3));
        this.niAlienanteAdquirente.addValidador((ValidadorIf)new ValidadorInfoIncompletaNirfCPF(this, MensagemUtil.getMensagem("300005")));
        this.niAlienanteAdquirente.addValidador((ValidadorIf)new ValidadorInfoIncompletaNI(this, MensagemUtil.getMensagem("300020")));
        this.data.addValidador((ValidadorIf)new ValidadorDataSimples(3));
        this.data.addValidador((ValidadorIf)new ValidadorInfoIncompletaData(this, MensagemUtil.getMensagem("300030")));
        this.data.addValidador((ValidadorIf)new ValidadorDataITR(2, MensagemUtil.getMensagem("300040")));
        this.nirfImovelAlienanteAdquirente.addValidador((ValidadorIf)new ValidadorNIRF(3));
        this.nirfImovelAlienanteAdquirente.addValidador((ValidadorIf)new ValidadorInfoIncompletaNirfCPF(this, MensagemUtil.getMensagem("300005")));
        this.nirfImovelAlienanteAdquirente.addValidador((ValidadorIf)new ValidadorInfoIncompletaNirf(this, MensagemUtil.getMensagem("300045")));
        this.area.addValidador((ValidadorIf)new ValidadorInfoIncompletaArea(this, MensagemUtil.getMensagem("300060", new String[]{nomeCampoArea})));
    }

    public boolean isVazio() {
        boolean vazio = this.niAlienanteAdquirente.isVazio();
        vazio = vazio && this.data.isVazio();
        vazio = vazio && this.nirfImovelAlienanteAdquirente.isVazio();
        vazio = vazio && this.area.isVazio();
        return vazio;
    }

    public NI getNiAlienanteAdquirente() {
        return this.niAlienanteAdquirente;
    }

    public void setNiAlienanteAdquirente(NI niAlienanteAdquirente) {
        this.niAlienanteAdquirente = niAlienanteAdquirente;
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public NIRF getNirfImovelAlienanteAdquirente() {
        return this.nirfImovelAlienanteAdquirente;
    }

    public void setNirfImovelAlienanteAdquirente(NIRF nirfImovelAlienanteAdquirente) {
        this.nirfImovelAlienanteAdquirente = nirfImovelAlienanteAdquirente;
    }

    public AreaHectares getArea() {
        return this.area;
    }

    public void setArea(AreaHectares area) {
        this.area = area;
    }

    protected List recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.getNiAlienanteAdquirente());
        retorno.add(this.getData());
        retorno.add(this.getNirfImovelAlienanteAdquirente());
        retorno.add(this.getArea());
        return retorno;
    }

    public Alfa getFichaOrigem() {
        return this.fichaOrigem;
    }

    public String getClasseFicha() {
        return PainelDadosAquisicaoAlienacao.class.getName();
    }

    public String getNomeAba() {
        return this.getFichaOrigem().asString();
    }

    public String getTituloFichaDashboard() {
        return null;
    }
}

