/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.aquisicaoalienacao;

import java.util.Date;
import java.util.List;
import serpro.ppgd.itr.AreaHectares;
import serpro.ppgd.itr.ValidadorCNPJItr;
import serpro.ppgd.itr.ValidadorDataSimples;
import serpro.ppgd.itr.aquisicaoalienacao.ValidadorDataITR;
import serpro.ppgd.itr.gui.aquisicaoalienacao.PainelAbaDesapropriacaoLista;
import serpro.ppgd.itr.gui.aquisicaoalienacao.PainelDadosAquisicaoAlienacao;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.CNPJ;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class InformacaoDesapropriacao
extends ObjetoNegocio
implements ObjetoFicha {
    private static final String NOME_FICHA = "Desapropria\u00e7\u00e3o ou Aliena\u00e7\u00e3o para Entidades Imunes do ITR";
    private Data dataPerdaPosse = new Data(this, "Data da Perda da Posse por Desapropria\u00e7\u00e3o ou Aliena\u00e7\u00e3o"){

        public boolean isVazio() {
            if (this.asString().trim().equals(ConstantesGlobais.EXERCICIO)) {
                return true;
            }
            return super.isVazio();
        }
    };
    private AreaHectares area = new AreaHectares(this, "\u00c1rea Desapropriada ou Alienada - ha");
    private CNPJ cnpjDesaproprianteAdquirente = new CNPJ((ObjetoNegocio)this, "CNPJ do Desapropriante ou do Adquirente");

    public InformacaoDesapropriacao() {
        this.dataPerdaPosse.addValidador((ValidadorIf)new ValidadorDataSimples(3));
        this.dataPerdaPosse.addValidador((ValidadorIf)new ValidadorDataITR(2, MensagemUtil.getMensagem("156")));
        this.dataPerdaPosse.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("155")){

            public RetornoValidacao validarImplementado() {
                if (!(!InformacaoDesapropriacao.this.dataPerdaPosse.isVazio() || InformacaoDesapropriacao.this.cnpjDesaproprianteAdquirente.isVazio() && InformacaoDesapropriacao.this.area.isVazio())) {
                    return new RetornoValidacao(this.getSeveridade());
                }
                return null;
            }
        });
        this.dataPerdaPosse.addValidador((ValidadorIf)new ValidadorDefault(2){

            public RetornoValidacao validarImplementado() {
                Data dataPassada = (Data)this.getInformacao();
                Data dataLimite = new Data(null, "");
                dataLimite.setConteudo(new Date());
                boolean maiorQueDataLimite = dataLimite.maisAntiga(dataPassada);
                if (maiorQueDataLimite) {
                    this.setMensagemValidacao(MensagemUtil.getMensagem("300040"));
                    this.setSeveridade((byte)2);
                    return new RetornoValidacao(MensagemUtil.getMensagem("300040"), 2);
                }
                return null;
            }
        });
        this.cnpjDesaproprianteAdquirente.addValidador((ValidadorIf)new ValidadorCNPJItr(3));
        this.cnpjDesaproprianteAdquirente.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("175")){

            public RetornoValidacao validarImplementado() {
                if (!(!InformacaoDesapropriacao.this.cnpjDesaproprianteAdquirente.isVazio() || InformacaoDesapropriacao.this.dataPerdaPosse.isVazio() && InformacaoDesapropriacao.this.area.isVazio())) {
                    return new RetornoValidacao(this.getSeveridade());
                }
                return null;
            }
        });
        this.area.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("170")){

            public RetornoValidacao validarImplementado() {
                if (!(!InformacaoDesapropriacao.this.area.isVazio() || InformacaoDesapropriacao.this.cnpjDesaproprianteAdquirente.isVazio() && InformacaoDesapropriacao.this.dataPerdaPosse.isVazio())) {
                    return new RetornoValidacao(this.getSeveridade());
                }
                return null;
            }
        });
        this.setFicha(NOME_FICHA);
    }

    public Data getData() {
        return this.dataPerdaPosse;
    }

    public void setData(Data aData) {
        this.dataPerdaPosse = aData;
    }

    public AreaHectares getArea() {
        return this.area;
    }

    public void setArea(AreaHectares aArea) {
        this.area = aArea;
    }

    public CNPJ getCnpjDesaproprianteAdquirente() {
        return this.cnpjDesaproprianteAdquirente;
    }

    public void setCnpjDesaproprianteAdquirente(CNPJ aCnpjDesaproprianteAdquirente) {
        this.cnpjDesaproprianteAdquirente = aCnpjDesaproprianteAdquirente;
    }

    public boolean isVazio() {
        boolean vazio = this.cnpjDesaproprianteAdquirente.isVazio();
        vazio = vazio && this.dataPerdaPosse.isVazio();
        vazio = vazio && this.area.isVazio();
        return vazio;
    }

    protected List recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.getArea());
        retorno.add(this.getData());
        retorno.add(this.getCnpjDesaproprianteAdquirente());
        return retorno;
    }

    public String getClasseFicha() {
        return PainelDadosAquisicaoAlienacao.class.getName();
    }

    public String getNomeAba() {
        return PainelAbaDesapropriacaoLista.NOME_ABA;
    }

    public String getTituloFichaDashboard() {
        return null;
    }
}

