/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.atividadeextrativa;

import serpro.ppgd.itr.AreaHectares;
import serpro.ppgd.itr.ObjetoNegocioITR;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class ItemAtividadeExtrativa
extends ObjetoNegocioITR {
    private String nomeProduto = "";
    private AreaHectares area = new AreaHectares(this, "\u00c1rea (ha)");
    private Valor qtdProduzida = new Valor((ObjetoNegocio)this, "Quantidade Extra\u00edda");
    private Alfa und = new Alfa((ObjetoNegocio)this, "Unid. Prod.", 3);
    private Valor rendMinimo = new Valor((ObjetoNegocio)this, "Rend. M\u00edn.");
    private AreaHectares areaCalculada = new AreaHectares(this, "\u00c1rea Calculada (ha)");
    private AreaHectares areaAceita = new AreaHectares(this, "\u00c1rea Aceita (ha)");

    public ItemAtividadeExtrativa() {
        this.iniciaValidadoresObservadores();
        this.setFicha("Atividade Extrativa");
    }

    public ItemAtividadeExtrativa(String nomeProduto) {
        this();
        this.setNomeProduto(nomeProduto);
        this.getArea().setNomeCampo(nomeProduto + "-" + this.getArea().getNomeCampo());
        this.getArea().setNomeCampoCurto(nomeProduto);
        this.getQtdProduzida().setNomeCampo(nomeProduto + "-" + this.getQtdProduzida().getNomeCampo());
        this.getUnd().setNomeCampo(nomeProduto + "-" + this.getUnd().getNomeCampo());
        this.getRendMinimo().setNomeCampo(nomeProduto + "-" + this.getRendMinimo().getNomeCampo());
        this.getAreaCalculada().setNomeCampo(nomeProduto + "-" + this.getAreaCalculada().getNomeCampo());
        this.getAreaAceita().setNomeCampo(nomeProduto + "-" + this.getAreaAceita().getNomeCampo());
    }

    protected void iniciaValidadoresObservadores() {
        Observador obsCalculaArea1 = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ItemAtividadeExtrativa.this.getAreaCalculada().clear();
                AreaHectares auxAreaCalculada = new AreaHectares("0,00");
                auxAreaCalculada.setCasasDecimais(2);
                auxAreaCalculada.append('+', ItemAtividadeExtrativa.this.getQtdProduzida());
                auxAreaCalculada.append('/', ItemAtividadeExtrativa.this.getRendMinimo());
                auxAreaCalculada.arredonda(1, 5);
                ItemAtividadeExtrativa.this.getAreaCalculada().setConteudo(auxAreaCalculada.getConteudoFormatado());
                ItemAtividadeExtrativa.this.calculaAreaAceita();
            }
        };
        this.getQtdProduzida().addObservador(obsCalculaArea1);
        this.getRendMinimo().addObservador(obsCalculaArea1);
        Observador obsCalculaArea2 = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                ItemAtividadeExtrativa.this.calculaAreaAceita();
            }
        };
        this.getArea().addObservador(obsCalculaArea2);
        ValidadorDefault validadorAreaQtdProduzida = new ValidadorDefault(2){

            public RetornoValidacao validarImplementado() {
                if (ItemAtividadeExtrativa.this.getArea().isVazio() && ItemAtividadeExtrativa.this.qtdProduzida.comparacao(">", "0")) {
                    RetornoValidacao retorno = new RetornoValidacao(this.getSeveridade());
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("700025"));
                    return retorno;
                }
                return null;
            }
        };
        this.getArea().addValidador((ValidadorIf)validadorAreaQtdProduzida);
        this.getQtdProduzida().addValidador((ValidadorIf)validadorAreaQtdProduzida);
    }

    private void calculaAreaAceita() {
        if (this.getArea().comparacao("<", this.getAreaCalculada())) {
            this.getAreaAceita().setConteudo(this.getArea());
        } else if (this.getRendMinimo().getConteudo().intValue() == 0) {
            this.getAreaAceita().setConteudo(this.getArea());
        } else {
            this.getAreaAceita().setConteudo(this.getAreaCalculada());
        }
    }

    public String getNomeProduto() {
        return this.nomeProduto;
    }

    public void setNomeProduto(String nomeProduto) {
        this.nomeProduto = nomeProduto;
    }

    public AreaHectares getArea() {
        return this.area;
    }

    public void setArea(AreaHectares area) {
        this.area = area;
    }

    public Valor getQtdProduzida() {
        return this.qtdProduzida;
    }

    public void setQtdProduzida(Valor qtdProduzida) {
        this.qtdProduzida = qtdProduzida;
    }

    public Alfa getUnd() {
        return this.und;
    }

    public void setUnd(Alfa und) {
        this.und = und;
    }

    public Valor getRendMinimo() {
        return this.rendMinimo;
    }

    public void setRendMinimo(Valor rendMinimo) {
        this.rendMinimo = rendMinimo;
    }

    public AreaHectares getAreaCalculada() {
        return this.areaCalculada;
    }

    public void setAreaCalculada(AreaHectares areaCalculada) {
        this.areaCalculada = areaCalculada;
    }

    public AreaHectares getAreaAceita() {
        return this.areaAceita;
    }

    public void setAreaAceita(AreaHectares areaAceita) {
        this.areaAceita = areaAceita;
    }
}

