/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.atividadeextrativa;

import java.lang.ref.WeakReference;
import serpro.ppgd.itr.atividadeextrativa.ItemAtividadeExtrativa;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.util.Validador;

public class ValidadorDataAprovacaoIbama
extends ValidadorDefault {
    private WeakReference refProduto;

    public ValidadorDataAprovacaoIbama(byte severidade, ItemAtividadeExtrativa produto) {
        super(severidade);
        this.setVerificaVazio(true);
        this.refProduto = new WeakReference<ItemAtividadeExtrativa>(produto);
    }

    public RetornoValidacao validarImplementado() {
        ItemAtividadeExtrativa produto = (ItemAtividadeExtrativa)((Object)this.refProduto.get());
        if (!this.getInformacao().isReadOnly()) {
            RetornoValidacao retorno = new RetornoValidacao(this.getSeveridade());
            if (Validador.verificaData((String)this.getInformacao().getConteudoFormatado()) == 0) {
                Data dataLimite = new Data(null, "data limite");
                dataLimite.setConteudo("31/12/" + ConstantesGlobais.EXERCICIO_ANTERIOR);
                Data dataPiso = new Data(null, "data Piso");
                dataPiso.setConteudo("01/01/1960");
                Data dataErro = new Data(null, "data Erro");
                dataErro.setConteudo("01/01/1880");
                Data dataPassada = (Data)this.getInformacao();
                if (dataPassada.maisNova(dataLimite)) {
                    this.setSeveridade((byte)3);
                    this.setMensagemValidacao(MensagemUtil.getMensagem("700005", new String[]{ConstantesGlobais.EXERCICIO_ANTERIOR}));
                    retorno.setSeveridade(this.getSeveridade());
                    retorno.setMensagemValidacao(this.getMensagemValidacao());
                    return retorno;
                }
                if (dataPassada.maisAntiga(dataErro)) {
                    this.setSeveridade((byte)3);
                    this.setMensagemValidacao(MensagemUtil.getMensagem("150"));
                    retorno.setSeveridade(this.getSeveridade());
                    retorno.setMensagemValidacao(this.getMensagemValidacao());
                    return retorno;
                }
                if (dataPassada.maisAntiga(dataPiso)) {
                    this.setSeveridade((byte)2);
                    this.setMensagemValidacao(MensagemUtil.getMensagem("700010"));
                    retorno.setSeveridade(this.getSeveridade());
                    retorno.setMensagemValidacao(this.getMensagemValidacao());
                    return retorno;
                }
            } else {
                if (this.getInformacao().isVazio() && !produto.getAreaAceita().isVazio()) {
                    this.setSeveridade((byte)3);
                    this.setMensagemValidacao(MensagemUtil.getMensagem("700030"));
                    retorno.setSeveridade(this.getSeveridade());
                    retorno.setMensagemValidacao(this.getMensagemValidacao());
                    return retorno;
                }
                if (!this.getInformacao().isVazio()) {
                    this.setSeveridade((byte)3);
                    retorno = Validador.validarData((String)this.getInformacao().getConteudoFormatado());
                    retorno.setSeveridade(this.getSeveridade());
                    this.setMensagemValidacao("Data inv\u00e1lida");
                    return retorno;
                }
            }
        }
        return null;
    }
}

