/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.calculoimposto;

import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.itr.AreaHectares;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.calculoimposto.ValidadorQtdQuotas;
import serpro.ppgd.itr.calculoimposto.ValidadorQtdQuotas2;
import serpro.ppgd.itr.calculoimposto.ValidadorSomaValorTerraNua;
import serpro.ppgd.itr.calculoimposto.ValidadorValorTerraNuaDivergente;
import serpro.ppgd.itr.gui.calculoimposto.PainelCalculoImposto;
import serpro.ppgd.itr.imovel.Imovel;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class CalculoImposto
extends ObjetoNegocio
implements ObjetoFicha {
    private Valor valorTotalImovel = new Valor((ObjetoNegocio)this, "01. Valor Total do Im\u00f3vel");
    private Valor valorBenfeitorias = new Valor((ObjetoNegocio)this, "02. Valor das Constru\u00e7\u00f5es, Instala\u00e7\u00f5es e Benfeitorias");
    private Valor valorCulturas = new Valor((ObjetoNegocio)this, "03. Valor das Culturas, Pastagens Cultivadas e Melhoradas e Florestas Plantadas");
    private Valor valorTerraNua = new Valor((ObjetoNegocio)this, "04. VALOR DA TERRA NUA");
    private Valor valorTerraNuaTributavel = new Valor((ObjetoNegocio)this, "05. VALOR DA TERRA NUA TRIBUT\u00c1VEL");
    private Valor aliquota = new Valor((ObjetoNegocio)this, "06. AL\u00cdQUOTA (%)");
    private Valor impostoCalculado = new Valor((ObjetoNegocio)this, "07. IMPOSTO CALCULADO");
    private Valor impostoDevido = new Valor((ObjetoNegocio)this, "08. IMPOSTO DEVIDO");
    private Valor qtdCotas = new Valor((ObjetoNegocio)this, "09. Quantidade de Quotas");
    private Valor valorQuota = new Valor((ObjetoNegocio)this, "10. VALOR DA QUOTA OU DA QUOTA \u00daNICA");
    private Valor impostoCalculadoBase = new Valor((ObjetoNegocio)this, "");
    private Valor paramVEL20 = new Valor((ObjetoNegocio)this, "Tratamento do Par\u00e2metro(TP) 20");
    private WeakReference refImovel;

    public CalculoImposto(Imovel aImovel) {
        this.setFicha("C\u00e1lculo do Imposto");
        this.refImovel = new WeakReference<Imovel>(aImovel);
        this.getValorTerraNua().setReadOnly(true);
        this.getValorTerraNuaTributavel().setReadOnly(true);
        this.getAliquota().setReadOnly(true);
        this.getImpostoDevido().setReadOnly(true);
        this.getImpostoCalculado().setReadOnly(true);
        this.getValorQuota().setReadOnly(true);
        this.getAliquota().setPorcentagem(true);
        this.getQtdCotas().converteQtdCasasDecimais(0);
        this.getQtdCotas().setMaximoDigitosParteInteira(1);
        this.getValorTotalImovel().setMaximoDigitosParteInteira(10);
        this.getValorBenfeitorias().setMaximoDigitosParteInteira(10);
        this.getValorCulturas().setMaximoDigitosParteInteira(10);
        this.adicionarValidadores();
        this.adicionarObservadores();
    }

    private void adicionarValidadores() {
        this.getValorTotalImovel().addValidador((ValidadorIf)new ValidadorNaoNuloFichaCalculoImposto(3, MensagemUtil.getMensagem("500005")));
        this.getValorTotalImovel().addValidador((ValidadorIf)new ValidadorSomaValorTerraNua(5, this.getValorTotalImovel(), this.getValorBenfeitorias(), this.getValorCulturas()));
        this.getValorTerraNua().addValidador((ValidadorIf)new ValidadorNaoNuloFichaCalculoImposto(2, MensagemUtil.getMensagem("500025")));
        this.getQtdCotas().addValidador((ValidadorIf)new ValidadorQtdQuotas(5));
        this.getQtdCotas().addValidador((ValidadorIf)new ValidadorQtdQuotas2(3));
        this.getValorBenfeitorias().addValidador((ValidadorIf)new ValidadorSomaValorTerraNua(5, this.getValorTotalImovel(), this.getValorBenfeitorias(), this.getValorCulturas()));
        this.getValorCulturas().addValidador((ValidadorIf)new ValidadorSomaValorTerraNua(5, this.getValorTotalImovel(), this.getValorBenfeitorias(), this.getValorCulturas()));
        this.getValorTotalImovel().addValidador((ValidadorIf)new ValidadorValorTerraNuaDivergente(5, this.getValorTerraNua()));
    }

    private void adicionarObservadores() {
        Observador observadorCalculoImposto1 = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                if (!ITRFacade.getDeclaracaoEmMemoria().getImovel().getIsento().formatado().equals(Logico.SIM)) {
                    this.setAtivo(false);
                    CalculoImposto.this.getValorTerraNua().setObservadoresAtivos(false);
                    CalculoImposto.this.getValorTerraNua().clear();
                    CalculoImposto.this.getValorTerraNua().append('+', CalculoImposto.this.getValorTotalImovel());
                    CalculoImposto.this.getValorTerraNua().append('-', CalculoImposto.this.getValorBenfeitorias());
                    CalculoImposto.this.getValorTerraNua().append('-', CalculoImposto.this.getValorCulturas());
                    if (CalculoImposto.this.getValorTotalImovel().comparacao(">", "0,00") && CalculoImposto.this.getQtdCotas().comparacao("=", "0")) {
                        CalculoImposto.this.getQtdCotas().setConteudo("1");
                    }
                    this.setAtivo(true);
                    CalculoImposto.this.getValorTerraNua().setObservadoresAtivos(true);
                    CalculoImposto.this.getValorTerraNua().disparaObservadores();
                    if (CalculoImposto.this.getValorQuota().comparacao("<=", "50,00") && CalculoImposto.this.getQtdCotas().comparacao(">", "1")) {
                        CalculoImposto.this.getQtdCotas().setConteudo("1");
                    }
                }
            }
        };
        Observador observadorCalculoImposto2 = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                if (!ITRFacade.getDeclaracaoEmMemoria().getImovel().getIsento().formatado().equals(Logico.SIM)) {
                    this.setAtivo(false);
                    CalculoImposto.this.getImpostoCalculado().setObservadoresAtivos(false);
                    CalculoImposto.this.getImpostoDevido().setObservadoresAtivos(false);
                    CalculoImposto.this.getValorQuota().setObservadoresAtivos(false);
                    CalculoImposto.this.getImpostoCalculado().clear();
                    CalculoImposto.this.getImpostoCalculado().append('+', CalculoImposto.this.getValorTerraNuaTributavel());
                    CalculoImposto.this.getImpostoCalculadoBase().setConteudo(CalculoImposto.this.getImpostoCalculado());
                    CalculoImposto.this.getImpostoCalculado().append('*', CalculoImposto.this.getAliquota());
                    CalculoImposto.this.getImpostoCalculado().append('/', "100,00");
                    if (CalculoImposto.this.getImpostoCalculado().comparacao(">", "10,00")) {
                        CalculoImposto.this.getImpostoDevido().clear();
                        CalculoImposto.this.getImpostoDevido().append('+', CalculoImposto.this.getImpostoCalculado());
                        CalculoImposto.this.getValorQuota().clear();
                        CalculoImposto.this.getValorQuota().append('+', CalculoImposto.this.getImpostoDevido());
                        CalculoImposto.this.getValorQuota().append('/', CalculoImposto.this.getQtdCotas());
                    } else {
                        CalculoImposto.this.getImpostoDevido().setConteudo("10,00");
                        CalculoImposto.this.getImpostoCalculadoBase().setConteudo("10,00");
                        CalculoImposto.this.getValorQuota().setConteudo("10,00");
                        CalculoImposto.this.getQtdCotas().setConteudo("1");
                    }
                    this.setAtivo(true);
                    CalculoImposto.this.getImpostoCalculado().setObservadoresAtivos(true);
                    CalculoImposto.this.getImpostoDevido().setObservadoresAtivos(true);
                    CalculoImposto.this.getValorQuota().setObservadoresAtivos(true);
                    CalculoImposto.this.getImpostoCalculado().disparaObservadores();
                    CalculoImposto.this.getImpostoDevido().disparaObservadores();
                    CalculoImposto.this.getValorQuota().disparaObservadores();
                }
            }
        };
        Observador observadorCalculoImposto3 = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                if (!ITRFacade.getDeclaracaoEmMemoria().getImovel().getIsento().formatado().equals(Logico.SIM)) {
                    this.setAtivo(false);
                    CalculoImposto.this.getValorQuota().setObservadoresAtivos(false);
                    CalculoImposto.this.getValorQuota().clear();
                    CalculoImposto.this.getValorQuota().append('+', CalculoImposto.this.getImpostoDevido());
                    CalculoImposto.this.getValorQuota().append('/', CalculoImposto.this.getQtdCotas());
                    if (CalculoImposto.this.getValorQuota().comparacao("<", "50,00") && CalculoImposto.this.getQtdCotas().comparacao(">", "1")) {
                        CalculoImposto.this.getQtdCotas().setConteudo("1");
                        CalculoImposto.this.getValorQuota().clear();
                        CalculoImposto.this.getValorQuota().append('+', CalculoImposto.this.getImpostoDevido());
                    }
                    this.setAtivo(true);
                    CalculoImposto.this.getValorQuota().setObservadoresAtivos(true);
                    CalculoImposto.this.getValorQuota().disparaObservadores();
                }
            }
        };
        this.getValorTotalImovel().addObservador(observadorCalculoImposto1);
        this.getValorBenfeitorias().addObservador(observadorCalculoImposto1);
        this.getValorCulturas().addObservador(observadorCalculoImposto1);
        this.getValorTerraNuaTributavel().addObservador(observadorCalculoImposto2);
        this.getAliquota().addObservador(observadorCalculoImposto2);
        this.getAliquota().addObservador(observadorCalculoImposto3);
        this.getQtdCotas().addObservador(observadorCalculoImposto3);
        ITRFacade.getDeclaracaoEmMemoria().getImovel().getIsento().addObservador(observadorCalculoImposto1);
        ITRFacade.getDeclaracaoEmMemoria().getImovel().getIsento().addObservador(observadorCalculoImposto2);
        ITRFacade.getDeclaracaoEmMemoria().getImovel().getIsento().addObservador(observadorCalculoImposto3);
    }

    protected boolean testaVazio(Informacao pInfo) {
        int hashcode = pInfo.hashCode();
        if (hashcode == this.getAliquota().hashCode() || hashcode == this.getImpostoDevido().hashCode() || hashcode == this.getQtdCotas().hashCode() || hashcode == this.getValorQuota().hashCode() || hashcode == this.getImpostoCalculadoBase().hashCode() || pInfo.isReadOnly()) {
            return false;
        }
        return super.testaVazio(pInfo);
    }

    public void calculaAliquota(Valor pGrauUtilizacao, AreaHectares pAreaTotalImovel, AreaHectares pAreaTributavel) {
        this.setAtivo(false);
        this.getAliquota().setObservadoresAtivos(false);
        if (pAreaTributavel.isVazio()) {
            this.getAliquota().setConteudo("0,00");
        } else if (pGrauUtilizacao.comparacao("<=", "30,00")) {
            if (pAreaTotalImovel.comparacao("<=", "50,0")) {
                this.getAliquota().setConteudo("1,00");
            } else if (pAreaTotalImovel.comparacao(">", "50,0") && pAreaTotalImovel.comparacao("<=", "200,0")) {
                this.getAliquota().setConteudo("2,00");
            } else if (pAreaTotalImovel.comparacao(">", "200,0") && pAreaTotalImovel.comparacao("<=", "500,0")) {
                this.getAliquota().setConteudo("3,30");
            } else if (pAreaTotalImovel.comparacao(">", "500,0") && pAreaTotalImovel.comparacao("<=", "1000,0")) {
                this.getAliquota().setConteudo("4,70");
            } else if (pAreaTotalImovel.comparacao(">", "1000,0") && pAreaTotalImovel.comparacao("<=", "5000,0")) {
                this.getAliquota().setConteudo("8,60");
            } else if (pAreaTotalImovel.comparacao(">", "5000,0")) {
                this.getAliquota().setConteudo("20,00");
            }
        } else if (pGrauUtilizacao.comparacao(">", "30,00") && pGrauUtilizacao.comparacao("<=", "50,00")) {
            if (pAreaTotalImovel.comparacao("<=", "50,0")) {
                this.getAliquota().setConteudo("0,70");
            } else if (pAreaTotalImovel.comparacao(">", "50,0") && pAreaTotalImovel.comparacao("<=", "200,0")) {
                this.getAliquota().setConteudo("1,40");
            } else if (pAreaTotalImovel.comparacao(">", "200,0") && pAreaTotalImovel.comparacao("<=", "500,0")) {
                this.getAliquota().setConteudo("2,30");
            } else if (pAreaTotalImovel.comparacao(">", "500,0") && pAreaTotalImovel.comparacao("<=", "1000,0")) {
                this.getAliquota().setConteudo("3,30");
            } else if (pAreaTotalImovel.comparacao(">", "1000,0") && pAreaTotalImovel.comparacao("<=", "5000,0")) {
                this.getAliquota().setConteudo("6,00");
            } else if (pAreaTotalImovel.comparacao(">", "5000,0")) {
                this.getAliquota().setConteudo("12,00");
            }
        } else if (pGrauUtilizacao.comparacao(">", "50,00") && pGrauUtilizacao.comparacao("<=", "65,00")) {
            if (pAreaTotalImovel.comparacao("<=", "50,0")) {
                this.getAliquota().setConteudo("0,40");
            } else if (pAreaTotalImovel.comparacao(">", "50,0") && pAreaTotalImovel.comparacao("<=", "200,0")) {
                this.getAliquota().setConteudo("0,80");
            } else if (pAreaTotalImovel.comparacao(">", "200,0") && pAreaTotalImovel.comparacao("<=", "500,0")) {
                this.getAliquota().setConteudo("1,30");
            } else if (pAreaTotalImovel.comparacao(">", "500,0") && pAreaTotalImovel.comparacao("<=", "1000,0")) {
                this.getAliquota().setConteudo("1,90");
            } else if (pAreaTotalImovel.comparacao(">", "1000,0") && pAreaTotalImovel.comparacao("<=", "5000,0")) {
                this.getAliquota().setConteudo("3,40");
            } else if (pAreaTotalImovel.comparacao(">", "5000,0")) {
                this.getAliquota().setConteudo("6,40");
            }
        } else if (pGrauUtilizacao.comparacao(">", "65,00") && pGrauUtilizacao.comparacao("<=", "80,00")) {
            if (pAreaTotalImovel.comparacao("<=", "50,0")) {
                this.getAliquota().setConteudo("0,20");
            } else if (pAreaTotalImovel.comparacao(">", "50,0") && pAreaTotalImovel.comparacao("<=", "200,0")) {
                this.getAliquota().setConteudo("0,40");
            } else if (pAreaTotalImovel.comparacao(">", "200,0") && pAreaTotalImovel.comparacao("<=", "500,0")) {
                this.getAliquota().setConteudo("0,60");
            } else if (pAreaTotalImovel.comparacao(">", "500,0") && pAreaTotalImovel.comparacao("<=", "1000,0")) {
                this.getAliquota().setConteudo("0,85");
            } else if (pAreaTotalImovel.comparacao(">", "1000,0") && pAreaTotalImovel.comparacao("<=", "5000,0")) {
                this.getAliquota().setConteudo("1,60");
            } else if (pAreaTotalImovel.comparacao(">", "5000,0")) {
                this.getAliquota().setConteudo("3,00");
            }
        } else if (pGrauUtilizacao.comparacao(">", "80,00")) {
            if (pAreaTotalImovel.comparacao("<=", "50,0")) {
                this.getAliquota().setConteudo("0,03");
            } else if (pAreaTotalImovel.comparacao(">", "50,0") && pAreaTotalImovel.comparacao("<=", "200,0")) {
                this.getAliquota().setConteudo("0,07");
            } else if (pAreaTotalImovel.comparacao(">", "200,0") && pAreaTotalImovel.comparacao("<=", "500,0")) {
                this.getAliquota().setConteudo("0,10");
            } else if (pAreaTotalImovel.comparacao(">", "500,0") && pAreaTotalImovel.comparacao("<=", "1000,0")) {
                this.getAliquota().setConteudo("0,15");
            } else if (pAreaTotalImovel.comparacao(">", "1000,0") && pAreaTotalImovel.comparacao("<=", "5000,0")) {
                this.getAliquota().setConteudo("0,30");
            } else if (pAreaTotalImovel.comparacao(">", "5000,0")) {
                this.getAliquota().setConteudo("0,45");
            }
        }
        this.setAtivo(true);
        this.getAliquota().setObservadoresAtivos(true);
        this.getAliquota().disparaObservadores();
    }

    public void calculaValorTerraNuaTributavel(AreaHectares pAreaTotalImovel, AreaHectares pAreaTributavel) {
        this.setAtivo(false);
        this.getValorTerraNuaTributavel().setObservadoresAtivos(false);
        this.getValorTerraNuaTributavel().clear();
        Valor valorTerraNuaTributavelCalculado = new Valor();
        valorTerraNuaTributavelCalculado.setConteudo((Valor)pAreaTributavel);
        valorTerraNuaTributavelCalculado.converteQtdCasasDecimais(4);
        valorTerraNuaTributavelCalculado.append('/', (Valor)pAreaTotalImovel);
        valorTerraNuaTributavelCalculado.append('*', this.getValorTerraNua());
        valorTerraNuaTributavelCalculado.converteQtdCasasDecimais(2);
        this.getValorTerraNuaTributavel().setConteudo(valorTerraNuaTributavelCalculado.formatado());
        this.setAtivo(true);
        this.getValorTerraNuaTributavel().setObservadoresAtivos(true);
        this.getValorTerraNuaTributavel().disparaObservadores();
    }

    public Valor getValorTotalImovel() {
        return this.valorTotalImovel;
    }

    public void setValorTotalImovel(Valor valorTotalImovel) {
        this.valorTotalImovel = valorTotalImovel;
    }

    public Valor getValorBenfeitorias() {
        return this.valorBenfeitorias;
    }

    public void setValorBenfeitorias(Valor valorBenfeitorias) {
        this.valorBenfeitorias = valorBenfeitorias;
    }

    public Valor getValorCulturas() {
        return this.valorCulturas;
    }

    public void setValorCulturas(Valor valorCulturas) {
        this.valorCulturas = valorCulturas;
    }

    public Valor getValorTerraNua() {
        return this.valorTerraNua;
    }

    public void setValorTerraNua(Valor valorTerraNua) {
        this.valorTerraNua = valorTerraNua;
    }

    public Valor getValorTerraNuaTributavel() {
        return this.valorTerraNuaTributavel;
    }

    public void setValorTerraNuaTributavel(Valor valorTerraNuaTributavel) {
        this.valorTerraNuaTributavel = valorTerraNuaTributavel;
    }

    public Valor getAliquota() {
        return this.aliquota;
    }

    public void setAliquota(Valor aliquota) {
        this.aliquota = aliquota;
    }

    public Valor getImpostoCalculado() {
        return this.impostoCalculado;
    }

    public void setImpostoCalculado(Valor impostoCalculado) {
        this.impostoCalculado = impostoCalculado;
    }

    public Valor getImpostoDevido() {
        return this.impostoDevido;
    }

    public void setImpostoDevido(Valor impostoDevido) {
        this.impostoDevido = impostoDevido;
    }

    public Valor getQtdCotas() {
        return this.qtdCotas;
    }

    public void setQtdCotas(Valor qtdCotas) {
        this.qtdCotas = qtdCotas;
    }

    public Valor getValorQuota() {
        return this.valorQuota;
    }

    public void setValorQuota(Valor valorQuota) {
        this.valorQuota = valorQuota;
    }

    public Valor getImpostoCalculadoBase() {
        return this.impostoCalculadoBase;
    }

    public void setImpostoCalculadoBase(Valor impostoCalculadoBase) {
        this.impostoCalculadoBase = impostoCalculadoBase;
    }

    public Valor getParamVEL20() {
        return this.paramVEL20;
    }

    public void setParamVEL20(Valor paramVEL20) {
        this.paramVEL20 = paramVEL20;
    }

    public void zeraValores() {
        this.valorTotalImovel.clear();
        this.valorBenfeitorias.clear();
        this.valorCulturas.clear();
        this.valorTerraNua.clear();
        this.valorTerraNuaTributavel.clear();
        this.aliquota.clear();
        this.impostoCalculado.clear();
        this.impostoDevido.clear();
        this.qtdCotas.clear();
        this.valorQuota.clear();
        this.impostoCalculadoBase.clear();
        this.paramVEL20.clear();
    }

    protected List recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.getValorTotalImovel());
        retorno.add(this.getValorBenfeitorias());
        retorno.add(this.getValorCulturas());
        retorno.add(this.getValorTerraNua());
        retorno.add(this.getQtdCotas());
        retorno.add(this.getParamVEL20());
        return retorno;
    }

    public String getClasseFicha() {
        return PainelCalculoImposto.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return null;
    }

    private class ValidadorNaoNuloFichaCalculoImposto
    extends ValidadorNaoNulo {
        public ValidadorNaoNuloFichaCalculoImposto(byte severidade) {
            super(severidade);
        }

        public ValidadorNaoNuloFichaCalculoImposto(byte severidade, String msg) {
            super(severidade, msg);
        }

        public RetornoValidacao validarImplementado() {
            Imovel imovel = (Imovel)((Object)CalculoImposto.this.refImovel.get());
            if (imovel != null && imovel.getIsento().formatado().equals(Logico.SIM)) {
                return null;
            }
            return super.validarImplementado();
        }
    }
}

