/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.calculoimposto;

import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.Valor;

public class ValidadorQtdQuotas
extends ValidadorImpeditivoDefault {
    public ValidadorQtdQuotas(byte severidade) {
        super("");
        this.setTipoExibicao(0);
        this.setSeveridade(severidade);
        this.setVerificaVazio(true);
    }

    public RetornoValidacao validarImplementado() {
        Valor qtdQuota = new Valor();
        Valor impostoDevido = ITRFacade.getDeclaracaoEmMemoria().getCalculoImposto().getImpostoDevido();
        qtdQuota.clear();
        qtdQuota.append('+', (String)this.getProximoConteudo());
        if (qtdQuota.isVazio()) {
            this.setSeveridade((byte)5);
            RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("500035"));
            this.setMensagemValidacao(retorno.getMensagemValidacao());
            return retorno;
        }
        if (qtdQuota.comparacao(">", "4,00")) {
            this.setSeveridade((byte)5);
            RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("500040"));
            this.setMensagemValidacao(retorno.getMensagemValidacao());
            return retorno;
        }
        if (qtdQuota.comparacao("<=", "4") && qtdQuota.comparacao(">", "1")) {
            Valor valorQuota = new Valor();
            valorQuota.setConteudo(impostoDevido);
            valorQuota.append('/', qtdQuota);
            if (impostoDevido.comparacao("<", "100,00")) {
                this.setSeveridade((byte)5);
                RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("500030"));
                this.setMensagemValidacao(retorno.getMensagemValidacao());
                return retorno;
            }
            if (valorQuota.comparacao("<", "50,00")) {
                this.setSeveridade((byte)5);
                RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("500040"));
                this.setMensagemValidacao(retorno.getMensagemValidacao());
                return retorno;
            }
            this.setSeveridade((byte)4);
            RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("500050"));
            this.setMensagemValidacao(retorno.getMensagemValidacao());
            return retorno;
        }
        return null;
    }

    public void acaoOk() {
    }

    public void acaoCancelar() {
    }

    public String getTituloPopup() {
        return this.getInformacao().getNomeCampo();
    }
}

