/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.calculoimposto;

import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.Valor;

public class ValidadorSomaValorTerraNua
extends ValidadorImpeditivoDefault {
    private Valor valorTotal;
    private Valor valorBenfeitorias;
    private Valor valorCulturas;

    public ValidadorSomaValorTerraNua(byte severidade, Valor pValorTotal, Valor pValorBenfeitorias, Valor pValorCulturas) {
        super("");
        this.setTipoExibicao(0);
        this.setSeveridade(severidade);
        this.valorTotal = pValorTotal;
        this.valorBenfeitorias = pValorBenfeitorias;
        this.valorCulturas = pValorCulturas;
        this.setVerificaVazio(true);
    }

    public RetornoValidacao validarImplementado() {
        Valor valorTemp = new Valor();
        String ultimoValor = this.getInformacao().getConteudoFormatado();
        String proxValor = (String)this.getProximoConteudo();
        this.getInformacao().setConteudo(proxValor);
        valorTemp.clear();
        valorTemp.setConteudo(this.valorTotal);
        valorTemp.append('-', this.valorBenfeitorias);
        valorTemp.append('-', this.valorCulturas);
        if (valorTemp.comparacao("<", "0,00")) {
            this.setSeveridade((byte)5);
            RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("500010"));
            this.setMensagemValidacao(retorno.getMensagemValidacao());
            this.getInformacao().setConteudo(ultimoValor);
            return retorno;
        }
        return null;
    }

    public void acaoOk() {
    }

    public void acaoCancelar() {
    }

    public String getTituloPopup() {
        return this.getInformacao().getNomeCampo();
    }
}

