/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.calculoimposto;

import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.Valor;

public class ValidadorValorTerraNuaDivergente
extends ValidadorImpeditivoDefault {
    private Valor vtnCalculado;
    private Valor vtnSistema;
    private String ultimoValor;

    public ValidadorValorTerraNuaDivergente(byte severidade, Valor pVtnCalculado) {
        super("");
        this.setTipoExibicao(0);
        this.setSeveridade(severidade);
        this.vtnCalculado = new Valor();
        this.vtnCalculado.setCasasDecimais(4);
        this.vtnCalculado = pVtnCalculado;
        this.setVerificaVazio(true);
    }

    public RetornoValidacao validarImplementado() {
        DeclaracaoITR dec = ControladorGui.getDeclaracaoAberta();
        ElementoTabela opcaoMunicipio = dec.getImovel().getMunicipio().getElementoTabela();
        if (opcaoMunicipio != null && !dec.getImovel().getMunicipio().isVazio()) {
            Valor somaProdutos = dec.calculaVTN();
            this.vtnCalculado.arredonda(2, 5);
            this.vtnSistema = new Valor();
            this.vtnSistema.setCasasDecimais(4);
            this.vtnSistema.setConteudo(somaProdutos);
            this.vtnSistema.append('*', "0.80");
            this.vtnSistema.arredonda(2, 5);
            this.ultimoValor = this.getInformacao().getConteudoAntigo();
            String proxValor = (String)this.getProximoConteudo();
            this.getInformacao().setConteudo(proxValor);
            Valor VEL = new Valor();
            VEL = dec.calculaVEL20();
            if (!ConstantesGlobaisITR.FASE.equalsIgnoreCase("Producao")) {
                System.out.println(" ");
                System.out.println("VTN (L4=L1-L2-L3): " + this.vtnCalculado.getConteudoFormatado());
                System.out.println("VTN SIPT (Soma dos Produtos): " + somaProdutos.getConteudoFormatado());
                System.out.println("VTN SIPT (Soma dos Produtos) * 0,80: " + this.vtnSistema.getConteudoFormatado());
                System.out.println(" ");
                System.out.println("VEL (Valor Esperado do Lan\u00e7amento): " + VEL.getConteudoFormatado());
                System.out.println(" ");
            }
            if (this.vtnCalculado.comparacao("<", this.vtnSistema) && VEL.comparacao(">", "5000,00")) {
                this.setSeveridade((byte)4);
                RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("110205"));
                this.setMensagemValidacao(retorno.getMensagemValidacao());
                return retorno;
            }
        }
        return null;
    }

    public void acaoOk() {
    }

    public void acaoCancelar() {
        this.getInformacao().setConteudo(this.ultimoValor);
    }

    public String getTituloPopup() {
        return this.getInformacao().getNomeCampo();
    }
}

