/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.contribuinte;

import java.util.List;
import java.util.Vector;
import serpro.ppgd.itr.DataITR;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.ObservadorEspacosDuplicados;
import serpro.ppgd.itr.ValidadorCaracteres;
import serpro.ppgd.itr.ValidadorNIItr;
import serpro.ppgd.itr.contribuinte.ValidadorIgualdade;
import serpro.ppgd.itr.gui.contribuinte.PainelContribuinte;
import serpro.ppgd.itr.tabelas.CadastroTabelasITR;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.itr.validadores.ValidadorNomeITR;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CEP;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCEP;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class Contribuinte
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String LABEL_PARTIC_CONDOMINIO = "Partic. Condom\u00ednio (%)";
    private IdentificadorDeclaracao identificadorDeclaracao;
    private NI ni;
    private Alfa nomeContribuinte;
    private Codigo tipoLogradouro = new Codigo((ObjetoNegocio)this, "Tipo Logradouro", CadastroTabelasITR.getTiposLogradouroContribuinte());
    private Data dataNascimento = new DataITR(this, "Data de Nascimento");
    private Alfa numero = new Alfa((ObjetoNegocio)this, "N\u00famero", 5);
    private Alfa complemento = new Alfa((ObjetoNegocio)this, "Complemento", 20);
    private Alfa bairro = new Alfa((ObjetoNegocio)this, "Bairro ou Distrito", 40);
    private CEP cep = new CEP((ObjetoNegocio)this, "CEP");
    private Alfa numeroTelefone = new Alfa((ObjetoNegocio)this, "Telefone", 9);
    private Alfa dddTelefone = new Alfa((ObjetoNegocio)this, "DDD", 2);
    private Codigo uf = new Codigo((ObjetoNegocio)this, "UF", CadastroTabelasITR.getUfs());
    private Codigo municipio = new Codigo((ObjetoNegocio)this, "Munic\u00edpio", new Vector());
    private Alfa nomeMunicipio = new Alfa((ObjetoNegocio)this, "Nome do Munic\u00edpio");
    private CPF cpfConjuge = new CPF((ObjetoNegocio)this, "CPF do C\u00f4njuge");
    private CPF cpfInventariante = new CPF((ObjetoNegocio)this, "CPF do Inventariante");
    private Alfa nomeInventariante = new Alfa((ObjetoNegocio)this, "Nome do Inventariante", 60);
    private CPF cpfRepresentante = new CPF((ObjetoNegocio)this, "CPF do Repres. Legal");
    private Alfa nomeRepresentante = new Alfa((ObjetoNegocio)this, "Nome do Representante Legal", 60);
    private Alfa logradouro = new Alfa((ObjetoNegocio)this, "Logradouro", 56);
    private Alfa dddFax = new Alfa((ObjetoNegocio)this, "", 4);
    private Alfa numeroFax = new Alfa((ObjetoNegocio)this, "DDD/Fax", 9);
    private Alfa email = new Alfa((ObjetoNegocio)this, "E-mail");
    private Valor particCondominio = new Valor((ObjetoNegocio)this, "Partic. Condom\u00ednio (%)", 2, 1);
    private static final String NOME_FICHA = "Identifica\u00e7\u00e3o do Contribuinte";

    public Contribuinte(IdentificadorDeclaracao id) {
        this.identificadorDeclaracao = id;
        this.ni = this.identificadorDeclaracao.getNiContribuinte();
        this.nomeContribuinte = this.identificadorDeclaracao.getNomeContribuinte();
        this.uf.setSimples(true);
        this.uf.setColunaFiltro(0);
        this.municipio.setSimples(true);
        this.municipio.setColunaFiltro(1);
        this.tipoLogradouro.setSimples(true);
        this.tipoLogradouro.setColunaFiltro(0);
        this.particCondominio.setPorcentagem(true);
        this.adicionarObservadores();
        this.adicionarValidadores();
        this.setFicha(NOME_FICHA);
    }

    private void adicionarValidadores() {
        this.ni.addValidador((ValidadorIf)new ValidadorNIItr(3, MensagemUtil.getMensagem("100005")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (ITRFacade.getDeclaracaoEmMemoria().getImovel().getPessoaFisica().formatado().equalsIgnoreCase(Logico.SIM) ? this.getInformacao().naoFormatado().length() != 11 : this.getInformacao().naoFormatado().length() != 14) {
                    return new RetornoValidacao(this.getSeveridade());
                }
                return super.validarImplementado();
            }
        });
        this.ni.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("100010")));
        this.cep.addValidador((ValidadorIf)new ValidadorCEP(3));
        this.cep.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("75")));
        this.nomeContribuinte.addValidador((ValidadorIf)new ValidadorCaracteres(3, MensagemUtil.getMensagem("110251"), "[a-zA-Z\u00e7\u00c7\\s\u00e2\u00c2\u00e1\u00c1\u00e9\u00c9\u00ed\u00cd\u00f3\u00d3\u00fa\u00da\u00ea\u00ca\u00f4\u00d4\u00fc\u00dc\u00e0\u00c0\u00e3\u00c3\u00f5\u00d5]*"){

            @Override
            public RetornoValidacao validarImplementado() {
                if (ITRFacade.getDeclaracaoEmMemoria().getImovel().getPessoaFisica().formatado().equalsIgnoreCase(Logico.SIM)) {
                    return super.validarImplementado(MensagemUtil.getMensagem("110251"));
                }
                return null;
            }
        });
        this.nomeContribuinte.addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = new RetornoValidacao(super.getSeveridade());
                if (Contribuinte.this.getNomeContribuinte().isVazio()) {
                    if (ITRFacade.getDeclaracaoEmMemoria().getImovel().getPessoaFisica().formatado().equalsIgnoreCase(Logico.SIM)) {
                        retorno.setMensagemValidacao(MensagemUtil.getMensagem("100045"));
                        return retorno;
                    }
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("100038"));
                    return retorno;
                }
                if (ITRFacade.getDeclaracaoEmMemoria().getImovel().getPessoaFisica().formatado().equalsIgnoreCase("1")) {
                    String nome = Contribuinte.this.getNomeContribuinte().formatado().trim().toLowerCase();
                    if (nome.startsWith("esp\u00f3lio") || nome.startsWith("espolio") || nome.endsWith("esp\u00f3lio") || nome.endsWith("espolio")) {
                        retorno.setMensagemValidacao(MensagemUtil.getMensagem("100046"));
                        return retorno;
                    }
                    if (nome.matches("(.)*(e)(\\ )*(outr)(o|a)(s)*$")) {
                        retorno.setMensagemValidacao(MensagemUtil.getMensagem("100047"));
                        return retorno;
                    }
                    if (nome.matches("(.)*(\\ )*(esposo)$")) {
                        retorno.setMensagemValidacao(MensagemUtil.getMensagem("100049"));
                        return retorno;
                    }
                    if (nome.matches("(.)*(\\ )*(esposa)$")) {
                        retorno.setMensagemValidacao(MensagemUtil.getMensagem("100048"));
                        return retorno;
                    }
                }
                return null;
            }
        });
        this.nomeContribuinte.addValidador((ValidadorIf)new ValidadorNomeITR(3, "Nome da Pessoa F\u00edsica"){

            @Override
            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = null;
                if (ITRFacade.getDeclaracaoEmMemoria().getImovel().getPessoaFisica().formatado().equalsIgnoreCase(Logico.SIM)) {
                    retorno = super.validarImplementado();
                }
                return retorno;
            }
        });
        this.complemento.addValidador((ValidadorIf)new ValidadorCaracteres(3, MensagemUtil.getMensagem("110250"), "[a-zA-Z0-9\u00e7\u00c7\\s'/;(),.\\-\u00e2\u00c2\u00e1\u00c1\u00e9\u00c9\u00ed\u00cd\u00f3\u00d3\u00fa\u00da\u00ea\u00ca\u00f4\u00d4\u00fc\u00dc\u00e0\u00c0\u00e3\u00c3\u00f5\u00d5]*"));
        this.bairro.addValidador((ValidadorIf)new ValidadorCaracteres(3, MensagemUtil.getMensagem("110250"), "[a-zA-Z0-9\u00e7\u00c7\\s'/;(),.\\-\u00e2\u00c2\u00e1\u00c1\u00e9\u00c9\u00ed\u00cd\u00f3\u00d3\u00fa\u00da\u00ea\u00ca\u00f4\u00d4\u00fc\u00dc\u00e0\u00c0\u00e3\u00c3\u00f5\u00d5]*"));
        this.nomeInventariante.addValidador((ValidadorIf)new ValidadorCaracteres(3, MensagemUtil.getMensagem("110250"), "[a-zA-Z\u00e7\u00c7\\s\u00e2\u00c2\u00e1\u00c1\u00e9\u00c9\u00ed\u00cd\u00f3\u00d3\u00fa\u00da\u00ea\u00ca\u00f4\u00d4\u00fc\u00dc\u00e0\u00c0\u00e3\u00c3\u00f5\u00d5]*"));
        this.nomeInventariante.addValidador((ValidadorIf)new ValidadorNomeITR(3));
        this.nomeRepresentante.addValidador((ValidadorIf)new ValidadorCaracteres(3, MensagemUtil.getMensagem("110250"), "[a-zA-Z\u00e7\u00c7\\s\u00e2\u00c2\u00e1\u00c1\u00e9\u00c9\u00ed\u00cd\u00f3\u00d3\u00fa\u00da\u00ea\u00ca\u00f4\u00d4\u00fc\u00dc\u00e0\u00c0\u00e3\u00c3\u00f5\u00d5]*"));
        this.nomeRepresentante.addValidador((ValidadorIf)new ValidadorNomeITR(3));
        this.logradouro.addValidador((ValidadorIf)new ValidadorCaracteres(3, MensagemUtil.getMensagem("110250"), "[a-zA-Z0-9\u00e7\u00c7\\s'/;(),.\\-\u00e2\u00c2\u00e1\u00c1\u00e9\u00c9\u00ed\u00cd\u00f3\u00d3\u00fa\u00da\u00ea\u00ca\u00f4\u00d4\u00fc\u00dc\u00e0\u00c0\u00e3\u00c3\u00f5\u00d5]*"));
        this.getLogradouro().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("100105")));
        this.getTipoLogradouro().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("100106")));
        this.getMunicipio().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("100100")));
        this.getCpfConjuge().addValidador((ValidadorIf)new ValidadorCPF(3));
        ValidadorCPF validadorCpfInventariante = new ValidadorCPF(3);
        validadorCpfInventariante.setMensagemValidacao(MensagemUtil.getMensagem("100060"));
        this.getCpfInventariante().addValidador((ValidadorIf)validadorCpfInventariante);
        ValidadorCPF validadorCpfRepresentante = new ValidadorCPF(3);
        validadorCpfRepresentante.setMensagemValidacao(MensagemUtil.getMensagem("100070"));
        this.getCpfRepresentante().addValidador((ValidadorIf)validadorCpfRepresentante);
        ValidadorNaoNulo validadorAlteracaoDados = new ValidadorNaoNulo(3);
        validadorAlteracaoDados.setMensagemValidacao(MensagemUtil.getMensagem("190"));
        this.particCondominio.addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (ITRFacade.getDeclaracaoEmMemoria().getImovel().getPertenceCondominio().formatado().equalsIgnoreCase(Logico.SIM)) {
                    if (Contribuinte.this.getParticCondominio().getConteudoAbsoluto().intValue() == 0) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("100040"), 3);
                    }
                    if (Contribuinte.this.getParticCondominio().getConteudoAbsoluto().intValue() >= 1000) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("800120"), 3);
                    }
                }
                return new RetornoValidacao(0);
            }
        });
        this.getCpfRepresentante().addValidador((ValidadorIf)new ValidadorIgualdade(3, (Informacao)this.getNi(), "100020"));
        this.getCpfConjuge().addValidador((ValidadorIf)new ValidadorIgualdade(3, (Informacao)this.getNi(), "100025"));
        this.getCpfInventariante().addValidador((ValidadorIf)new ValidadorIgualdade(2, (Informacao)this.getCpfConjuge(), "110220"));
        this.getCpfRepresentante().addValidador((ValidadorIf)new ValidadorIgualdade(3, (Informacao)this.getCpfInventariante(), "100090"));
        this.getCpfRepresentante().addValidador((ValidadorIf)new ValidadorIgualdade(2, (Informacao)this.getCpfConjuge(), "110240"));
        ValidadorNaoNulo validadorCpfNomeInventariante = new ValidadorNaoNulo(2){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = new RetornoValidacao(this.getSeveridade());
                if (!Contribuinte.this.getCpfInventariante().isReadOnly() && Contribuinte.this.getCpfInventariante().isVazio() && !Contribuinte.this.getNomeInventariante().isVazio()) {
                    super.setSeveridade((byte)3);
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("100085"));
                    return retorno;
                }
                return null;
            }
        };
        this.getCpfInventariante().addValidador((ValidadorIf)validadorCpfNomeInventariante);
        ValidadorNaoNulo validadorNomeCpfInventariante = new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = new RetornoValidacao(this.getSeveridade());
                if (!Contribuinte.this.getCpfInventariante().isVazio() && Contribuinte.this.getNomeInventariante().isVazio()) {
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("100065"));
                    return retorno;
                }
                return null;
            }
        };
        this.getNomeInventariante().addValidador((ValidadorIf)validadorNomeCpfInventariante);
        this.getDddTelefone().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = new RetornoValidacao(this.getSeveridade());
                if (Contribuinte.this.getDddTelefone().isVazio()) {
                    if (!Contribuinte.this.getNumeroTelefone().isVazio()) {
                        retorno.setMensagemValidacao(MensagemUtil.getMensagem("100050"));
                        return retorno;
                    }
                } else if (Contribuinte.this.getDddTelefone().asString().trim().length() == 1) {
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("100053"));
                    return retorno;
                }
                return null;
            }
        });
        this.getNumeroTelefone().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getNumeroTelefone().isVazio() && !Contribuinte.this.getDddTelefone().isVazio()) {
                    RetornoValidacao retorno = new RetornoValidacao(this.getSeveridade());
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("100055"));
                    return retorno;
                }
                return null;
            }
        });
        this.getNumeroTelefone().addValidador((ValidadorIf)new ValidadorNaoNulo(2){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = new RetornoValidacao(this.getSeveridade());
                if (!Contribuinte.this.getNumeroTelefone().isVazio() && Contribuinte.this.getNumeroTelefone().naoFormatado().trim().length() < 8) {
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("100052"));
                    return retorno;
                }
                return null;
            }
        });
        ValidadorNaoNulo validadorCepMunicipioAusente = new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = new RetornoValidacao(this.getSeveridade());
                if (Contribuinte.this.getMunicipio().isVazio() && Contribuinte.this.getCep().isVazio()) {
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("75"));
                    return retorno;
                }
                return null;
            }
        };
        this.getCep().addValidador((ValidadorIf)validadorCepMunicipioAusente);
        ValidadorNaoNulo validadorCepMunicipio = new ValidadorNaoNulo(2){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = new RetornoValidacao(this.getSeveridade());
                if (!(Contribuinte.this.getMunicipio().isVazio() || Contribuinte.this.getCep().isVazio() || Contribuinte.this.municipio.isVazio())) {
                    int cepIni2 = 0;
                    int cepFim2 = 0;
                    int cepIni3 = 0;
                    int cepFim3 = 0;
                    int cepIni1 = Integer.parseInt(Contribuinte.this.municipio.getConteudoAtual(4).substring(0, 8));
                    int cepFim1 = Integer.parseInt(Contribuinte.this.municipio.getConteudoAtual(4).substring(8, 16));
                    if (Contribuinte.this.municipio.getConteudoAtual(4).length() >= 32) {
                        cepIni2 = Integer.parseInt(Contribuinte.this.municipio.getConteudoAtual(4).substring(16, 24));
                        cepFim2 = Integer.parseInt(Contribuinte.this.municipio.getConteudoAtual(4).substring(24, 32));
                        if (Contribuinte.this.municipio.getConteudoAtual(4).length() >= 48) {
                            cepIni3 = Integer.parseInt(Contribuinte.this.municipio.getConteudoAtual(4).substring(32, 40));
                            cepFim3 = Integer.parseInt(Contribuinte.this.municipio.getConteudoAtual(4).substring(40, 48));
                        }
                    }
                    int cepDigitado = 0;
                    try {
                        cepDigitado = Integer.parseInt(Contribuinte.this.getCep().naoFormatado().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (cepDigitado == 0) {
                        retorno.setMensagemValidacao(MensagemUtil.getMensagem("76"));
                        return retorno;
                    }
                    if (!(cepDigitado >= cepIni1 && cepDigitado <= cepFim1 || cepDigitado >= cepIni2 && cepDigitado <= cepFim2 || cepDigitado >= cepIni3 && cepDigitado <= cepFim3)) {
                        retorno.setMensagemValidacao(MensagemUtil.getMensagem("76"));
                        return retorno;
                    }
                }
                return null;
            }
        };
        this.getCep().addValidador((ValidadorIf)validadorCepMunicipio);
        ValidadorNaoNulo validadorUFVazia = new ValidadorNaoNulo(3);
        validadorUFVazia.setMensagemValidacao(MensagemUtil.getMensagem("80"));
        this.getUf().addValidador((ValidadorIf)validadorUFVazia);
        ValidadorNaoNulo validadorMunicipioUfAusente = new ValidadorNaoNulo(2){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = new RetornoValidacao(this.getSeveridade());
                if (!Contribuinte.this.getMunicipio().isVazio() && Contribuinte.this.getUf().isVazio()) {
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("100"));
                    return retorno;
                }
                return null;
            }
        };
        this.getMunicipio().addValidador((ValidadorIf)validadorMunicipioUfAusente);
        this.getNumero().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("110442")));
    }

    private void adicionarObservadores() {
        this.municipio.addObservador(new Observador(){

            public void notifica(Object object, String string, Object object0, Object object1) {
                if (!Contribuinte.this.municipio.isVazio()) {
                    Contribuinte.this.nomeMunicipio.setConteudo(UtilitariosString.removeAcentos((String)Contribuinte.this.municipio.getConteudoAtual(1)));
                } else {
                    Contribuinte.this.nomeMunicipio.clear();
                }
            }
        });
        this.uf.addObservador(new Observador(){

            public void notifica(Object object, String string, Object object0, Object object1) {
                String conteudoUf = Contribuinte.this.uf.getConteudoAtual(0);
                if (conteudoUf != null && conteudoUf.trim().length() > 0) {
                    Contribuinte.this.municipio.setColecaoElementoTabela(CadastroTabelasITR.getListaMunicipios(conteudoUf.trim()));
                }
            }
        });
        this.logradouro.addObservador((Observador)new ObservadorEspacosDuplicados());
        this.complemento.addObservador((Observador)new ObservadorEspacosDuplicados());
        this.bairro.addObservador((Observador)new ObservadorEspacosDuplicados());
        this.nomeInventariante.addObservador((Observador)new ObservadorEspacosDuplicados());
        this.nomeRepresentante.addObservador((Observador)new ObservadorEspacosDuplicados());
    }

    protected List recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.getNi());
        retorno.add(this.getNomeContribuinte());
        retorno.add(this.getDataNascimento());
        retorno.add(this.getCpfConjuge());
        retorno.add(this.getParticCondominio());
        retorno.add(this.getTipoLogradouro());
        retorno.add(this.getLogradouro());
        retorno.add(this.getComplemento());
        retorno.add(this.getBairro());
        retorno.add(this.getNumero());
        retorno.add(this.getDddTelefone());
        retorno.add(this.getNumeroTelefone());
        retorno.add(this.getUf());
        retorno.add(this.getMunicipio());
        retorno.add(this.getCep());
        retorno.add(this.getDddFax());
        retorno.add(this.getNumeroFax());
        retorno.add(this.getCpfInventariante());
        retorno.add(this.getNomeInventariante());
        retorno.add(this.getCpfRepresentante());
        retorno.add(this.getNomeRepresentante());
        return retorno;
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao() {
        return this.identificadorDeclaracao;
    }

    public void setIdentificadorDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
    }

    public NI getNi() {
        return this.ni;
    }

    public void setNi(NI ni) {
        this.ni = ni;
    }

    public Alfa getNomeContribuinte() {
        return this.nomeContribuinte;
    }

    public void setNomeContribuinte(Alfa nomeContribuinte) {
        this.nomeContribuinte = nomeContribuinte;
    }

    public Codigo getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    public void setTipoLogradouro(Codigo tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    public Data getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Data dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    public Alfa getNumero() {
        return this.numero;
    }

    public void setNumero(Alfa numero) {
        this.numero = numero;
    }

    public Alfa getComplemento() {
        return this.complemento;
    }

    public void setComplemento(Alfa complemento) {
        this.complemento = complemento;
    }

    public Alfa getBairro() {
        return this.bairro;
    }

    public void setBairro(Alfa bairro) {
        this.bairro = bairro;
    }

    public CEP getCep() {
        return this.cep;
    }

    public void setCep(CEP cep) {
        this.cep = cep;
    }

    public Alfa getNumeroTelefone() {
        return this.numeroTelefone;
    }

    public void setNumeroTelefone(Alfa numeroTelefone) {
        this.numeroTelefone = numeroTelefone;
    }

    public Alfa getDddTelefone() {
        return this.dddTelefone;
    }

    public void setDddTelefone(Alfa dddTelefone) {
        this.dddTelefone = dddTelefone;
    }

    public Codigo getUf() {
        return this.uf;
    }

    public void setUf(Codigo uf) {
        this.uf = uf;
    }

    public Codigo getMunicipio() {
        return this.municipio;
    }

    public void setMunicipio(Codigo municipio) {
        this.municipio = municipio;
    }

    public Alfa getNomeMunicipio() {
        return this.nomeMunicipio;
    }

    public void setNomeMunicipio(Alfa nomeMunicipio) {
        this.nomeMunicipio = nomeMunicipio;
    }

    public CPF getCpfConjuge() {
        return this.cpfConjuge;
    }

    public void setCpfConjuge(CPF cpfConjuge) {
        this.cpfConjuge = cpfConjuge;
    }

    public CPF getCpfInventariante() {
        return this.cpfInventariante;
    }

    public void setCpfInventariante(CPF cpfInventariante) {
        this.cpfInventariante = cpfInventariante;
    }

    public Alfa getNomeInventariante() {
        return this.nomeInventariante;
    }

    public void setNomeInventariante(Alfa nomeInventariante) {
        this.nomeInventariante = nomeInventariante;
    }

    public CPF getCpfRepresentante() {
        return this.cpfRepresentante;
    }

    public void setCpfRepresentante(CPF cpfRepresentante) {
        this.cpfRepresentante = cpfRepresentante;
    }

    public Alfa getNomeRepresentante() {
        return this.nomeRepresentante;
    }

    public void setNomeRepresentante(Alfa nomeRepresentante) {
        this.nomeRepresentante = nomeRepresentante;
    }

    public Alfa getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(Alfa logradouro) {
        this.logradouro = logradouro;
    }

    public Alfa getDddFax() {
        return this.dddFax;
    }

    public void setDddFax(Alfa dddFax) {
        this.dddFax = dddFax;
    }

    public Alfa getNumeroFax() {
        return this.numeroFax;
    }

    public void setNumeroFax(Alfa numeroFax) {
        this.numeroFax = numeroFax;
    }

    public Alfa getEmail() {
        return this.email;
    }

    public void setEmail(Alfa email) {
        this.email = email;
    }

    public Valor getParticCondominio() {
        return this.particCondominio;
    }

    public void setParticCondominio(Valor particCondominio) {
        this.particCondominio = particCondominio;
    }

    public String getClasseFicha() {
        return PainelContribuinte.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return null;
    }
}

