/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.conversormedidas;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import serpro.ppgd.itr.AreaHectares;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Valor;

public class Medida {
    private Vector medidasCorrespondentes = new Vector();
    private Valor valor;
    private AreaHectares valorConvertido;
    private Codigo listaConversoes;

    public Medida() {
        this.setValor(new Valor(null, "\u00c1rea a ser convertida:"));
        this.getValor().converteQtdCasasDecimais(3);
        this.setValorConvertido(new AreaHectares(null, "\u00c1rea Ap\u00f3s convers\u00e3o (ha):"));
        this.setListaConversoes(new Codigo(null, "Nome da unidade de medida:", (List)this.medidasCorrespondentes));
        this.cadastraConversao("Alqueire Paulista", new Valor("2,42"), "01");
        this.cadastraConversao("Alqueire", new Valor("2,72"), "02");
        this.cadastraConversao("Alqueire Mineiro/Alqueire Geom\u00e9trico", new Valor("4,84"), "03");
        this.cadastraConversao("Alqueir\u00e3o", new Valor("9,68"), "04");
        this.cadastraConversao("Bra\u00e7a Quadrada", new Valor("0,000484"), "05");
        this.cadastraConversao("Data", new Valor("0,10"), "06");
        this.cadastraConversao("L\u00e9gua Quadrada", new Valor("3600,00"), "07");
        this.cadastraConversao("Litro", new Valor("0,06"), "08");
        this.cadastraConversao("Metro Quadrado", new Valor("0,0001"), "09");
        this.cadastraConversao("Mil Covas", new Valor("0,30"), "10");
        this.cadastraConversao("Quarta", new Valor("1,21"), "11");
        this.cadastraConversao("Tarefa", new Valor("0,30"), "12");
        this.cadastraConversao("Tarefa Baiana", new Valor("0,44"), "13");
        this.getValor().getObservadores().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Medida.this.convertePara(Medida.this.listaConversoes.getConteudoAtual(1));
            }
        });
        this.listaConversoes.getObservadores().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Medida.this.convertePara(Medida.this.listaConversoes.getConteudoAtual(1));
            }
        });
    }

    public void cadastraConversao(String aMedida, Valor aCoeficiente, String codigo) {
        ElementoTabela elem = new ElementoTabela();
        elem.setConteudo(0, codigo);
        elem.setConteudo(1, aMedida);
        elem.setConteudo(2, aCoeficiente.getConteudoFormatado());
        this.medidasCorrespondentes.add(elem);
    }

    public void convertePara(String aMedida) {
        ElementoTabela elem = null;
        for (int i = 0; i < this.medidasCorrespondentes.size(); ++i) {
            ElementoTabela aux = (ElementoTabela)this.medidasCorrespondentes.get(i);
            if (!aux.getConteudo(1).equals(aMedida)) continue;
            elem = aux;
            break;
        }
        if (elem != null) {
            Locale brasil = new Locale("pt", "BR");
            DecimalFormat format = new DecimalFormat("#,###.######", new DecimalFormatSymbols(brasil));
            format.setParseBigDecimal(true);
            BigDecimal valor = null;
            BigDecimal medida = null;
            try {
                valor = (BigDecimal)format.parse(this.getValor().asString());
                medida = (BigDecimal)format.parse(elem.getConteudo(2));
            }
            catch (ParseException e) {
                e.printStackTrace();
                return;
            }
            BigDecimal resultado = valor.multiply(medida);
            Valor valorResultado = new Valor();
            valorResultado.setTratamentocasasDecimais(Valor.ARREDONDA);
            valorResultado.setCasasDecimais(1);
            valorResultado.setConteudo(format.format(resultado.setScale(1, RoundingMode.HALF_UP)));
            this.getValorConvertido().setTratamentocasasDecimais(Valor.ARREDONDA);
            this.getValorConvertido().setConteudo(valorResultado);
        }
    }

    public void setValor(Valor valor) {
        this.valor = valor;
    }

    public Valor getValor() {
        return this.valor;
    }

    public void setValorConvertido(AreaHectares valorConvertido) {
        this.valorConvertido = valorConvertido;
        this.valorConvertido.setReadOnly(true);
    }

    public Valor getValorConvertido() {
        return this.valorConvertido;
    }

    public void setListaConversoes(Codigo listaConversoes) {
        this.listaConversoes = listaConversoes;
    }

    public Codigo getListaConversoes() {
        return this.listaConversoes;
    }
}

