/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.declaracao;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.itr.AreaHectares;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.aquisicaoalienacao.AquisicaoAlienacao;
import serpro.ppgd.itr.aquisicaoalienacao.InformacaoDesapropriacao;
import serpro.ppgd.itr.areanaoutilizada.AreaNaoUtilizada;
import serpro.ppgd.itr.atividadeextrativa.AtividadeExtrativa;
import serpro.ppgd.itr.atividadepecuaria.AtividadePecuaria;
import serpro.ppgd.itr.calculoimposto.CalculoImposto;
import serpro.ppgd.itr.calculoimposto.VTN;
import serpro.ppgd.itr.calculoimposto.ValidadorAliquotaInvalida;
import serpro.ppgd.itr.contribuinte.Contribuinte;
import serpro.ppgd.itr.declaracao.CalculaAreaExploracaoExtrativa;
import serpro.ppgd.itr.declaracao.ObservadorIndiceLotacaoPecuaria;
import serpro.ppgd.itr.declaracao.ValidadorAreaNaoUtilizada;
import serpro.ppgd.itr.declaracao.ValidadorValorBenfeitorias;
import serpro.ppgd.itr.declaracao.ValidadorValorCulturas;
import serpro.ppgd.itr.demaiscondominos.Condomino;
import serpro.ppgd.itr.demaiscondominos.DemaisCondominos;
import serpro.ppgd.itr.demaiscondominos.ValidadorMudancaPertenceCondominio;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.PainelAuxiliarObrigatoriedade;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.imovel.Imovel;
import serpro.ppgd.itr.imovel.ValidadorMudancaEnquadramentoAreaTotal;
import serpro.ppgd.itr.imovel.ValidadorMudancaEnquadramentoMunicipio;
import serpro.ppgd.itr.imovel.ValidadorMudancaEnquadramentoUFMunicipio;
import serpro.ppgd.itr.imovel.ValidadorMudancaIsento;
import serpro.ppgd.itr.imovel.ValidadorMudancaPfPj;
import serpro.ppgd.itr.tabelas.CadastroTabelasITR;
import serpro.ppgd.itr.util.BarramentoUtil;
import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.itr.utilizacaoimovel.DistribuicaoAreaUtilizada;
import serpro.ppgd.itr.utilizacaoimovel.UtilizacaoImovel;
import serpro.ppgd.itr.utilizacaoimovel.ValidadorAnulaAreaCalamidade;
import serpro.ppgd.itr.utilizacaoimovel.ValidadorAreaAproveitavelInconsistente;
import serpro.ppgd.itr.utilizacaoimovel.ValidadorCAR;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.DataHora;
import serpro.ppgd.negocio.DeclaracaoComIdentificador;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.IdentificadorDeclaracaoXML;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNrRecibo;

public class DeclaracaoITR
extends ObjetoNegocio
implements DeclaracaoComIdentificador {
    protected transient IdentificadorDeclaracao identificadorDeclaracao;
    protected Imovel imovel;
    protected Contribuinte contribuinte;
    protected DemaisCondominos demaisCondominos = new DemaisCondominos(this);
    protected AquisicaoAlienacao aquisicaoAlienacao;
    protected UtilizacaoImovel utilizacaoImovel = new UtilizacaoImovel();
    protected AreaNaoUtilizada areaNaoUtilizada = new AreaNaoUtilizada();
    protected CalculoImposto calculoImposto;
    protected AtividadePecuaria atividadePecuaria = new AtividadePecuaria();
    protected AtividadeExtrativa atividadeExtrativa = new AtividadeExtrativa();
    protected Alfa codigoBarrasDarf = new Alfa((ObjetoNegocio)this, "C\u00f3digo de Barras");
    protected Alfa exercicioDeclaracao = new Alfa("Exercicio");
    public static final String LABEL_NOME_PESSOA_FISICA = "Nome da Pessoa F\u00edsica";
    public static final String LABEL_NOME_PESSOA_JURIDICA = "Nome Empresarial";
    public static final String LABEL_CPF = "CPF";
    public static final String LABEL_CNPJ = "CNPJ";
    private DataHora dataHoraSalvamento = new DataHora((ObjetoNegocio)this, "dataHoraSalvamento");
    private IdentificadorDeclaracao copiaIdentificador = new IdentificadorDeclaracao();

    public DeclaracaoITR(IdentificadorDeclaracao id) {
        ITRFacade.setDeclaracaoEmMemoria(this);
        this.identificadorDeclaracao = id;
        this.imovel = new Imovel(this.identificadorDeclaracao);
        this.contribuinte = new Contribuinte(this.identificadorDeclaracao);
        this.calculoImposto = new CalculoImposto(this.imovel);
        this.aquisicaoAlienacao = new AquisicaoAlienacao(this.identificadorDeclaracao, this.imovel);
        this.adicionaValidadores();
        this.adicionaObservadoresNegocio();
    }

    public IdentificadorDeclaracao getCopiaIdentificador() {
        return this.copiaIdentificador;
    }

    public Valor calculaVEL17() {
        String origAreaOcupada = this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaOcupada().asString();
        String origImpostoDevido = this.getCalculoImposto().getImpostoDevido().asString();
        String origQtdQuotas = this.getCalculoImposto().getQtdCotas().asString();
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaOcupada().clear();
        Valor novoImposto = new Valor(this.getCalculoImposto().getImpostoDevido().asString());
        Valor VEL = novoImposto.operacao('-', origImpostoDevido);
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaOcupada().setConteudo(origAreaOcupada);
        this.getCalculoImposto().getQtdCotas().setConteudo(origQtdQuotas);
        return VEL;
    }

    public Boolean obrigadoDeclarar() {
        boolean dispensado = this.getIdentificadorDeclaracao().getRetificadora().asString().equals(Logico.NAO);
        dispensado = dispensado && this.getImovel().getIsento().asString().equals(Logico.SIM);
        dispensado = dispensado && " ABCDE".indexOf(this.getImovel().getMotivoIsencao().asString()) > 0;
        dispensado = dispensado && this.getImovel().getPertenceCondominio().validar().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade() <= 2;
        boolean bl = dispensado = dispensado && this.getImovel().getAreaTotal().validar().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade() <= 2;
        if (dispensado && this.getImovel().getPertenceCondominio().asString().equals(Logico.SIM)) {
            boolean totalCondominosValido = this.getDemaisCondominos().getTotalCondominos().validar().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade() <= 2;
            long totalCondominos = this.getDemaisCondominos().getTotalCondominos().getConteudo();
            dispensado = dispensado && totalCondominosValido && totalCondominos <= 11L;
            Iterator itCondomino = this.getDemaisCondominos().recuperarLista().iterator();
            while (itCondomino.hasNext() && dispensado) {
                Condomino condomino = (Condomino)((Object)itCondomino.next());
                boolean condominoValido = condomino.getNi().validar().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade() <= 2;
                dispensado = dispensado && condominoValido;
            }
        }
        return !dispensado;
    }

    public Valor calculaVEL18() {
        String origAreaPreservacaoPermanente = this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaPreservacaoPermanente().asString();
        String origAreaReservaLegal = this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaLegal().asString();
        String origAreaReservaParticular = this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaParticular().asString();
        String origAreaInteresseEcologico = this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaInteresseEcologico().asString();
        String origAreaServidaoFlorestal = this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaServidaoFlorestal().asString();
        String origAreaFlorestasNativas = this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaFlorestasNativas().asString();
        String origAreaAlagada = this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAlagada().asString();
        String origImpostoDevido = this.getCalculoImposto().getImpostoDevido().asString();
        String origQtdQuotas = this.getCalculoImposto().getQtdCotas().asString();
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaPreservacaoPermanente().clear();
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaLegal().clear();
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaParticular().clear();
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaInteresseEcologico().clear();
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaServidaoFlorestal().clear();
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaFlorestasNativas().clear();
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAlagada().clear();
        Valor novoImposto = new Valor(this.getCalculoImposto().getImpostoDevido().asString());
        Valor VEL = novoImposto.operacao('-', origImpostoDevido);
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaPreservacaoPermanente().setConteudo(origAreaPreservacaoPermanente);
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaLegal().setConteudo(origAreaReservaLegal);
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaParticular().setConteudo(origAreaReservaParticular);
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaInteresseEcologico().setConteudo(origAreaInteresseEcologico);
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaServidaoFlorestal().setConteudo(origAreaServidaoFlorestal);
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaFlorestasNativas().setConteudo(origAreaFlorestasNativas);
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAlagada().setConteudo(origAreaAlagada);
        this.getCalculoImposto().getQtdCotas().setConteudo(origQtdQuotas);
        return VEL;
    }

    public Valor calculaVEL20() {
        Valor vtnSistema = new Valor();
        if (!this.getImovel().getMunicipio().isVazio()) {
            vtnSistema.setConteudo(this.calculaVTN());
        }
        String origImpostoDevido = this.getCalculoImposto().getImpostoDevido().asString();
        String origValorTotalImovel = this.getCalculoImposto().getValorTotalImovel().asString();
        String origValorBenfeitorias = this.getCalculoImposto().getValorBenfeitorias().asString();
        String origValorCulturas = this.getCalculoImposto().getValorCulturas().asString();
        String origQtdQuotas = this.getCalculoImposto().getQtdCotas().asString();
        this.getCalculoImposto().getValorBenfeitorias().clear();
        this.getCalculoImposto().getValorCulturas().clear();
        this.getCalculoImposto().getValorTotalImovel().setConteudo(vtnSistema);
        Valor novoImposto = new Valor(this.getCalculoImposto().getImpostoDevido().asString());
        if (!ConstantesGlobaisITR.FASE.equalsIgnoreCase("Producao")) {
            System.out.println("Imposto Devido SIPT: " + novoImposto.getConteudoFormatado());
            System.out.println("Imposto Devido L08: " + origImpostoDevido);
        }
        Valor VEL = novoImposto.operacao('-', origImpostoDevido);
        this.getCalculoImposto().getValorBenfeitorias().setConteudo(origValorBenfeitorias);
        this.getCalculoImposto().getValorCulturas().setConteudo(origValorCulturas);
        this.getCalculoImposto().getValorTotalImovel().setConteudo(origValorTotalImovel);
        this.getCalculoImposto().getQtdCotas().setConteudo(origQtdQuotas);
        return VEL;
    }

    public void adicionaValidadores() {
        this.getContribuinte().getNi().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = new RetornoValidacao(3);
                String nirf = DeclaracaoITR.this.getIdentificadorDeclaracao().getNirf().asString();
                String ni = DeclaracaoITR.this.getContribuinte().getNi().asString();
                if (DeclaracaoITR.this.getImovel().getPessoaFisica().getConteudoFormatado().equals("1") && nirf.length() == 8 && ni.startsWith(nirf)) {
                    super.setSeveridade((byte)2);
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("100000"));
                    return retorno;
                }
                return null;
            }
        });
        this.getContribuinte().getCpfConjuge().addValidador((ValidadorIf)new ValidadorNaoNulo(2, MensagemUtil.getMensagem("100035")){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoITR.this.getImovel().getPessoaFisica().getConteudoFormatado().equals("1")) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getContribuinte().getDataNascimento().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("100030")){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoITR.this.getImovel().getPessoaFisica().getConteudoFormatado().equals("1")) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getContribuinte().getDataNascimento().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoITR.this.getImovel().getPessoaFisica().getConteudoFormatado().equals("1")) {
                    RetornoValidacao retorno = new RetornoValidacao(super.getSeveridade());
                    switch (ITRUtil.verificaData(this.getInformacao().getConteudoFormatado())) {
                        case 2: {
                            if (this.getInformacao().getConteudoFormatado().substring(0, 2).equals("29") && this.getInformacao().getConteudoFormatado().substring(3, 5).equals("02")) {
                                super.setSeveridade((byte)2);
                                retorno.setMensagemValidacao(MensagemUtil.getMensagem("110441"));
                            } else {
                                super.setSeveridade((byte)3);
                                retorno.setMensagemValidacao("Data com dia inv\u00e1lido.");
                            }
                            return retorno;
                        }
                        case 3: {
                            super.setSeveridade((byte)3);
                            retorno.setMensagemValidacao("Data com m\u00eas inv\u00e1lido.");
                            return retorno;
                        }
                        case 1: {
                            super.setSeveridade((byte)3);
                            retorno.setMensagemValidacao(MensagemUtil.getMensagem("111117"));
                            return retorno;
                        }
                    }
                    Date data = DeclaracaoITR.this.getContribuinte().getDataNascimento().asDate();
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(data);
                    int intAno = calendar.get(1);
                    if (intAno < 1850) {
                        super.setSeveridade((byte)3);
                        retorno.setMensagemValidacao(MensagemUtil.getMensagem("100115"));
                        return retorno;
                    }
                    if (intAno < 1900 && intAno >= 1850) {
                        super.setSeveridade((byte)2);
                        retorno.setMensagemValidacao(MensagemUtil.getMensagem("110280"));
                        return retorno;
                    }
                    if (calendar.after(new GregorianCalendar())) {
                        super.setSeveridade((byte)2);
                        retorno.setMensagemValidacao(MensagemUtil.getMensagem("100120"));
                        return retorno;
                    }
                }
                return null;
            }
        });
        this.getContribuinte().getCpfInventariante().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoITR.this.getImovel().getPessoaFisica().getConteudoFormatado().equals("1") && DeclaracaoITR.this.getContribuinte().getCpfInventariante().asString().trim().equals(DeclaracaoITR.this.getContribuinte().getNi().asString().trim())) {
                    RetornoValidacao retorno = new RetornoValidacao(3);
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("100015"));
                    return retorno;
                }
                return null;
            }
        });
        this.getContribuinte().getCpfRepresentante().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = new RetornoValidacao(this.getSeveridade());
                if (!DeclaracaoITR.this.getContribuinte().getCpfRepresentante().isReadOnly() && DeclaracaoITR.this.getContribuinte().getCpfRepresentante().isVazio()) {
                    if (!DeclaracaoITR.this.getContribuinte().getNomeRepresentante().isVazio()) {
                        super.setSeveridade((byte)3);
                        retorno.setMensagemValidacao(MensagemUtil.getMensagem("100075"));
                        return retorno;
                    }
                    if (DeclaracaoITR.this.getImovel().getPessoaFisica().getConteudoFormatado().equals("2")) {
                        super.setSeveridade((byte)3);
                        retorno.setMensagemValidacao(MensagemUtil.getMensagem("100075"));
                        return retorno;
                    }
                }
                return null;
            }
        });
        ValidadorNaoNulo validadoNomeCpfRepresentante = new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoITR.this.getContribuinte().getNomeRepresentante().isVazio()) {
                    RetornoValidacao retorno = new RetornoValidacao(this.getSeveridade());
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("100080"));
                    if (!DeclaracaoITR.this.getContribuinte().getCpfRepresentante().isVazio()) {
                        return retorno;
                    }
                    if (DeclaracaoITR.this.getImovel().getPessoaFisica().getConteudoFormatado().equals("2")) {
                        return retorno;
                    }
                }
                return null;
            }
        };
        this.getContribuinte().getNomeRepresentante().addValidador((ValidadorIf)validadoNomeCpfRepresentante);
        ValidadorMudancaPertenceCondominio validadorMudancaPertenceCondominio = new ValidadorMudancaPertenceCondominio("", this);
        validadorMudancaPertenceCondominio.setValorOpcaoDoLogico(Logico.NAO);
        this.getImovel().getPertenceCondominio().addValidador((ValidadorIf)validadorMudancaPertenceCondominio);
        ValidadorMudancaIsento validadorMudancaIsento = new ValidadorMudancaIsento("", this);
        validadorMudancaIsento.setValorOpcaoDoLogico(Logico.SIM);
        this.getImovel().getIsento().addValidador((ValidadorIf)validadorMudancaIsento);
        ValidadorNrRecibo validadorNrRecibo = new ValidadorNrRecibo(3, this.getIdentificadorDeclaracao().getRetificadora(), MensagemUtil.getMensagem("187")){

            public RetornoValidacao validarImplementado() {
                if (this.getInformacao().getConteudoFormatado().equals("000000000000")) {
                    return new RetornoValidacao(this.getSeveridade());
                }
                return super.validarImplementado();
            }
        };
        this.getIdentificadorDeclaracao().getNumeroReciboDeclaracaoAnterior().addValidador((ValidadorIf)validadorNrRecibo);
        this.getIdentificadorDeclaracao().getNumeroReciboDeclaracaoAnterior().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("186")){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoITR.this.getIdentificadorDeclaracao().getRetificadora().getConteudoFormatado().equals(Logico.SIM)) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getDemaisCondominos().getTotalCondominos().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("200050")){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoITR.this.getImovel().getPertenceCondominio().getConteudoFormatado().equals(Logico.SIM)) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        ValidadorMudancaPfPj validadorMudancaPfPjParaPJ = new ValidadorMudancaPfPj("", this);
        validadorMudancaPfPjParaPJ.setValorOpcaoDoLogico("2");
        this.getImovel().getPessoaFisica().addValidador((ValidadorIf)validadorMudancaPfPjParaPJ);
        ValidadorMudancaPfPj validadorMudancaPfPjParaPF = new ValidadorMudancaPfPj("", this);
        validadorMudancaPfPjParaPF.setValorOpcaoDoLogico("1");
        this.getImovel().getPessoaFisica().addValidador((ValidadorIf)validadorMudancaPfPjParaPF);
        this.getImovel().getAreaTotal().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(4));
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaPreservacaoPermanente().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaLegal().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaParticular().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaInteresseEcologico().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaServidaoFlorestal().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaFlorestasNativas().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAlagada().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaOcupada().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaProdutosVegetais().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaEmDescanso().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaReflorestamento().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaEmDescanso().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaPastagens().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaExploracaoExtrativa().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaAtividadeGranjeira().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaFrustracaoSafra().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAproveitavel().addValidador((ValidadorIf)new ValidadorAreaAproveitavelInferior(2));
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAproveitavel().addValidador((ValidadorIf)new ValidadorAreaAproveitavelInconsistente(3, this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaTotalImovel()));
        this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaUtilizadaPelaAR().addValidador((ValidadorIf)new ValidadorAreaUtilizadaZero(2, this.getAreaNaoUtilizada().getAreaTotalNaoUtilizada(), this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAproveitavel(), (Informacao)this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaProdutosVegetais()));
        this.getImovel().getMunicipio().addValidador((ValidadorIf)new ValidadorAnulaAreaCalamidade(MensagemUtil.getMensagemComQuebraDeLinha("31"), this.getUtilizacaoImovel()));
        this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaFrustracaoSafra().addValidador((ValidadorIf)new ValidadorImpeditivoDefault(UtilitariosString.insereQuebraDeLinha((String)MensagemUtil.getMensagem("400015"), (int)80, (String)"\n")){

            public void acaoCancelar() {
            }

            public void acaoOk() {
            }

            public String getTituloPopup() {
                return "ITR " + ConstantesGlobais.EXERCICIO;
            }

            public RetornoValidacao validarImplementado() {
                this.setTipoExibicao(0);
                this.setSeveridade((byte)5);
                this.setMensagemValidacao(ITRUtil.inserirQuebraLinha(MensagemUtil.getMensagem("400015"), 80, "\n"));
                AreaHectares areaTemp = new AreaHectares();
                areaTemp.setConteudo(this.getInformacao().getConteudoFormatado());
                if (areaTemp.isVazio()) {
                    String proximoConteudo = (String)this.getProximoConteudo();
                    AreaHectares area = new AreaHectares();
                    area.setConteudo(proximoConteudo);
                    if (!area.isVazio()) {
                        if (!CadastroTabelasITR.verificaMunicipioEmCalamidade(DeclaracaoITR.this.getImovel().getMunicipio().getConteudoAtual(0))) {
                            if (GuiUtil.mostrarConfirma("400016", new String[]{DeclaracaoITR.this.getImovel().getMunicipio().getConteudoAtual(1)})) {
                                RetornoValidacao retorno = new RetornoValidacao(this.getMensagemValidacao());
                                return retorno;
                            }
                            this.setSeveridade((byte)4);
                            this.setMensagemValidacao(MensagemUtil.getMensagemComQuebraDeLinha("400018"));
                            RetornoValidacao retorno = new RetornoValidacao(this.getMensagemValidacao());
                            return retorno;
                        }
                        this.setSeveridade((byte)4);
                        this.setMensagemValidacao(MensagemUtil.getMensagemComQuebraDeLinha("400017"));
                        RetornoValidacao retorno = new RetornoValidacao(this.getMensagemValidacao());
                        return retorno;
                    }
                }
                return null;
            }
        });
        this.getImovel().getAreaTotal().addValidador((ValidadorIf)new ValidadorMudancaEnquadramentoAreaTotal("", this));
        this.getImovel().getMunicipio().addValidador((ValidadorIf)new ValidadorMudancaEnquadramentoMunicipio("", this));
        this.getImovel().getUf().addValidador((ValidadorIf)new ValidadorMudancaEnquadramentoUFMunicipio("", this));
        this.getImovel().getAreaTotal().addValidador((ValidadorIf)new ValidadorImpeditivoDefault(MensagemUtil.getMensagem("900180")){

            public RetornoValidacao validarImplementado() {
                this.setTipoExibicao(0);
                this.setSeveridade((byte)5);
                List dsapropriacoes = DeclaracaoITR.this.getAquisicaoAlienacao().getDesapropriacao().recuperarLista();
                AreaHectares area = new AreaHectares();
                for (InformacaoDesapropriacao des : dsapropriacoes) {
                    area.append('+', des.getArea());
                }
                if (area.comparacao(">", (String)this.getProximoConteudo())) {
                    return new RetornoValidacao(this.getMensagemValidacao());
                }
                return null;
            }

            public void acaoCancelar() {
            }

            public void acaoOk() {
            }

            public String getTituloPopup() {
                return this.getInformacao().getNomeCampo();
            }
        });
        this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getDemaisBenfeitorias().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getMineracao().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getImprestaveis().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getInexploradas().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getOutras().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getAreaNaoUtilizada().addValidador((ValidadorIf)new ValidadorAreaNaoUtilizada(2, this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaUtilizadaPelaAR(), this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAproveitavel(), this.getAreaNaoUtilizada().getAreaTotalNaoUtilizada()));
        this.getAtividadePecuaria().getAreaServidaPastagem().getPastagemNativa().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAtividadePecuaria().getAreaServidaPastagem().getPastagemPlantada().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAtividadePecuaria().getAreaServidaPastagem().getForrageiraCorte().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAtividadePecuaria().getAreaServidaPastagem().getPastagemEmFormacao().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAtividadePecuaria().getAreaServidaPastagem().getImplantadaObjetoProjetoTecnico().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAtividadeExtrativa().getAcaciaNegra().getArea().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAtividadeExtrativa().getBabacu().getArea().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAtividadeExtrativa().getBorracha().getArea().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAtividadeExtrativa().getCarnauba().getArea().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAtividadeExtrativa().getCastanha().getArea().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAtividadeExtrativa().getGuarana().getArea().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAtividadeExtrativa().getMadeira().getArea().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAtividadeExtrativa().getProduto().getArea().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getAtividadeExtrativa().getOutros().getArea().addValidador((ValidadorIf)new ValidadorAreaAproveitavel(5));
        this.getCalculoImposto().getValorBenfeitorias().addValidador((ValidadorIf)new ValidadorValorBenfeitorias(2, this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaOcupada(), this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getDemaisBenfeitorias()));
        this.getCalculoImposto().getValorCulturas().addValidador((ValidadorIf)new ValidadorValorCulturas(2, this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaUtilizadaPelaAR()));
        this.getUtilizacaoImovel().getParamVEL18().addValidador((ValidadorIf)new ValidadorNaoNulo(2){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaOcupada().comparacao(">", "200,00") && DeclaracaoITR.this.calculaVEL17().comparacao(">", "30000,00")) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("110180"), 2);
                }
                return null;
            }
        });
        this.getUtilizacaoImovel().getParamVEL19().addValidador((ValidadorIf)new ValidadorNaoNulo(2){

            public RetornoValidacao validarImplementado() {
                ElementoTabela opcaoMunicipio = DeclaracaoITR.this.getImovel().getMunicipio().getElementoTabela();
                if (opcaoMunicipio != null && !DeclaracaoITR.this.getImovel().getMunicipio().isVazio()) {
                    Valor somaAreas1 = new Valor();
                    somaAreas1.append('+', (Valor)DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaPreservacaoPermanente());
                    somaAreas1.append('+', (Valor)DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaLegal());
                    somaAreas1.append('+', (Valor)DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaParticular());
                    somaAreas1.append('+', (Valor)DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaInteresseEcologico());
                    somaAreas1.append('+', (Valor)DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaServidaoFlorestal());
                    somaAreas1.append('+', (Valor)DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaFlorestasNativas());
                    somaAreas1.append('+', (Valor)DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAlagada());
                    Valor somaAreas2 = new Valor();
                    somaAreas2.append('+', (Valor)DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaLegal());
                    somaAreas2.append('+', (Valor)DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaParticular());
                    somaAreas2.append('+', (Valor)DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaInteresseEcologico());
                    somaAreas2.append('+', (Valor)DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaServidaoFlorestal());
                    String percent1 = null;
                    String percent2 = null;
                    if (opcaoMunicipio.getConteudo(3).equals("4") || opcaoMunicipio.getConteudo(3).equals("2") || opcaoMunicipio.getConteudo(3).equals("5")) {
                        percent1 = "0,8";
                        percent2 = "0,6";
                    } else {
                        percent1 = "0,5";
                        percent2 = "0,3";
                    }
                    Valor percentAreaTotal1 = new Valor();
                    percentAreaTotal1.setConteudo(DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaTotalImovel().operacao('*', percent1));
                    Valor percentAreaTotal2 = new Valor();
                    percentAreaTotal2.setConteudo(DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaTotalImovel().operacao('*', percent2));
                    if ((somaAreas1.comparacao(">", percentAreaTotal1) || somaAreas2.comparacao(">", percentAreaTotal2)) && DeclaracaoITR.this.calculaVEL18().comparacao(">", "30000,00")) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("110190"), 2);
                    }
                }
                return null;
            }
        });
        this.getUtilizacaoImovel().getNumeroCAR().addValidador((ValidadorIf)new ValidadorCAR(2){

            @Override
            public RetornoValidacao validarImplementado() {
                if (DeclaracaoITR.this.getUtilizacaoImovel().getNumeroCAR().asString() != null && !DeclaracaoITR.this.getUtilizacaoImovel().getNumeroCAR().asString().equals("")) {
                    String ufUpper;
                    int tamanhoCARinformado = DeclaracaoITR.this.getUtilizacaoImovel().getNumeroCAR().asString().length();
                    String string = ufUpper = tamanhoCARinformado >= 2 ? DeclaracaoITR.this.getUtilizacaoImovel().getNumeroCAR().asString().substring(0, 2).toUpperCase() : "";
                    if (!ufUpper.equals(DeclaracaoITR.this.getImovel().getUf().getConteudoFormatado())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("110253"), this.getSeveridade());
                    }
                    if (tamanhoCARinformado >= 4 && !DeclaracaoITR.this.getUtilizacaoImovel().getNumeroCAR().asString().substring(2, 4).equals(DeclaracaoITR.this.getImovel().getMunicipio().getElementoTabela().getConteudo(9))) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("110254"), this.getSeveridade());
                    }
                    if (tamanhoCARinformado >= 9 && !DeclaracaoITR.this.getUtilizacaoImovel().getNumeroCAR().asString().substring(4, 9).equals(DeclaracaoITR.this.getImovel().getMunicipio().getElementoTabela().getConteudo(10))) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("110255"), this.getSeveridade());
                    }
                } else if (DeclaracaoITR.this.getImovel().getIsento().getConteudoFormatado().equals(Logico.NAO)) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("219"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getCalculoImposto().getParamVEL20().addValidador((ValidadorIf)new ValidadorNaoNulo(2){

            public RetornoValidacao validarImplementado() {
                ElementoTabela opcaoMunicipio = DeclaracaoITR.this.getImovel().getMunicipio().getElementoTabela();
                if (opcaoMunicipio != null && !DeclaracaoITR.this.getImovel().getMunicipio().isVazio()) {
                    Valor somaProdutos = DeclaracaoITR.this.calculaVTN();
                    Valor vtnCalculado = new Valor();
                    vtnCalculado.setCasasDecimais(4);
                    Valor vtnSistema = new Valor();
                    vtnSistema.setCasasDecimais(4);
                    vtnSistema.setConteudo(somaProdutos);
                    vtnCalculado.setConteudo(DeclaracaoITR.this.getCalculoImposto().getValorTerraNua());
                    vtnSistema.append('*', "0.80");
                    vtnSistema.arredonda(2, 5);
                    vtnCalculado.arredonda(2, 5);
                    Valor VEL = new Valor();
                    VEL = DeclaracaoITR.this.calculaVEL20();
                    if (!ConstantesGlobaisITR.FASE.equalsIgnoreCase("Producao")) {
                        System.out.println(" ");
                        System.out.println("VTN (L4=L1-L2-L3): " + vtnCalculado.getConteudoFormatado());
                        System.out.println("VTN SIPT (Soma dos Produtos): " + somaProdutos.getConteudoFormatado());
                        System.out.println("VTN SIPT (Soma dos Produtos) * 0,80: " + vtnSistema.getConteudoFormatado());
                        System.out.println(" ");
                        System.out.println("VEL (Valor Esperado do Lan\u00e7amento): " + VEL.getConteudoFormatado());
                        System.out.println(" ");
                    }
                    if (vtnCalculado.comparacao("<", vtnSistema) && VEL.comparacao(">", "5000,00")) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("110205"), 2);
                    }
                }
                return null;
            }
        });
        this.getImovel().getAreaTotal().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (DeclaracaoITR.this.getImovel().getIsento().formatado().equals(Logico.SIM) && DeclaracaoITR.this.getImovel().getMotivoIsencao().formatado().equals("C") && DeclaracaoITR.this.getImovel().getPertenceCondominio().formatado().equals(Logico.SIM) && !DeclaracaoITR.this.getDemaisCondominos().getTotalCondominos().isVazio()) {
                    AreaHectares areaIdeal = new AreaHectares();
                    areaIdeal.append('+', DeclaracaoITR.this.getImovel().getAreaTotal());
                    areaIdeal.append('*', DeclaracaoITR.this.getContribuinte().getParticCondominio());
                    areaIdeal.append('/', "100,0");
                    if (!DeclaracaoITR.this.getImovel().pequenaGleba(DeclaracaoITR.this.getImovel().getMunicipio().getElementoTabela(), areaIdeal)) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("110445"));
                    }
                    List condominos = DeclaracaoITR.this.getDemaisCondominos().itens();
                    for (ObjetoNegocio condomino : condominos) {
                        areaIdeal.clear();
                        areaIdeal.append('+', DeclaracaoITR.this.getImovel().getAreaTotal());
                        areaIdeal.append('*', ((Condomino)condomino).getPercentual());
                        areaIdeal.append('/', "100,0");
                        if (DeclaracaoITR.this.getImovel().pequenaGleba(DeclaracaoITR.this.getImovel().getMunicipio().getElementoTabela(), areaIdeal)) continue;
                        return new RetornoValidacao(MensagemUtil.getMensagem("110445"));
                    }
                }
                return null;
            }
        });
        this.getImovel().getAreaTotal().addValidador((ValidadorIf)new ValidadorAliquotaInvalida(3, this.getCalculoImposto().getAliquota()));
    }

    public void adicionaObservadoresNegocio() {
        this.getIdentificadorDeclaracao().getRetificadora().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (valorNovo.equals(Logico.SIM)) {
                    DeclaracaoITR.this.getIdentificadorDeclaracao().getNumeroReciboDeclaracaoAnterior().setHabilitado(true);
                    DeclaracaoITR.this.getIdentificadorDeclaracao().getNumeroReciboDeclaracaoAnterior().setReadOnly(false);
                } else if (valorNovo.equals(Logico.NAO)) {
                    DeclaracaoITR.this.getIdentificadorDeclaracao().getNumeroReciboDeclaracaoAnterior().setHabilitado(false);
                    DeclaracaoITR.this.getIdentificadorDeclaracao().getNumeroReciboDeclaracaoAnterior().setReadOnly(true);
                }
            }
        });
        this.getIdentificadorDeclaracao().getRetificadora().disparaObservadores();
        this.getImovel().getAreaTotal().addObservador(new Observador(){

            public void notifica(Object object, String string, Object object0, Object object1) {
                DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaTotalImovel().setConteudo(DeclaracaoITR.this.getImovel().getAreaTotal());
            }
        });
        this.getImovel().getIsento().addObservador(new Observador(){

            public void notifica(Object object, String string, Object object0, Object object1) {
                if (DeclaracaoITR.this.getImovel().getIsento().getConteudoFormatado().equals(Logico.NAO)) {
                    DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaTotalImovel().disparaObservadores();
                }
                DeclaracaoITR.this.getCalculoImposto().calculaAliquota(DeclaracaoITR.this.getUtilizacaoImovel().getGrauUtilizacao(), DeclaracaoITR.this.getImovel().getAreaTotal(), DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaTributavel());
            }
        });
        Observador obsEnquadramentoPastagemExploracao = new Observador(){

            public void notifica(Object o, String string, Object o1, Object o2) {
                boolean enquadramento = DeclaracaoITR.this.getImovel().enquadramento();
                DeclaracaoITR.this.utilizacaoImovel.getDistribuicaoAreaUtilizada().getAreaPastagens().setReadOnly(enquadramento);
                DeclaracaoITR.this.utilizacaoImovel.getDistribuicaoAreaUtilizada().getAreaPastagens().setHabilitado(!enquadramento);
                DeclaracaoITR.this.utilizacaoImovel.getDistribuicaoAreaUtilizada().getAreaExploracaoExtrativa().setReadOnly(enquadramento);
                DeclaracaoITR.this.utilizacaoImovel.getDistribuicaoAreaUtilizada().getAreaExploracaoExtrativa().setHabilitado(!enquadramento);
            }
        };
        this.getImovel().getMunicipio().addObservador(obsEnquadramentoPastagemExploracao);
        this.getImovel().getAreaTotal().addObservador(obsEnquadramentoPastagemExploracao);
        this.getImovel().getMunicipio().addObservador((Observador)new ObservadorIndiceLotacaoPecuaria(this.getImovel(), this.getAtividadePecuaria().getAreaServidaPastagem()));
        this.getUtilizacaoImovel().getGrauUtilizacao().addObservador(new Observador(){

            public void notifica(Object object, String string, Object object0, Object object1) {
                this.setAtivo(false);
                DeclaracaoITR.this.getCalculoImposto().calculaAliquota(DeclaracaoITR.this.getUtilizacaoImovel().getGrauUtilizacao(), DeclaracaoITR.this.getImovel().getAreaTotal(), DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaTributavel());
                this.setAtivo(true);
            }
        });
        this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAproveitavel().addObservador(new Observador(){

            public void notifica(Object object, String string, Object object0, Object object1) {
                this.setAtivo(false);
                DeclaracaoITR.this.getCalculoImposto().calculaValorTerraNuaTributavel(DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaTotalImovel(), DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaTributavel());
                this.setAtivo(true);
            }
        });
        this.getCalculoImposto().getValorTerraNua().addObservador(new Observador(){

            public void notifica(Object object, String string, Object object0, Object object1) {
                this.setAtivo(false);
                DeclaracaoITR.this.getCalculoImposto().calculaValorTerraNuaTributavel(DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaTotalImovel(), DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaTributavel());
                this.setAtivo(true);
            }
        });
        this.getAtividadeExtrativa().getAcaciaNegra().getArea().addObservador(new CalculaAreaExploracaoExtrativa(this));
        this.getAtividadeExtrativa().getBabacu().getArea().addObservador(new CalculaAreaExploracaoExtrativa(this));
        this.getAtividadeExtrativa().getBorracha().getArea().addObservador(new CalculaAreaExploracaoExtrativa(this));
        this.getAtividadeExtrativa().getCarnauba().getArea().addObservador(new CalculaAreaExploracaoExtrativa(this));
        this.getAtividadeExtrativa().getCastanha().getArea().addObservador(new CalculaAreaExploracaoExtrativa(this));
        this.getAtividadeExtrativa().getGuarana().getArea().addObservador(new CalculaAreaExploracaoExtrativa(this));
        this.getAtividadeExtrativa().getMadeira().getArea().addObservador(new CalculaAreaExploracaoExtrativa(this));
        this.getAtividadeExtrativa().getProduto().getArea().addObservador(new CalculaAreaExploracaoExtrativa(this));
        this.getAtividadeExtrativa().getOutros().getArea().addObservador(new CalculaAreaExploracaoExtrativa(this));
        this.getAtividadeExtrativa().getAcaciaNegra().getQtdProduzida().addObservador((Observador)new CalculaAreaExploracaoExtrativa(this));
        this.getAtividadeExtrativa().getBabacu().getQtdProduzida().addObservador((Observador)new CalculaAreaExploracaoExtrativa(this));
        this.getAtividadeExtrativa().getBorracha().getQtdProduzida().addObservador((Observador)new CalculaAreaExploracaoExtrativa(this));
        this.getAtividadeExtrativa().getCarnauba().getQtdProduzida().addObservador((Observador)new CalculaAreaExploracaoExtrativa(this));
        this.getAtividadeExtrativa().getCastanha().getQtdProduzida().addObservador((Observador)new CalculaAreaExploracaoExtrativa(this));
        this.getAtividadeExtrativa().getGuarana().getQtdProduzida().addObservador((Observador)new CalculaAreaExploracaoExtrativa(this));
        this.getAtividadeExtrativa().getMadeira().getQtdProduzida().addObservador((Observador)new CalculaAreaExploracaoExtrativa(this));
        final ObservadorObrigatoriedadeDeclarar observadorObrigatoriedadeDeclarar = new ObservadorObrigatoriedadeDeclarar();
        this.getIdentificadorDeclaracao().getRetificadora().addObservador((Observador)observadorObrigatoriedadeDeclarar);
        this.getImovel().getIsento().addObservador((Observador)observadorObrigatoriedadeDeclarar);
        this.getImovel().getMotivoIsencao().addObservador((Observador)observadorObrigatoriedadeDeclarar);
        this.getImovel().getPertenceCondominio().addObservador((Observador)observadorObrigatoriedadeDeclarar);
        this.getImovel().getAreaTotal().addObservador(observadorObrigatoriedadeDeclarar);
        this.getContribuinte().getNi().addObservador((Observador)observadorObrigatoriedadeDeclarar);
        this.getDemaisCondominos().getTotalCondominos().addObservador((Observador)observadorObrigatoriedadeDeclarar);
        this.getDemaisCondominos().addObservador("ObjetoInserido", observadorObrigatoriedadeDeclarar);
        this.getDemaisCondominos().addObservador("ObjetoInserido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                Condomino cond = (Condomino)((Object)valorNovo);
                cond.getNi().addObservador(observadorObrigatoriedadeDeclarar);
            }
        });
        this.getDemaisCondominos().addObservador("ObjetoRemovido", observadorObrigatoriedadeDeclarar);
        this.getDemaisCondominos().addObservador("ObjetoRemovido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                Condomino cond = (Condomino)((Object)valorNovo);
                try {
                    cond.getNi().removeObservadores(new Class[]{ObservadorObrigatoriedadeDeclarar.class});
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Valor calculaVTN() {
        VTN vtn = this.obterValores();
        Valor V1 = vtn.getValor1();
        Valor V2 = vtn.getValor2();
        Valor V3 = vtn.getValor3();
        Valor V4 = vtn.getValor4();
        if (!ConstantesGlobaisITR.FASE.equalsIgnoreCase("Producao")) {
            System.out.println(" ");
            System.out.println("=================================== ");
            System.out.println("Valores de VTN para o municipio:");
            System.out.println("V1: " + V1.formatado());
            System.out.println("V2: " + V2.formatado());
            System.out.println("V3: " + V3.formatado());
            System.out.println("V4: " + V4.formatado());
            System.out.println("=================================== ");
            System.out.println(" ");
        }
        Valor P1 = new Valor();
        Valor P2 = new Valor();
        Valor P3 = new Valor();
        Valor P4 = new Valor();
        Valor P5 = new Valor();
        Valor P6 = new Valor();
        Valor P7 = new Valor();
        Valor P8 = new Valor();
        Valor P9 = new Valor();
        Valor P10 = new Valor();
        Valor P11 = new Valor();
        Valor P12 = new Valor();
        Valor P13 = new Valor();
        Valor P14 = new Valor();
        Valor P15 = new Valor();
        Valor P16 = new Valor();
        Valor P17 = new Valor();
        Valor P18 = new Valor();
        Valor P19 = new Valor();
        Valor P20 = new Valor();
        Valor P21 = new Valor();
        Valor P22 = new Valor();
        Valor P23 = new Valor();
        Valor P24 = new Valor();
        Valor P25 = new Valor();
        Valor P26 = new Valor();
        Valor P27 = new Valor();
        P1.setCasasDecimais(4);
        P2.setCasasDecimais(4);
        P3.setCasasDecimais(4);
        P4.setCasasDecimais(4);
        P5.setCasasDecimais(4);
        P6.setCasasDecimais(4);
        P7.setCasasDecimais(4);
        P8.setCasasDecimais(4);
        P9.setCasasDecimais(4);
        P10.setCasasDecimais(4);
        P11.setCasasDecimais(4);
        P12.setCasasDecimais(4);
        P13.setCasasDecimais(4);
        P14.setCasasDecimais(4);
        P15.setCasasDecimais(4);
        P16.setCasasDecimais(4);
        P17.setCasasDecimais(4);
        P18.setCasasDecimais(4);
        P19.setCasasDecimais(4);
        P20.setCasasDecimais(4);
        P21.setCasasDecimais(4);
        P22.setCasasDecimais(4);
        P23.setCasasDecimais(4);
        P24.setCasasDecimais(4);
        P25.setCasasDecimais(4);
        P26.setCasasDecimais(4);
        P27.setCasasDecimais(4);
        P1.setConteudo(V4.operacao('*', (Valor)this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaPreservacaoPermanente()));
        P2.setConteudo(V4.operacao('*', (Valor)this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaLegal()));
        P3.setConteudo(V4.operacao('*', (Valor)this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaParticular()));
        P4.setConteudo(V4.operacao('*', (Valor)this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaInteresseEcologico()));
        P5.setConteudo(V4.operacao('*', (Valor)this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaServidaoFlorestal()));
        P6.setConteudo(V4.operacao('*', (Valor)this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaFlorestasNativas()));
        P7.setConteudo(this.menorEntreV1V2V3V4(V1, V2, V3, V4).operacao('*', (Valor)this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAlagada()));
        P8.setConteudo(this.menorEntreV1V2V3V4(V1, V2, V3, V4).operacao('*', (Valor)this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaOcupada()));
        P9.setConteudo(V1.operacao('*', (Valor)this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaProdutosVegetais()));
        P10.setConteudo(V1.operacao('*', (Valor)this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaEmDescanso()));
        P11.setConteudo(V3.operacao('*', (Valor)this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaReflorestamento()));
        if (!ControladorGui.getJanelaPrincipal().getFichaAtividadePecuariaHabilitada()) {
            P12.setConteudo(this.menorEntreV2V3(V2, V3).operacao('*', (Valor)this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaPastagens()));
        } else {
            P13.setConteudo(V3.operacao('*', (Valor)this.getAtividadePecuaria().getAreaServidaPastagem().getPastagemNativa()));
            P14.setConteudo(V2.operacao('*', (Valor)this.getAtividadePecuaria().getAreaServidaPastagem().getPastagemPlantada()));
            P15.setConteudo(V1.operacao('*', (Valor)this.getAtividadePecuaria().getAreaServidaPastagem().getForrageiraCorte()));
            P16.setConteudo(this.menorEntreV1V2V3V4(V1, V2, V3, V4).operacao('*', (Valor)this.getAtividadePecuaria().getAreaServidaPastagem().getPastagemEmFormacao()));
            P17.setConteudo(this.menorEntreV1V2V3V4(V1, V2, V3, V4).operacao('*', (Valor)this.getAtividadePecuaria().getAreaServidaPastagem().getImplantadaObjetoProjetoTecnico()));
        }
        if (!ControladorGui.getJanelaPrincipal().getFichaAtividadeExtrativaHabilitada()) {
            P18.setConteudo(V3.operacao('*', (Valor)this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaExploracaoExtrativa()));
        } else {
            P19.setConteudo(V3.operacao('*', (Valor)this.getAtividadeExtrativa().getAreaExploracaoExtrativa()));
            P20.setConteudo(V3.operacao('*', (Valor)this.getAreaNaoUtilizada().getAreasNaoAceitas().getAreaTotalNaoAceita()));
        }
        P21.setConteudo(this.menorEntreV1V2V3V4(V1, V2, V3, V4).operacao('*', (Valor)this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaAtividadeGranjeira()));
        P22.setConteudo(this.menorEntreV1V2V3(V1, V2, V3).operacao('*', (Valor)this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaFrustracaoSafra()));
        P23.setConteudo(this.menorEntreV1V2V3V4(V1, V2, V3, V4).operacao('*', (Valor)this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getDemaisBenfeitorias()));
        P24.setConteudo(this.menorEntreV1V2V3V4(V1, V2, V3, V4).operacao('*', (Valor)this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getMineracao()));
        P25.setConteudo(this.menorEntreV1V2V3V4(V1, V2, V3, V4).operacao('*', (Valor)this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getImprestaveis()));
        P26.setConteudo(this.menorEntreV1V2V3V4(V1, V2, V3, V4).operacao('*', (Valor)this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getInexploradas()));
        P27.setConteudo(this.menorEntreV1V2V3V4(V1, V2, V3, V4).operacao('*', (Valor)this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getOutras()));
        Valor somaProdutos = new Valor();
        somaProdutos.append('+', P1.getConteudoFormatado());
        somaProdutos.append('+', P2.getConteudoFormatado());
        somaProdutos.append('+', P3.getConteudoFormatado());
        somaProdutos.append('+', P4.getConteudoFormatado());
        somaProdutos.append('+', P5.getConteudoFormatado());
        somaProdutos.append('+', P6.getConteudoFormatado());
        somaProdutos.append('+', P7.getConteudoFormatado());
        somaProdutos.append('+', P8.getConteudoFormatado());
        somaProdutos.append('+', P9.getConteudoFormatado());
        somaProdutos.append('+', P10.getConteudoFormatado());
        somaProdutos.append('+', P11.getConteudoFormatado());
        somaProdutos.append('+', P12.getConteudoFormatado());
        somaProdutos.append('+', P13.getConteudoFormatado());
        somaProdutos.append('+', P14.getConteudoFormatado());
        somaProdutos.append('+', P15.getConteudoFormatado());
        somaProdutos.append('+', P16.getConteudoFormatado());
        somaProdutos.append('+', P17.getConteudoFormatado());
        somaProdutos.append('+', P18.getConteudoFormatado());
        somaProdutos.append('+', P19.getConteudoFormatado());
        somaProdutos.append('+', P20.getConteudoFormatado());
        somaProdutos.append('+', P21.getConteudoFormatado());
        somaProdutos.append('+', P22.getConteudoFormatado());
        somaProdutos.append('+', P23.getConteudoFormatado());
        somaProdutos.append('+', P24.getConteudoFormatado());
        somaProdutos.append('+', P25.getConteudoFormatado());
        somaProdutos.append('+', P26.getConteudoFormatado());
        somaProdutos.append('+', P27.getConteudoFormatado());
        return somaProdutos;
    }

    private VTN obterValores() {
        String codMunicipio = this.getImovel().getMunicipio().naoFormatado();
        int exercicio = Integer.valueOf(ConstantesGlobais.EXERCICIO) - 1;
        VTN vtn = null;
        if (ConstantesGlobaisITR.VTN_SIPT_WEB) {
            vtn = BarramentoUtil.consultarVTNs(codMunicipio, String.valueOf(exercicio));
        }
        if (vtn == null) {
            System.out.println("VTNs ser\u00e3o recuperados da tabela interna.");
            vtn = new VTN();
            vtn.getValor1().setCasasDecimais(4);
            vtn.getValor2().setCasasDecimais(4);
            vtn.getValor3().setCasasDecimais(4);
            vtn.getValor4().setCasasDecimais(4);
            vtn.getValor1().setConteudo(this.getImovel().getMunicipio().getElementoTabela().getConteudo(5));
            vtn.getValor2().setConteudo(this.getImovel().getMunicipio().getElementoTabela().getConteudo(6));
            vtn.getValor3().setConteudo(this.getImovel().getMunicipio().getElementoTabela().getConteudo(7));
            vtn.getValor4().setConteudo(this.getImovel().getMunicipio().getElementoTabela().getConteudo(8));
        }
        vtn.getValor1().setConteudo(vtn.getValor1().operacao('/', "100"));
        vtn.getValor2().setConteudo(vtn.getValor2().operacao('/', "100"));
        vtn.getValor3().setConteudo(vtn.getValor3().operacao('/', "100"));
        vtn.getValor4().setConteudo(vtn.getValor4().operacao('/', "100"));
        return vtn;
    }

    protected Valor menorEntreV1V2V3V4(Valor V1, Valor V2, Valor V3, Valor V4) {
        Valor menor = new Valor();
        if (V4.comparacao(">", "0")) {
            menor = V4;
        } else {
            menor.setConteudo("99999999999");
        }
        if (V3.comparacao(">", "0") && V3.comparacao("<", menor)) {
            menor = V3;
        }
        if (V2.comparacao(">", "0") && V2.comparacao("<", menor)) {
            menor = V2;
        }
        if (V1.comparacao(">", "0") && V1.comparacao("<", menor)) {
            menor = V1;
        }
        if (menor.comparacao("=", "99999999999")) {
            menor.setConteudo("0");
        }
        return menor;
    }

    protected Valor menorEntreV1V2V3(Valor V1, Valor V2, Valor V3) {
        Valor menor = new Valor();
        if (V3.comparacao(">", "0")) {
            menor = V3;
        } else {
            menor.setConteudo("99999999999");
        }
        if (V2.comparacao(">", "0") && V2.comparacao("<", menor)) {
            menor = V2;
        }
        if (V1.comparacao(">", "0") && V1.comparacao("<", menor)) {
            menor = V1;
        }
        if (menor.comparacao("=", "99999999999")) {
            menor.setConteudo("0");
        }
        return menor;
    }

    protected Valor menorEntreV2V3(Valor V2, Valor V3) {
        Valor menor = new Valor();
        if (V3.comparacao(">", "0")) {
            menor = V3;
        } else {
            menor.setConteudo("99999999999");
        }
        if (V2.comparacao(">", "0") && V2.comparacao("<", menor)) {
            menor = V2;
        }
        if (menor.comparacao("=", "99999999999")) {
            menor.setConteudo("0");
        }
        return menor;
    }

    public IdentificadorDeclaracaoXML getIdentificador() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AquisicaoAlienacao getAquisicaoAlienacao() {
        return this.aquisicaoAlienacao;
    }

    public void setAquisicaoAlienacao(AquisicaoAlienacao aAquisicaoAlienacao) {
        this.aquisicaoAlienacao = aAquisicaoAlienacao;
    }

    public Imovel getImovel() {
        return this.imovel;
    }

    public AreaNaoUtilizada getAreaNaoUtilizada() {
        return this.areaNaoUtilizada;
    }

    public void setAreaNaoUtilizada(AreaNaoUtilizada aAreaNaoUtilizada) {
        this.areaNaoUtilizada = aAreaNaoUtilizada;
    }

    public AtividadeExtrativa getAtividadeExtrativa() {
        return this.atividadeExtrativa;
    }

    public void setAtividadeExtrativa(AtividadeExtrativa aAtividadeExtrativa) {
        this.atividadeExtrativa = aAtividadeExtrativa;
    }

    public AtividadePecuaria getAtividadePecuaria() {
        return this.atividadePecuaria;
    }

    public void setAtividadePecuaria(AtividadePecuaria aAtividadePecuaria) {
        this.atividadePecuaria = aAtividadePecuaria;
    }

    public CalculoImposto getCalculoImposto() {
        return this.calculoImposto;
    }

    public void setCalculoImposto(CalculoImposto aCalculoImposto) {
        this.calculoImposto = aCalculoImposto;
    }

    public Contribuinte getContribuinte() {
        return this.contribuinte;
    }

    public void setContribuinte(Contribuinte aContribuinte) {
        this.contribuinte = aContribuinte;
    }

    public DemaisCondominos getDemaisCondominos() {
        return this.demaisCondominos;
    }

    public void setDemaisCondominos(DemaisCondominos aDemaisCondominos) {
        this.demaisCondominos = aDemaisCondominos;
    }

    public UtilizacaoImovel getUtilizacaoImovel() {
        return this.utilizacaoImovel;
    }

    public void setUtilizacaoImovel(UtilizacaoImovel aUtilizacaoImovel) {
        this.utilizacaoImovel = aUtilizacaoImovel;
    }

    public Alfa getExercicioDeclaracao() {
        return this.exercicioDeclaracao;
    }

    public Alfa getCodigoBarrasDarf() {
        return this.codigoBarrasDarf;
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao() {
        return this.identificadorDeclaracao;
    }

    public DataHora getDataHoraSalvamento() {
        return this.dataHoraSalvamento;
    }

    class ValidadorAreaUtilizadaZero
    extends ValidadorNaoNulo {
        AreaHectares areaNaoUtilizada;
        AreaHectares areaAproveitavel;

        public ValidadorAreaUtilizadaZero(byte severidade, AreaHectares pAreaNaoUtilizada, AreaHectares pAreaAproveitavel) {
            super(severidade);
            this.areaNaoUtilizada = pAreaNaoUtilizada;
            this.areaAproveitavel = pAreaAproveitavel;
        }

        public ValidadorAreaUtilizadaZero(byte severidade, AreaHectares pAreaNaoUtilizada, AreaHectares pAreaAproveitavel, Informacao informacaoFoco) {
            this(severidade, pAreaNaoUtilizada, pAreaAproveitavel);
        }

        public RetornoValidacao validarImplementado() {
            if (ITRFacade.getDeclaracaoEmMemoria().getImovel().getIsento().getConteudoFormatado().equals(Logico.NAO) && this.areaNaoUtilizada.comparacao("<", this.areaAproveitavel) && this.getInformacao().isVazio()) {
                RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagem("400019"));
                return retorno;
            }
            return null;
        }
    }

    class ValidadorAreaAproveitavelInferior
    extends ValidadorDefault {
        private String campo;

        public ValidadorAreaAproveitavelInferior(byte severidade) {
            super(severidade);
            this.setSeveridade(severidade);
        }

        public RetornoValidacao validarImplementado() {
            if (!ITRFacade.getDeclaracaoEmMemoria().getImovel().getIsento().asString().equals(Logico.SIM)) {
                AreaHectares areaAtividadePecuaria = new AreaHectares();
                AreaHectares areaAtividadeExtrativa = new AreaHectares();
                AreaHectares areaNaoUtilizada = new AreaHectares();
                AreaHectares areaUtilizada = new AreaHectares();
                AreaHectares areaSomada = new AreaHectares();
                String ultimoValor = this.getInformacao().getConteudoFormatado();
                if (DeclaracaoITR.this.getImovel().enquadramento()) {
                    areaAtividadePecuaria.clear();
                    areaAtividadePecuaria.append('+', DeclaracaoITR.this.getAtividadePecuaria().getAreaServidaPastagem().getPastagemDeclarada());
                    areaAtividadePecuaria.append('+', DeclaracaoITR.this.getAtividadePecuaria().getAreaServidaPastagem().getPastagemEmFormacao());
                    areaAtividadePecuaria.append('+', DeclaracaoITR.this.getAtividadePecuaria().getAreaServidaPastagem().getImplantadaObjetoProjetoTecnico());
                    areaAtividadeExtrativa.clear();
                    areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getAcaciaNegra().getArea());
                    areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getBabacu().getArea());
                    areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getBorracha().getArea());
                    areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getCarnauba().getArea());
                    areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getCastanha().getArea());
                    areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getGuarana().getArea());
                    areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getMadeira().getArea());
                    areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getProduto().getArea());
                    areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getOutros().getArea());
                    areaNaoUtilizada.clear();
                    areaNaoUtilizada.append('+', DeclaracaoITR.this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getAreaNaoUtilizada());
                    areaUtilizada.clear();
                    areaUtilizada.append('+', DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaProdutosVegetais());
                    areaUtilizada.append('+', DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaEmDescanso());
                    areaUtilizada.append('+', DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaReflorestamento());
                    areaUtilizada.append('+', DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaAtividadeGranjeira());
                    areaUtilizada.append('+', DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaFrustracaoSafra());
                    areaSomada.clear();
                    areaSomada.append('+', areaAtividadePecuaria);
                    areaSomada.append('+', areaAtividadeExtrativa);
                    areaSomada.append('+', areaNaoUtilizada);
                    areaSomada.append('+', areaUtilizada);
                    if (areaSomada.comparacao("<", DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAproveitavel())) {
                        RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagem("400025"));
                        this.setSeveridade((byte)2);
                        this.setMensagemValidacao(retorno.getMensagemValidacao());
                        this.getInformacao().setConteudo(ultimoValor);
                        return retorno;
                    }
                } else {
                    areaSomada.clear();
                    areaSomada.append('+', DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaUtilizadaPelaAR());
                    areaSomada.append('+', DeclaracaoITR.this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getAreaNaoUtilizada());
                    if (ITRFacade.getDeclaracaoEmMemoria().getImovel().getIsento().getConteudoFormatado().equals(Logico.NAO) && areaSomada.comparacao("<", DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAproveitavel())) {
                        RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagem("400030"));
                        this.setSeveridade((byte)2);
                        this.setMensagemValidacao(retorno.getMensagemValidacao());
                        this.getInformacao().setConteudo(ultimoValor);
                        return retorno;
                    }
                }
                this.getInformacao().setConteudo(ultimoValor);
            }
            return null;
        }
    }

    class ValidadorAreaAproveitavel
    extends ValidadorImpeditivoDefault {
        private String ultimoValor;
        private String proxValor;
        private boolean areaMaior50;

        public ValidadorAreaAproveitavel(byte severidade) {
            super("");
            this.ultimoValor = null;
            this.proxValor = null;
            this.setTipoExibicao(0);
            this.setSeveridade(severidade);
        }

        public RetornoValidacao validarImplementado() {
            this.ultimoValor = this.getInformacao().getConteudoFormatado();
            this.proxValor = (String)this.getProximoConteudo();
            this.getInformacao().setConteudo(this.proxValor);
            if (!ITRFacade.getDeclaracaoEmMemoria().getImovel().getIsento().asString().equals(Logico.SIM)) {
                AreaHectares areaAtividadePecuaria = new AreaHectares();
                AreaHectares areaAtividadeExtrativa = new AreaHectares();
                AreaHectares areaNaoUtilizada = new AreaHectares();
                AreaHectares areaUtilizada = new AreaHectares();
                AreaHectares areaSomada = new AreaHectares();
                areaAtividadePecuaria.clear();
                areaAtividadePecuaria.append('+', DeclaracaoITR.this.getAtividadePecuaria().getAreaServidaPastagem().getPastagemDeclarada());
                areaAtividadePecuaria.append('+', DeclaracaoITR.this.getAtividadePecuaria().getAreaServidaPastagem().getPastagemEmFormacao());
                areaAtividadePecuaria.append('+', DeclaracaoITR.this.getAtividadePecuaria().getAreaServidaPastagem().getImplantadaObjetoProjetoTecnico());
                areaAtividadeExtrativa.clear();
                areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getAcaciaNegra().getArea());
                areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getBabacu().getArea());
                areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getBorracha().getArea());
                areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getCarnauba().getArea());
                areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getCastanha().getArea());
                areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getGuarana().getArea());
                areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getMadeira().getArea());
                areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getProduto().getArea());
                areaAtividadeExtrativa.append('+', DeclaracaoITR.this.getAtividadeExtrativa().getOutros().getArea());
                areaNaoUtilizada.clear();
                areaNaoUtilizada.append('+', DeclaracaoITR.this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getAreaNaoUtilizada());
                areaUtilizada.clear();
                areaUtilizada.append('+', DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaProdutosVegetais());
                areaUtilizada.append('+', DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaEmDescanso());
                areaUtilizada.append('+', DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaReflorestamento());
                areaUtilizada.append('+', DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaAtividadeGranjeira());
                areaUtilizada.append('+', DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaFrustracaoSafra());
                if (DeclaracaoITR.this.getImovel().enquadramento()) {
                    areaSomada.clear();
                    areaSomada.append('+', areaAtividadePecuaria);
                    areaSomada.append('+', areaAtividadeExtrativa);
                    areaSomada.append('+', areaNaoUtilizada);
                    areaSomada.append('+', areaUtilizada);
                    if (areaSomada.comparacao(">", DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAproveitavel())) {
                        if (this.getInformacao().getOwner().getClass().equals(DistribuicaoAreaUtilizada.class) && areaNaoUtilizada.getConteudoAbsoluto() == 0L && areaAtividadePecuaria.getConteudoAbsoluto() == 0L && areaAtividadeExtrativa.getConteudoAbsoluto() == 0L) {
                            RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("35"));
                            this.setMensagemValidacao(retorno.getMensagemValidacao());
                            this.getInformacao().setConteudo(this.ultimoValor);
                            return retorno;
                        }
                        if (this.getSeveridade() == 4) {
                            RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("24"));
                            this.setMensagemValidacao(retorno.getMensagemValidacao());
                            return retorno;
                        }
                        RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("25"));
                        this.setMensagemValidacao(retorno.getMensagemValidacao());
                        this.getInformacao().setConteudo(this.ultimoValor);
                        return retorno;
                    }
                } else {
                    areaSomada.clear();
                    areaSomada.append('+', DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaUtilizadaPelaAR());
                    areaSomada.append('+', DeclaracaoITR.this.getAreaNaoUtilizada().getDistribuicaoPelaAR().getAreaNaoUtilizada());
                    if (areaSomada.comparacao(">", DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAproveitavel())) {
                        if (this.getInformacao().getOwner().getClass().equals(DistribuicaoAreaUtilizada.class) && areaNaoUtilizada.getConteudoAbsoluto() == 0L && areaAtividadePecuaria.getConteudoAbsoluto() == 0L && areaAtividadeExtrativa.getConteudoAbsoluto() == 0L) {
                            RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("35"));
                            this.setMensagemValidacao(retorno.getMensagemValidacao());
                            this.getInformacao().setConteudo(this.ultimoValor);
                            return retorno;
                        }
                        if (this.getSeveridade() == 4) {
                            RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("29"));
                            this.setMensagemValidacao(retorno.getMensagemValidacao());
                            return retorno;
                        }
                        RetornoValidacao retorno = new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("30"));
                        this.setMensagemValidacao(retorno.getMensagemValidacao());
                        this.getInformacao().setConteudo(this.ultimoValor);
                        return retorno;
                    }
                }
                this.getInformacao().setConteudo(this.ultimoValor);
            } else {
                this.getInformacao().setConteudo(this.ultimoValor);
            }
            return null;
        }

        public void acaoOk() {
            DeclaracaoITR.this.getAtividadeExtrativa().limpaValoresPreenchidos();
            DeclaracaoITR.this.getAtividadePecuaria().limpaValoresPreenchidos();
            DeclaracaoITR.this.getAreaNaoUtilizada().getAreasNaoAceitas().getAreaExploracaoExtrativa().clear();
            DeclaracaoITR.this.getAreaNaoUtilizada().getAreasNaoAceitas().getAreaPastagem().clear();
            DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaImovel().zeraValores();
            DeclaracaoITR.this.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().zeraValores();
            DeclaracaoITR.this.getAreaNaoUtilizada().getDistribuicaoPelaAR().zeraValores();
        }

        public void acaoCancelar() {
            this.getInformacao().setConteudo(this.ultimoValor);
        }

        public String getTituloPopup() {
            return this.getInformacao().getNomeCampo();
        }
    }

    public class ObservadorObrigatoriedadeDeclarar
    extends Observador {
        public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            PainelAuxiliarObrigatoriedade.getInstance().setObrigatoriedade(DeclaracaoITR.this.obrigadoDeclarar(), DeclaracaoITR.this.getImovel().getIsento());
        }
    }
}

