/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.demaiscondominos;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.ValidadorNIItr;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.demaiscondominos.Condomino;
import serpro.ppgd.itr.demaiscondominos.ValidadorNiContribuinte;
import serpro.ppgd.itr.demaiscondominos.ValidadorSomaPercentuais;
import serpro.ppgd.itr.demaiscondominos.ValidadorSomatorioAtingiu100;
import serpro.ppgd.itr.demaiscondominos.ValidadorTipoNI;
import serpro.ppgd.itr.gui.demaiscondominos.PainelCondominosLista;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class DemaisCondominos
extends Colecao<Condomino>
implements ObjetoFicha {
    private Valor totalCondominos = new Valor((ObjetoNegocio)this, "Informe o total de cond\u00f4minos (inclusive o declarante) :");
    private Valor totalPercentual = new Valor((ObjetoNegocio)this, "Informe o total de cond\u00f4minos (inclusive o declarante) :");
    private Valor validacaoFichas = new Valor((ObjetoNegocio)this, "Informe o total de cond\u00f4minos (inclusive o declarante) :");
    private static final String NOME_FICHA = "Demais Cond\u00f4minos";
    private WeakReference declaracaoRef = null;

    public DemaisCondominos(DeclaracaoITR dec) {
        super(Condomino.class.getName());
        this.declaracaoRef = new WeakReference<DeclaracaoITR>(dec);
        this.totalPercentual.addValidador((ValidadorIf)new ValidadorSomatorioAtingiu100(3));
        this.totalCondominos.converteQtdCasasDecimais(0);
        this.totalCondominos.setMaximoDigitosParteInteira(3);
        this.getTotalCondominos().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                int totalPreenchidos = DemaisCondominos.this.recuperarNumeroObjetosNaoNulos();
                if (DemaisCondominos.this.getTotalCondominos().comparacao(">", "11") && totalPreenchidos < 10) {
                    String[] params = new String[]{"10"};
                    return new RetornoValidacao(MensagemUtil.getMensagem("200065", params));
                }
                return null;
            }
        });
        this.getTotalCondominos().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (DemaisCondominos.this.getTotalCondominos().comparacao("<", "2")) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("200055"));
                }
                return null;
            }
        });
        this.getValidacaoFichas().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                int totalPreenchidos;
                if (ITRFacade.getDeclaracaoEmMemoria().getImovel().getPertenceCondominio().formatado().equals(Logico.SIM) && (totalPreenchidos = DemaisCondominos.this.recuperarNumeroObjetosNaoNulos()) == 0) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("200005"), 3);
                }
                return new RetornoValidacao(0);
            }
        });
        this.getTotalCondominos().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                int totalPreenchidos = DemaisCondominos.this.recuperarNumeroObjetosNaoNulos() + 1;
                if (!DemaisCondominos.this.getTotalCondominos().comparacao("=", "" + totalPreenchidos) && (totalPreenchidos < 11 || DemaisCondominos.this.getTotalCondominos().comparacao("<", "" + totalPreenchidos))) {
                    String[] params = new String[]{DemaisCondominos.this.getTotalCondominos().operacao('-', "1").formatado()};
                    return new RetornoValidacao(MensagemUtil.getMensagem("200065", params), 3);
                }
                return new RetornoValidacao(0);
            }
        });
        this.getValidacaoFichas().addValidador((ValidadorIf)new ValidadorSomaPercentuais(3));
        this.setFicha(NOME_FICHA);
    }

    public Valor getValidacaoFichas() {
        return this.validacaoFichas;
    }

    public void objetoInserido(final Condomino cond) {
        cond.getNi().addValidador((ValidadorIf)new ValidadorNI(3));
        cond.getNi().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (DemaisCondominos.this.existeCpfRepetido(cond.getNi())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("200045"), 3);
                }
                return new RetornoValidacao(0);
            }
        });
        cond.getNi().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (!cond.getPercentual().isVazio() && cond.getNi().isVazio() && cond.getNome().isVazio()) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(MensagemUtil.getMensagem("200021"), 3);
                }
                return new RetornoValidacao(0);
            }
        });
        cond.getNi().addValidador((ValidadorIf)new ValidadorNiContribuinte(3));
        cond.getNi().addValidador((ValidadorIf)new ValidadorNIItr(3));
        cond.getNi().addValidador((ValidadorIf)new ValidadorTipoNI(3, (DeclaracaoITR)((Object)this.declaracaoRef.get())));
        cond.getPercentual().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("200025")));
    }

    private boolean existeCpfRepetido(NI ni) {
        int countAchados = 0;
        Iterator it = this.itens().iterator();
        while (it.hasNext() && countAchados < 2) {
            Condomino cond = (Condomino)((Object)it.next());
            if (cond.getNi().compareTo(ni) != 0) continue;
            ++countAchados;
        }
        return countAchados == 2;
    }

    public Valor getTotalCondominos() {
        return this.totalCondominos;
    }

    public void setTotalCondominos(Valor totalCondominos) {
        this.totalCondominos = totalCondominos;
    }

    public Valor getTotalPercentual() {
        return this.totalPercentual;
    }

    public void setTotalPercentual(Valor totalPercentual) {
        this.totalPercentual = totalPercentual;
    }

    protected List recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.getValidacaoFichas());
        retorno.add(this.getTotalCondominos());
        retorno.add(this.getTotalPercentual());
        return retorno;
    }

    public String getClasseFicha() {
        return PainelCondominosLista.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return null;
    }
}

