/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import serpro.ppgd.app.acoes.NovaDeclaracaoAction;
import serpro.ppgd.gui.pendencia.MapeamentoInformacaoEditCampo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.PainelCacher;
import serpro.ppgd.infraestrutura.util.ProcessoSwing;
import serpro.ppgd.infraestrutura.util.Tarefa;
import serpro.ppgd.infraestrutura.util.TarefaComExcecao;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.exception.AplicacaoException;
import serpro.ppgd.itr.gui.ITRBemVindos;
import serpro.ppgd.itr.gui.ITRTableModelAb;
import serpro.ppgd.itr.gui.JanelaPrincipalITR;
import serpro.ppgd.itr.gui.NavegacaoIf;
import serpro.ppgd.itr.gui.PainelAuxiliarObrigatoriedade;
import serpro.ppgd.itr.gui.PainelContainer;
import serpro.ppgd.itr.gui.PainelDeclaracaoAb;
import serpro.ppgd.itr.gui.PainelDeclaracaoIf;
import serpro.ppgd.itr.gui.PainelPrincipalAb;
import serpro.ppgd.itr.gui.listener.CabecalhoFichaListener;
import serpro.ppgd.itr.gui.listener.DeclaracaoListener;
import serpro.ppgd.itr.gui.listener.HelpListener;
import serpro.ppgd.itr.gui.listener.LoginGovListener;
import serpro.ppgd.itr.gui.listener.MensagemFichaListener;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.nuvem.UsuarioLogado;
import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;

public class ControladorGui {
    private static DeclaracaoITR declaracaoAberta = null;
    private static PainelDeclaracaoIf painelAtualmenteExibido = null;
    private static List<DeclaracaoListener> listaEscutadores = null;
    private static List<CabecalhoFichaListener> listaEscutadoresCabecalhoFicha = null;
    private static List<MensagemFichaListener> listaEscutadoresMensagemFicha = null;
    private static List<HelpListener> listaEscutadoresHelp = null;
    private static ListenerList<LoginGovListener> listaEscutadoresLoginGov = null;
    private static final Preferences preferences = Preferences.userNodeForPackage(DeclaracaoITR.class);
    public static final String CACHE_NI_LIGADO_PREF = "CacheNILigado";
    public static final String CACHE_NI_MSG_INICIAL_EXIBIDA_PREF = "CacheNIMsgInicial";
    public static final String NAO_EXIBIR_NOVIDADES_ITR = "NaoExibirNovidades" + ConstantesGlobais.EXERCICIO;

    public static Preferences getITRPreferences() {
        return preferences;
    }

    private static void dispatchDeclaracaoAberta() {
        if (listaEscutadores != null) {
            for (DeclaracaoListener lListener : listaEscutadores) {
                lListener.declaracaoAberta();
            }
        }
    }

    private static boolean dispatchDeclaracaoVaiFechar() {
        if (listaEscutadores != null) {
            for (DeclaracaoListener lListener : listaEscutadores) {
                if (lListener.declaracaoVaiFechar()) continue;
                return false;
            }
        }
        return true;
    }

    private static void dispatchDeclaracaoFechada() {
        if (listaEscutadores != null) {
            for (DeclaracaoListener lListener : listaEscutadores) {
                lListener.declaracaoFechado();
            }
        }
    }

    private static void dispatchDeclaracaoSalva() {
        if (listaEscutadores != null) {
            for (DeclaracaoListener lListener : listaEscutadores) {
                lListener.declaracaoSalva();
            }
        }
    }

    private static void dispatchMudouNumeroDeclaracoes() {
        if (listaEscutadores != null) {
            for (DeclaracaoListener lListener : listaEscutadores) {
                lListener.mudouNumerodeclaracoes();
            }
        }
    }

    private static void dispatchMudouCabecalho(String novoTextoCabecalho) {
        if (listaEscutadoresCabecalhoFicha != null) {
            for (CabecalhoFichaListener lListener : listaEscutadoresCabecalhoFicha) {
                lListener.cabecalhoAlterado(novoTextoCabecalho);
            }
        }
    }

    private static void dispatchMudouMensagem(String novaMensagem) {
        if (listaEscutadoresMensagemFicha != null) {
            for (MensagemFichaListener lListener : listaEscutadoresMensagemFicha) {
                lListener.mensagemAlterada(novaMensagem);
            }
        }
    }

    private static void dispatchMudouHelpId(String novoHelpId) {
        if (listaEscutadoresHelp != null) {
            for (HelpListener lListener : listaEscutadoresHelp) {
                lListener.helpIdAlterado(novoHelpId);
            }
        }
    }

    public static void addDeclaracaoListener(DeclaracaoListener pListener) {
        if (listaEscutadores == null) {
            listaEscutadores = new ArrayList<DeclaracaoListener>();
        }
        listaEscutadores.add(pListener);
    }

    public static void removeDeclaracaoListener(DeclaracaoListener pListener) {
        if (listaEscutadores != null) {
            listaEscutadores.remove(pListener);
            if (listaEscutadores.isEmpty()) {
                listaEscutadores = null;
            }
        }
    }

    public static void addCabecalhoFichaListener(CabecalhoFichaListener pListener) {
        if (listaEscutadoresCabecalhoFicha == null) {
            listaEscutadoresCabecalhoFicha = new ArrayList<CabecalhoFichaListener>();
        }
        listaEscutadoresCabecalhoFicha.add(pListener);
    }

    public static void removeCabecalhoFichaListener(CabecalhoFichaListener pListener) {
        if (listaEscutadoresCabecalhoFicha != null) {
            listaEscutadoresCabecalhoFicha.remove(pListener);
            if (listaEscutadoresCabecalhoFicha.isEmpty()) {
                listaEscutadoresCabecalhoFicha = null;
            }
        }
    }

    public static void addMensagemFichaListener(MensagemFichaListener pListener) {
        if (listaEscutadoresMensagemFicha == null) {
            listaEscutadoresMensagemFicha = new ArrayList<MensagemFichaListener>();
        }
        listaEscutadoresMensagemFicha.add(pListener);
    }

    public static void removeMensagemFichaListener(MensagemFichaListener pListener) {
        if (listaEscutadoresMensagemFicha != null) {
            listaEscutadoresMensagemFicha.remove(pListener);
            if (listaEscutadoresMensagemFicha.isEmpty()) {
                listaEscutadoresMensagemFicha = null;
            }
        }
    }

    public static void addHelpListener(HelpListener pListener) {
        if (listaEscutadoresHelp == null) {
            listaEscutadoresHelp = new ArrayList<HelpListener>();
        }
        listaEscutadoresHelp.add(pListener);
    }

    public static void removeHelpListener(HelpListener pListener) {
        if (listaEscutadoresHelp != null) {
            listaEscutadoresHelp.remove(pListener);
            if (listaEscutadoresHelp.isEmpty()) {
                listaEscutadoresHelp = null;
            }
        }
    }

    public static void init() {
        if (ControladorGui.isDeclaracaoAberta()) {
            ControladorGui.dispatchDeclaracaoAberta();
        } else {
            ControladorGui.dispatchDeclaracaoFechada();
        }
        ControladorGui.dispatchMudouNumeroDeclaracoes();
        ITRBemVindos painelBemVindos = (ITRBemVindos)PainelCacher.getInstancia().obtemUrgentemente(NavegacaoIf.PAINEL_BEM_VINDOS);
        ControladorGui.addDeclaracaoListener(painelBemVindos);
        ControladorGui.acionarPainel(painelBemVindos);
    }

    private static void verificarExisteDeclaracao() {
        if (!ControladorGui.existemDeclaracoes() && GuiUtil.mostrarConfirma("111135")) {
            new NovaDeclaracaoAction().actionPerformed(null);
        }
    }

    public static DeclaracaoITR getDeclaracaoAberta() {
        return declaracaoAberta;
    }

    private static void setDeclaracaoAberta(DeclaracaoITR pDemonstrativoAberto) {
        declaracaoAberta = pDemonstrativoAberto;
    }

    public static void setPainelAtualmenteExibido(PainelDeclaracaoIf pPainelAtualmenteExibido) {
        painelAtualmenteExibido = pPainelAtualmenteExibido;
    }

    public static PainelDeclaracaoIf getPainelAtualmenteExibido() {
        return painelAtualmenteExibido;
    }

    public static void atualizarListaPainelAtual() {
        PainelDeclaracaoIf painel = ControladorGui.getPainelAtualmenteExibido();
        if (painel != null && painel instanceof PainelDeclaracaoAb) {
            ((PainelDeclaracaoAb)painel).atualizarLista();
        }
    }

    public static void tratarException(Exception pExcecao) {
        if (pExcecao instanceof AplicacaoException) {
            GuiUtil.mostrarErro(pExcecao);
        } else if (pExcecao instanceof HashInvalidoException) {
            HashInvalidoException ex = (HashInvalidoException)pExcecao;
            FabricaUtilitarios.printStackEmDesenvolvimento((Exception)pExcecao);
            int n = JOptionPane.showConfirmDialog(null, "Foi detectado que o arquivo desta declara\u00e7\u00e3o est\u00e1 corrompido.", "Erro ao Abrir", -1, 0);
        } else {
            LogPPGD.erro((String)pExcecao.getMessage());
            pExcecao.printStackTrace();
        }
    }

    public static boolean acionarPainel(String pPainelStr) {
        boolean lTrocouPainel = false;
        try {
            JPanel painelAcionado = PainelCacher.getInstancia().obtemUrgentemente(pPainelStr);
            if (painelAcionado == null) {
                Class<?> c = Class.forName(pPainelStr);
                painelAcionado = (JPanel)c.newInstance();
            }
            lTrocouPainel = ControladorGui.acionarPainel((PainelDeclaracaoIf)((Object)painelAcionado));
        }
        catch (Exception ex) {
            ControladorGui.tratarException(ex);
        }
        return lTrocouPainel;
    }

    public static boolean acionarPainel(PainelDeclaracaoIf pPainelAcionado) {
        PainelDeclaracaoIf painelAtual = ControladorGui.getPainelAtualmenteExibido();
        GuiUtil.adicionarEnterComoTeclaDeNavegacao((JPanel)((Object)pPainelAcionado));
        if (painelAtual == null) {
            try {
                ControladorGui.alterarPainel(pPainelAcionado);
                return true;
            }
            catch (Exception ex) {
                ControladorGui.tratarException(ex);
            }
        } else if (!painelAtual.getClass().getName().equals(pPainelAcionado.getClass().getName()) && painelAtual.isPodeSair()) {
            try {
                if (pPainelAcionado instanceof PainelPrincipalAb) {
                    PainelPrincipalAb painelPrincipal = (PainelPrincipalAb)pPainelAcionado;
                    ITRTableModelAb gcapTableModel = (ITRTableModelAb)painelPrincipal.getTabela().getModel();
                    gcapTableModel.refresh();
                }
                ControladorGui.alterarPainel(pPainelAcionado);
                painelAtual.posSair();
                return true;
            }
            catch (Exception ex) {
                ControladorGui.tratarException(ex);
            }
        }
        return false;
    }

    private static void alterarPainel(PainelDeclaracaoIf pPainelAcionado) throws Exception {
        pPainelAcionado.preExibir();
        PainelContainer lPainelBasico = ControladorGui.obterPainelContainer();
        ControladorGui.salvarDeclaracaoAberta();
        ImageIcon lImagem = pPainelAcionado.getImagemTitulo();
        if (lImagem != null) {
            lPainelBasico.setImagem(lImagem);
        }
        lPainelBasico.mudaCorpoPainelPrincipal(pPainelAcionado);
        ControladorGui.setPainelAtualmenteExibido(pPainelAcionado);
        PlataformaPPGD.getPlataforma().mudaPainelExibido((JPanel)lPainelBasico);
        JComponent lComponent = pPainelAcionado.getDefaultFocus();
        if (lComponent != null && ITRUtil.getEstadoSistema() != 1) {
            lComponent.requestFocusInWindow();
        }
        pPainelAcionado.posExibir();
    }

    private static PainelContainer obterPainelContainer() {
        return (PainelContainer)PainelCacher.getInstancia().obtemUrgentemente(PainelContainer.class.getName());
    }

    public static JanelaPrincipalITR getJanelaPrincipal() {
        return (JanelaPrincipalITR)PlataformaPPGD.getPlataforma().getJanelaPrincipal();
    }

    public static void fecharDeclaracao() {
        try {
            if (ControladorGui.isDeclaracaoAberta() && ControladorGui.dispatchDeclaracaoVaiFechar()) {
                DeclaracaoITR lDemonstrativoAberto = ControladorGui.getDeclaracaoAberta();
                PainelDeclaracaoIf painelAtual = ControladorGui.getPainelAtualmenteExibido();
                painelAtual.preFecharDeclaracao();
                ITRFacade.getInstancia();
                ITRFacade.salvarDeclaracao(lDemonstrativoAberto);
                lDemonstrativoAberto.removeObservadores(new Class[]{JPanel.class});
                ControladorGui.removeListeners();
                PainelCacher.getInstancia().encerra();
                ControladorGui.setPainelAtualmenteExibido(null);
                ControladorGui.setDeclaracaoAberta(null);
                MapeamentoInformacaoEditCampo.limpaAssociacoes();
                ITRFacade.limpaCacheDeclaracoes();
                ControladorGui.dispatchDeclaracaoFechada();
                System.gc();
                ITRBemVindos painelBemVindos = (ITRBemVindos)PainelCacher.getInstancia().obtemUrgentemente(NavegacaoIf.PAINEL_BEM_VINDOS);
                ControladorGui.addDeclaracaoListener(painelBemVindos);
                ControladorGui.acionarPainel(painelBemVindos);
            }
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    private static void removeListeners() {
        PainelContainer painelContainer = ControladorGui.obterPainelContainer();
        ControladorGui.removeMensagemFichaListener(painelContainer);
        ControladorGui.removeHelpListener(painelContainer);
        ControladorGui.removeDeclaracaoListener(painelContainer.getHoraSalvamentoPanel1());
        ControladorGui.removeCabecalhoFichaListener(painelContainer);
    }

    public static void abrirDeclaracao(final IdentificadorDeclaracao pId, boolean pExecutaProcessoSwing) throws HashInvalidoException {
        if (pExecutaProcessoSwing) {
            try {
                ProcessoSwing.executa((TarefaComExcecao)new TarefaComExcecao(){

                    public Object run() throws Exception {
                        ControladorGui.abrirDeclaracao(pId);
                        return null;
                    }
                });
            }
            catch (HashInvalidoException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ControladorGui.abrirDeclaracao(pId);
        }
    }

    public static void abrirDeclaracao(final DeclaracaoITR pDec, boolean pExecutaProcessoSwing) {
        if (pExecutaProcessoSwing) {
            ProcessoSwing.executa((Tarefa)new Tarefa(){

                public Object run() {
                    ControladorGui.abrirDeclaracao(pDec);
                    return null;
                }
            });
        } else {
            ControladorGui.abrirDeclaracao(pDec);
        }
    }

    private static void abrirDeclaracao(IdentificadorDeclaracao pId) throws HashInvalidoException {
        try {
            PainelContainer pc = ControladorGui.obterPainelContainer();
            ControladorGui.addDeclaracaoListener(pc.getHoraSalvamentoPanel1());
            ControladorGui.addCabecalhoFichaListener(pc);
            ControladorGui.addMensagemFichaListener(pc);
            ControladorGui.addHelpListener(pc);
            ITRBemVindos painelBemVindos = (ITRBemVindos)PainelCacher.getInstancia().obtemUrgentemente(NavegacaoIf.PAINEL_BEM_VINDOS);
            ControladorGui.removeDeclaracaoListener(painelBemVindos);
            ITRFacade.abreDeclaracao(pId);
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(false);
            ControladorGui.setDeclaracaoAberta(ITRFacade.getInstancia().getDeclaracao());
            if (ControladorGui.acionarPainel(NavegacaoIf.PAINEL_IDENTIFICACAO_IMOVEL)) {
                ControladorGui.getJanelaPrincipal().setLastAccessedItem(NavegacaoIf.PAINEL_IDENTIFICACAO_IMOVEL);
            }
            ControladorGui.dispatchDeclaracaoAberta();
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(true);
            ControladorGui.getPainelAtualmenteExibido().getDefaultFocus().requestFocusInWindow();
            PainelAuxiliarObrigatoriedade.getInstance().setObrigatoriedade(ITRFacade.getInstancia().getDeclaracao().obrigadoDeclarar(), ITRFacade.getInstancia().getDeclaracao().getImovel().getIsento());
        }
        catch (HashInvalidoException e) {
            throw e;
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    private static void abrirDeclaracao(DeclaracaoITR pDec) {
        try {
            PainelContainer pc = ControladorGui.obterPainelContainer();
            ControladorGui.addDeclaracaoListener(pc.getHoraSalvamentoPanel1());
            ControladorGui.addMensagemFichaListener(pc);
            ControladorGui.addHelpListener(pc);
            ITRBemVindos painelBemVindos = (ITRBemVindos)PainelCacher.getInstancia().obtemUrgentemente(NavegacaoIf.PAINEL_BEM_VINDOS);
            ControladorGui.removeDeclaracaoListener(painelBemVindos);
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(false);
            ITRFacade.abreDeclaracao(pDec);
            ControladorGui.setDeclaracaoAberta(pDec);
            if (ControladorGui.acionarPainel(NavegacaoIf.PAINEL_IDENTIFICACAO_IMOVEL)) {
                ControladorGui.getJanelaPrincipal().setLastAccessedItem(NavegacaoIf.PAINEL_IDENTIFICACAO_IMOVEL);
            }
            ControladorGui.dispatchDeclaracaoAberta();
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setEnabled(true);
            ControladorGui.getPainelAtualmenteExibido().getDefaultFocus().requestFocusInWindow();
            PainelAuxiliarObrigatoriedade.getInstance().setObrigatoriedade(pDec.obrigadoDeclarar(), pDec.getImovel().getIsento());
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static boolean isDeclaracaoAberta() {
        return ControladorGui.getDeclaracaoAberta() != null;
    }

    public static void salvarDeclaracaoAberta() throws Exception {
        DeclaracaoITR dec = ControladorGui.getDeclaracaoAberta();
        if (dec != null) {
            ControladorGui.salvarDeclaracao(dec);
        }
    }

    public static void salvarDeclaracao(DeclaracaoITR dec) throws Exception {
        ITRFacade.getInstancia();
        ITRFacade.salvarDeclaracao(dec);
        ControladorGui.dispatchDeclaracaoSalva();
        ControladorGui.dispatchMudouNumeroDeclaracoes();
    }

    public static void excluirDeclaracao(List<IdentificadorDeclaracao> pIds) {
        try {
            for (IdentificadorDeclaracao identificadorDeclaracao : pIds) {
                ITRFacade.excluirDeclaracao(identificadorDeclaracao);
            }
            ControladorGui.dispatchMudouNumeroDeclaracoes();
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void excluirDeclaracao(IdentificadorDeclaracao pId) throws Exception {
        ITRFacade.excluirDeclaracao(pId);
        ControladorGui.dispatchMudouNumeroDeclaracoes();
    }

    public static boolean existemDeclaracoes() {
        try {
            ITRFacade.getInstancia();
            return ITRFacade.existemDeclaracoes();
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
            return false;
        }
    }

    public static void alterarCabecalhoFicha(String novoTextoCabecalho) {
        try {
            ControladorGui.dispatchMudouCabecalho(novoTextoCabecalho);
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void alterarMensagemFicha(String novaMensagem) {
        try {
            ControladorGui.dispatchMudouMensagem(novaMensagem);
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void alterarHelpId(String novoHelpId) {
        try {
            ControladorGui.dispatchMudouHelpId(novoHelpId);
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void atualizarNumeroDeclaracoes() {
        try {
            ControladorGui.dispatchMudouNumeroDeclaracoes();
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
    }

    public static void atualizarUsuarioLogado(UsuarioLogado usuario) {
        if (usuario != null) {
            ControladorGui.dispatchUsuarioLogado(usuario);
        } else {
            ControladorGui.dispatchUsuarioDeslogado();
        }
    }

    private static void dispatchUsuarioLogado(UsuarioLogado usuario) {
        if (listaEscutadoresLoginGov != null) {
            for (LoginGovListener lListener : listaEscutadoresLoginGov.list()) {
                lListener.usuarioLogado(usuario);
            }
        }
    }

    private static void dispatchUsuarioDeslogado() {
        if (listaEscutadoresLoginGov != null) {
            for (LoginGovListener lListener : listaEscutadoresLoginGov.list()) {
                lListener.usuarioDeslogado();
            }
        }
    }

    public static void addLoginGovListener(LoginGovListener pListener) {
        if (listaEscutadoresLoginGov == null) {
            listaEscutadoresLoginGov = new ListenerList();
        }
        listaEscutadoresLoginGov.add(pListener);
    }

    public static void removeLoginGovListener(LoginGovListener pListener) {
        if (listaEscutadoresLoginGov != null) {
            listaEscutadoresLoginGov.remove(pListener);
            if (listaEscutadoresLoginGov.isEmpty()) {
                listaEscutadoresLoginGov = null;
            }
        }
    }

    public static void verificaFichasHabilitadas() {
        ControladorGui.getJanelaPrincipal().setFichaContribuinteHabilitada(ITRFacade.habilitarFichaContribuinte(ControladorGui.getDeclaracaoAberta()));
        ControladorGui.getJanelaPrincipal().setFichaDemaisCondominosHabilitada(ITRFacade.habilitarFichaDemaisCondominos(ControladorGui.getDeclaracaoAberta()));
        ControladorGui.getJanelaPrincipal().setFichaUtilizacaoImovelHabilitada(ITRFacade.habilitarFichaUtilizacaoImovel(ControladorGui.getDeclaracaoAberta()));
        ControladorGui.getJanelaPrincipal().setFichaAreaNaoUtilizadaHabilitada(ITRFacade.habilitarFichaAreaNaoUtilizada(ControladorGui.getDeclaracaoAberta()));
        ControladorGui.getJanelaPrincipal().setFichaCalculoImpostoHabilitada(ITRFacade.habilitarFichaCalculoImposto(ControladorGui.getDeclaracaoAberta()));
        ControladorGui.getJanelaPrincipal().setFichaAtividadePecuariaHabilitada(ITRFacade.habilitarFichaAtividadePecuaria(ControladorGui.getDeclaracaoAberta()));
        ControladorGui.getJanelaPrincipal().setFichaAtividadeExtrativaHabilitada(ITRFacade.habilitarFichaAtividadeExtrativa(ControladorGui.getDeclaracaoAberta()));
    }

    public static class ListenerList<E> {
        private final ArrayList<WeakReference<E>> list = new ArrayList();

        public void add(E e) {
            this.list.add(new WeakReference<E>(e));
        }

        public boolean remove(Object o) {
            return this.list.removeIf(e -> e == null || e.get() == null || Objects.equals(e.get(), o));
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public List<E> list() {
            return this.list.stream().filter(e -> e != null && e.get() != null).map(e -> e.get()).collect(Collectors.toList());
        }
    }
}

