/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Field;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.JEditLogico;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class ControleFocoComSetas {
    private Vector allEditsParaFoco = null;
    protected boolean aceitaSetasComoTab = true;
    private JPanel painel;
    private KeyListener defaultKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10 || e.getKeyChar() == '\t' && !e.isShiftDown() || e.getKeyCode() == 40 && ControleFocoComSetas.this.isAceitaSetasComoTab()) {
                ControleFocoComSetas.this.acionaProximoComponente((Component)e.getSource());
            } else if (e.getKeyChar() == '\t' && e.isShiftDown() || e.getKeyCode() == 38 && ControleFocoComSetas.this.isAceitaSetasComoTab()) {
                ControleFocoComSetas.this.acionaFocoNoComponenteAnterior((Component)e.getSource());
            }
        }
    };

    public ControleFocoComSetas(JPanel aPainel) {
        this.painel = aPainel;
        this.preparaFoco();
    }

    protected void acionaProximoComponente(Component comp) {
        FocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
    }

    protected void acionaFocoNoComponenteAnterior(Component comp) {
        FocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
    }

    protected JEditCampo getUltimoEdit() {
        Vector allEdits = this.getAllEditsParaFoco();
        return (JEditCampo)allEdits.elementAt(allEdits.size() - 1);
    }

    protected JEditCampo getPrimeiroEdit() {
        for (JEditCampo edit : this.getAllEditsParaFoco()) {
            if (edit.getInformacao().isReadOnly()) continue;
            return edit;
        }
        return null;
    }

    protected void setaFocoNoPrimeiroComponente() {
        JEditCampo edit = this.getPrimeiroEdit();
        if (edit != null) {
            edit.getComponenteFoco().requestFocusInWindow();
        }
    }

    public Vector getAllEditsParaFoco() {
        try {
            if (this.allEditsParaFoco == null) {
                this.allEditsParaFoco = new Vector();
                for (Field f : FabricaUtilitarios.getAllFieldsOfSpecificType(this.painel.getClass(), JEditCampo.class)) {
                    boolean acessivel = f.isAccessible();
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    Object conteudo = f.get(this.painel);
                    this.adicionaEdit(conteudo);
                    f.setAccessible(acessivel);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.allEditsParaFoco;
    }

    public Vector getAllButtonsParaFoco() {
        Vector lista = new Vector();
        try {
            for (Field f : FabricaUtilitarios.getAllFieldsOfSpecificType(this.painel.getClass(), JButton.class)) {
                boolean acessivel = f.isAccessible();
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                Object conteudo = f.get(this.painel);
                this.adicionaButton(lista, conteudo);
                f.setAccessible(acessivel);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return lista;
    }

    private void adicionaEdit(Object conteudo) {
        JComponent componenteFoco;
        JEditCampo edit = (JEditCampo)conteudo;
        if (edit != null && (componenteFoco = edit.getComponenteFoco()) != null && (componenteFoco instanceof JTextField || componenteFoco instanceof JTextArea || componenteFoco instanceof JComboBox || componenteFoco instanceof JRadioButton)) {
            this.allEditsParaFoco.add(edit);
        }
    }

    private void adicionaButton(Vector lista, Object conteudo) {
        JButton btn = (JButton)conteudo;
        if (btn != null) {
            lista.add(btn);
        }
    }

    private void preparaFoco() {
        for (JEditCampo edit : this.getAllEditsParaFoco()) {
            edit.setReadOnlyFocusAble(false);
            if (edit.getInformacao().isReadOnly()) {
                edit.getComponenteFoco().setFocusable(false);
            }
            JComponent componenteFoco = edit.getComponenteFoco();
            componenteFoco.setFocusTraversalKeysEnabled(false);
            if (edit instanceof JEditLogico) {
                ((JEditLogico)edit).addListener((EventListener)this.defaultKeyListener);
                continue;
            }
            if (componenteFoco instanceof JTextField) {
                ((JTextField)componenteFoco).addKeyListener(this.defaultKeyListener);
                continue;
            }
            if (componenteFoco instanceof JTextField) {
                ((JTextField)componenteFoco).addKeyListener(this.defaultKeyListener);
                continue;
            }
            if (componenteFoco instanceof JComboBox) {
                componenteFoco.addKeyListener(this.defaultKeyListener);
                continue;
            }
            if (!(componenteFoco instanceof JButton)) continue;
            componenteFoco.addKeyListener(this.defaultKeyListener);
        }
        for (JButton btn : this.getAllButtonsParaFoco()) {
            btn.addKeyListener(this.defaultKeyListener);
        }
    }

    public boolean isAceitaSetasComoTab() {
        return this.aceitaSetasComoTab;
    }

    public void setAceitaSetasComoTab(boolean aceitaSetasComoTab) {
        this.aceitaSetasComoTab = aceitaSetasComoTab;
    }
}

