/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import serpro.ppgd.app.acoes.NovaDeclaracaoAction;
import serpro.ppgd.app.acoes.RecuperarExercicioAnteriorAction;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.itr.ColecaoIdDeclaracao;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.PainelBemVindoToolTip;
import serpro.ppgd.itr.gui.PainelDeclaracaoAb;
import serpro.ppgd.itr.gui.PainelITRBemVindos;
import serpro.ppgd.itr.gui.componente.DashedBorder;
import serpro.ppgd.itr.gui.listener.DeclaracaoListener;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.util.AplicacaoPropertiesUtil;
import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;

public class ITRBemVindos
extends PainelDeclaracaoAb
implements DeclaracaoListener {
    private JButton btnCriarNovaDeclaracao;
    private JButton btnImportarDados;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel lblExercicio_BemVindos;
    private PainelITRBemVindos painelITRBemVindos;
    private static JPanel panelDeclaracoes;
    private JScrollPane scrollDeclaracoes;

    public ITRBemVindos() {
        this.initComponents();
        try {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ITRBemVindos.this.preencherListaDeclaracoesRecentes();
                    }
                });
            } else {
                this.preencherListaDeclaracoesRecentes();
            }
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
        this.btnCriarNovaDeclaracao.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ITRBemVindos.this.btnCriarNovaDeclaracao.setBorder(new DashedBorder(new Color(0, 0, 0), 2, 2, 1));
            }

            @Override
            public void focusLost(FocusEvent e) {
                ITRBemVindos.this.btnCriarNovaDeclaracao.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        });
        this.btnImportarDados.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ITRBemVindos.this.btnImportarDados.setBorder(new DashedBorder(new Color(0, 0, 0), 2, 2, 1));
            }

            @Override
            public void focusLost(FocusEvent e) {
                ITRBemVindos.this.btnImportarDados.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        });
        this.configCursor(this.btnCriarNovaDeclaracao);
        this.configCursor(this.btnImportarDados);
    }

    @Override
    public JComponent getDefaultFocus() {
        return panelDeclaracoes;
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/ITR40x40/receita.png");
    }

    @Override
    public String getTituloPainel() {
        return MensagemUtil.getMensagem("bem_vindos");
    }

    private void initComponents() {
        this.painelITRBemVindos = new PainelITRBemVindos();
        this.jLabel1 = new JLabel();
        this.btnCriarNovaDeclaracao = new JButton();
        this.jLabel10 = new JLabel();
        this.btnImportarDados = new JButton();
        this.scrollDeclaracoes = new JScrollPane();
        panelDeclaracoes = new JPanel();
        this.lblExercicio_BemVindos = new JLabel();
        this.setBackground(new Color(240, 245, 240));
        this.setPreferredSize(new Dimension(647, 551));
        this.setLayout(new GridBagLayout());
        this.painelITRBemVindos.setPreferredSize(new Dimension(689, 541));
        this.jLabel1.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.jLabel1.setForeground(new Color(30, 105, 140));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_abrir.png")));
        this.jLabel1.setText("Abrir Declara\u00e7\u00f5es Recentes");
        this.btnCriarNovaDeclaracao.setAction(new NovaDeclaracaoAction());
        this.btnCriarNovaDeclaracao.setBackground(new Color(255, 255, 255));
        this.btnCriarNovaDeclaracao.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.btnCriarNovaDeclaracao.setForeground(new Color(30, 105, 140));
        this.btnCriarNovaDeclaracao.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_novo.png")));
        this.btnCriarNovaDeclaracao.setText("<html>&nbsp;<br>Criar Nova Declara\u00e7\u00e3o&nbsp;&nbsp;&nbsp;<br>&nbsp;</html>");
        this.btnCriarNovaDeclaracao.setBorder(null);
        this.btnCriarNovaDeclaracao.setContentAreaFilled(false);
        this.btnCriarNovaDeclaracao.setCursor(new Cursor(0));
        this.btnCriarNovaDeclaracao.setFocusPainted(false);
        this.btnCriarNovaDeclaracao.setHorizontalAlignment(2);
        this.jLabel10.setIcon(new ImageIcon(this.getClass().getResource("/imagens/tela-bem-vindos/div_horiz2.png")));
        this.btnImportarDados.setAction(new RecuperarExercicioAnteriorAction());
        this.btnImportarDados.setBackground(new Color(255, 255, 255));
        this.btnImportarDados.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.btnImportarDados.setForeground(new Color(30, 105, 140));
        this.btnImportarDados.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_import.png")));
        this.btnImportarDados.setText("<html>&nbsp;<br>Importar Dados ITR " + ConstantesGlobais.EXERCICIO_ANTERIOR + "&nbsp;&nbsp;&nbsp;<br>&nbsp;</html>");
        this.btnImportarDados.setBorder(null);
        this.btnImportarDados.setContentAreaFilled(false);
        this.btnImportarDados.setCursor(new Cursor(0));
        this.btnImportarDados.setFocusPainted(false);
        this.btnImportarDados.setHorizontalAlignment(2);
        this.btnImportarDados.setPreferredSize(new Dimension(146, 45));
        this.scrollDeclaracoes.setBorder(BorderFactory.createLineBorder(new Color(175, 196, 214)));
        panelDeclaracoes.setBackground(new Color(233, 248, 233));
        panelDeclaracoes.setLayout(new GridLayout(10, 0));
        this.scrollDeclaracoes.setViewportView(panelDeclaracoes);
        this.lblExercicio_BemVindos.setFont(new Font("Ubuntu", 1, 36));
        this.lblExercicio_BemVindos.setForeground(new Color(100, 157, 120));
        this.lblExercicio_BemVindos.setText(AplicacaoPropertiesUtil.getExercicio());
        GroupLayout painelITRBemVindosLayout = new GroupLayout(this.painelITRBemVindos);
        this.painelITRBemVindos.setLayout(painelITRBemVindosLayout);
        painelITRBemVindosLayout.setHorizontalGroup(painelITRBemVindosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelITRBemVindosLayout.createSequentialGroup().addGroup(painelITRBemVindosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelITRBemVindosLayout.createSequentialGroup().addGap(38, 38, 38).addGroup(painelITRBemVindosLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel10, -1, -1, Short.MAX_VALUE).addComponent(this.btnCriarNovaDeclaracao, -2, -1, -2).addComponent(this.btnImportarDados, -1, -1, Short.MAX_VALUE)).addGap(43, 43, 43).addGroup(painelITRBemVindosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.scrollDeclaracoes, -2, 317, -2))).addGroup(painelITRBemVindosLayout.createSequentialGroup().addGap(202, 202, 202).addComponent(this.lblExercicio_BemVindos, -2, 110, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        painelITRBemVindosLayout.setVerticalGroup(painelITRBemVindosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelITRBemVindosLayout.createSequentialGroup().addGap(45, 45, 45).addComponent(this.lblExercicio_BemVindos, -2, 34, -2).addGap(130, 130, 130).addGroup(painelITRBemVindosLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, painelITRBemVindosLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollDeclaracoes, -2, 149, -2).addGap(194, 194, 194)).addGroup(GroupLayout.Alignment.TRAILING, painelITRBemVindosLayout.createSequentialGroup().addComponent(this.btnCriarNovaDeclaracao, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10, -2, 9, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnImportarDados, -2, 24, -2).addGap(235, 235, 235))).addGap(0, 0, Short.MAX_VALUE)));
        this.add((Component)this.painelITRBemVindos, new GridBagConstraints());
    }

    public void atualizarListaDeclaracoesRecentes() {
        this.preencherListaDeclaracoesRecentes();
    }

    private void preencherListaDeclaracoesRecentes() {
        panelDeclaracoes.removeAll();
        List<IdentificadorDeclaracao> listaDeclaracoesRecentes = ITRFacade.getListaDeclaracoesRecentes();
        if (listaDeclaracoesRecentes.size() > 5) {
            panelDeclaracoes.setLayout(new GridLayout(listaDeclaracoesRecentes.size(), 0));
        } else {
            panelDeclaracoes.setLayout(new GridLayout(5, 0));
        }
        for (ObjetoNegocio objetoNegocio : listaDeclaracoesRecentes) {
            IdentificadorDeclaracao idDeclaracao = (IdentificadorDeclaracao)objetoNegocio;
            panelDeclaracoes.add(this.getItemDeclaracao(idDeclaracao));
        }
        this.validate();
        this.repaint();
    }

    private JLabel getItemDeclaracao(IdentificadorDeclaracao idDeclaracao) {
        final int retificadora = idDeclaracao.getRetificadora().formatado().equals(Logico.SIM) ? 2 : (idDeclaracao.getRetificadora().formatado().equals(Logico.NAO) ? 1 : 0);
        int status = ITRFacade.obterStatusIdImovel(idDeclaracao);
        final int gravadaTransmitida = status == 1 ? 1 : (status == 3 ? 2 : 0);
        final String niContribuinte = idDeclaracao.getNiContribuinte().isVazio() ? "" : idDeclaracao.getNiContribuinte().naoFormatado();
        final JLabel lblDeclaracao = new JLabel(){

            @Override
            public JToolTip createToolTip() {
                return new PainelBemVindoToolTip(retificadora, gravadaTransmitida, niContribuinte);
            }

            @Override
            public Point getToolTipLocation(MouseEvent event) {
                return new Point(-200, -80);
            }
        };
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.unregisterComponent(lblDeclaracao);
        lblDeclaracao.setFont(FontesUtil.FONTE_MENOR);
        lblDeclaracao.setForeground(new Color(30, 105, 140));
        if (idDeclaracao.getNomeImovel().naoFormatado().length() == 0) {
            lblDeclaracao.setText(ITRUtil.formatarIdentificacaoImovel(idDeclaracao.getNirf().naoFormatado()));
        } else {
            lblDeclaracao.setText(ITRUtil.formatarIdentificacaoImovel(idDeclaracao.getNirf().naoFormatado()) + " - " + idDeclaracao.getNomeImovel().naoFormatado());
        }
        lblDeclaracao.setIcon(GuiUtil.getImage("/icones/png20px/MN_novo.png"));
        lblDeclaracao.setHorizontalAlignment(2);
        lblDeclaracao.setBackground(new Color(233, 248, 233));
        lblDeclaracao.setOpaque(true);
        lblDeclaracao.setToolTipText("<html>&nbsp;<br>&nbsp;<br>&nbsp;<br>&nbsp;<br>&nbsp;<br>&nbsp;<br>&nbsp;<br>&nbsp;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</html>");
        lblDeclaracao.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                String nirfSelecionado = ((JLabel)evt.getSource()).getText();
                nirfSelecionado = ITRUtil.limparFormatacaoIdentificacaoImovel(nirfSelecionado);
                nirfSelecionado = nirfSelecionado.substring(0, 8);
                IdentificadorDeclaracao idDeclaracao = null;
                ColecaoIdDeclaracao colIdDeclaracoes = ITRFacade.getListaIdDeclaracoes();
                for (IdentificadorDeclaracao idDec : colIdDeclaracoes.itens()) {
                    if (!idDec.getNirf().naoFormatado().equals(nirfSelecionado)) continue;
                    idDeclaracao = idDec;
                    break;
                }
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                try {
                    ControladorGui.abrirDeclaracao(idDeclaracao, true);
                }
                catch (HashInvalidoException e) {
                    ControladorGui.tratarException((Exception)((Object)e));
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getPredefinedCursor(12));
                lblDeclaracao.setBackground(Color.white);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                lblDeclaracao.setBackground(new Color(233, 248, 233));
            }
        });
        return lblDeclaracao;
    }

    @Override
    public void declaracaoAberta() {
    }

    @Override
    public void declaracaoFechado() {
    }

    @Override
    public void declaracaoSalva() {
    }

    @Override
    public void mudouNumerodeclaracoes() {
        this.preencherListaDeclaracoesRecentes();
    }

    @Override
    public boolean declaracaoVaiFechar() {
        return true;
    }

    @Override
    public boolean isTelaComAjuda() {
        return false;
    }

    public void configCursor(JComponent component) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }
}

