/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;

public abstract class ITRTableModelAb
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private ObjetoNegocio objetoNegocio = null;
    public static final String ALINHA_DIREITA = "right";
    public static final String ALINHA_ESQUERDA = "left";
    public static final String ALINHA_CENTRO = "center";
    private Observador observadorColecao = new Observador(){

        public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            if (nomePropriedade.equals("ObjetoInserido") || nomePropriedade.equals("ObjetoRemovido")) {
                ITRTableModelAb.this.fireTableDataChanged();
            }
        }
    };

    public ITRTableModelAb(ObjetoNegocio pObj) {
        this.setObjetoNegocio(pObj);
    }

    protected JPanel getCelulaMes(int row) {
        JLabel lbl = new JLabel();
        lbl.setHorizontalAlignment(0);
        lbl.setVerticalAlignment(0);
        switch (row) {
            case 0: {
                lbl.setText("JAN");
                break;
            }
            case 1: {
                lbl.setText("FEV");
                break;
            }
            case 2: {
                lbl.setText("MAR");
                break;
            }
            case 3: {
                lbl.setText("ABR");
                break;
            }
            case 4: {
                lbl.setText("MAI");
                break;
            }
            case 5: {
                lbl.setText("JUN");
                break;
            }
            case 6: {
                lbl.setText("JUL");
                break;
            }
            case 7: {
                lbl.setText("AGO");
                break;
            }
            case 8: {
                lbl.setText("SET");
                break;
            }
            case 9: {
                lbl.setText("OUT");
                break;
            }
            case 10: {
                lbl.setText("NOV");
                break;
            }
            case 11: {
                lbl.setText("DEZ");
                break;
            }
            case 12: {
                lbl.setText("Total");
                lbl.setFont(lbl.getFont().deriveFont(1));
            }
        }
        if (row < 12) {
            lbl.setForeground(new Color(11, 56, 90));
        }
        JPanel lPanel = new JPanel();
        lPanel.setLayout(new BorderLayout());
        lPanel.add((Component)lbl, "Center");
        return lPanel;
    }

    public void setObjetoNegocio(ObjetoNegocio pObj) {
        if (this.objetoNegocio != null && this.objetoNegocio instanceof Colecao) {
            ((Colecao)this.objetoNegocio).removeObservador(this.observadorColecao);
        }
        if (pObj != null && pObj instanceof Colecao) {
            ((Colecao)pObj).addObservador(this.observadorColecao);
        }
        this.objetoNegocio = pObj;
        this.fireTableDataChanged();
    }

    public ObjetoNegocio getObjetoNegocio() {
        return this.objetoNegocio;
    }

    @Override
    public int getRowCount() {
        return ((Colecao)this.getObjetoNegocio()).recuperarLista().size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        JLabel lbl = new JLabel();
        lbl.setText(this.getValorExibir(rowIndex, columnIndex));
        String desAlinhamento = this.getDesAlinhamento(rowIndex, columnIndex);
        JPanel lPanel = new JPanel();
        if (ALINHA_CENTRO.equals(desAlinhamento)) {
            lPanel.setLayout(new FlowLayout(1));
        } else if (ALINHA_DIREITA.equals(desAlinhamento)) {
            lPanel.setLayout(new FlowLayout(2));
        } else {
            lPanel.setLayout(new FlowLayout(0));
        }
        lPanel.add(lbl);
        if (rowIndex % 2 == 0) {
            lPanel.setBackground(UIManager.getColor("Table.background"));
        } else {
            lPanel.setBackground(UIManager.getColor("Table.alternateRowColor"));
        }
        return lPanel;
    }

    public String getValorExibir(int rowIndex, int columnIndex) {
        Informacao lInformacao = this.getInformacaoAt(rowIndex, columnIndex);
        if (lInformacao != null) {
            return lInformacao.getConteudoFormatado();
        }
        return null;
    }

    protected String getDesAlinhamento(int rowIndex, int columnIndex) {
        return ALINHA_ESQUERDA;
    }

    public abstract Informacao getInformacaoAt(int var1, int var2);

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void refresh() {
        this.fireTableDataChanged();
    }

    @Override
    public void addTableModelListener(TableModelListener pListener) {
        pListener.tableChanged(new TableModelEvent(this));
        super.addTableModelListener(pListener);
    }
}

