/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import serpro.ppgd.itr.gui.IdImovel;
import serpro.ppgd.itr.gui.ListaDeclaracaoTableModel;
import serpro.ppgd.itr.gui.PainelLegendaNirf;

public class ListaDecITRTable
extends JTable {
    public ListaDecITRTable() {
        this.setBackground(Color.WHITE);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setForeground(new Color(0, 76, 119));
        this.getTableHeader().setFont(this.getTableHeader().getFont().deriveFont(1));
        this.getTableHeader().setPreferredSize(new Dimension(this.getTableHeader().getWidth(), 25));
        this.setShowGrid(false);
        this.setRowHeight(25);
        this.setDefaultRenderer(IdImovel.class, new NirfImovelCellRenderer(true));
    }

    public void setShowIcone(boolean comIcones) {
        this.setDefaultRenderer(IdImovel.class, new NirfImovelCellRenderer(comIcones));
        this.repaint();
    }

    public ListaDecITRTable(TableModel dm) {
        super(dm);
    }

    public TableModel getDefaultModel() {
        return new ListaDeclaracaoTableModel(){

            @Override
            public IdImovel novoIdImovel(int index) {
                return new IdImovel();
            }
        };
    }

    private static class NirfImovelCellRenderer
    extends PainelLegendaNirf
    implements TableCellRenderer {
        private ImageIcon iconGravada = new ImageIcon(this.getClass().getResource("/icones/png16px/AB_gravado.png"));
        private ImageIcon iconTransmitida = new ImageIcon(this.getClass().getResource("/icones/png16px/AB_transmitido.png"));
        private ImageIcon iconRetificadora = new ImageIcon(this.getClass().getResource("/icones/png16px/AB_retif.png"));
        private ImageIcon iconOriginal = new ImageIcon(this.getClass().getResource("/icones/png16px/AB_original.png"));
        private boolean comIcones;

        public NirfImovelCellRenderer(boolean comIcones) {
            this.comIcones = comIcones;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            IdImovel idImovel = (IdImovel)value;
            this.getLblNirf().setText(idImovel.getNirf());
            if (this.comIcones) {
                if (idImovel.getStatus() == 1) {
                    this.getLblGravada().setIcon(this.iconGravada);
                } else if (idImovel.getStatus() == 3) {
                    this.getLblGravada().setIcon(this.iconTransmitida);
                } else {
                    this.getLblGravada().setIcon(null);
                }
            }
            if (idImovel.isRetificadora() != null) {
                if (idImovel.isRetificadora().booleanValue()) {
                    this.getLblOriginal().setIcon(this.iconRetificadora);
                } else {
                    this.getLblOriginal().setIcon(this.iconOriginal);
                }
            } else {
                this.getLblOriginal().setIcon(null);
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.getLblGravada().setForeground(table.getSelectionForeground());
                this.getLblOriginal().setForeground(table.getSelectionForeground());
                this.getLblNirf().setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.getLblGravada().setForeground(table.getForeground());
                this.getLblOriginal().setForeground(table.getForeground());
                this.getLblNirf().setForeground(table.getForeground());
            }
            return this;
        }
    }
}

