/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.gui.util.MonitorProgressoIf;
import serpro.ppgd.itr.gui.util.TarefaMonitorada;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class PainelBarraProgresso
extends JPanel
implements MonitorProgressoIf {
    private int progress;
    private int offset;
    private TarefaMonitorada tarefa;
    private boolean cancelado;
    private String titulo;
    private boolean ehMac = FabricaUtilitarios.isMac();
    private JButton btnCancelar;
    private JPanel jPanel1;
    private JProgressBar pgbProgresso;

    public PainelBarraProgresso() {
        this.initComponents();
        this.titulo = "";
        this.cancelado = false;
        this.progress = 0;
        this.offset = 0;
        this.setTarefa(null);
        this.pgbProgresso.setMinimum(0);
        this.pgbProgresso.setMaximum(0);
        this.pgbProgresso.setValue(this.progress);
        this.pgbProgresso.setStringPainted(true);
    }

    public PainelBarraProgresso(String titulo, TarefaMonitorada tarefa) {
        this();
        this.titulo = titulo;
        this.setTarefa(tarefa);
    }

    @Override
    public void exibir() {
        if (this.ehMac) {
            this.exibeJanelaMac();
        } else {
            this.exibeJanelaOutrosSistemas();
        }
    }

    private void exibeJanelaOutrosSistemas() {
        JDialog dlg = GuiUtil.novoDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), this, true, this.getTitulo(), false);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                PainelBarraProgresso.this.getTarefa().start();
            }
        });
        dlg.setVisible(true);
    }

    private void exibeJanelaMac() {
        JFrame frame = new JFrame(this.getTitulo());
        frame.setContentPane(this);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                PainelBarraProgresso.this.getTarefa().start();
            }
        });
        frame.setVisible(true);
    }

    private void initComponents() {
        this.pgbProgresso = new JProgressBar();
        this.jPanel1 = new JPanel();
        this.btnCancelar = new JButton();
        this.btnCancelar.setIcon(new ImageIcon(this.getClass().getResource("/icones/CANCELAR.PNG")));
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBarraProgresso.this.btnCancelarActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(103, Short.MAX_VALUE).add((Component)this.btnCancelar).add(98, 98, 98)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.btnCancelar));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pgbProgresso, -1, 290, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.pgbProgresso, -2, -1, -2).addPreferredGap(1).add((Component)this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        this.cancelado = true;
    }

    public JProgressBar getPgbProgresso() {
        return this.pgbProgresso;
    }

    @Override
    public int getMaximum() {
        return this.pgbProgresso.getMaximum();
    }

    @Override
    public void setMaximum(int max) {
        this.pgbProgresso.setMaximum(max);
    }

    @Override
    public int getMinimum() {
        return this.pgbProgresso.getMinimum();
    }

    @Override
    public void setMinimum(int min) {
        this.pgbProgresso.setMinimum(min);
    }

    public int getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress;
        if (progress <= this.getMaximum()) {
            if (this.getOffset() != 0 && progress % this.getOffset() != 0) {
                return;
            }
            this.getPgbProgresso().setValue(this.getProgress());
            try {
                if (this.ehMac) {
                    Container con = this.getTopLevelAncestor();
                    ((JFrame)con).toFront();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public void close() {
        Component janela = GuiUtil.getParent(this);
        janela.setVisible(false);
        if (this.ehMac) {
            ((JFrame)janela).dispose();
        } else {
            ((JDialog)janela).dispose();
        }
    }

    @Override
    public boolean isCanceled() {
        return this.cancelado;
    }

    @Override
    public void setNote(String note) {
        if (this.progress <= this.getMaximum()) {
            if (this.getOffset() != 0 && this.progress % this.getOffset() != 0) {
                return;
            }
            this.getPgbProgresso().setString(note);
        }
    }

    @Override
    public String getNote() {
        return this.getPgbProgresso().getString();
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public TarefaMonitorada getTarefa() {
        return this.tarefa;
    }

    public void setTarefa(TarefaMonitorada tarefa) {
        this.tarefa = tarefa;
        if (tarefa != null) {
            this.tarefa.setMonitor(this);
        }
    }
}

