/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.LayoutStyle;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.itr.gui.PainelFundoToolTip;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.negocio.util.UtilitariosString;

public class PainelBemVindoToolTip
extends JToolTip {
    public static final int CONTRIBUINTE_CPF = 11;
    public static final int CONTRIBUINTE_CNPJ = 14;
    public static final int DEC_ORIGINAL = 1;
    public static final int DEC_RETIFICADORA = 2;
    public static final int DEC_GRAVADA = 1;
    public static final int DEC_TRANSMITIDA = 2;
    public static final int DEC_SEM_ESTADO = 0;
    private JLabel jLabel1;
    private JLabel lblGravadaTransmitida;
    private JLabel lblNIContribuinte;
    private JLabel lblOriginalRetificadora;
    private PainelFundoToolTip painelFundoToolTip1;

    public PainelBemVindoToolTip(int originalOuRertificadora, int GravadaOuTransmitida, String niContribuinte) {
        this.initComponents();
        this.montarToolTip(originalOuRertificadora, GravadaOuTransmitida, niContribuinte);
        this.setBounds(200, 100, 100, 100);
    }

    private void initComponents() {
        this.painelFundoToolTip1 = new PainelFundoToolTip();
        this.jLabel1 = new JLabel();
        this.lblOriginalRetificadora = new JLabel();
        this.lblGravadaTransmitida = new JLabel();
        this.lblNIContribuinte = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(null);
        this.setOpaque(false);
        this.painelFundoToolTip1.setOpaque(false);
        this.jLabel1.setBackground(new Color(204, 204, 204));
        this.jLabel1.setFont(FontesUtil.FONTE_XMENOR);
        this.jLabel1.setForeground(new Color(30, 105, 140));
        this.jLabel1.setText("Status da Declara\u00e7\u00e3o");
        this.lblOriginalRetificadora.setFont(FontesUtil.FONTE_NORMAL);
        this.lblOriginalRetificadora.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/AB_original.png")));
        this.lblOriginalRetificadora.setText("Original");
        this.lblGravadaTransmitida.setFont(FontesUtil.FONTE_NORMAL);
        this.lblGravadaTransmitida.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/AB_transmitido.png")));
        this.lblGravadaTransmitida.setText("Transmitida");
        this.lblNIContribuinte.setBackground(new Color(204, 204, 204));
        this.lblNIContribuinte.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNIContribuinte.setForeground(new Color(30, 105, 140));
        this.lblNIContribuinte.setText("CPF/CNPJ Contribuinte");
        GroupLayout painelFundoToolTip1Layout = new GroupLayout(this.painelFundoToolTip1);
        this.painelFundoToolTip1.setLayout(painelFundoToolTip1Layout);
        painelFundoToolTip1Layout.setHorizontalGroup(painelFundoToolTip1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelFundoToolTip1Layout.createSequentialGroup().addContainerGap().addGroup(painelFundoToolTip1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 126, -2).addGroup(painelFundoToolTip1Layout.createSequentialGroup().addComponent(this.lblOriginalRetificadora).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblGravadaTransmitida)).addComponent(this.lblNIContribuinte, -2, 161, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        painelFundoToolTip1Layout.setVerticalGroup(painelFundoToolTip1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelFundoToolTip1Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNIContribuinte, -2, 21, -2).addGap(9, 9, 9).addGroup(painelFundoToolTip1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblOriginalRetificadora).addComponent(this.lblGravadaTransmitida)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.painelFundoToolTip1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.painelFundoToolTip1, -1, -1, Short.MAX_VALUE));
    }

    private void montarToolTip(int originalOuRertificadora, int GravadaOuTransmitida, String niContribuinte) {
        if (niContribuinte != null && !niContribuinte.trim().isEmpty()) {
            if (niContribuinte.trim().length() == 11) {
                this.lblNIContribuinte.setText("CPF: " + UtilitariosString.formataCPF((String)niContribuinte));
            } else if (niContribuinte.trim().length() == 14) {
                this.lblNIContribuinte.setText("CNPJ: " + UtilitariosString.formataCNPJ((String)niContribuinte));
            } else {
                this.lblNIContribuinte.setText("CPF/CNPJ inv\u00e1lido");
            }
        } else {
            this.lblNIContribuinte.setText("CPF/CNPJ n\u00e3o informado");
        }
        switch (originalOuRertificadora) {
            case 1: {
                this.configurarLabel(this.lblOriginalRetificadora, "Original", GuiUtil.getImage("/icones/png16px/AB_original.png"), true);
                break;
            }
            case 2: {
                this.configurarLabel(this.lblOriginalRetificadora, "Retificadora", GuiUtil.getImage("/icones/png16px/AB_retif.png"), true);
                break;
            }
            default: {
                this.configurarLabel(this.lblOriginalRetificadora, " ", null, false);
            }
        }
        switch (GravadaOuTransmitida) {
            case 1: {
                this.configurarLabel(this.lblGravadaTransmitida, "Gravada", GuiUtil.getImage("/icones/png16px/AB_gravado.png"), true);
                break;
            }
            case 2: {
                this.configurarLabel(this.lblGravadaTransmitida, "Transmitida", GuiUtil.getImage("/icones/png16px/AB_transmitido.png"), true);
                break;
            }
            default: {
                this.configurarLabel(this.lblGravadaTransmitida, " ", null, false);
            }
        }
    }

    private void configurarLabel(JLabel label, String texto, ImageIcon icone, boolean visivel) {
        label.setText(texto);
        label.setFont(FontesUtil.FONTE_XMENOR);
        label.setIcon(icone);
        label.setVisible(visivel);
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        return new Point(100, 100);
    }
}

