/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.app.PlataformaITRPGD;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.itr.gui.HoraSalvamentoPanel;
import serpro.ppgd.itr.gui.PainelDeclaracaoIf;
import serpro.ppgd.itr.gui.componente.BarraTitulo;
import serpro.ppgd.itr.gui.componente.MensagemPanel;
import serpro.ppgd.itr.gui.listener.CabecalhoFichaListener;
import serpro.ppgd.itr.gui.listener.HelpListener;
import serpro.ppgd.itr.gui.listener.MensagemFichaListener;
import serpro.ppgd.negocio.util.LogPPGD;

public class PainelContainer
extends JPanel
implements CabecalhoFichaListener,
MensagemFichaListener,
HelpListener {
    private static final long serialVersionUID = 1L;
    private BarraTitulo barraTitulo1;
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnImprimir;
    private JButton btnVoltar;
    private HoraSalvamentoPanel horaSalvamentoPanel1;
    private JPanel jPanel1;
    public JPanel pnlAreaUtil;
    private MensagemPanel pnlMensagem;
    private JScrollPane scrollAreaProg;

    public PainelContainer() {
        this.initComponents();
    }

    public PainelContainer(PainelDeclaracaoIf painel) {
        this();
        this.mudaCorpoPainelPrincipal(painel);
    }

    public void setImagem(ImageIcon pIcon) {
        this.barraTitulo1.getLblIcone().setIcon(pIcon);
    }

    public ImageIcon getImagem() {
        return (ImageIcon)this.barraTitulo1.getLblIcone().getIcon();
    }

    private void initComponents() {
        this.barraTitulo1 = new BarraTitulo();
        this.pnlAreaUtil = new JPanel();
        this.scrollAreaProg = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.btnVoltar = new JButton();
        this.btnCancelar = new JButton();
        this.btnImprimir = new JButton();
        this.btnAjuda = new JButton();
        this.horaSalvamentoPanel1 = new HoraSalvamentoPanel();
        this.pnlMensagem = new MensagemPanel();
        this.setFocusCycleRoot(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.barraTitulo1, "First");
        this.pnlAreaUtil.setBackground(new Color(238, 238, 238));
        this.pnlAreaUtil.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(5, 5, 0, 5)));
        this.scrollAreaProg.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel1.setBackground(new Color(238, 238, 238));
        this.jPanel1.setLayout(new FlowLayout(2));
        this.btnVoltar.setText("OK");
        this.btnVoltar.setToolTipText("Retornar a tela principal");
        this.btnVoltar.setPreferredSize(new Dimension(98, 25));
        this.jPanel1.add(this.btnVoltar);
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.setPreferredSize(new Dimension(98, 25));
        this.jPanel1.add(this.btnCancelar);
        this.btnImprimir.setText("Imprimir");
        this.btnImprimir.setToolTipText("Imprimir");
        this.btnImprimir.setPreferredSize(new Dimension(98, 25));
        this.jPanel1.add(this.btnImprimir);
        this.btnAjuda.setText("Ajuda");
        this.btnAjuda.setToolTipText("Ajuda");
        this.btnAjuda.setPreferredSize(new Dimension(98, 25));
        this.jPanel1.add(this.btnAjuda);
        this.horaSalvamentoPanel1.setBackground(new Color(238, 238, 238));
        GroupLayout pnlAreaUtilLayout = new GroupLayout((Container)this.pnlAreaUtil);
        this.pnlAreaUtil.setLayout((LayoutManager)pnlAreaUtilLayout);
        pnlAreaUtilLayout.setHorizontalGroup((GroupLayout.Group)pnlAreaUtilLayout.createParallelGroup(1).add((GroupLayout.Group)pnlAreaUtilLayout.createSequentialGroup().add((Component)this.horaSalvamentoPanel1, -1, 167, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jPanel1, -1, 452, Short.MAX_VALUE)).add((Component)this.scrollAreaProg, -1, 631, Short.MAX_VALUE).add((Component)this.pnlMensagem, -1, 631, Short.MAX_VALUE));
        pnlAreaUtilLayout.setVerticalGroup((GroupLayout.Group)pnlAreaUtilLayout.createParallelGroup(1).add(2, (GroupLayout.Group)pnlAreaUtilLayout.createSequentialGroup().add((Component)this.pnlMensagem, -2, -1, -2).addPreferredGap(0).add((Component)this.scrollAreaProg, -1, 146, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)pnlAreaUtilLayout.createParallelGroup(1).add((Component)this.jPanel1, -1, 39, Short.MAX_VALUE).add((Component)this.horaSalvamentoPanel1, -2, -1, -2))));
        pnlAreaUtilLayout.linkSize(new Component[]{this.horaSalvamentoPanel1, this.jPanel1}, 2);
        this.add((Component)this.pnlAreaUtil, "Center");
    }

    public void mudaCorpoPainelPrincipal(final PainelDeclaracaoIf pPainel) {
        this.pnlMensagem.setVisible(pPainel.isTelaComMensagem());
        if (pPainel.isTelaComMensagem()) {
            this.pnlMensagem.setMensagem(pPainel.getMensagemTela());
        }
        this.scrollAreaProg.getViewport().removeAll();
        this.scrollAreaProg.getViewport().add((JPanel)((Object)pPainel));
        this.barraTitulo1.getLblTitulo().setText(pPainel.getTituloPainel());
        this.barraTitulo1.getLblTitulo().getAccessibleContext().setAccessibleName(pPainel.getTituloPainel());
        this.scrollAreaProg.getViewport().validate();
        if (pPainel.isTelaComVoltar()) {
            this.btnVoltar.setVisible(true);
            this.btnVoltar.setAction(new AbstractAction("OK"){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    pPainel.executaVoltar();
                }
            });
            this.btnVoltar.setMnemonic(79);
            this.btnVoltar.setToolTipText("Voltar \u00e0 tela principal");
        } else {
            this.btnVoltar.setVisible(false);
        }
        if (pPainel.isTelaComCancelar()) {
            this.btnCancelar.setVisible(true);
            this.btnCancelar.setAction(new AbstractAction("Cancelar"){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    pPainel.executaCancelar();
                }
            });
            this.btnCancelar.setMnemonic(67);
            this.btnCancelar.setToolTipText("Cancelar");
        } else {
            this.btnCancelar.setVisible(false);
        }
        if (pPainel.isTelaComImpressao()) {
            this.btnImprimir.setVisible(true);
            this.btnImprimir.setAction(new AbstractAction("Imprimir"){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    pPainel.executaImpressao();
                }
            });
            this.btnImprimir.setMnemonic(73);
            this.btnImprimir.setToolTipText("Imprimir");
        } else {
            this.btnImprimir.setVisible(false);
        }
        if (pPainel.isTelaComAjuda()) {
            if (pPainel.getHelpID() != null) {
                PlataformaPPGD plataforma = PlataformaPPGD.getPlataforma();
                ((PlataformaITRPGD)plataforma).getHelpPDF().setHelpID(this.btnAjuda, pPainel.getHelpID());
            } else {
                LogPPGD.erro((String)("Aten\u00e7\u00e3o! A tela " + pPainel.getClass().getName() + " possui Ajuda mas n\u00e3o possui HelpID!"));
            }
            this.btnAjuda.setVisible(true);
            this.btnAjuda.setToolTipText("Ajuda");
            this.btnAjuda.setMnemonic(74);
        } else {
            this.btnAjuda.setVisible(false);
        }
    }

    @Override
    public void cabecalhoAlterado(String novoTextoCabecalho) {
        this.barraTitulo1.getLblTitulo().setText(novoTextoCabecalho);
    }

    @Override
    public void mensagemAlterada(String novaMensagem) {
        this.pnlMensagem.setMensagem(novaMensagem);
    }

    @Override
    public void helpIdAlterado(String novoHelpId) {
        PlataformaPPGD plataforma = PlataformaPPGD.getPlataforma();
        ((PlataformaITRPGD)plataforma).getHelpPDF().setHelpID(this.btnAjuda, novoHelpId);
    }

    public HoraSalvamentoPanel getHoraSalvamentoPanel1() {
        return this.horaSalvamentoPanel1;
    }

    public JButton getBtnAjuda() {
        return this.btnAjuda;
    }
}

