/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;

public class Toast
extends JDialog {
    private static final long serialVersionUID = -1602907470843951525L;
    public static final int LENGTH_SHORT = 3000;
    public static final int LENGTH_LONG = 6000;
    public static final Color ERROR_RED = new Color(121, 0, 0);
    public static final Color SUCCESS_GREEN = new Color(22, 127, 57);
    public static final Color NORMAL_BLACK = new Color(0, 0, 0);
    private final float MAX_OPACITY = 0.8f;
    private final float OPACITY_INCREMENT = 0.05f;
    private final int FADE_REFRESH_RATE = 20;
    private final int WINDOW_RADIUS = 15;
    private final int CHARACTER_LENGTH_MULTIPLIER = 7;
    private final int DISTANCE_FROM_PARENT_TOP = 100;
    private JFrame mOwner;
    private String mText;
    private int mDuration;
    private Color mBackgroundColor = Color.BLACK;
    private Color mForegroundColor = Color.WHITE;
    protected boolean translucencySuported = false;

    public Toast(JFrame owner) {
        super(owner);
        this.mOwner = owner;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        this.translucencySuported = graphicsDevice.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
    }

    private void createGUI() {
        this.setLayout(new GridBagLayout());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Toast.this.setShape(new RoundRectangle2D.Double(0.0, 0.0, Toast.this.getWidth(), Toast.this.getHeight(), 15.0, 15.0));
            }
        });
        this.setAlwaysOnTop(true);
        this.setUndecorated(true);
        this.setFocusableWindowState(false);
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.setSize(this.mText.length() * 7, 25);
        this.getContentPane().setBackground(this.mBackgroundColor);
        JLabel label = new JLabel(this.mText);
        label.setForeground(this.mForegroundColor);
        this.add(label);
    }

    public void fadeIn() {
        final Timer timer = new Timer(20, null);
        timer.setRepeats(true);
        timer.addActionListener(new ActionListener(){
            private float opacity = 0.0f;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.opacity += 0.05f;
                Toast.this.setOpacity(Math.min(this.opacity, 0.8f));
                if (this.opacity >= 0.8f) {
                    timer.stop();
                }
            }
        });
        if (this.translucencySuported) {
            this.setOpacity(0.0f);
            timer.start();
        }
        this.setLocation(this.getToastLocation());
        this.setVisible(true);
    }

    public void fadeOut() {
        final Timer timer = new Timer(20, null);
        timer.setRepeats(true);
        timer.addActionListener(new ActionListener(){
            private float opacity = 0.8f;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.opacity -= 0.05f;
                Toast.this.setOpacity(Math.max(this.opacity, 0.0f));
                if (this.opacity <= 0.0f) {
                    timer.stop();
                    Toast.this.setVisible(false);
                    Toast.this.dispose();
                }
            }
        });
        if (this.translucencySuported) {
            this.setOpacity(0.8f);
            timer.start();
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private Point getToastLocation() {
        Point ownerLoc = this.mOwner.getLocation();
        int x = (int)(ownerLoc.getX() + (double)((this.mOwner.getWidth() - this.getWidth()) / 2));
        int y = (int)(ownerLoc.getY() + 100.0);
        return new Point(x, y);
    }

    public void setText(String text) {
        this.mText = text;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    @Override
    public void setBackground(Color backgroundColor) {
        this.mBackgroundColor = backgroundColor;
    }

    @Override
    public void setForeground(Color foregroundColor) {
        this.mForegroundColor = foregroundColor;
    }

    public static Toast makeText(JFrame owner, String text) {
        return Toast.makeText(owner, text, 3000);
    }

    public static Toast makeText(JFrame owner, String text, Style style) {
        return Toast.makeText(owner, text, 3000, style);
    }

    public static Toast makeText(JFrame owner, String text, int duration) {
        return Toast.makeText(owner, text, duration, Style.NORMAL);
    }

    public static Toast makeText(JFrame owner, String text, int duration, Style style) {
        Toast toast = new Toast(owner);
        toast.mText = text;
        toast.mDuration = duration;
        if (style == Style.SUCCESS) {
            toast.mBackgroundColor = SUCCESS_GREEN;
        }
        if (style == Style.ERROR) {
            toast.mBackgroundColor = ERROR_RED;
        }
        if (style == Style.NORMAL) {
            toast.mBackgroundColor = NORMAL_BLACK;
        }
        return toast;
    }

    public void display() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Toast.this.createGUI();
                    Toast.this.fadeIn();
                    Thread.sleep(Toast.this.mDuration);
                    Toast.this.fadeOut();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }).start();
    }

    public static enum Style {
        NORMAL,
        SUCCESS,
        ERROR;

    }
}

