/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.aquisicaoalienacao;

import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.itr.aquisicaoalienacao.AquisicaoParcial;
import serpro.ppgd.itr.aquisicaoalienacao.InformacaoAquisicao;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.ITRTableAb;
import serpro.ppgd.itr.gui.ITRTableModelAb;
import serpro.ppgd.itr.gui.PainelAbaIf;
import serpro.ppgd.itr.gui.PainelDeclaracaoIf;
import serpro.ppgd.itr.gui.PainelListaAb;
import serpro.ppgd.itr.gui.TableLista;
import serpro.ppgd.itr.gui.TableListaModel;
import serpro.ppgd.itr.gui.aquisicaoalienacao.PainelAquisicaoParcialDetalhe;
import serpro.ppgd.itr.gui.aquisicaoalienacao.TableModelAquisicaoParcial;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelAbaAquisicaoParcialLista
extends PainelListaAb
implements PainelAbaIf {
    public static String NOME_ABA = "Aquisi\u00e7\u00e3o de \u00c1rea Parcial";
    public static final String TITULO = "<html>Documento de Informa\u00e7\u00e3o e Atualiza\u00e7\u00e3o Cadastral do ITR - Diac<br>Aquisi\u00e7\u00e3o Parcial</html>";
    public static final String HELP_ID = "Preenchimento_do_Diac_Aquisicao_Parcial";
    private PainelDeclaracaoIf painelPai;
    private static int QUANTIDADE_MAXIMA_REGISTROS;

    public PainelAbaAquisicaoParcialLista(PainelDeclaracaoIf painelPai) {
        this.painelPai = painelPai;
        try {
            QUANTIDADE_MAXIMA_REGISTROS = Integer.valueOf(MensagemUtil.getMensagem("quantidade.aquisicao.parcial"));
        }
        catch (NumberFormatException ex) {
            QUANTIDADE_MAXIMA_REGISTROS = 12;
        }
    }

    @Override
    protected String getButtonHelpID() {
        return HELP_ID;
    }

    @Override
    protected String getClassePainelNavegacao() {
        return PainelAquisicaoParcialDetalhe.class.getName();
    }

    @Override
    public String getTituloPainel() {
        return TITULO;
    }

    @Override
    protected int getColunaOrdenacao() {
        return 0;
    }

    @Override
    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    @Override
    protected TableListaModel getTableModel() {
        return new TableModelAquisicaoParcial((ObjetoNegocio)ControladorGui.getDeclaracaoAberta().getAquisicaoAlienacao().getAquisicaoParcial());
    }

    @Override
    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(5);
        tcm.getColumn(1).setPreferredWidth(50);
        tcm.getColumn(2).setPreferredWidth(50);
        tcm.getColumn(3).setPreferredWidth(50);
        tcm.getColumn(4).setPreferredWidth(50);
    }

    @Override
    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista2 = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista2.accessibleColumnHeader = new String[]{"Item", "CPF/CNPJ do alienante", "Data", "Nirf", "\u00c1rea adquirida (em hectares)"};
        return tableLista2;
    }

    @Override
    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            ITRTableModelAb model = (ITRTableModelAb)this.getTabela().getModel();
            AquisicaoParcial colCondominos = (AquisicaoParcial)model.getObjetoNegocio();
            InformacaoAquisicao aquisicao = (InformacaoAquisicao)((Object)colCondominos.recuperarLista().get(indiceVetor));
            ControladorGui.acionarPainel(new PainelAquisicaoParcialDetalhe(aquisicao));
        } else {
            GuiUtil.mostrarAviso("111138");
        }
    }

    @Override
    public void onBtnExcluirClick(ActionEvent e) {
        ITRTableAb tabela = this.getTabela();
        if (tabela.getSelectedRow() >= 0) {
            int linhaTabela = tabela.getSelectedRow();
            int indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela);
            TableListaModel model = (TableListaModel)tabela.getModel();
            Colecao colecao = (Colecao)model.getObjetoNegocio();
            if (GuiUtil.mostrarConfirma("111137", new String[]{"aquisi\u00e7\u00e3o"})) {
                colecao.recuperarLista().remove(indiceVetor);
                this.atualizarVisualizacao();
                this.getDefaultFocus().requestFocusInWindow();
                if (this.getTabela().getModel().getRowCount() > 0) {
                    if (linhaTabela == this.getTabela().getModel().getRowCount()) {
                        this.getTabela().selecionaCelula(1, linhaTabela - 1);
                    } else {
                        this.getTabela().selecionaCelula(1, linhaTabela);
                    }
                }
            }
        } else {
            GuiUtil.mostrarAviso("111138");
        }
    }

    @Override
    public void onBtnNovoClick(ActionEvent e) {
        if (this.getTabela().getRowCount() == 12) {
            GuiUtil.mostrarAviso("quantidade_aquisicao_parcial_excedida");
        } else {
            TableModelAquisicaoParcial lModel = (TableModelAquisicaoParcial)this.getTabela().getModel();
            ControladorGui.acionarPainel(new PainelAquisicaoParcialDetalhe());
            lModel.refresh();
        }
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/ITR40x40/aquisicao_alienacao.png");
    }

    @Override
    public boolean isTelaComMensagem() {
        return true;
    }

    @Override
    public String getMensagemTela() {
        return MensagemUtil.getMensagem("quantidade_aquisicao_parcial_excedida");
    }

    @Override
    public void aposCriarAbas() {
    }

    @Override
    public String getNomeAba() {
        return NOME_ABA;
    }

    @Override
    public PainelDeclaracaoIf getPainelPai() {
        return this.painelPai;
    }

    @Override
    public void preExibir() {
        super.preExibir();
        this.atualizarVisualizacao();
    }

    private void atualizarVisualizacao() {
        if (this.getTabela().getRowCount() == QUANTIDADE_MAXIMA_REGISTROS) {
            this.getIrpfToolbar().getBtnNovo().setEnabled(false);
        } else {
            this.getIrpfToolbar().getBtnNovo().setEnabled(true);
        }
    }
}

