/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.aquisicaoalienacao;

import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.itr.aquisicaoalienacao.AquisicaoTotal;
import serpro.ppgd.itr.aquisicaoalienacao.InformacaoAquisicao;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.ITRTableAb;
import serpro.ppgd.itr.gui.ITRTableModelAb;
import serpro.ppgd.itr.gui.PainelAbaIf;
import serpro.ppgd.itr.gui.PainelDeclaracaoIf;
import serpro.ppgd.itr.gui.PainelListaAb;
import serpro.ppgd.itr.gui.TableLista;
import serpro.ppgd.itr.gui.TableListaModel;
import serpro.ppgd.itr.gui.TableListaSumario;
import serpro.ppgd.itr.gui.aquisicaoalienacao.PainelAquisicaoTotalDetalhe;
import serpro.ppgd.itr.gui.aquisicaoalienacao.TableModelAquisicaoTotal;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelAbaAquisicaoTotalLista
extends PainelListaAb
implements PainelAbaIf {
    public static String NOME_ABA = "Aquisi\u00e7\u00e3o de \u00c1rea Total";
    public static final String TITULO = "<html>Documento de Informa\u00e7\u00e3o e Atualiza\u00e7\u00e3o Cadastral do ITR - Diac<br>Aquisi\u00e7\u00e3o Total</html>";
    public static final String HELP_ID = "Preenchimento_do_Diac_Aquisicao_Total";
    private PainelDeclaracaoIf painelPai;
    private static int QUANTIDADE_MAXIMA_REGISTROS;

    public PainelAbaAquisicaoTotalLista(PainelDeclaracaoIf painelPai) {
        this.painelPai = painelPai;
        try {
            QUANTIDADE_MAXIMA_REGISTROS = Integer.valueOf(MensagemUtil.getMensagem("quantidade.aquisicao.total"));
        }
        catch (NumberFormatException ex) {
            QUANTIDADE_MAXIMA_REGISTROS = 12;
        }
    }

    @Override
    protected String getButtonHelpID() {
        return HELP_ID;
    }

    @Override
    protected String getClassePainelNavegacao() {
        return PainelAquisicaoTotalDetalhe.class.getName();
    }

    @Override
    public String getTituloPainel() {
        return TITULO;
    }

    @Override
    protected int getColunaOrdenacao() {
        return 0;
    }

    @Override
    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    @Override
    protected TableListaModel getTableModel() {
        return new TableModelAquisicaoTotal((ObjetoNegocio)ControladorGui.getDeclaracaoAberta().getAquisicaoAlienacao().getAquisicaoTotal());
    }

    @Override
    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(5);
        tcm.getColumn(1).setPreferredWidth(50);
        tcm.getColumn(2).setPreferredWidth(50);
        tcm.getColumn(3).setPreferredWidth(50);
        tcm.getColumn(4).setPreferredWidth(50);
    }

    @Override
    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista2 = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista2.accessibleColumnHeader = new String[]{"Item", "CPF/CNPJ do alienante", "Data", "Nirf", "\u00c1rea adquirida (em hectares)"};
        return tableLista2;
    }

    @Override
    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            ITRTableModelAb model = (ITRTableModelAb)this.getTabela().getModel();
            AquisicaoTotal aquisicoes = (AquisicaoTotal)model.getObjetoNegocio();
            InformacaoAquisicao alimentando = (InformacaoAquisicao)((Object)aquisicoes.recuperarLista().get(indiceVetor));
            ControladorGui.acionarPainel(new PainelAquisicaoTotalDetalhe(alimentando));
        } else {
            GuiUtil.mostrarAviso("111138");
        }
    }

    @Override
    public void onBtnExcluirClick(ActionEvent e) {
        ITRTableAb tabela = this.getTabela();
        boolean temSumario = tabela instanceof TableListaSumario;
        if (!(tabela.getSelectedRow() < 0 || temSumario && tabela.getSelectedRow() >= tabela.getRowCount() - 1)) {
            int linhaTabela = tabela.getSelectedRow();
            int indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela);
            TableListaModel model = (TableListaModel)tabela.getModel();
            Colecao colecao = (Colecao)model.getObjetoNegocio();
            if (GuiUtil.mostrarConfirma("111137", new String[]{"aquisi\u00e7\u00e3o"})) {
                colecao.recuperarLista().remove(indiceVetor);
                this.atualizarVisualizacao();
                this.getDefaultFocus().requestFocusInWindow();
                if (this.getTabela().getModel().getRowCount() > 0) {
                    if (linhaTabela == this.getTabela().getModel().getRowCount()) {
                        this.getTabela().selecionaCelula(1, linhaTabela - 1);
                    } else {
                        this.getTabela().selecionaCelula(1, linhaTabela);
                    }
                }
            }
        } else {
            GuiUtil.mostrarAviso("111138");
        }
    }

    @Override
    public void onBtnNovoClick(ActionEvent e) {
        if (this.getTabela().getRowCount() == 12) {
            GuiUtil.mostrarAviso("quantidade_aquisicao_total_excedida");
        } else {
            TableModelAquisicaoTotal lModel = (TableModelAquisicaoTotal)this.getTabela().getModel();
            ControladorGui.acionarPainel(new PainelAquisicaoTotalDetalhe());
            lModel.refresh();
        }
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/ITR40x40/aquisicao_alienacao.png");
    }

    @Override
    public boolean isTelaComMensagem() {
        return true;
    }

    @Override
    public String getMensagemTela() {
        String msg = "<html>" + MensagemUtil.getMensagem("quantidade_aquisicao_total_excedida") + "<br>" + MensagemUtil.getMensagem("aquisicao_total_aviso") + "</html>";
        return msg;
    }

    @Override
    public void aposCriarAbas() {
    }

    @Override
    public String getNomeAba() {
        return NOME_ABA;
    }

    @Override
    public PainelDeclaracaoIf getPainelPai() {
        return this.painelPai;
    }

    @Override
    public void preExibir() {
        super.preExibir();
        this.atualizarVisualizacao();
    }

    private void atualizarVisualizacao() {
        if (this.getTabela().getRowCount() == QUANTIDADE_MAXIMA_REGISTROS) {
            this.getIrpfToolbar().getBtnNovo().setEnabled(false);
        } else {
            this.getIrpfToolbar().getBtnNovo().setEnabled(true);
        }
    }
}

