/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.aquisicaoalienacao;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.JEditData;
import serpro.ppgd.gui.xbeans.JEditNI;
import serpro.ppgd.gui.xbeans.JEditNirf;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.itr.aquisicaoalienacao.InformacaoAlienacao;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.PainelDeclaracaoAb;
import serpro.ppgd.itr.gui.aquisicaoalienacao.PainelAbaAlienacaoParcialLista;
import serpro.ppgd.itr.gui.aquisicaoalienacao.PainelDadosAquisicaoAlienacao;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;

public class PainelAlienacaoParcialDetalhe
extends PainelDeclaracaoAb {
    public static final String TITULO = "<html>Documento de Informa\u00e7\u00e3o e Atualiza\u00e7\u00e3o Cadastral do ITR - Diac<br>Aliena\u00e7\u00e3o Parcial</html>";
    public static final String HELP_ID = "Preenchimento_do_Diac_Alienacao_Parcial";
    InformacaoAlienacao informacaoAlienacao;
    private JEditValor edtAreaAdquirida;
    private JEditData edtData;
    private JEditNI edtNi;
    private JEditNirf edtNirf;
    private JPanel jPanel1;
    private JLabel lblAreaAdquirida;
    private JLabel lblData;
    private JLabel lblNi;
    private JLabel lblNirf;
    private JLabel lblTitulo;

    public PainelAlienacaoParcialDetalhe() {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        this.informacaoAlienacao = new InformacaoAlienacao();
        this.salvarNovoItem();
        this.associarInformacao();
        this.adicionarObservadores();
    }

    public PainelAlienacaoParcialDetalhe(InformacaoAlienacao condomino) {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        this.informacaoAlienacao = condomino;
        this.associarInformacao();
        this.adicionarObservadores();
    }

    private void adicionarObservadores() {
        this.edtNi.getInformacao().addObservador((Observador)new ObsRevalidadorCampos());
        this.edtNirf.getInformacao().addObservador((Observador)new ObsRevalidadorCampos());
        this.edtData.getInformacao().addObservador((Observador)new ObsRevalidadorCampos());
        this.edtAreaAdquirida.getInformacao().addObservador((Observador)new ObsRevalidadorCampos());
    }

    private void removerObservadores() {
        try {
            this.edtNi.getInformacao().removeObservadores(new Class[]{ObsRevalidadorCampos.class});
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            this.edtNirf.getInformacao().removeObservadores(new Class[]{ObsRevalidadorCampos.class});
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            this.edtData.getInformacao().removeObservadores(new Class[]{ObsRevalidadorCampos.class});
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            this.edtAreaAdquirida.getInformacao().removeObservadores(new Class[]{ObsRevalidadorCampos.class});
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void associarInformacao() {
        this.edtNi.setInformacao((Informacao)this.informacaoAlienacao.getNiAlienanteAdquirente());
        this.edtData.setInformacao((Informacao)this.informacaoAlienacao.getData());
        this.edtNirf.setInformacao((Informacao)this.informacaoAlienacao.getNirfImovelAlienanteAdquirente());
        this.edtAreaAdquirida.setInformacao((Informacao)this.informacaoAlienacao.getArea());
    }

    @Override
    public JComponent getDefaultFocus() {
        return this.edtNi;
    }

    @Override
    public String getTituloPainel() {
        return TITULO;
    }

    @Override
    public boolean isTelaComVoltar() {
        return true;
    }

    @Override
    public void executaVoltar() {
        ControladorGui.acionarPainel(new PainelDadosAquisicaoAlienacao(PainelAbaAlienacaoParcialLista.NOME_ABA));
    }

    protected void salvarNovoItem() {
        List informacaoAlienacao = ControladorGui.getDeclaracaoAberta().getAquisicaoAlienacao().getAlienacaoParcial().itens();
        informacaoAlienacao.add(this.informacaoAlienacao);
    }

    @Override
    public void posSair() {
        ControladorGui.getDeclaracaoAberta().getAquisicaoAlienacao().getAlienacaoParcial().excluirRegistrosEmBranco();
        this.removerObservadores();
    }

    @Override
    public void preFecharDeclaracao() {
        ControladorGui.getDeclaracaoAberta().getAquisicaoAlienacao().getAlienacaoParcial().excluirRegistrosEmBranco();
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/ITR40x40/aquisicao_alienacao.png");
    }

    @Override
    public String getHelpID() {
        return HELP_ID;
    }

    private void initComponents() {
        this.lblTitulo = new JLabel();
        this.jPanel1 = new JPanel();
        this.lblNi = new JLabel();
        this.edtNi = new JEditNI();
        this.lblData = new JLabel();
        this.edtData = new JEditData();
        this.lblNirf = new JLabel();
        this.edtNirf = new JEditNirf();
        this.lblAreaAdquirida = new JLabel();
        this.edtAreaAdquirida = new JEditValor();
        this.setBackground(new Color(240, 245, 240));
        this.lblTitulo.setFont(new Font("Arial", 1, 12));
        this.lblTitulo.setForeground(new Color(30, 105, 140));
        this.lblTitulo.setText("Dados da Aliena\u00e7\u00e3o de \u00c1rea Parcial");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblNi.setFont(new Font("Arial", 0, 11));
        this.lblNi.setForeground(new Color(89, 89, 89));
        this.lblNi.setText("CPF/CNPJ do adquirente");
        this.lblData.setFont(new Font("Arial", 0, 11));
        this.lblData.setForeground(new Color(89, 89, 89));
        this.lblData.setText("Data");
        this.lblNirf.setFont(new Font("Arial", 0, 11));
        this.lblNirf.setForeground(new Color(89, 89, 89));
        this.lblNirf.setText("Nirf");
        this.lblAreaAdquirida.setFont(new Font("Arial", 0, 11));
        this.lblAreaAdquirida.setForeground(new Color(89, 89, 89));
        this.lblAreaAdquirida.setText("\u00c1rea alienada (em hectares)");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtNi, -2, 170, -2).addComponent(this.lblNi)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtData, -2, 112, -2).addComponent(this.lblData)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblNirf).addGap(118, 118, 118).addComponent(this.lblAreaAdquirida)).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.edtNirf, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtAreaAdquirida, -2, 164, -2))).addContainerGap(36, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblNi).addComponent(this.lblData).addComponent(this.lblNirf).addComponent(this.lblAreaAdquirida)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.edtNi, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.edtData, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.edtNirf, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.edtAreaAdquirida, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lblTitulo).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblTitulo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    protected class ObsRevalidadorCampos
    extends Observador {
        protected ObsRevalidadorCampos() {
        }

        public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            this.revalidarEditores(PainelAlienacaoParcialDetalhe.this, observado);
        }

        protected void revalidarEditores(JPanel painel, Object observado) {
            Component[] components = painel.getComponents();
            for (int i = 0; i < components.length; ++i) {
                Component component = components[i];
                if (component instanceof JEditCampo) {
                    JEditCampo campo = (JEditCampo)component;
                    if (campo.getInformacao() == observado) continue;
                    campo.chamaValidacao();
                    continue;
                }
                if (!(component instanceof JPanel)) continue;
                this.revalidarEditores((JPanel)component, observado);
            }
        }
    }
}

